/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseIntArray;
import com.taobao.weex.dom.flex.CSSConstants;
import com.taobao.weex.dom.flex.FloatUtil;
import com.taobao.weex.dom.flex.Spacing;
import com.taobao.weex.utils.WXViewUtils;
import java.util.Arrays;
import java.util.Locale;

public class WXBackgroundDrawable
extends Drawable {
    public static final int BORDER_TOP_LEFT_RADIUS = 0;
    public static final int BORDER_TOP_RIGHT_RADIUS = 1;
    public static final int BORDER_BOTTOM_RIGHT_RADIUS = 2;
    public static final int BORDER_BOTTOM_LEFT_RADIUS = 3;
    private static final int DEFAULT_BORDER_COLOR = -16777216;
    private final Paint mPaint = new Paint(1);
    @Nullable
    private Spacing mBorderWidth;
    @Nullable
    private SparseIntArray mBorderColor;
    @Nullable
    private BorderStyle mBorderStyle;
    @Nullable
    private PathEffect mPathEffectForBorderStyle;
    @Nullable
    private Path mPathForBorderRadius;
    @Nullable
    private Path mPathForBorderRadiusOutline;
    @Nullable
    private Path mPathForBorder;
    @Nullable
    private RectF mTempRectForBorderRadius;
    @Nullable
    private RectF mTempRectForBorderRadiusOutline;
    private boolean mNeedUpdatePathForBorderRadius = false;
    private float mBorderRadius = Float.NaN;
    private int mColor = 0;
    private int mAlpha = 255;
    @Nullable
    private float[] mBorderCornerRadii;

    public void draw(Canvas canvas) {
        boolean roundedBorders;
        this.updatePathEffect();
        boolean bl = roundedBorders = this.mBorderCornerRadii != null || !CSSConstants.isUndefined(this.mBorderRadius) && this.mBorderRadius > 0.0f;
        if (!(this.mBorderStyle != null && this.mBorderStyle != BorderStyle.SOLID || roundedBorders)) {
            this.drawRectangularBackgroundWithBorders(canvas);
        } else {
            this.drawRoundedBackgroundWithBorders(canvas);
        }
    }

    private void drawRoundedBackgroundWithBorders(Canvas canvas) {
        float fullBorderWidth;
        this.updatePath();
        int useColor = WXViewUtils.multiplyColorAlpha(this.mColor, this.mAlpha);
        if (useColor >>> 24 != 0) {
            this.mPaint.setColor(useColor);
            this.mPaint.setStyle(Paint.Style.FILL);
            canvas.drawPath(this.mPathForBorderRadiusOutline, this.mPaint);
        }
        if ((fullBorderWidth = this.getFullBorderWidth()) > 0.0f) {
            int borderColor = this.getFullBorderColor();
            this.mPaint.setColor(WXViewUtils.multiplyColorAlpha(borderColor, this.mAlpha));
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth(fullBorderWidth);
            canvas.drawPath(this.mPathForBorderRadius, this.mPaint);
        }
    }

    private void drawRectangularBackgroundWithBorders(Canvas canvas) {
        int useColor = WXViewUtils.multiplyColorAlpha(this.mColor, this.mAlpha);
        Rect bounds = this.getBounds();
        if (useColor >>> 24 != 0) {
            this.mPaint.setColor(useColor);
            this.mPaint.setStyle(Paint.Style.FILL);
            canvas.drawRect(bounds, this.mPaint);
        }
        if (this.getBorderWidth(0) > 0 || this.getBorderWidth(1) > 0 || this.getBorderWidth(2) > 0 || this.getBorderWidth(3) > 0) {
            int borderLeft = this.getBorderWidth(0);
            int borderTop = this.getBorderWidth(1);
            int borderRight = this.getBorderWidth(2);
            int borderBottom = this.getBorderWidth(3);
            int colorLeft = this.getBorderColor(0);
            int colorTop = this.getBorderColor(1);
            int colorRight = this.getBorderColor(2);
            int colorBottom = this.getBorderColor(3);
            int width = bounds.width();
            int height = bounds.height();
            this.mPaint.setAntiAlias(false);
            if (this.mPathForBorder == null) {
                this.mPathForBorder = new Path();
            }
            if (borderLeft > 0 && colorLeft != 0) {
                this.drawBorder(canvas, colorLeft, new float[]{0.0f, 0.0f, borderLeft, borderTop, borderLeft, height - borderBottom, 0.0f, height}, this.mPathForBorder, this.mPaint);
            }
            if (borderTop > 0 && colorTop != 0) {
                this.drawBorder(canvas, colorTop, new float[]{0.0f, 0.0f, borderLeft, borderTop, width - borderRight, borderTop, width, 0.0f}, this.mPathForBorder, this.mPaint);
            }
            if (borderRight > 0 && colorRight != 0) {
                this.drawBorder(canvas, colorRight, new float[]{width, 0.0f, width, height, width - borderRight, height - borderBottom, width - borderRight, borderTop}, this.mPathForBorder, this.mPaint);
            }
            if (borderBottom > 0 && colorBottom != 0) {
                this.drawBorder(canvas, colorBottom, new float[]{0.0f, height, width, height, width - borderRight, height - borderBottom, borderLeft, height - borderBottom}, this.mPathForBorder, this.mPaint);
            }
            this.mPaint.setAntiAlias(true);
        }
    }

    private void drawBorder(Canvas canvas, int color, float[] pts, Path path, Paint paint) {
        paint.setColor(color);
        path.reset();
        path.moveTo(pts[0], pts[1]);
        int len = pts.length / 2;
        for (int i = 1; i < len; ++i) {
            path.lineTo(pts[i * 2], pts[i * 2 + 1]);
        }
        path.lineTo(pts[0], pts[1]);
        canvas.drawPath(path, paint);
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mNeedUpdatePathForBorderRadius = true;
    }

    private void updatePath() {
        if (!this.mNeedUpdatePathForBorderRadius) {
            return;
        }
        this.mNeedUpdatePathForBorderRadius = false;
        if (this.mPathForBorderRadius == null) {
            this.mPathForBorderRadius = new Path();
        }
        if (this.mTempRectForBorderRadius == null) {
            this.mTempRectForBorderRadius = new RectF();
        }
        if (this.mPathForBorderRadiusOutline == null) {
            this.mPathForBorderRadiusOutline = new Path();
        }
        if (this.mTempRectForBorderRadiusOutline == null) {
            this.mTempRectForBorderRadiusOutline = new RectF();
        }
        this.mPathForBorderRadius.reset();
        this.mPathForBorderRadiusOutline.reset();
        this.mTempRectForBorderRadius.set(this.getBounds());
        this.mTempRectForBorderRadiusOutline.set(this.getBounds());
        float fullBorderWidth = this.getFullBorderWidth();
        if (fullBorderWidth > 0.0f) {
            this.mTempRectForBorderRadius.inset(fullBorderWidth * 0.5f, fullBorderWidth * 0.5f);
        }
        float defaultBorderRadius = !CSSConstants.isUndefined(this.mBorderRadius) ? this.mBorderRadius : 0.0f;
        float topLeftRadius = this.mBorderCornerRadii != null && !CSSConstants.isUndefined(this.mBorderCornerRadii[0]) ? this.mBorderCornerRadii[0] : defaultBorderRadius;
        float topRightRadius = this.mBorderCornerRadii != null && !CSSConstants.isUndefined(this.mBorderCornerRadii[1]) ? this.mBorderCornerRadii[1] : defaultBorderRadius;
        float bottomRightRadius = this.mBorderCornerRadii != null && !CSSConstants.isUndefined(this.mBorderCornerRadii[2]) ? this.mBorderCornerRadii[2] : defaultBorderRadius;
        float bottomLeftRadius = this.mBorderCornerRadii != null && !CSSConstants.isUndefined(this.mBorderCornerRadii[3]) ? this.mBorderCornerRadii[3] : defaultBorderRadius;
        this.mPathForBorderRadius.addRoundRect(this.mTempRectForBorderRadius, new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomRightRadius, bottomRightRadius, bottomLeftRadius, bottomLeftRadius}, Path.Direction.CW);
        float extraRadiusForOutline = 0.0f;
        if (this.mBorderWidth != null) {
            extraRadiusForOutline = this.mBorderWidth.get(8) / 2.0f;
        }
        this.mPathForBorderRadiusOutline.addRoundRect(this.mTempRectForBorderRadiusOutline, new float[]{topLeftRadius + extraRadiusForOutline, topLeftRadius + extraRadiusForOutline, topRightRadius + extraRadiusForOutline, topRightRadius + extraRadiusForOutline, bottomRightRadius + extraRadiusForOutline, bottomRightRadius + extraRadiusForOutline, bottomLeftRadius + extraRadiusForOutline, bottomLeftRadius + extraRadiusForOutline}, Path.Direction.CW);
    }

    private void updatePathEffect() {
        this.mPathEffectForBorderStyle = this.mBorderStyle != null ? this.mBorderStyle.getPathEffect(this.getFullBorderWidth()) : null;
        this.mPaint.setPathEffect(this.mPathEffectForBorderStyle);
    }

    public void setAlpha(int alpha) {
        if (alpha != this.mAlpha) {
            this.mAlpha = alpha;
            this.invalidateSelf();
        }
    }

    private float getFullBorderWidth() {
        return this.mBorderWidth != null && !CSSConstants.isUndefined(this.mBorderWidth.getRaw(8)) ? this.mBorderWidth.getRaw(8) : 0.0f;
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    private int getFullBorderColor() {
        if (this.mBorderColor != null) {
            return this.mBorderColor.get(8, -16777216);
        }
        return -16777216;
    }

    public void setColorFilter(ColorFilter cf) {
    }

    private int getBorderWidth(int position) {
        return this.mBorderWidth != null ? Math.round(this.mBorderWidth.get(position)) : 0;
    }

    public int getOpacity() {
        return WXViewUtils.getOpacityFromColor(WXViewUtils.multiplyColorAlpha(this.mColor, this.mAlpha));
    }

    private int getBorderColor(int position) {
        return this.mBorderColor != null ? this.mBorderColor.get(position, this.mBorderColor.get(8)) : -16777216;
    }

    public void getOutline(@NonNull Outline outline) {
        if (Build.VERSION.SDK_INT < 21) {
            super.getOutline(outline);
        } else if (!CSSConstants.isUndefined(this.mBorderRadius) && this.mBorderRadius > 0.0f || this.mBorderCornerRadii != null) {
            this.updatePath();
            outline.setConvexPath(this.mPathForBorderRadiusOutline);
        } else {
            outline.setRect(this.getBounds());
        }
    }

    public void setBorderWidth(int position, float width) {
        if (this.mBorderWidth == null) {
            this.mBorderWidth = new Spacing();
        }
        if (!FloatUtil.floatsEqual(this.mBorderWidth.getRaw(position), width)) {
            this.mBorderWidth.set(position, width);
            if (position == 8) {
                this.mNeedUpdatePathForBorderRadius = true;
            }
            this.invalidateSelf();
        }
    }

    public void setBorderColor(int position, int color) {
        if (this.mBorderColor == null) {
            this.mBorderColor = new SparseIntArray(9);
            this.mBorderColor.put(8, -16777216);
        }
        if (this.mBorderColor.get(position) != color) {
            this.mBorderColor.put(position, color);
            this.invalidateSelf();
        }
    }

    public void setBorderStyle(@Nullable String style) {
        BorderStyle borderStyle;
        BorderStyle borderStyle2 = borderStyle = style == null ? null : BorderStyle.valueOf(style.toUpperCase(Locale.US));
        if (this.mBorderStyle != borderStyle) {
            this.mBorderStyle = borderStyle;
            this.mNeedUpdatePathForBorderRadius = true;
            this.invalidateSelf();
        }
    }

    public void setRadius(float radius) {
        if (!FloatUtil.floatsEqual(this.mBorderRadius, radius)) {
            this.mBorderRadius = radius;
            this.mNeedUpdatePathForBorderRadius = true;
            this.invalidateSelf();
        }
    }

    public void setRadius(float radius, int position) {
        if (this.mBorderCornerRadii == null) {
            this.mBorderCornerRadii = new float[4];
            Arrays.fill(this.mBorderCornerRadii, Float.NaN);
        }
        if (!FloatUtil.floatsEqual(this.mBorderCornerRadii[position], radius)) {
            this.mBorderCornerRadii[position] = radius;
            this.mNeedUpdatePathForBorderRadius = true;
            this.invalidateSelf();
        }
    }

    public int getColor() {
        return this.mColor;
    }

    public void setColor(int color) {
        this.mColor = color;
        this.invalidateSelf();
    }

    private static enum BorderStyle {
        SOLID,
        DASHED,
        DOTTED;


        @Nullable
        public PathEffect getPathEffect(float borderWidth) {
            switch (this) {
                case SOLID: {
                    return null;
                }
                case DASHED: {
                    return new DashPathEffect(new float[]{borderWidth * 3.0f, borderWidth * 3.0f, borderWidth * 3.0f, borderWidth * 3.0f}, 0.0f);
                }
                case DOTTED: {
                    return new DashPathEffect(new float[]{borderWidth, borderWidth, borderWidth, borderWidth}, 0.0f);
                }
            }
            return null;
        }
    }
}

