/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.MediaController;
import android.widget.ProgressBar;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXVideoView;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import java.util.HashMap;

public class WXVideo
extends WXComponent<FrameLayout> {
    public static final String PLAY_STATUS = "playStatus";
    public static final String PLAY = "play";
    public static final String PAUSE = "pause";
    public static final String STOP = "stop";
    private WXVideoView mVideoView;
    private boolean mAutoPlay;
    private String mSrc;
    private boolean mPrepared;
    private boolean mError;
    private ProgressBar mProgressBar;
    private boolean mStopped;

    @Deprecated
    public WXVideo(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this(instance, dom, parent, isLazy);
    }

    public WXVideo(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, boolean isLazy) {
        super(instance, dom, parent, isLazy);
    }

    @Override
    protected FrameLayout initComponentHostView(Context context) {
        FrameLayout videoRoot = new FrameLayout(this.mContext);
        videoRoot.setBackgroundColor(WXResourceUtils.getColor("#ee000000"));
        this.mVideoView = new WXVideoView(this.mContext);
        FrameLayout.LayoutParams videoLayoutParams = new FrameLayout.LayoutParams(-1, -1);
        videoLayoutParams.gravity = 17;
        this.mVideoView.setLayoutParams((ViewGroup.LayoutParams)videoLayoutParams);
        videoRoot.addView((View)this.mVideoView);
        this.mProgressBar = new ProgressBar(this.mContext);
        FrameLayout.LayoutParams pLayoutParams = new FrameLayout.LayoutParams(-2, -2);
        this.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)pLayoutParams);
        pLayoutParams.gravity = 17;
        videoRoot.addView((View)this.mProgressBar);
        final MediaController controller = new MediaController(this.mContext);
        controller.setAnchorView((View)videoRoot);
        this.mVideoView.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mp, int what, int extra) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("Video", "onError:" + what);
                }
                WXVideo.this.mProgressBar.setVisibility(8);
                WXVideo.this.mPrepared = false;
                WXVideo.this.mError = true;
                if (WXVideo.this.mDomObj.event != null && WXVideo.this.mDomObj.event.contains("fail")) {
                    WXVideo.this.notify("fail", WXVideo.STOP);
                }
                return true;
            }
        });
        this.mVideoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mediaPlayer) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("Video", "onPrepared");
                }
                WXVideo.this.mProgressBar.setVisibility(8);
                WXVideo.this.mPrepared = true;
                if (WXVideo.this.mAutoPlay) {
                    WXVideo.this.mVideoView.start();
                }
                WXVideo.this.mVideoView.seekTo(5);
                if (!WXVideo.this.mStopped) {
                    controller.show(3);
                } else {
                    controller.hide();
                }
                WXVideo.this.mStopped = false;
            }
        });
        this.mVideoView.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("Video", "onCompletion");
                }
                if (WXVideo.this.mDomObj.event != null && WXVideo.this.mDomObj.event.contains("finish")) {
                    WXVideo.this.notify("finish", WXVideo.STOP);
                }
            }
        });
        this.mVideoView.setOnVideoPauseListener(new WXVideoView.VideoPlayListener(){

            @Override
            public void onPause() {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("Video", "onPause");
                }
                if (WXVideo.this.mDomObj.event != null && WXVideo.this.mDomObj.event.contains(WXVideo.PAUSE)) {
                    WXVideo.this.notify(WXVideo.PAUSE, WXVideo.PAUSE);
                }
            }

            @Override
            public void onStart() {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("Video", "onStart");
                }
                if (WXVideo.this.mDomObj.event != null && WXVideo.this.mDomObj.event.contains("start")) {
                    WXVideo.this.notify("start", WXVideo.PLAY);
                }
            }
        });
        this.mVideoView.setMediaController(controller);
        controller.setMediaPlayer((MediaController.MediaPlayerControl)this.mVideoView);
        return videoRoot;
    }

    private void notify(String event, String newStatus) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put(PLAY_STATUS, newStatus);
        params.put("timeStamp", System.currentTimeMillis());
        HashMap<String, Object> domChanges = new HashMap<String, Object>();
        HashMap<String, String> attrsChanges = new HashMap<String, String>();
        attrsChanges.put(PLAY_STATUS, newStatus);
        domChanges.put("attrs", attrsChanges);
        WXSDKManager.getInstance().fireEvent(this.mInstanceId, this.getRef(), event, params, domChanges);
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "src": {
                String src = WXUtils.getString(param, null);
                if (src != null) {
                    this.setSrc(src);
                }
                return true;
            }
            case "autoPlay": {
                Boolean result = WXUtils.getBoolean(param, null);
                if (result != null) {
                    this.setAutoPlay(result);
                }
                return true;
            }
            case "playStatus": {
                String status = WXUtils.getString(param, null);
                if (status != null) {
                    this.setPlaystatus(status);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="src")
    public void setSrc(String src) {
        if (TextUtils.isEmpty((CharSequence)src) || this.getHostView() == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)src)) {
            this.mVideoView.setVideoURI(Uri.parse((String)src));
            this.mProgressBar.setVisibility(0);
            this.mSrc = src;
        }
    }

    @WXComponentProp(name="autoPlay")
    public void setAutoPlay(boolean autoPlay) {
        this.mAutoPlay = autoPlay;
    }

    @WXComponentProp(name="playStatus")
    public void setPlaystatus(String playstatus) {
        if (this.mPrepared && !this.mError && !this.mStopped) {
            if (playstatus.equals(PLAY)) {
                this.mVideoView.start();
            } else if (playstatus.equals(PAUSE)) {
                this.mVideoView.pause();
            } else if (playstatus.equals(STOP)) {
                this.mVideoView.stopPlayback();
                this.mStopped = true;
            }
        } else if ((this.mError || this.mStopped) && playstatus.equals(PLAY)) {
            this.mError = false;
            this.mVideoView.resume();
            this.mProgressBar.setVisibility(0);
        }
    }
}

