/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.OnWXScrollListener;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.component.Scrollable;
import com.taobao.weex.ui.component.WXBaseRefresh;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXLoading;
import com.taobao.weex.ui.component.WXRefresh;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.helper.WXStickyHelper;
import com.taobao.weex.ui.view.IWXScroller;
import com.taobao.weex.ui.view.WXBaseRefreshLayout;
import com.taobao.weex.ui.view.WXHorizontalScrollView;
import com.taobao.weex.ui.view.WXScrollView;
import com.taobao.weex.ui.view.refresh.wrapper.BaseBounceView;
import com.taobao.weex.ui.view.refresh.wrapper.BounceScrollerView;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WXScroller
extends WXVContainer<ViewGroup>
implements WXScrollView.WXScrollViewListener,
Scrollable {
    private Map<String, ConcurrentHashMap<String, AppearData>> mAppearMap = new ConcurrentHashMap<String, ConcurrentHashMap<String, AppearData>>();
    private Map<String, HashMap<String, WXComponent>> mStickyMap = new HashMap<String, HashMap<String, WXComponent>>();
    private FrameLayout mRealView;
    private Rect mScrollRect;
    private int mContentHeight = 0;
    private WXStickyHelper stickyHelper;
    private Handler handler = new Handler();

    @Deprecated
    public WXScroller(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this(instance, dom, parent, isLazy);
    }

    public WXScroller(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) {
        super(instance, node, parent, lazy);
        this.stickyHelper = new WXStickyHelper(this);
    }

    @Override
    public ViewGroup getRealView() {
        return this.mRealView;
    }

    public ViewGroup getInnerView() {
        if (this.mHost instanceof BounceScrollerView) {
            return (ViewGroup)((BounceScrollerView)this.mHost).getInnerView();
        }
        return (ViewGroup)this.getHostView();
    }

    @Override
    protected void addSubView(View child, int index) {
        if (child == null || this.getRealView() == null) {
            return;
        }
        if (child instanceof WXBaseRefreshLayout) {
            return;
        }
        int count = this.getRealView().getChildCount();
        int n = index = index >= count ? -1 : index;
        if (index == -1) {
            this.getRealView().addView(child);
        } else {
            this.getRealView().addView(child, index);
        }
    }

    @Override
    public void addChild(WXComponent child, int index) {
        int count;
        if (child == null || index < -1) {
            return;
        }
        this.checkRefreshOrLoading(child);
        if (child instanceof WXBaseRefresh) {
            return;
        }
        if (this.mChildren == null) {
            this.mChildren = new ArrayList();
        }
        int n = index = index >= (count = this.mChildren.size()) ? -1 : index;
        if (index == -1) {
            this.mChildren.add(child);
        } else {
            this.mChildren.add(index, child);
        }
    }

    private void checkRefreshOrLoading(WXComponent child) {
        Runnable runnable;
        WXComponent temp;
        if (child instanceof WXRefresh) {
            ((BaseBounceView)this.mHost).setOnRefreshListener((WXRefresh)child);
            temp = child;
            runnable = new Runnable(){

                @Override
                public void run() {
                    ((BaseBounceView)WXScroller.this.mHost).setHeaderView((View)temp.getHostView());
                }
            };
            this.handler.postDelayed(runnable, 100L);
        }
        if (child instanceof WXLoading) {
            ((BaseBounceView)this.mHost).setOnLoadingListener((WXLoading)child);
            temp = child;
            runnable = new Runnable(){

                @Override
                public void run() {
                    ((BaseBounceView)WXScroller.this.mHost).setFooterView((View)temp.getHostView());
                }
            };
            this.handler.postDelayed(runnable, 100L);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.mAppearMap != null) {
            this.mAppearMap.clear();
        }
        if (this.mStickyMap != null) {
            this.mStickyMap.clear();
        }
        if (this.getInnerView() != null && this.getInnerView() instanceof IWXScroller) {
            ((IWXScroller)this.getInnerView()).destroy();
        }
    }

    @Override
    protected WXComponent.MeasureOutput measure(int width, int height) {
        WXComponent.MeasureOutput measureOutput = new WXComponent.MeasureOutput();
        if (this.mOrientation == 0) {
            int screenW = WXViewUtils.getScreenWidth((Context)WXEnvironment.sApplication);
            int weexW = WXViewUtils.getWeexWidth(this.mInstanceId);
            measureOutput.width = width > (weexW >= screenW ? screenW : weexW) ? -1 : width;
            measureOutput.height = height;
        } else {
            int screenH = WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication);
            int weexH = WXViewUtils.getWeexHeight(this.mInstanceId);
            measureOutput.height = height > (weexH >= screenH ? screenH : weexH) ? -1 : height;
            measureOutput.width = width;
        }
        return measureOutput;
    }

    @Override
    protected ViewGroup initComponentHostView(Context context) {
        Object host;
        String scroll = this.mDomObj == null || this.mDomObj.attr == null ? "vertical" : this.mDomObj.attr.getScrollDirection();
        if ("horizontal".equals(scroll)) {
            this.mOrientation = 0;
            WXHorizontalScrollView scrollView = new WXHorizontalScrollView(this.mContext);
            this.mRealView = new FrameLayout(this.mContext);
            scrollView.setScrollViewListener(new WXHorizontalScrollView.ScrollViewListener(){

                @Override
                public void onScrollChanged(WXHorizontalScrollView scrollView, int x, int y, int oldx, int oldy) {
                    WXScroller.this.procAppear((View)scrollView, x, y, oldx, oldy);
                }
            });
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
            scrollView.addView((View)this.mRealView, (ViewGroup.LayoutParams)layoutParams);
            scrollView.setHorizontalScrollBarEnabled(false);
            host = scrollView;
        } else {
            this.mOrientation = 1;
            BounceScrollerView scrollerView = new BounceScrollerView(this.mContext, this.mOrientation, this);
            this.mRealView = new FrameLayout(this.mContext);
            WXScrollView innerView = (WXScrollView)scrollerView.getInnerView();
            innerView.addScrollViewListener(this);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
            innerView.addView((View)this.mRealView, (ViewGroup.LayoutParams)layoutParams);
            innerView.setVerticalScrollBarEnabled(true);
            innerView.addScrollViewListener(new WXScrollView.WXScrollViewListener(){

                @Override
                public void onScrollChanged(WXScrollView scrollView, int x, int y, int oldx, int oldy) {
                }

                @Override
                public void onScrollToBottom(WXScrollView scrollView, int x, int y) {
                }

                @Override
                public void onScrollStopped(WXScrollView scrollView, int x, int y) {
                    List<OnWXScrollListener> listeners = WXScroller.this.mInstance.getWXScrollListeners();
                    if (listeners != null && listeners.size() > 0) {
                        for (OnWXScrollListener listener : listeners) {
                            if (listener == null) continue;
                            listener.onScrollStateChanged((View)scrollView, x, y, 0);
                        }
                    }
                }

                @Override
                public void onScroll(WXScrollView scrollView, int x, int y) {
                    List<OnWXScrollListener> listeners = WXScroller.this.mInstance.getWXScrollListeners();
                    if (listeners != null && listeners.size() > 0) {
                        for (OnWXScrollListener listener : listeners) {
                            if (listener == null) continue;
                            listener.onScrolled((View)scrollView, x, y);
                        }
                    }
                }
            });
            host = scrollerView;
        }
        return host;
    }

    @Override
    public int getScrollY() {
        return this.getInnerView() == null ? 0 : this.getInnerView().getScrollY();
    }

    @Override
    public int getScrollX() {
        return this.getInnerView() == null ? 0 : this.getInnerView().getScrollX();
    }

    public Map<String, HashMap<String, WXComponent>> getStickMap() {
        return this.mStickyMap;
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "showScrollbar": {
                Boolean result = WXUtils.getBoolean(param, null);
                if (result != null) {
                    this.setShowScrollbar(result);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="showScrollbar")
    public void setShowScrollbar(boolean show) {
        if (this.mOrientation == 1) {
            this.getInnerView().setVerticalScrollBarEnabled(show);
        } else {
            this.getInnerView().setHorizontalScrollBarEnabled(show);
        }
    }

    @Override
    public void bindStickStyle(WXComponent component) {
        this.stickyHelper.bindStickStyle(component, this.mStickyMap);
    }

    @Override
    public void unbindStickStyle(WXComponent component) {
        this.stickyHelper.unbindStickStyle(component, this.mStickyMap);
    }

    @Override
    public void bindAppearEvent(WXComponent component) {
        AppearData appearData;
        ConcurrentHashMap<String, AppearData> appearMap = this.mAppearMap.get(this.getRef());
        if (appearMap == null) {
            appearMap = new ConcurrentHashMap();
        }
        if ((appearData = appearMap.get(component.getRef())) == null) {
            appearData = new AppearData();
        }
        appearData.mAppearComponent = component;
        appearData.hasAppear = true;
        appearMap.put(component.getRef(), appearData);
        this.mAppearMap.put(this.getRef(), appearMap);
    }

    @Override
    public void bindDisappearEvent(WXComponent component) {
        AppearData appearData;
        ConcurrentHashMap<String, AppearData> appearMap = this.mAppearMap.get(this.getRef());
        if (appearMap == null) {
            appearMap = new ConcurrentHashMap();
        }
        if ((appearData = appearMap.get(component.getRef())) == null) {
            appearData = new AppearData();
        }
        appearData.mAppearComponent = component;
        appearData.hasDisappear = true;
        appearMap.put(component.getRef(), appearData);
        this.mAppearMap.put(this.getRef(), appearMap);
    }

    @Override
    public void unbindAppearEvent(WXComponent component) {
        ConcurrentHashMap<String, AppearData> appearMap = this.mAppearMap.get(this.getInnerView());
        if (appearMap == null) {
            return;
        }
        AppearData appearData = appearMap.get(component.getRef());
        if (appearData == null) {
            return;
        }
        appearData.hasAppear = false;
        if (!appearData.hasDisappear) {
            appearMap.remove(component.getRef());
        }
    }

    @Override
    public void unbindDisappearEvent(WXComponent component) {
        ConcurrentHashMap<String, AppearData> appearMap = this.mAppearMap.get(this.getInnerView());
        if (appearMap == null) {
            return;
        }
        AppearData appearData = appearMap.get(component.getRef());
        if (appearData == null) {
            return;
        }
        appearData.hasDisappear = false;
        if (!appearData.hasAppear) {
            appearMap.remove(component.getRef());
        }
    }

    @Override
    public void scrollTo(WXComponent component, int offset) {
        int offsetIntF = (int)WXViewUtils.getRealPxByWidth(offset);
        int viewYInScroller = component.getAbsoluteY() - this.getAbsoluteY();
        int viewXInScroller = component.getAbsoluteX() - this.getAbsoluteX();
        this.scrollBy(viewXInScroller - this.getScrollX() + offsetIntF, viewYInScroller - this.getScrollY() + offsetIntF);
    }

    public void scrollBy(final int x, final int y) {
        if (this.getInnerView() == null) {
            return;
        }
        this.getInnerView().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (WXScroller.this.mOrientation == 1) {
                    ((WXScrollView)WXScroller.this.getInnerView()).smoothScrollBy(0, y);
                } else {
                    ((WXHorizontalScrollView)WXScroller.this.getInnerView()).smoothScrollBy(x, 0);
                }
                WXScroller.this.getInnerView().invalidate();
            }
        }, 16L);
    }

    @Override
    public void onScrollChanged(WXScrollView scrollView, int x, int y, int oldx, int oldy) {
        this.procAppear((View)scrollView, x, y, oldx, oldy);
    }

    private void procAppear(View scrollView, int x, int y, int oldx, int oldy) {
        String direction = "";
        if (this.mOrientation == 1) {
            direction = y - oldy > 0 ? "up" : "down";
        } else if (this.mOrientation == 0) {
            direction = x - oldx > 0 ? "right" : "left";
        }
        ConcurrentHashMap<String, AppearData> appearMap = this.mAppearMap.get(this.mDomObj.ref);
        if (appearMap == null) {
            return;
        }
        Iterator<Map.Entry<String, AppearData>> iterator = appearMap.entrySet().iterator();
        Map.Entry<String, AppearData> entry = null;
        if (this.mScrollRect == null) {
            this.mScrollRect = new Rect();
            this.getInnerView().getHitRect(this.mScrollRect);
        }
        while (iterator.hasNext()) {
            HashMap<String, Object> params;
            entry = iterator.next();
            AppearData appearData = entry.getValue();
            if (!appearData.mAppear && appearData.mAppearComponent.getHostView().getLocalVisibleRect(this.mScrollRect)) {
                appearData.mAppear = true;
                if (!appearData.hasAppear) continue;
                params = new HashMap<String, Object>();
                params.put("direction", direction);
                WXSDKManager.getInstance().fireEvent(this.mInstanceId, appearData.mAppearComponent.getRef(), "appear", params);
                continue;
            }
            if (!appearData.mAppear || appearData.mAppearComponent.getHostView().getLocalVisibleRect(this.mScrollRect)) continue;
            appearData.mAppear = false;
            if (!appearData.hasDisappear) continue;
            params = new HashMap();
            params.put("direction", direction);
            WXSDKManager.getInstance().fireEvent(this.mInstanceId, appearData.mAppearComponent.getRef(), "disappear", params);
        }
    }

    @Override
    public void onScrollToBottom(WXScrollView scrollView, int x, int y) {
    }

    @Override
    public void onScrollStopped(WXScrollView scrollView, int x, int y) {
    }

    @Override
    public void onScroll(WXScrollView scrollView, int x, int y) {
        this.onLoadMore(scrollView, x, y);
    }

    protected void onLoadMore(WXScrollView scrollView, int x, int y) {
        try {
            int scrollerH;
            String offset = this.mDomObj.attr.getLoadMoreOffset();
            if (TextUtils.isEmpty((CharSequence)offset)) {
                return;
            }
            int contentH = scrollView.getChildAt(0).getHeight();
            int offScreenY = contentH - y - (scrollerH = scrollView.getHeight());
            if (offScreenY < Integer.parseInt(offset)) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("[WXScroller-onScroll] offScreenY :" + offScreenY);
                }
                if (this.mContentHeight != contentH) {
                    WXSDKManager.getInstance().fireEvent(this.mInstanceId, this.mDomObj.ref, "loadmore");
                    this.mContentHeight = contentH;
                }
            }
        }
        catch (Exception e) {
            WXLogUtils.d("[WXScroller-onScroll] ", e);
        }
    }

    static class AppearData {
        public WXComponent mAppearComponent;
        public boolean hasAppear;
        public boolean hasDisappear;
        public boolean mAppear;

        AppearData() {
        }
    }

    public static class Ceator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return new WXScroller(instance, node, parent, lazy);
        }
    }
}

