/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.text.TextUtils;
import android.widget.ImageView;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXImgLoaderAdapter;
import com.taobao.weex.common.Component;
import com.taobao.weex.common.WXImageSharpen;
import com.taobao.weex.common.WXImageStrategy;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXImageView;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

@Component(lazyload=false)
public class WXImage
extends WXComponent<ImageView> {
    @Deprecated
    public WXImage(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this(instance, dom, parent, isLazy);
    }

    public WXImage(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) {
        super(instance, node, parent, lazy);
    }

    @Override
    protected WXImageView initComponentHostView(Context context) {
        WXImageView view = new WXImageView(this.mContext, this.mDomObj);
        view.setScaleType(ImageView.ScaleType.FIT_XY);
        return view;
    }

    @Override
    public void setBackgroundColor(String color) {
        int colorInt;
        if (!TextUtils.isEmpty((CharSequence)color) && (colorInt = WXResourceUtils.getColor(color)) != Integer.MIN_VALUE) {
            ((ImageView)this.mHost).setBackgroundColor(colorInt);
        }
    }

    @Override
    public void setBorderRadius(String key, float borderRadius) {
    }

    @Override
    public void setBorderWidth(String key, float borderWidth) {
    }

    @Override
    public void setBorderStyle(String borderStyle) {
    }

    @Override
    public void setBorderColor(String key, String borderColor) {
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "resizeMode": {
                String resize_mode = WXUtils.getString(param, null);
                if (resize_mode != null) {
                    this.setResizeMode(resize_mode);
                }
                return true;
            }
            case "resize": {
                String resize = WXUtils.getString(param, null);
                if (resize != null) {
                    this.setResize(resize);
                }
                return true;
            }
            case "src": {
                String src = WXUtils.getString(param, null);
                if (src != null) {
                    this.setSrc(src);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="resizeMode")
    public void setResizeMode(String resizeMode) {
        ((ImageView)this.getHostView()).setScaleType(this.getResizeMode(resizeMode));
    }

    private ImageView.ScaleType getResizeMode(String resizeMode) {
        ImageView.ScaleType scaleType = ImageView.ScaleType.FIT_XY;
        if (TextUtils.isEmpty((CharSequence)resizeMode)) {
            return scaleType;
        }
        if (resizeMode.equals("cover")) {
            scaleType = ImageView.ScaleType.CENTER_CROP;
        } else if (resizeMode.equals("contain")) {
            scaleType = ImageView.ScaleType.FIT_CENTER;
        } else if (resizeMode.equals("stretch")) {
            scaleType = ImageView.ScaleType.FIT_XY;
        } else if (resizeMode.equals("center")) {
            scaleType = ImageView.ScaleType.CENTER;
        } else if (resizeMode.equals("start")) {
            scaleType = ImageView.ScaleType.MATRIX;
        } else if (resizeMode.equals("end")) {
            scaleType = ImageView.ScaleType.FIT_END;
        }
        return scaleType;
    }

    @WXComponentProp(name="resize")
    public void setResize(String resize) {
        ((ImageView)this.getHostView()).setScaleType(this.getResizeMode(resize));
    }

    @WXComponentProp(name="src")
    public void setSrc(String src) {
        IWXImgLoaderAdapter imgLoaderAdapter;
        WXImageStrategy imageStrategy = new WXImageStrategy();
        imageStrategy.isClipping = true;
        WXImageSharpen imageSharpen = this.mDomObj.attr.getImageSharpen();
        imageStrategy.isSharpen = imageSharpen == WXImageSharpen.SHARPEN;
        imageStrategy.setImageListener(new WXImageStrategy.ImageListener(){

            @Override
            public void onImageFinish(String url, ImageView imageView, boolean result, Map extra) {
                if (!result && imageView != null) {
                    imageView.setImageDrawable(null);
                }
                if (WXImage.this.getDomObject() != null && WXImage.this.getDomObject().containsEvent("load")) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("success", result);
                    WXSDKManager.getInstance().fireEvent(WXImage.this.mInstanceId, WXImage.this.getRef(), "load", params);
                }
            }
        });
        if (this.mDomObj.attr != null && this.mDomObj.attr.containsKey("placeHolder")) {
            String placeHolder;
            imageStrategy.placeHolder = placeHolder = (String)this.mDomObj.attr.get("placeHolder");
        }
        if ((imgLoaderAdapter = this.mInstance.getImgLoaderAdapter()) != null) {
            imgLoaderAdapter.setImage(src, (ImageView)this.getHostView(), this.mDomObj.attr.getImageQuality(), imageStrategy);
        }
    }

    public static class Ceator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return new WXImage(instance, node, parent, lazy);
        }
    }
}

