/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.taobao.weappplus_sdk.R;
import com.taobao.weex.IWXRenderListener;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.WXRenderStrategy;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXDiv;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXFrameLayout;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;

public class WXEmbed
extends WXDiv
implements WXSDKInstance.OnInstanceVisibleListener {
    private String src;
    private WXSDKInstance instance;
    private static final int ERROR_IMG_WIDTH = (int)WXViewUtils.getRealPxByWidth(270.0f);
    private static final int ERROR_IMG_HEIGHT = (int)WXViewUtils.getRealPxByWidth(260.0f);
    private boolean mIsVisible = true;

    @Deprecated
    public WXEmbed(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this(instance, dom, parent, isLazy);
    }

    public WXEmbed(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) {
        super(instance, node, parent, lazy);
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "src": {
                String src = WXUtils.getString(param, null);
                if (src != null) {
                    this.setSrc(src);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="src")
    public void setSrc(String src) {
        this.src = src;
        if (this.instance != null) {
            this.instance.destroy();
            this.instance = null;
        }
        if (TextUtils.equals((CharSequence)this.getVisibility(), (CharSequence)"visible")) {
            this.instance = this.createInstance();
        }
    }

    private WXSDKInstance createInstance() {
        WXSDKInstance sdkInstance = new WXSDKInstance(this.mContext);
        this.mInstance.addOnInstanceVisibleListener(this);
        sdkInstance.registerRenderListener(new IWXRenderListener(){

            @Override
            public void onViewCreated(WXSDKInstance instance, View view) {
                ((WXFrameLayout)WXEmbed.this.getHostView()).removeAllViews();
                ((WXFrameLayout)WXEmbed.this.getHostView()).addView(view);
            }

            @Override
            public void onRenderSuccess(WXSDKInstance instance, int width, int height) {
            }

            @Override
            public void onRefreshSuccess(WXSDKInstance instance, int width, int height) {
            }

            @Override
            public void onException(WXSDKInstance instance, String errCode, String msg) {
                if (TextUtils.equals((CharSequence)msg, (CharSequence)"wx_network_error")) {
                    final ImageView imageView = new ImageView(WXEmbed.this.mContext);
                    imageView.setImageResource(R.drawable.error);
                    FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(ERROR_IMG_WIDTH, ERROR_IMG_HEIGHT);
                    layoutParams.gravity = 17;
                    imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    imageView.setScaleType(ImageView.ScaleType.FIT_XY);
                    imageView.setAdjustViewBounds(true);
                    imageView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            imageView.setOnClickListener(null);
                            imageView.setEnabled(false);
                            WXEmbed.this.instance = WXEmbed.this.createInstance();
                        }
                    });
                    ((WXFrameLayout)WXEmbed.this.getHostView()).removeAllViews();
                    ((WXFrameLayout)WXEmbed.this.getHostView()).addView((View)imageView);
                    WXLogUtils.e("WXEmbed", "NetWork failure :" + errCode + ",\n error message :" + msg);
                }
            }
        });
        ViewGroup.LayoutParams layoutParams = ((WXFrameLayout)this.getHostView()).getLayoutParams();
        sdkInstance.renderByUrl("default", this.src, null, null, layoutParams.width, layoutParams.height, WXRenderStrategy.APPEND_ASYNC);
        return sdkInstance;
    }

    @Override
    public void setVisibility(String visibility) {
        super.setVisibility(visibility);
        boolean visible = TextUtils.equals((CharSequence)this.getVisibility(), (CharSequence)"visible");
        if (!TextUtils.isEmpty((CharSequence)this.src) && visible) {
            if (this.instance == null) {
                this.instance = this.createInstance();
            } else {
                this.instance.onViewAppear();
            }
        }
        if (!visible && this.instance != null) {
            this.instance.onViewDisappear();
        }
        this.mIsVisible = visible;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.instance != null) {
            this.instance.destroy();
            this.instance = null;
        }
        this.src = null;
    }

    @Override
    public void onAppear() {
        WXComponent comp;
        if (this.mIsVisible && this.instance != null && (comp = this.instance.getRootCom()) != null) {
            WXBridgeManager.getInstance().fireEvent(this.instance.getInstanceId(), comp.getRef(), "viewappear", null, null);
        }
    }

    @Override
    public void onDisappear() {
        WXComponent comp;
        if (this.mIsVisible && this.instance != null && (comp = this.instance.getRootCom()) != null) {
            WXBridgeManager.getInstance().fireEvent(this.instance.getInstanceId(), comp.getRef(), "viewdisappear", null, null);
        }
    }
}

