/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ScrollView;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXRenderStrategy;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.flex.Spacing;
import com.taobao.weex.ui.animation.WXAnimationBean;
import com.taobao.weex.ui.animation.WXAnimationModule;
import com.taobao.weex.ui.component.Scrollable;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentFactory;
import com.taobao.weex.ui.component.WXScroller;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXLogUtils;
import java.util.HashMap;
import java.util.Map;

class WXRenderStatement {
    private Map<String, WXComponent> mRegistry;
    private WXSDKInstance mWXSDKInstance;
    private WXVContainer mGodComponent;

    public WXRenderStatement(WXSDKInstance instance) {
        this.mWXSDKInstance = instance;
        this.mRegistry = new HashMap<String, WXComponent>();
    }

    public void destroy() {
        this.mWXSDKInstance = null;
        if (this.mGodComponent != null) {
            this.mGodComponent.destroy();
        }
        this.mRegistry.clear();
    }

    public WXSDKInstance getWXSDKInstance() {
        return this.mWXSDKInstance;
    }

    void createBody(WXComponent component) {
        WXScroller scroller;
        long start = System.currentTimeMillis();
        component.createView(this.mGodComponent, -1);
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.renderPerformanceLog("createView", System.currentTimeMillis() - start);
        }
        start = System.currentTimeMillis();
        component.applyLayoutAndEvent(component);
        component.bindData(component);
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.renderPerformanceLog("bind", System.currentTimeMillis() - start);
        }
        if (component instanceof WXScroller && (scroller = (WXScroller)component).getInnerView() instanceof ScrollView) {
            this.mWXSDKInstance.setRootScrollView((ScrollView)scroller.getInnerView());
        }
        this.mWXSDKInstance.setRootView(this.mGodComponent.getRealView());
        if (this.mWXSDKInstance.getRenderStrategy() != WXRenderStrategy.APPEND_ONCE) {
            this.mWXSDKInstance.onViewCreated(this.mGodComponent);
        }
    }

    WXComponent createBodyOnDomThread(WXDomObject dom) {
        if (this.mWXSDKInstance == null) {
            return null;
        }
        WXDomObject domObject = new WXDomObject();
        domObject.type = "div";
        domObject.ref = "god";
        this.mGodComponent = (WXVContainer)WXComponentFactory.newInstance(this.mWXSDKInstance, domObject, null);
        this.mGodComponent.createView(null, -1);
        if (this.mGodComponent == null) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.e("rootView failed!");
            }
            return null;
        }
        FrameLayout frameLayout = (FrameLayout)this.mGodComponent.getHostView();
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -2);
        frameLayout.setLayoutParams(layoutParams);
        frameLayout.setBackgroundColor(0);
        WXComponent component = this.generateComponentTree(dom, this.mGodComponent);
        this.mGodComponent.addChild(component);
        this.mRegistry.put(component.getRef(), component);
        return component;
    }

    void setPadding(String ref, Spacing padding, Spacing border) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        component.setPadding(padding, border);
    }

    void setLayout(String ref, WXDomObject domObject) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        component.setLayout(domObject);
    }

    void setExtra(String ref, Object extra) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        component.updateExtra(extra);
    }

    void addComponent(WXDomObject dom, String parentRef, int index) {
        WXVContainer parent = (WXVContainer)this.mRegistry.get(parentRef);
        WXComponent component = this.generateComponentTree(dom, parent);
        parent.addChild(component, index);
    }

    WXComponent createComponentOnDomThread(WXDomObject dom, String parentRef, int index) {
        return this.generateComponentTree(dom, (WXVContainer)this.mRegistry.get(parentRef));
    }

    void addComponent(WXComponent component, String parentRef, int index) {
        WXVContainer parent = (WXVContainer)this.mRegistry.get(parentRef);
        if (parent == null || component == null) {
            return;
        }
        component.createView(parent, index);
        component.applyLayoutAndEvent(component);
        component.bindData(component);
        parent.addChild(component, index);
    }

    WXComponent removeComponent(String ref) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null || component.getParent() == null) {
            return component;
        }
        WXVContainer parent = component.getParent();
        this.clearRegistryForComponent(component);
        parent.remove(component);
        this.mRegistry.remove(ref);
        component.destroy();
        return component;
    }

    public WXComponent getComponent(String ref) {
        return this.mRegistry.get(ref);
    }

    private void clearRegistryForComponent(WXComponent component) {
        WXComponent removedComponent = this.mRegistry.remove(component.getDomObject().ref);
        if (removedComponent != null) {
            removedComponent.removeAllEvent();
            removedComponent.removeStickyStyle();
        }
        if (component instanceof WXVContainer) {
            WXVContainer container = (WXVContainer)component;
            int count = container.childCount();
            for (int i = count - 1; i >= 0; --i) {
                this.clearRegistryForComponent(container.getChild(i));
            }
        }
    }

    void move(String ref, String parentRef, int index) {
        WXComponent component = this.mRegistry.get(ref);
        WXComponent newParent = this.mRegistry.get(parentRef);
        if (component == null || component.getParent() == null || newParent == null || !(newParent instanceof WXVContainer)) {
            return;
        }
        WXVContainer oldParent = component.getParent();
        oldParent.remove(component, false);
        ((WXVContainer)newParent).addChild(component, index);
    }

    void addEvent(String ref, String type) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        component.addEvent(type);
    }

    void removeEvent(String ref, String type) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        component.removeEvent(type);
    }

    void updateAttrs(String ref, Map<String, Object> attrs) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        component.updateProperties(attrs);
    }

    void updateStyle(String ref, Map<String, Object> style) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        component.updateProperties(style);
    }

    void scrollTo(String ref, Map<String, Object> options) {
        Scrollable scroller;
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        int offsetInt = 0;
        if (options != null) {
            String offset;
            String string = offset = options.get("offset") == null ? "0" : options.get("offset").toString();
            if (offset != null) {
                offsetInt = Integer.parseInt(offset);
            }
        }
        if ((scroller = component.getParentScroller()) == null) {
            return;
        }
        scroller.scrollTo(component, offsetInt);
    }

    void createFinish(int width, int height) {
        if (this.mWXSDKInstance.getRenderStrategy() == WXRenderStrategy.APPEND_ONCE) {
            this.mWXSDKInstance.onViewCreated(this.mGodComponent);
        }
        this.mWXSDKInstance.onRenderSuccess(width, height);
    }

    void refreshFinish(int width, int height) {
        this.mWXSDKInstance.onRefreshSuccess(width, height);
    }

    void updateFinish() {
        this.mWXSDKInstance.onUpdateFinish();
    }

    private WXComponent generateComponentTree(WXDomObject dom, WXVContainer parent) {
        if (dom == null || parent == null) {
            return null;
        }
        WXComponent component = WXComponentFactory.newInstance(this.mWXSDKInstance, dom, parent, parent.isLazy());
        this.mRegistry.put(dom.ref, component);
        if (component instanceof WXVContainer) {
            WXVContainer parentC = (WXVContainer)component;
            int count = dom.childCount();
            WXDomObject child = null;
            for (int i = 0; i < count; ++i) {
                child = dom.getChild(i);
                if (child == null) continue;
                parentC.addChild(this.generateComponentTree(child, parentC));
            }
        }
        return component;
    }

    void startAnimation(@NonNull String ref, @NonNull WXAnimationBean animationBean, @Nullable String callBack) {
        WXAnimationModule.startAnimation(this.mWXSDKInstance, this.mRegistry.get(ref), animationBean, callBack);
    }
}

