/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui;

import android.text.TextUtils;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.WXException;
import com.taobao.weex.ui.IFComponentHolder;
import com.taobao.weex.utils.WXLogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class WXComponentRegistry {
    private static Map<String, IFComponentHolder> sTypeComponentMap = new HashMap<String, IFComponentHolder>();
    private static ArrayList<Map<String, String>> sComponentInfos = new ArrayList();

    public static boolean registerComponent(final String type, final IFComponentHolder holder, Map<String, String> componentInfo) throws WXException {
        if (holder == null || TextUtils.isEmpty((CharSequence)type)) {
            return false;
        }
        if (componentInfo == null) {
            componentInfo = new HashMap<String, String>();
        }
        componentInfo.put("type", type);
        final Map<String, String> registerInfo = componentInfo;
        WXBridgeManager.getInstance().getJSHandler().post(new Runnable(){

            @Override
            public void run() {
                try {
                    WXComponentRegistry.registerNativeComponent(type, holder);
                    WXComponentRegistry.registerJSComponent(registerInfo);
                    sComponentInfos.add(registerInfo);
                }
                catch (WXException e) {
                    WXLogUtils.e("", e);
                }
            }
        });
        return true;
    }

    private static boolean registerNativeComponent(String type, IFComponentHolder holder) throws WXException {
        try {
            holder.loadIfNonLazy();
            sTypeComponentMap.put(type, holder);
        }
        catch (ArrayStoreException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static boolean registerJSComponent(Map<String, String> componentInfo) throws WXException {
        ArrayList<Map<String, String>> coms = new ArrayList<Map<String, String>>();
        coms.add(componentInfo);
        WXSDKManager.getInstance().registerComponents(coms);
        return true;
    }

    public static IFComponentHolder getComponent(String type) {
        return sTypeComponentMap.get(type);
    }

    public static void reload() {
        WXBridgeManager.getInstance().getJSHandler().post(new Runnable(){

            @Override
            public void run() {
                try {
                    for (Map com : sComponentInfos) {
                        WXComponentRegistry.registerJSComponent(com);
                    }
                }
                catch (WXException e) {
                    WXLogUtils.e("", e);
                }
            }
        });
    }
}

