/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.appfram.storage;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.taobao.weex.utils.WXLogUtils;

public class WXSQLiteOpenHelper
extends SQLiteOpenHelper {
    private static final String DATABASE_NAME = "WXStorage";
    private static final int DATABASE_VERSION = 1;
    private long mMaximumDatabaseSize = 0x500000L;
    private static WXSQLiteOpenHelper sInstance;
    private Context mContext;
    private SQLiteDatabase mDb;
    static final String TABLE_STORAGE = "default_wx_storage";
    static final String COLUMN_KEY = "key";
    static final String COLUMN_VALUE = "value";
    private static final String STATEMENT_CREATE_TABLE = "CREATE TABLE IF NOT EXISTS default_wx_storage (key TEXT PRIMARY KEY,value TEXT NOT NULL)";

    private WXSQLiteOpenHelper(Context context) {
        super(context, DATABASE_NAME, null, 1);
        this.mContext = context;
    }

    public static WXSQLiteOpenHelper getInstance(Context context) {
        if (context == null) {
            WXLogUtils.e("can not get context instance...");
            return null;
        }
        if (sInstance == null) {
            sInstance = new WXSQLiteOpenHelper(context);
        }
        return sInstance;
    }

    SQLiteDatabase getDatabase() {
        this.ensureDatabase();
        return this.mDb;
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL(STATEMENT_CREATE_TABLE);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion != newVersion) {
            this.deleteDB();
            this.onCreate(db);
        }
    }

    synchronized void ensureDatabase() {
        if (this.mDb != null && this.mDb.isOpen()) {
            return;
        }
        this.mDb = this.getWritableDatabase();
        this.mDb.setMaximumSize(this.mMaximumDatabaseSize);
    }

    public synchronized void setMaximumSize(long size) {
        this.mMaximumDatabaseSize = size;
        if (this.mDb != null) {
            this.mDb.setMaximumSize(this.mMaximumDatabaseSize);
        }
    }

    private boolean deleteDB() {
        this.closeDatabase();
        return this.mContext.deleteDatabase(DATABASE_NAME);
    }

    public void closeDatabase() {
        if (this.mDb != null && this.mDb.isOpen()) {
            this.mDb.close();
            this.mDb = null;
        }
    }
}

