/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.taobao.weex.common.IWXObject;
import com.taobao.weex.utils.WXUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;

public class WXReflectionUtils {
    public static Object parseArgument(Type paramClazz, Object value) {
        String originValue = value instanceof String ? (String)value : JSON.toJSONString((Object)value);
        if (paramClazz == Integer.TYPE) {
            return WXUtils.getInt(originValue);
        }
        if (paramClazz == String.class) {
            return originValue;
        }
        if (paramClazz == Long.TYPE) {
            return WXUtils.getLong(originValue);
        }
        if (paramClazz == Double.TYPE) {
            return WXUtils.getDouble(originValue);
        }
        if (paramClazz == Float.TYPE) {
            return Float.valueOf(WXUtils.getFloat(originValue));
        }
        if (ParameterizedType.class.isAssignableFrom(paramClazz.getClass())) {
            return JSON.parseObject((String)originValue, (Type)paramClazz, (Feature[])new Feature[0]);
        }
        if (IWXObject.class.isAssignableFrom(paramClazz.getClass())) {
            return JSON.parseObject((String)originValue, (Type)paramClazz, (Feature[])new Feature[0]);
        }
        return JSON.parseObject((String)originValue, (Type)paramClazz, (Feature[])new Feature[0]);
    }

    public static void setValue(Object obj, String fieldName, Object value) {
        if (obj == null || TextUtils.isEmpty((CharSequence)fieldName)) {
            return;
        }
        try {
            Field field = WXReflectionUtils.getDeclaredField(obj, fieldName);
            Object realValue = value;
            if (value instanceof BigDecimal || value instanceof Number || value instanceof String) {
                if (field.getType() == Float.class || field.getType() == Float.TYPE) {
                    realValue = Float.valueOf(Float.parseFloat(value.toString()));
                } else if (field.getType() == Double.class || field.getType() == Double.TYPE) {
                    realValue = Double.parseDouble(value.toString());
                } else if (field.getType() == Integer.class || field.getType() == Integer.TYPE) {
                    realValue = (int)Double.parseDouble(value.toString());
                } else if (field.getType() == Boolean.class || field.getType() == Boolean.TYPE) {
                    realValue = Boolean.valueOf(value.toString());
                }
            }
            if ((field.getType() == Boolean.TYPE || field.getType() == Boolean.class) && value != null) {
                realValue = Boolean.valueOf(value.toString());
            }
            WXReflectionUtils.setProperty(obj, field, realValue);
        }
        catch (Exception e) {
            return;
        }
    }

    public static Field getDeclaredField(Object object, String fieldName) {
        Field field = null;
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(fieldName);
                return field;
            }
            catch (Exception e) {
                continue;
            }
        }
        return null;
    }

    public static void setProperty(Object bean, Field field, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null || field == null) {
            return;
        }
        try {
            field.setAccessible(true);
            field.set(bean, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

