/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.util.Log;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.utils.LogLevel;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;

public class WXLogUtils {
    public static String WEEX_TAG = "weex";
    public static String WEEX_PERF_TAG = "weex_perf";
    private static StringBuilder builder = new StringBuilder(50);

    public static void renderPerformanceLog(String type, long time) {
        if (WXEnvironment.isApkDebugable() || WXEnvironment.isPerf()) {
            builder.setLength(0);
            builder.append("[render time]").append(type).append(":").append(time);
            Log.d((String)WEEX_PERF_TAG, (String)builder.substring(0));
            WXLogUtils.writeConsoleLog("debug", builder.substring(0));
        }
    }

    public static void d(String msg) {
        if (WXEnvironment.isApkDebugable() && msg != null) {
            Log.d((String)WEEX_TAG, (String)msg);
            WXLogUtils.writeConsoleLog("debug", msg);
        }
        WXLogUtils.sendLog(LogLevel.DEBUG, msg);
    }

    public static void info(String msg) {
        if (WXEnvironment.isApkDebugable() && msg != null) {
            Log.i((String)WEEX_TAG, (String)msg);
            WXLogUtils.writeConsoleLog("info", msg);
        }
        WXLogUtils.sendLog(LogLevel.INFO, msg);
    }

    public static void v(String msg) {
        if (WXEnvironment.isApkDebugable() && msg != null) {
            Log.v((String)WEEX_TAG, (String)msg);
            WXLogUtils.writeConsoleLog("verbose", msg);
        }
        WXLogUtils.sendLog(LogLevel.VERBOSE, msg);
    }

    public static void w(String msg) {
        if (WXEnvironment.isApkDebugable() && msg != null) {
            Log.w((String)WEEX_TAG, (String)msg);
            WXLogUtils.writeConsoleLog("warning", msg);
        }
        WXLogUtils.sendLog(LogLevel.WARN, msg);
    }

    public static void e(String msg) {
        if (WXEnvironment.isApkDebugable() && msg != null) {
            Log.e((String)WEEX_TAG, (String)msg);
            WXLogUtils.writeConsoleLog("error", msg);
        }
        WXLogUtils.sendLog(LogLevel.ERROR, msg);
    }

    public static void d(String tag, String msg) {
        if (WXEnvironment.isApkDebugable() && msg != null) {
            Log.d((String)tag, (String)msg);
            WXLogUtils.writeConsoleLog("debug", tag + ":" + msg);
        }
        WXLogUtils.sendLog(LogLevel.DEBUG, tag + ":" + msg);
    }

    public static void i(String tag, String msg) {
        if (WXEnvironment.isApkDebugable() && msg != null) {
            Log.i((String)tag, (String)msg);
            WXLogUtils.writeConsoleLog("info", tag + ":" + msg);
        }
        WXLogUtils.sendLog(LogLevel.INFO, tag + ":" + msg);
    }

    public static void v(String tag, String msg) {
        if (WXEnvironment.isApkDebugable() && msg != null) {
            Log.v((String)tag, (String)msg);
            WXLogUtils.writeConsoleLog("verbose", tag + ":" + msg);
        }
        WXLogUtils.sendLog(LogLevel.VERBOSE, tag + ":" + msg);
    }

    public static void w(String tag, String msg) {
        if (WXEnvironment.isApkDebugable() && msg != null) {
            Log.w((String)tag, (String)msg);
            WXLogUtils.writeConsoleLog("warning", tag + ":" + msg);
        }
        WXLogUtils.sendLog(LogLevel.WARN, tag + ":" + msg);
    }

    public static void e(String tag, String msg) {
        if (WXEnvironment.isApkDebugable() && msg != null) {
            Log.e((String)tag, (String)msg);
            WXLogUtils.writeConsoleLog("error", tag + ":" + msg);
        }
        WXLogUtils.sendLog(LogLevel.ERROR, tag + ":" + msg);
    }

    public static void p(String msg) {
        if (WXEnvironment.isApkDebugable() && msg != null) {
            Log.d((String)WEEX_PERF_TAG, (String)msg);
            WXLogUtils.writeConsoleLog("debug", msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTrace(Exception e) {
        if (e == null) {
            return "";
        }
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            sw.flush();
        }
        finally {
            if (sw != null) {
                try {
                    sw.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (pw != null) {
                pw.close();
            }
        }
        return sw.toString();
    }

    private static void writeConsoleLog(String level, String message) {
        if (WXEnvironment.isApkDebugable()) {
            try {
                Class<?> cls = Class.forName("com.taobao.weex.devtools.common.LogUtil");
                Method m = cls.getMethod("log", String.class, String.class);
                m.invoke(cls, level, message);
            }
            catch (Exception e) {
                Log.d((String)WEEX_TAG, (String)"WXDebugTool not found!");
            }
        }
    }

    private static void sendLog(LogLevel level, String msg) {
        if (WXEnvironment.isApkDebugable()) {
            try {
                Class<?> cls = Class.forName("com.taobao.weex.WXDebugTool");
                Method m = cls.getMethod("sendLog", LogLevel.class, String.class);
                m.invoke(cls, new Object[]{level, msg});
            }
            catch (Exception e) {
                Log.d((String)"weex", (String)"WXDebugTool not found!");
            }
        }
    }
}

