/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.refresh.wrapper;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.taobao.weex.ui.view.refresh.core.WXSwipeLayout;

public abstract class BaseBounceView<T extends View>
extends ViewGroup {
    private int mOrientation = 1;
    protected WXSwipeLayout swipeLayout;
    private T innerView;

    public BaseBounceView(Context context, int orientation) {
        this(context, null, orientation);
    }

    public BaseBounceView(Context context, AttributeSet attrs, int orientataion) {
        super(context, attrs);
        this.mOrientation = orientataion;
        this.init(context);
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    private void init(Context context) {
        this.createBounceView(context);
    }

    boolean isVertical() {
        return this.mOrientation == 1;
    }

    public void setOnRefreshListener(WXSwipeLayout.WXOnRefreshListener onRefreshListener) {
        if (this.swipeLayout != null) {
            this.swipeLayout.setOnRefreshListener(onRefreshListener);
        }
    }

    public void setOnLoadingListener(WXSwipeLayout.WXOnLoadingListener onLoadingListener) {
        if (this.swipeLayout != null) {
            this.swipeLayout.setOnLoadingListener(onLoadingListener);
        }
    }

    public void finishPullRefresh() {
        if (this.swipeLayout != null) {
            this.swipeLayout.finishPullRefresh();
        }
    }

    public void finishPullLoad() {
        if (this.swipeLayout != null) {
            this.swipeLayout.finishPullLoad();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        View child0 = this.getChildAt(0);
        int w = 0;
        int h = 0;
        if (child0 != null) {
            child0.measure(widthMeasureSpec, heightMeasureSpec);
            w = child0.getMeasuredWidth();
            h = child0.getMeasuredHeight();
        }
        this.measureChild(w, h, 1);
        this.measureChild(w, h, 2);
    }

    private void measureChild(int w, int h, int index) {
        View child = this.getChildAt(index);
        if (child != null) {
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            if (this.isVertical()) {
                child.measure(View.MeasureSpec.makeMeasureSpec((int)w, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)lp.height, (int)(lp.height > 0 ? 0x40000000 : Integer.MIN_VALUE)));
            } else {
                child.measure(View.MeasureSpec.makeMeasureSpec((int)lp.width, (int)(lp.width > 0 ? 0x40000000 : Integer.MIN_VALUE)), View.MeasureSpec.makeMeasureSpec((int)h, (int)0x40000000));
            }
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        View child2;
        View child1;
        View child0 = this.getChildAt(0);
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int childRight = r - l - this.getPaddingRight();
        int childBottom = b - t - this.getPaddingBottom();
        if (child0 != null) {
            if (this.isVertical()) {
                child0.layout(paddingLeft, paddingTop, childRight, b - t - paddingTop);
            } else {
                child0.layout(paddingLeft, paddingTop, r - l - paddingLeft, childBottom);
            }
        }
        if ((child1 = this.getChildAt(1)) != null) {
            if (this.isVertical()) {
                int h = child1.getMeasuredHeight();
                child1.layout(paddingLeft, -h, childRight, 0);
            } else {
                int w = child1.getMeasuredWidth();
                child1.layout(-w, paddingTop, 0, childBottom);
            }
        }
        if ((child2 = this.getChildAt(2)) != null) {
            if (this.isVertical()) {
                int h = child2.getMeasuredHeight();
                child2.layout(paddingLeft, b, childRight, b + h);
            } else {
                int w = child2.getMeasuredWidth();
                child2.layout(r, paddingTop, r + w, childBottom);
            }
        }
    }

    private WXSwipeLayout createBounceView(Context context) {
        this.swipeLayout = new WXSwipeLayout(context);
        this.swipeLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.innerView = this.setInnerView(context);
        if (this.innerView == null) {
            return null;
        }
        this.swipeLayout.addView((View)this.innerView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)this.swipeLayout, -1, -1);
        return this.swipeLayout;
    }

    public T getInnerView() {
        return this.innerView;
    }

    public abstract T setInnerView(Context var1);

    public void setHeaderView(View headerView) {
        this.setRefreshEnable(true);
        if (this.swipeLayout != null && this.swipeLayout.getHeaderView() != null) {
            this.swipeLayout.getHeaderView().setRefreshView(headerView);
        }
    }

    public void setFooterView(View footerView) {
        this.setLoadmoreEnable(true);
        if (this.swipeLayout != null && this.swipeLayout.getFooterView() != null) {
            this.swipeLayout.getFooterView().setRefreshView(footerView);
        }
    }

    public void setRefreshEnable(boolean enable) {
        if (this.swipeLayout != null) {
            this.swipeLayout.setPullRefreshEnable(enable);
        }
    }

    public void setLoadmoreEnable(boolean enable) {
        if (this.swipeLayout != null) {
            this.swipeLayout.setPullLoadEnable(enable);
        }
    }

    public WXSwipeLayout getSwipeLayout() {
        return this.swipeLayout;
    }

    public abstract void onRefreshingComplete();

    public abstract void onLoadmoreComplete();
}

