/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.refresh.core;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import com.taobao.weex.ui.view.refresh.core.WXRefreshView;

public class WXSwipeLayout
extends FrameLayout
implements NestedScrollingParent {
    private NestedScrollingParentHelper parentHelper;
    private WXOnRefreshListener onRefreshListener;
    private WXOnLoadingListener onLoadingListener;
    private WXRefreshView headerView;
    private WXRefreshView footerView;
    private View mTargetView;
    private static final int REFRESH_VIEW_HEIGHT = 80;
    private static final int PULL_REFRESH = 0;
    private static final int LOAD_MORE = 1;
    private boolean mPullRefreshEnable = false;
    private boolean mPullLoadEnable = false;
    private volatile boolean mRefreshing = false;
    private float loadingViewHeight = 0.0f;
    private float refreshViewFlowHeight = 0.0f;
    private int mCurrentAction = -1;
    private boolean isConfirm = false;
    private int mRefreshViewBgColor;
    private int mProgressBgColor;
    private int mProgressColor;

    public WXSwipeLayout(Context context) {
        super(context);
        this.initAttrs(context, null);
    }

    public WXSwipeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
    }

    public WXSwipeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs);
    }

    @TargetApi(value=21)
    public WXSwipeLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initAttrs(context, attrs);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        if (this.getChildCount() > 1) {
            throw new RuntimeException("WXSwipeLayout should not have more than one child");
        }
        this.parentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.loadingViewHeight = this.dipToPx(context, 80.0f);
        this.refreshViewFlowHeight = this.loadingViewHeight * 1.5f;
        if (this.isInEditMode() && attrs == null) {
            return;
        }
        this.mRefreshViewBgColor = 0;
        this.mProgressBgColor = 0;
        this.mProgressColor = -65536;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mTargetView = this.getChildAt(0);
        this.setRefreshView();
    }

    private void setRefreshView() {
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, 0);
        this.headerView = new WXRefreshView(this.getContext());
        this.headerView.setStartEndTrim(0.0f, 0.75f);
        this.headerView.setBackgroundColor(this.mRefreshViewBgColor);
        this.headerView.setProgressBgColor(this.mProgressBgColor);
        this.headerView.setProgressColor(this.mProgressColor);
        this.addView((View)this.headerView, (ViewGroup.LayoutParams)lp);
        lp = new FrameLayout.LayoutParams(-1, 0);
        lp.gravity = 80;
        this.footerView = new WXRefreshView(this.getContext());
        this.footerView.setStartEndTrim(0.5f, 1.25f);
        this.footerView.setBackgroundColor(this.mRefreshViewBgColor);
        this.footerView.setProgressBgColor(this.mProgressBgColor);
        this.footerView.setProgressColor(this.mProgressColor);
        this.addView((View)this.footerView, (ViewGroup.LayoutParams)lp);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.mPullRefreshEnable && !this.mPullLoadEnable) {
            return false;
        }
        if (this.mRefreshing) {
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return true;
    }

    public void onNestedScrollAccepted(View child, View target, int axes) {
        this.parentHelper.onNestedScrollAccepted(child, target, axes);
    }

    public void onStopNestedScroll(View child) {
        this.parentHelper.onStopNestedScroll(child);
        this.handlerAction();
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        if (!this.mPullRefreshEnable && !this.mPullLoadEnable) {
            return;
        }
        if (Math.abs(dy) > 200) {
            return;
        }
        if (!this.isConfirm) {
            if (dy < 0 && !this.canChildScrollUp()) {
                this.mCurrentAction = 0;
                this.isConfirm = true;
            } else if (dy > 0 && !this.canChildScrollDown()) {
                this.mCurrentAction = 1;
                this.isConfirm = true;
            }
        }
        if (this.moveSpinner(-dy)) {
            consumed[1] = consumed[1] + dy;
        }
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
    }

    public int getNestedScrollAxes() {
        return this.parentHelper.getNestedScrollAxes();
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return false;
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return false;
    }

    private boolean moveSpinner(float distanceY) {
        if (this.mRefreshing) {
            return false;
        }
        if (!this.canChildScrollUp() && this.mPullRefreshEnable && this.mCurrentAction == 0) {
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.headerView.getLayoutParams();
            lp.height = (int)((float)lp.height + distanceY);
            if (lp.height < 0) {
                lp.height = 0;
            } else if ((float)lp.height > this.refreshViewFlowHeight) {
                lp.height = (int)this.refreshViewFlowHeight;
            }
            if (lp.height == 0) {
                this.isConfirm = false;
                this.mCurrentAction = -1;
            }
            this.headerView.setLayoutParams((ViewGroup.LayoutParams)lp);
            this.headerView.setProgressRotation((float)lp.height / this.refreshViewFlowHeight);
            this.moveTargetView(lp.height);
            return true;
        }
        if (!this.canChildScrollDown() && this.mPullLoadEnable && this.mCurrentAction == 1) {
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.footerView.getLayoutParams();
            lp.height = (int)((float)lp.height - distanceY);
            if (lp.height < 0) {
                lp.height = 0;
            } else if ((float)lp.height > this.refreshViewFlowHeight) {
                lp.height = (int)this.refreshViewFlowHeight;
            }
            if (lp.height == 0) {
                this.isConfirm = false;
                this.mCurrentAction = -1;
            }
            this.footerView.setLayoutParams((ViewGroup.LayoutParams)lp);
            this.footerView.setProgressRotation((float)lp.height / this.refreshViewFlowHeight);
            this.moveTargetView(-lp.height);
            return true;
        }
        return false;
    }

    private void moveTargetView(float h) {
        this.mTargetView.setTranslationY(h);
    }

    private void handlerAction() {
        FrameLayout.LayoutParams lp;
        if (this.isRefreshing()) {
            return;
        }
        this.isConfirm = false;
        if (this.mPullRefreshEnable && this.mCurrentAction == 0) {
            lp = (FrameLayout.LayoutParams)this.headerView.getLayoutParams();
            if ((float)lp.height >= this.loadingViewHeight) {
                this.startRefresh(lp.height);
            } else if (lp.height > 0) {
                this.resetHeaderView(lp.height);
            } else {
                this.resetRefreshState();
            }
        }
        if (this.mPullLoadEnable && this.mCurrentAction == 1) {
            lp = (FrameLayout.LayoutParams)this.footerView.getLayoutParams();
            if ((float)lp.height >= this.loadingViewHeight) {
                this.startLoadmore(lp.height);
            } else if (lp.height > 0) {
                this.resetFootView(lp.height);
            } else {
                this.resetLoadmoreState();
            }
        }
    }

    private void startRefresh(int headerViewHeight) {
        this.mRefreshing = true;
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{headerViewHeight, this.loadingViewHeight});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)WXSwipeLayout.this.headerView.getLayoutParams();
                lp.height = (int)((Float)animation.getAnimatedValue()).floatValue();
                WXSwipeLayout.this.headerView.setLayoutParams((ViewGroup.LayoutParams)lp);
                WXSwipeLayout.this.moveTargetView(lp.height);
            }
        });
        animator.addListener((Animator.AnimatorListener)new WXRefreshAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                WXSwipeLayout.this.headerView.startAnimation();
                if (WXSwipeLayout.this.onRefreshListener != null) {
                    WXSwipeLayout.this.onRefreshListener.onRefresh();
                }
            }
        });
        animator.setDuration(300L);
        animator.start();
    }

    private void resetHeaderView(int headerViewHeight) {
        this.headerView.stopAnimation();
        this.headerView.setStartEndTrim(0.0f, 0.75f);
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{headerViewHeight, 0.0f});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)WXSwipeLayout.this.headerView.getLayoutParams();
                lp.height = (int)((Float)animation.getAnimatedValue()).floatValue();
                WXSwipeLayout.this.headerView.setLayoutParams((ViewGroup.LayoutParams)lp);
                WXSwipeLayout.this.moveTargetView(lp.height);
            }
        });
        animator.addListener((Animator.AnimatorListener)new WXRefreshAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                WXSwipeLayout.this.resetRefreshState();
            }
        });
        animator.setDuration(300L);
        animator.start();
    }

    private void resetRefreshState() {
        this.mRefreshing = false;
        this.isConfirm = false;
        this.mCurrentAction = -1;
    }

    private void startLoadmore(int headerViewHeight) {
        this.mRefreshing = true;
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{headerViewHeight, this.loadingViewHeight});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)WXSwipeLayout.this.footerView.getLayoutParams();
                lp.height = (int)((Float)animation.getAnimatedValue()).floatValue();
                WXSwipeLayout.this.footerView.setLayoutParams((ViewGroup.LayoutParams)lp);
                WXSwipeLayout.this.moveTargetView(-lp.height);
            }
        });
        animator.addListener((Animator.AnimatorListener)new WXRefreshAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                WXSwipeLayout.this.footerView.startAnimation();
                if (WXSwipeLayout.this.onLoadingListener != null) {
                    WXSwipeLayout.this.onLoadingListener.onLoading();
                }
            }
        });
        animator.setDuration(300L);
        animator.start();
    }

    private void resetFootView(int headerViewHeight) {
        this.footerView.stopAnimation();
        this.footerView.setStartEndTrim(0.5f, 1.25f);
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{headerViewHeight, 0.0f});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)WXSwipeLayout.this.footerView.getLayoutParams();
                lp.height = (int)((Float)animation.getAnimatedValue()).floatValue();
                WXSwipeLayout.this.footerView.setLayoutParams((ViewGroup.LayoutParams)lp);
                WXSwipeLayout.this.moveTargetView(-lp.height);
            }
        });
        animator.addListener((Animator.AnimatorListener)new WXRefreshAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                WXSwipeLayout.this.resetLoadmoreState();
            }
        });
        animator.setDuration(300L);
        animator.start();
    }

    private void resetLoadmoreState() {
        this.mRefreshing = false;
        this.isConfirm = false;
        this.mCurrentAction = -1;
    }

    public boolean canChildScrollUp() {
        if (this.mTargetView == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 14) {
            if (this.mTargetView instanceof AbsListView) {
                AbsListView absListView = (AbsListView)this.mTargetView;
                return absListView.getChildCount() > 0 && (absListView.getFirstVisiblePosition() > 0 || absListView.getChildAt(0).getTop() < absListView.getPaddingTop());
            }
            return ViewCompat.canScrollVertically((View)this.mTargetView, (int)-1) || this.mTargetView.getScrollY() > 0;
        }
        return ViewCompat.canScrollVertically((View)this.mTargetView, (int)-1);
    }

    public boolean canChildScrollDown() {
        if (this.mTargetView == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 14) {
            if (this.mTargetView instanceof AbsListView) {
                AbsListView absListView = (AbsListView)this.mTargetView;
                if (absListView.getChildCount() > 0) {
                    int lastChildBottom = absListView.getChildAt(absListView.getChildCount() - 1).getBottom();
                    return absListView.getLastVisiblePosition() == ((ListAdapter)absListView.getAdapter()).getCount() - 1 && lastChildBottom <= absListView.getMeasuredHeight();
                }
                return false;
            }
            return ViewCompat.canScrollVertically((View)this.mTargetView, (int)1) || this.mTargetView.getScrollY() > 0;
        }
        return ViewCompat.canScrollVertically((View)this.mTargetView, (int)1);
    }

    public float dipToPx(Context context, float value) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return TypedValue.applyDimension((int)1, (float)value, (DisplayMetrics)metrics);
    }

    public void setOnLoadingListener(WXOnLoadingListener onLoadingListener) {
        this.onLoadingListener = onLoadingListener;
    }

    public void setOnRefreshListener(WXOnRefreshListener onRefreshListener) {
        this.onRefreshListener = onRefreshListener;
    }

    public void finishPullRefresh() {
        if (this.mCurrentAction == 0) {
            this.resetHeaderView(this.headerView == null ? 0 : this.headerView.getMeasuredHeight());
        }
    }

    public void finishPullLoad() {
        if (this.mCurrentAction == 1) {
            this.resetFootView(this.footerView == null ? 0 : this.footerView.getMeasuredHeight());
        }
    }

    public WXRefreshView getHeaderView() {
        return this.headerView;
    }

    public WXRefreshView getFooterView() {
        return this.footerView;
    }

    public boolean isPullLoadEnable() {
        return this.mPullLoadEnable;
    }

    public void setPullLoadEnable(boolean mPullLoadEnable) {
        this.mPullLoadEnable = mPullLoadEnable;
    }

    public boolean isPullRefreshEnable() {
        return this.mPullRefreshEnable;
    }

    public void setPullRefreshEnable(boolean mPullRefreshEnable) {
        this.mPullRefreshEnable = mPullRefreshEnable;
    }

    public boolean isRefreshing() {
        return this.mRefreshing;
    }

    static class WXRefreshAnimatorListener
    implements Animator.AnimatorListener {
        WXRefreshAnimatorListener() {
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }

    public static interface WXOnLoadingListener {
        public void onLoading();
    }

    public static interface WXOnRefreshListener {
        public void onRefresh();
    }
}

