/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Message;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingChildHelper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ScrollView;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXScroller;
import com.taobao.weex.ui.view.IWXScroller;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXReflectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WXScrollView
extends ScrollView
implements Handler.Callback,
IWXScroller,
WXGestureObservable,
NestedScrollingChild {
    private NestedScrollingChildHelper childHelper;
    private float ox;
    private float oy;
    private int[] consumed = new int[2];
    private int[] offsetInWindow = new int[2];
    int mScrollX;
    int mScrollY;
    private WXGesture wxGesture;
    private List<WXScrollViewListener> mScrollViewListeners;
    private WXScroller mWAScroller;
    private View mCurrentStickyView;
    private boolean mRedirectTouchToStickyView;
    private int mStickyOffset;
    private boolean mHasNotDoneActionDown = true;
    @SuppressLint(value={"HandlerLeak"})
    private Handler mScrollerTask;
    private int mInitialPosition;
    private int mCheckTime = 100;
    private int[] mStickyP = new int[2];
    private Rect mScrollRect;
    private int[] stickyScrollerP = new int[2];
    private int[] stickyViewP = new int[2];

    public WXScrollView(Context context) {
        super(context);
        this.mScrollViewListeners = new ArrayList<WXScrollViewListener>();
        this.init();
        try {
            WXReflectionUtils.setValue(this, "mMinimumVelocity", 5);
        }
        catch (Exception e) {
            WXLogUtils.e("[WXScrollView] WXScrollView: " + WXLogUtils.getStackTrace(e));
        }
    }

    private void init() {
        this.setWillNotDraw(false);
        this.startScrollerTask();
        this.setOverScrollMode(2);
        this.childHelper = new NestedScrollingChildHelper((View)this);
        this.childHelper.setNestedScrollingEnabled(true);
    }

    public void startScrollerTask() {
        if (this.mScrollerTask == null) {
            this.mScrollerTask = new Handler((Handler.Callback)this);
        }
        this.mInitialPosition = this.getScrollY();
        this.mScrollerTask.sendEmptyMessageDelayed(0, (long)this.mCheckTime);
    }

    public WXScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public WXScrollView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setOverScrollMode(2);
    }

    public void addScrollViewListener(WXScrollViewListener scrollViewListener) {
        if (!this.mScrollViewListeners.contains(scrollViewListener)) {
            this.mScrollViewListeners.add(scrollViewListener);
        }
    }

    public void removeScrollViewListener(WXScrollViewListener scrollViewListener) {
        this.mScrollViewListeners.remove(scrollViewListener);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            this.mRedirectTouchToStickyView = true;
        }
        if (this.mRedirectTouchToStickyView) {
            boolean bl = this.mRedirectTouchToStickyView = this.mCurrentStickyView != null;
            if (this.mRedirectTouchToStickyView) {
                boolean bl2 = this.mRedirectTouchToStickyView = ev.getY() <= (float)this.mCurrentStickyView.getHeight() && ev.getX() >= (float)this.mCurrentStickyView.getLeft() && ev.getX() <= (float)this.mCurrentStickyView.getRight();
            }
        }
        if (this.mRedirectTouchToStickyView) {
            if (this.mScrollRect == null) {
                this.mScrollRect = new Rect();
                this.getGlobalVisibleRect(this.mScrollRect);
            }
            this.mCurrentStickyView.getLocationOnScreen(this.stickyViewP);
            ev.offsetLocation(0.0f, (float)(this.stickyViewP[1] - this.mScrollRect.top));
        }
        return super.dispatchTouchEvent(ev);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mCurrentStickyView != null) {
            canvas.save();
            this.mCurrentStickyView.getLocationOnScreen(this.mStickyP);
            int realOffset = this.mStickyOffset <= 0 ? this.mStickyOffset : 0;
            canvas.translate((float)this.mStickyP[0], (float)(this.getScrollY() + realOffset));
            canvas.clipRect(0, realOffset, this.mCurrentStickyView.getWidth(), this.mCurrentStickyView.getHeight());
            this.mCurrentStickyView.draw(canvas);
            canvas.restore();
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mRedirectTouchToStickyView) {
            if (this.mScrollRect == null) {
                this.mScrollRect = new Rect();
                this.getGlobalVisibleRect(this.mScrollRect);
            }
            this.mCurrentStickyView.getLocationOnScreen(this.stickyViewP);
            ev.offsetLocation(0.0f, (float)(-(this.stickyViewP[1] - this.mScrollRect.top)));
        }
        if (ev.getAction() == 0) {
            this.mHasNotDoneActionDown = false;
        }
        if (this.mHasNotDoneActionDown) {
            MotionEvent down = MotionEvent.obtain((MotionEvent)ev);
            down.setAction(0);
            this.mHasNotDoneActionDown = false;
        }
        if (ev.getAction() == 0) {
            this.ox = ev.getX();
            this.oy = ev.getY();
            this.startNestedScroll(3);
        }
        if (ev.getAction() == 1 || ev.getAction() == 3) {
            this.mHasNotDoneActionDown = true;
            this.stopNestedScroll();
        }
        if (ev.getAction() == 2) {
            float clampedY;
            int dy;
            float clampedX = ev.getX();
            int dx = (int)(this.ox - clampedX);
            if (this.dispatchNestedPreScroll(dx, dy = (int)(this.oy - (clampedY = ev.getY())), this.consumed, this.offsetInWindow)) {
                ev.setLocation(clampedX + (float)this.consumed[0], clampedY + (float)this.consumed[1]);
            }
            this.ox = ev.getX();
            this.oy = ev.getY();
        }
        boolean result = super.onTouchEvent(ev);
        if (this.wxGesture != null) {
            result |= this.wxGesture.onTouch((View)this, ev);
        }
        return result;
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.childHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.childHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.childHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.childHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.childHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.childHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.childHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.childHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.childHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return this.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return this.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public void fling(int velocityY) {
        super.fling(velocityY);
        if (this.mScrollerTask != null) {
            this.mScrollerTask.removeMessages(0);
        }
        this.startScrollerTask();
    }

    protected void onScrollChanged(int x, int y, int oldx, int oldy) {
        this.mScrollX = this.getScrollX();
        this.mScrollY = this.getScrollY();
        this.onScroll(this, this.mScrollX, this.mScrollY);
        View view = this.getChildAt(this.getChildCount() - 1);
        if (view == null) {
            return;
        }
        int d = view.getBottom();
        if ((d -= this.getHeight() + this.mScrollY) == 0) {
            this.onScrollToBottom(this.mScrollX, this.mScrollY);
        }
        int count = this.mScrollViewListeners == null ? 0 : this.mScrollViewListeners.size();
        for (int i = 0; i < count; ++i) {
            this.mScrollViewListeners.get(i).onScrollChanged(this, x, y, oldx, oldy);
        }
        this.showStickyView();
    }

    protected void onScroll(WXScrollView scrollView, int x, int y) {
        int count = this.mScrollViewListeners == null ? 0 : this.mScrollViewListeners.size();
        for (int i = 0; i < count; ++i) {
            this.mScrollViewListeners.get(i).onScroll(this, x, y);
        }
    }

    protected void onScrollToBottom(int x, int y) {
        int count = this.mScrollViewListeners == null ? 0 : this.mScrollViewListeners.size();
        for (int i = 0; i < count; ++i) {
            this.mScrollViewListeners.get(i).onScrollToBottom(this, x, y);
        }
    }

    private void showStickyView() {
        View curStickyView = this.procSticky(this.mWAScroller.getStickMap());
        this.mCurrentStickyView = curStickyView != null ? curStickyView : null;
    }

    private View procSticky(Map<String, HashMap<String, WXComponent>> mStickyMap) {
        if (mStickyMap == null) {
            return null;
        }
        HashMap<String, WXComponent> stickyMap = mStickyMap.get(this.mWAScroller.getRef());
        if (stickyMap == null) {
            return null;
        }
        Iterator<Map.Entry<String, WXComponent>> iterator = stickyMap.entrySet().iterator();
        Map.Entry<String, WXComponent> entry = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            WXComponent stickyData = entry.getValue();
            this.getLocationOnScreen(this.stickyScrollerP);
            stickyData.getView().getLocationOnScreen(this.stickyViewP);
            int parentH = 0;
            if (stickyData.getParent() != null && stickyData.getParent().getRealView() != null) {
                parentH = stickyData.getParent().getRealView().getHeight();
            }
            int stickyViewH = stickyData.getView().getHeight();
            int stickyShowPos = this.stickyScrollerP[1];
            int stickyStartHidePos = -parentH + this.stickyScrollerP[1] + stickyViewH;
            if (this.stickyViewP[1] > stickyShowPos || this.stickyViewP[1] < stickyStartHidePos - stickyViewH) continue;
            this.mStickyOffset = this.stickyViewP[1] - stickyStartHidePos;
            return stickyData.getView();
        }
        return null;
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                int newPosition;
                if (this.mScrollerTask != null) {
                    this.mScrollerTask.removeMessages(0);
                }
                if (this.mInitialPosition - (newPosition = this.getScrollY()) == 0) {
                    this.onScrollStopped(this, this.getScrollX(), this.getScrollY());
                    break;
                }
                this.onScroll(this, this.getScrollX(), this.getScrollY());
                this.mInitialPosition = this.getScrollY();
                if (this.mScrollerTask == null) break;
                this.mScrollerTask.sendEmptyMessageDelayed(0, (long)this.mCheckTime);
                break;
            }
        }
        return true;
    }

    protected void onScrollStopped(WXScrollView scrollView, int x, int y) {
        int count = this.mScrollViewListeners == null ? 0 : this.mScrollViewListeners.size();
        for (int i = 0; i < count; ++i) {
            this.mScrollViewListeners.get(i).onScrollStopped(this, x, y);
        }
    }

    @Override
    public void destroy() {
        if (this.mScrollerTask != null) {
            this.mScrollerTask.removeCallbacksAndMessages(null);
        }
    }

    @Override
    public void registerGestureListener(WXGesture wxGesture) {
        this.wxGesture = wxGesture;
    }

    public void setWAScroller(WXScroller mWAScroller) {
        this.mWAScroller = mWAScroller;
    }

    public static interface WXScrollViewListener {
        public void onScrollChanged(WXScrollView var1, int var2, int var3, int var4, int var5);

        public void onScrollToBottom(WXScrollView var1, int var2, int var3);

        public void onScrollStopped(WXScrollView var1, int var2, int var3);

        public void onScroll(WXScrollView var1, int var2, int var3);
    }
}

