/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.common.WXModuleAnno;
import com.taobao.weex.common.WXRequest;
import com.taobao.weex.common.WXResponse;
import com.taobao.weex.http.Options;
import com.taobao.weex.http.Status;
import com.taobao.weex.utils.WXLogUtils;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WXStreamModule
extends WXModule {
    public static final String STATUS_TEXT = "statusText";
    public static final String STATUS = "status";
    final IWXHttpAdapter mAdapter;
    static final Pattern CHARSET_PATTERN = Pattern.compile("charset=([a-z0-9-]+)");

    public WXStreamModule() {
        this(null);
    }

    public WXStreamModule(IWXHttpAdapter adapter) {
        this.mAdapter = adapter;
    }

    @Deprecated
    @WXModuleAnno
    public void sendHttp(String params, final String callback) {
        JSONObject paramsObj = JSON.parseObject((String)params);
        String method = paramsObj.getString("method");
        String url = paramsObj.getString("url");
        JSONObject headers = paramsObj.getJSONObject("header");
        String body = paramsObj.getString("body");
        Options.Builder builder = new Options.Builder().setMethod(!"GET".equals(method) && !"POST".equals(method) ? "GET" : method).setUrl(url).setBody(body);
        this.extractHeaders(headers, builder);
        this.sendRequest(builder.createOptions(), new ResponseCallback(){

            @Override
            public void onResponse(WXResponse response, Map<String, String> headers) {
                if (callback != null) {
                    WXBridgeManager.getInstance().callback(WXStreamModule.this.mWXSDKInstance.getInstanceId(), callback, response == null || response.originalData == null ? "{}" : WXStreamModule.readAsString(response.originalData, headers != null ? headers.get("Content-Type") : ""));
                }
            }
        }, null);
    }

    @WXModuleAnno
    public void fetch(String optionsStr, final JSCallback callback, JSCallback progressCallback) {
        boolean invaildOption;
        JSONObject optionsObj = null;
        try {
            optionsObj = JSON.parseObject((String)optionsStr);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        boolean bl = invaildOption = optionsObj == null || optionsObj.getString("url") == null;
        if (invaildOption) {
            if (callback != null) {
                HashMap<String, Object> resp = new HashMap<String, Object>();
                resp.put("ok", false);
                resp.put(STATUS_TEXT, "ERR_INVALID_REQUEST");
                callback.invoke(resp);
            }
            return;
        }
        String method = optionsObj.getString("method");
        String url = optionsObj.getString("url");
        JSONObject headers = optionsObj.getJSONObject("headers");
        String body = optionsObj.getString("body");
        String type = optionsObj.getString("type");
        Options.Builder builder = new Options.Builder().setMethod(!"GET".equals(method) && !"POST".equals(method) ? "GET" : method).setUrl(url).setBody(body).setType(type);
        this.extractHeaders(headers, builder);
        final Options options = builder.createOptions();
        this.sendRequest(options, new ResponseCallback(){

            @Override
            public void onResponse(WXResponse response, Map<String, String> headers) {
                if (callback != null) {
                    HashMap<String, Object> resp = new HashMap<String, Object>();
                    if (response == null || "-1".equals(response.statusCode)) {
                        resp.put(WXStreamModule.STATUS, "-1");
                        resp.put(WXStreamModule.STATUS_TEXT, "ERR_CONNECT_FAILED");
                    } else {
                        resp.put(WXStreamModule.STATUS, response.statusCode);
                        int code = Integer.parseInt(response.statusCode);
                        resp.put("ok", code >= 200 && code <= 299);
                        if (response.originalData == null) {
                            resp.put("data", null);
                        } else {
                            String respData = WXStreamModule.readAsString(response.originalData, headers != null ? headers.get("Content-Type") : "");
                            resp.put("data", options.getType() != Options.Type.text ? JSONObject.parse((String)respData) : respData);
                        }
                        resp.put(WXStreamModule.STATUS_TEXT, Status.getStatusText(response.statusCode));
                    }
                    resp.put("headers", headers);
                    callback.invoke(resp);
                }
            }
        }, progressCallback);
    }

    static String readAsString(byte[] data, String cType) {
        Matcher matcher;
        String charset = "utf-8";
        if (cType != null && (matcher = CHARSET_PATTERN.matcher(cType.toLowerCase())).find()) {
            charset = matcher.group(1);
        }
        try {
            return new String(data, charset);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return new String(data);
        }
    }

    private void extractHeaders(JSONObject headers, Options.Builder builder) {
        if (headers != null) {
            for (String key : headers.keySet()) {
                builder.putHeader(key, headers.getString(key));
            }
        }
    }

    private void sendRequest(Options options, ResponseCallback callback, JSCallback progressCallback) {
        IWXHttpAdapter adapter;
        WXRequest wxRequest = new WXRequest();
        wxRequest.method = options.getMethod();
        wxRequest.url = options.getUrl();
        wxRequest.body = options.getBody();
        if (options.getHeaders() != null) {
            if (wxRequest.paramMap == null) {
                wxRequest.paramMap = options.getHeaders();
            } else {
                wxRequest.paramMap.putAll(options.getHeaders());
            }
        }
        IWXHttpAdapter iWXHttpAdapter = adapter = this.mAdapter == null && this.mWXSDKInstance != null ? this.mWXSDKInstance.getWXHttpAdapter() : this.mAdapter;
        if (adapter != null) {
            adapter.sendRequest(wxRequest, new StreamHttpListener(callback, progressCallback));
        } else {
            WXLogUtils.e("WXStreamModule", "No HttpAdapter found,request failed.");
        }
    }

    private static class StreamHttpListener
    implements IWXHttpAdapter.OnHttpListener {
        private ResponseCallback mCallback;
        private JSCallback mProgressCallback;
        private Map<String, Object> mResponse = new HashMap<String, Object>();
        private Map<String, String> mRespHeaders;

        private StreamHttpListener(ResponseCallback callback, JSCallback progressCallback) {
            this.mCallback = callback;
            this.mProgressCallback = progressCallback;
        }

        @Override
        public void onHttpStart() {
            if (this.mProgressCallback != null) {
                this.mResponse.put("readyState", 1);
                this.mResponse.put("length", 0);
                this.mProgressCallback.invokeAndKeepAlive(this.mResponse);
            }
        }

        @Override
        public void onHttpUploadProgress(int uploadProgress) {
        }

        @Override
        public void onHeadersReceived(int statusCode, Map<String, List<String>> headers) {
            this.mResponse.put("readyState", 2);
            this.mResponse.put(WXStreamModule.STATUS, statusCode);
            Iterator<Map.Entry<String, List<String>>> it = headers.entrySet().iterator();
            HashMap<String, String> simpleHeaders = new HashMap<String, String>();
            while (it.hasNext()) {
                Map.Entry<String, List<String>> entry = it.next();
                if (entry.getValue().size() <= 0) continue;
                simpleHeaders.put(entry.getKey() == null ? "_" : entry.getKey(), entry.getValue().get(0));
            }
            this.mResponse.put("headers", simpleHeaders);
            this.mRespHeaders = simpleHeaders;
            if (this.mProgressCallback != null) {
                this.mProgressCallback.invokeAndKeepAlive(this.mResponse);
            }
        }

        @Override
        public void onHttpResponseProgress(int loadedLength) {
            this.mResponse.put("length", loadedLength);
            if (this.mProgressCallback != null) {
                this.mProgressCallback.invokeAndKeepAlive(this.mResponse);
            }
        }

        @Override
        public void onHttpFinish(WXResponse response) {
            if (this.mCallback != null) {
                this.mCallback.onResponse(response, this.mRespHeaders);
            }
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("WXStreamModule", response != null && response.originalData != null ? new String(response.originalData) : "response data is NUll!");
            }
        }
    }

    private static interface ResponseCallback {
        public void onResponse(WXResponse var1, Map<String, String> var2);
    }
}

