/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.dom.WXDomHandler;
import com.taobao.weex.dom.WXDomStatement;
import com.taobao.weex.ui.WXRenderManager;
import com.taobao.weex.utils.WXUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class WXDomManager {
    private WXThread mDomThread;
    private Handler mDomHandler;
    private WXRenderManager mWXRenderManager;
    private ConcurrentHashMap<String, WXDomStatement> mDomRegistries;

    public WXDomManager(WXRenderManager renderManager) {
        this.mWXRenderManager = renderManager;
        this.mDomRegistries = new ConcurrentHashMap();
        this.mDomThread = new WXThread("WeeXDomThread", new WXDomHandler(this));
        this.mDomHandler = this.mDomThread.getHandler();
    }

    public void sendEmptyMessageDelayed(int what, long delayMillis) {
        if (this.mDomHandler == null || this.mDomThread == null || !this.mDomThread.isWXThreadAlive() || this.mDomThread.getLooper() == null) {
            return;
        }
        this.mDomHandler.sendEmptyMessageDelayed(what, delayMillis);
    }

    public void sendMessage(Message msg) {
        if (msg == null || this.mDomHandler == null || this.mDomThread == null || !this.mDomThread.isWXThreadAlive() || this.mDomThread.getLooper() == null) {
            return;
        }
        this.mDomHandler.sendMessage(msg);
    }

    public void removeDomStatement(String instanceId) {
        if (!WXUtils.isUiThread()) {
            throw new WXRuntimeException("[WXDomManager] removeDomStatement");
        }
        final WXDomStatement statement = this.mDomRegistries.remove(instanceId);
        if (statement != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    statement.destroy();
                }
            });
        }
    }

    public void post(Runnable task) {
        if (this.mDomHandler == null || task == null || this.mDomThread == null || !this.mDomThread.isWXThreadAlive() || this.mDomThread.getLooper() == null) {
            return;
        }
        this.mDomHandler.post(task);
    }

    public void destroy() {
        if (this.mDomThread != null && this.mDomThread.isWXThreadAlive()) {
            this.mDomThread.quit();
        }
        if (this.mDomRegistries != null) {
            this.mDomRegistries.clear();
        }
        this.mDomHandler = null;
        this.mDomThread = null;
    }

    void createBody(String instanceId, JSONObject element) {
        if (!this.isDomThread()) {
            throw new WXRuntimeException("Create body operation must be done in dom thread");
        }
        WXDomStatement statement = new WXDomStatement(instanceId, this.mWXRenderManager);
        this.mDomRegistries.put(instanceId, statement);
        statement.createBody(element);
    }

    private boolean isDomThread() {
        return !WXEnvironment.isApkDebugable() || Thread.currentThread().getId() == this.mDomThread.getId();
    }

    void batch() {
        if (!this.isDomThread()) {
            throw new WXRuntimeException("Batch operation must be done in dom thread");
        }
        Iterator<Map.Entry<String, WXDomStatement>> iterator = this.mDomRegistries.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.next().getValue().batch();
        }
    }

    void addDom(String instanceId, String parentRef, JSONObject element, int index) {
        if (!this.isDomThread()) {
            throw new WXRuntimeException("Add dom operation must be done in dom thread");
        }
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.addDom(element, parentRef, index);
    }

    void removeDom(String instanceId, String ref) {
        if (!this.isDomThread()) {
            throw new WXRuntimeException("Remove dom operation must be done in dom thread");
        }
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.removeDom(ref);
    }

    void moveDom(String instanceId, String ref, String parentRef, int index) {
        if (!this.isDomThread()) {
            throw new WXRuntimeException("Move dom operation must be done in dom thread");
        }
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.moveDom(ref, parentRef, index);
    }

    void updateAttrs(String instanceId, String ref, JSONObject attr) {
        if (!this.isDomThread()) {
            throw new WXRuntimeException("UpdateAttrs operation must be done in dom thread");
        }
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.updateAttrs(ref, attr);
    }

    void updateStyle(String instanceId, String ref, JSONObject style) {
        if (!this.isDomThread()) {
            throw new WXRuntimeException("UpdateStyle operation must be done in dom thread");
        }
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.updateStyle(ref, style);
    }

    void addEvent(String instanceId, String ref, String type) {
        if (!this.isDomThread()) {
            throw new WXRuntimeException("AddEvent operation must be done in dom thread");
        }
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.addEvent(ref, type);
    }

    void removeEvent(String instanceId, String ref, String type) {
        if (!this.isDomThread()) {
            throw new WXRuntimeException("RemoveEvent operation must be done in dom thread");
        }
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.removeEvent(ref, type);
    }

    void scrollToDom(String instanceId, String ref, JSONObject options) {
        if (!this.isDomThread()) {
            throw new WXRuntimeException("ScrollToDom operation must be done in dom thread");
        }
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.scrollToDom(ref, options);
    }

    void createFinish(String instanceId) {
        if (!this.isDomThread()) {
            throw new WXRuntimeException("CreateFinish operation must be done in dom thread");
        }
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.createFinish();
    }

    void refreshFinish(String instanceId) {
        if (!this.isDomThread()) {
            throw new WXRuntimeException("RefreshFinish operation must be done in dom thread");
        }
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.refreshFinish();
    }

    void updateFinish(String instanceId) {
        if (!this.isDomThread()) {
            throw new WXRuntimeException("RefreshFinish operation must be done in dom thread");
        }
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.updateFinish();
    }

    void startAnimation(@NonNull String instanceId, @NonNull String ref, @NonNull String animation, @Nullable String callBack) {
        if (!this.isDomThread()) {
            throw new WXRuntimeException("RefreshFinish operation must be done in dom thread");
        }
        WXDomStatement statement = this.mDomRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.startAnimation(ref, animation, callBack);
    }
}

