/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex;

import android.app.Application;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.utils.LogLevel;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXSoInstallMgrSdk;
import com.taobao.weex.utils.WXUtils;
import java.util.HashMap;
import java.util.Map;

public class WXEnvironment {
    public static final String OS = "android";
    public static final String SYS_VERSION = Build.VERSION.RELEASE;
    public static final String SYS_MODEL = Build.MODEL;
    public static String JS_LIB_SDK_VERSION = "v0.13.10";
    public static String WXSDK_VERSION = "0.5.2.8";
    public static Application sApplication;
    public static final String DEV_Id;
    public static int sDefaultWidth;
    public static volatile boolean JsFrameworkInit;
    public static final String SETTING_EXCLUDE_X86SUPPORT = "env_exclude_x86";
    public static boolean SETTING_FORCE_VERTICAL_SCREEN;
    public static boolean sDebugMode;
    public static String sDebugWsUrl;
    public static boolean sRemoteDebugMode;
    public static String sRemoteDebugProxyUrl;
    public static long sJSLibInitTime;
    public static long sSDKInitInvokeTime;
    public static long sSDKInitExecuteTime;
    public static LogLevel sLogLevel;
    private static boolean isApkDebug;
    private static boolean isPerf;
    public static boolean sShow3DLayer;
    private static Map<String, String> options;
    public static boolean sDynamicMode;
    public static String sDynamicUrl;

    public static Map<String, String> getConfig() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("os", OS);
        configs.put("appVersion", WXEnvironment.getAppVersionName());
        configs.put("devId", DEV_Id);
        configs.put("sysVersion", SYS_VERSION);
        configs.put("sysModel", SYS_MODEL);
        configs.put("weexVersion", String.valueOf(WXSDK_VERSION));
        configs.put("logLevel", sLogLevel.getName());
        configs.putAll(options);
        if (configs != null && configs.get("appName") == null && sApplication != null) {
            configs.put("appName", sApplication.getPackageName());
        }
        return configs;
    }

    private static String getAppVersionName() {
        String versionName = "";
        PackageInfo info = null;
        try {
            PackageManager manager = sApplication.getPackageManager();
            info = manager.getPackageInfo(sApplication.getPackageName(), 0);
            versionName = info.versionName;
        }
        catch (Exception e) {
            WXLogUtils.e("WXEnvironment getAppVersionName Exception: " + WXLogUtils.getStackTrace(e));
        }
        return versionName;
    }

    public static void addCustomOptions(String key, String value) {
        options.put(key, value);
    }

    public static boolean isSupport() {
        boolean isCPUSupport;
        boolean excludeX86 = "true".equals(options.get(SETTING_EXCLUDE_X86SUPPORT));
        boolean isX86AndExcluded = WXSoInstallMgrSdk.isX86() && excludeX86;
        boolean bl = isCPUSupport = WXSoInstallMgrSdk.isCPUSupport() && !isX86AndExcluded;
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("WXEnvironment.sSupport:" + isCPUSupport + " WXSDKEngine.isInitialized():" + WXSDKEngine.isInitialized() + " !WXUtils.isTabletDevice():" + !WXUtils.isTabletDevice());
        }
        return isCPUSupport && WXSDKEngine.isInitialized() && !WXUtils.isTabletDevice();
    }

    public static boolean isApkDebugable() {
        if (sApplication == null) {
            return false;
        }
        if (isPerf) {
            return false;
        }
        if (!isApkDebug) {
            return false;
        }
        try {
            ApplicationInfo info = sApplication.getApplicationInfo();
            isApkDebug = (info.flags & 2) != 0;
            return isApkDebug;
        }
        catch (Exception e) {
            WXLogUtils.e("WXEnvironment isApkDebugable Exception: " + WXLogUtils.getStackTrace(e));
            return false;
        }
    }

    public static boolean isPerf() {
        return isPerf;
    }

    private static String getDevId() {
        return sApplication == null ? "" : ((TelephonyManager)sApplication.getSystemService("phone")).getDeviceId();
    }

    public static Application getApplication() {
        return sApplication;
    }

    public void initMetrics() {
        if (sApplication == null) {
            return;
        }
    }

    static {
        DEV_Id = WXEnvironment.getDevId();
        sDefaultWidth = 750;
        JsFrameworkInit = false;
        SETTING_FORCE_VERTICAL_SCREEN = false;
        sDebugMode = false;
        sDebugWsUrl = "";
        sRemoteDebugMode = false;
        sRemoteDebugProxyUrl = "";
        sJSLibInitTime = 0L;
        sSDKInitInvokeTime = 0L;
        sSDKInitExecuteTime = 0L;
        sLogLevel = LogLevel.DEBUG;
        isApkDebug = true;
        isPerf = false;
        sShow3DLayer = true;
        options = new HashMap<String, String>();
        sDynamicMode = false;
        sDynamicUrl = "";
    }
}

