/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.listview;

import android.content.Context;
import android.support.v4.view.GestureDetectorCompat;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.Scroller;
import com.taobao.weex.ui.view.listview.IRefreshLayout;

public abstract class BaseBounceView<T extends View>
extends ViewGroup {
    private static final float FRICTION = 2.0f;
    private static final int DEFAULT_DURATION = 250;
    private int mTouchSlop;
    private boolean mIsBeingDragged;
    private float mLastMotionY;
    private float mLastMotionX;
    private Mode mMode;
    protected Scroller mScroller;
    private T mView;
    private IRefreshLayout mRefreshLayout;
    private IRefreshLayout mLoadMoreLayout;
    private int mScrollValue = 0;
    private int mMaxPadding = 0;
    private GestureDetectorCompat mGestureDetector;
    private boolean mBounceable = true;
    private int mOrientation = 1;
    private static final int[] STATE_LAYOUT_WIDTH = new int[]{-2, -1};
    private static final int[] STATE_LAYOUT_HEIGHT = new int[]{-1, -2};
    private final GestureDetector.SimpleOnGestureListener mGestureListener = new GestureDetector.SimpleOnGestureListener(){

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (BaseBounceView.this.isVertical()) {
                BaseBounceView.this.mScroller.fling(BaseBounceView.this.getPaddingLeft(), BaseBounceView.this.getPaddingTop(), 0, (int)velocityY, 0, 0, -BaseBounceView.this.mMaxPadding, 0);
            } else {
                BaseBounceView.this.mScroller.fling(BaseBounceView.this.getPaddingLeft(), BaseBounceView.this.getPaddingTop(), (int)velocityX, 0, -BaseBounceView.this.mMaxPadding, 0, 0, 0);
            }
            BaseBounceView.this.invalidate();
            return true;
        }
    };

    public BaseBounceView(Context context, int orientation) {
        this(context, null, orientation);
    }

    public BaseBounceView(Context context, AttributeSet attrs, int orientataion) {
        super(context, attrs);
        this.mOrientation = orientataion;
        this.init(context);
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    private void init(Context context) {
        ViewConfiguration config = ViewConfiguration.get((Context)this.getContext());
        this.mTouchSlop = config.getScaledTouchSlop();
        this.mScroller = new Scroller(context);
        this.mView = this.createBounceView(context);
        this.addView((View)this.mView, -1, -1);
        this.mRefreshLayout = this.createBounceHeaderView(context);
        if (this.mRefreshLayout != null) {
            this.addView(this.mRefreshLayout.getView(), STATE_LAYOUT_WIDTH[this.mOrientation], STATE_LAYOUT_HEIGHT[this.mOrientation]);
        }
        this.mLoadMoreLayout = this.createBounceFooterView(context);
        if (this.mLoadMoreLayout != null) {
            this.addView(this.mLoadMoreLayout.getView(), STATE_LAYOUT_WIDTH[this.mOrientation], STATE_LAYOUT_HEIGHT[this.mOrientation]);
        }
    }

    public final T getBounceView() {
        return this.mView;
    }

    boolean isVertical() {
        return this.mOrientation == 1;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (action != 0 && this.mIsBeingDragged) {
            return true;
        }
        switch (action) {
            case 0: {
                this.mLastMotionY = ev.getRawY();
                this.mLastMotionX = ev.getRawX();
                this.mScrollValue = this.isVertical() ? -this.getPaddingTop() : -this.getPaddingLeft();
                break;
            }
            case 2: {
                float mainDelta;
                float x = ev.getRawX();
                float y = ev.getRawY();
                float deltaX = ev.getRawX() - this.mLastMotionX;
                float deltaY = ev.getRawY() - this.mLastMotionY;
                float degree = this.isVertical() ? Math.abs(deltaY) / Math.abs(deltaX) : Math.abs(deltaX) / Math.abs(deltaY);
                float f = mainDelta = this.isVertical() ? deltaY : deltaX;
                if (!(Math.abs(mainDelta) > (float)this.mTouchSlop) || !(degree >= 1.7f) || !this.mBounceable) break;
                if (mainDelta > 0.0f && this.isReadyForPullFromStart()) {
                    this.mLastMotionX = x;
                    this.mLastMotionY = y;
                    this.mIsBeingDragged = true;
                    this.mMode = Mode.PULL_FROM_START;
                    break;
                }
                if (!(mainDelta < 0.0f) || !this.isReadyForPullFromEnd()) break;
                this.mLastMotionX = x;
                this.mLastMotionY = y;
                this.mIsBeingDragged = true;
                this.mMode = Mode.PULL_FROM_END;
                break;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
            }
        }
        return this.mIsBeingDragged;
    }

    private int getStartPadding() {
        return this.isVertical() ? this.getPaddingTop() : this.getPaddingLeft();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mGestureDetector != null) {
            this.mGestureDetector.onTouchEvent(ev);
        }
        switch (ev.getAction()) {
            case 0: {
                if (ev.getEdgeFlags() != 0) {
                    return false;
                }
                this.mLastMotionX = ev.getRawX();
                this.mLastMotionY = ev.getRawY();
                this.mScrollValue = this.isVertical() ? -this.getPaddingTop() : -this.getPaddingLeft();
                return this.mIsBeingDragged;
            }
            case 2: {
                if (!this.mIsBeingDragged) break;
                float raw = this.isVertical() ? ev.getRawY() : ev.getRawX();
                this.startPull(raw);
                return true;
            }
            case 1: 
            case 3: {
                if (!this.mIsBeingDragged) break;
                this.mScrollValue = this.isVertical() ? -this.getPaddingTop() : -this.getPaddingLeft();
                this.mIsBeingDragged = false;
                this.onTouchActionUp();
                if (this.mMaxPadding > 0) {
                    int startPadding = this.getStartPadding();
                    if (startPadding > 0) {
                        this.mScrollValue = startPadding > 0 ? 0 : -this.mMaxPadding;
                        this.backToInitPos(startPadding, startPadding > 0 ? -startPadding : -this.mMaxPadding - startPadding);
                    }
                } else {
                    int delta = this.isVertical() ? this.getScrollY() : this.getScrollX();
                    this.backToInitPos(delta, -delta);
                }
                this.mMode = null;
                return true;
            }
        }
        return false;
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.mScroller.computeScrollOffset()) {
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (this.mMaxPadding > 0) {
                this.mScrollValue = this.isVertical() ? -y : -x;
                this.setPadding(x, y, 0, 0);
            } else {
                this.scrollTo(x, y);
            }
            this.invalidate();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        View child0 = this.getChildAt(0);
        int w = 0;
        int h = 0;
        if (child0 != null) {
            child0.measure(widthMeasureSpec, heightMeasureSpec);
            w = child0.getMeasuredWidth();
            h = child0.getMeasuredHeight();
        }
        this.measureChild(w, h, 1);
        this.measureChild(w, h, 2);
    }

    private void measureChild(int w, int h, int index) {
        View child = this.getChildAt(index);
        if (child != null) {
            ViewGroup.LayoutParams lp = child.getLayoutParams();
            if (this.isVertical()) {
                child.measure(View.MeasureSpec.makeMeasureSpec((int)w, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)lp.height, (int)(lp.height > 0 ? 0x40000000 : Integer.MIN_VALUE)));
            } else {
                child.measure(View.MeasureSpec.makeMeasureSpec((int)lp.width, (int)(lp.width > 0 ? 0x40000000 : Integer.MIN_VALUE)), View.MeasureSpec.makeMeasureSpec((int)h, (int)0x40000000));
            }
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        View child2;
        View child1;
        View child0 = this.getChildAt(0);
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int childRight = r - l - this.getPaddingRight();
        int childBottom = b - t - this.getPaddingBottom();
        if (child0 != null) {
            if (this.isVertical()) {
                child0.layout(paddingLeft, paddingTop, childRight, b - t - paddingTop);
            } else {
                child0.layout(paddingLeft, paddingTop, r - l - paddingLeft, childBottom);
            }
        }
        if ((child1 = this.getChildAt(1)) != null) {
            if (this.isVertical()) {
                int h = child1.getMeasuredHeight();
                child1.layout(paddingLeft, -h, childRight, 0);
            } else {
                int w = child1.getMeasuredWidth();
                child1.layout(-w, paddingTop, 0, childBottom);
            }
        }
        if ((child2 = this.getChildAt(2)) != null) {
            if (this.isVertical()) {
                int h = child2.getMeasuredHeight();
                child2.layout(paddingLeft, b, childRight, b + h);
            } else {
                int w = child2.getMeasuredWidth();
                child2.layout(r, paddingTop, r + w, childBottom);
            }
        }
    }

    protected void smoothScroll(int value) {
        if (this.isVertical()) {
            this.mScroller.startScroll(0, this.getScrollY(), 0, value);
        } else {
            this.mScroller.startScroll(this.getScrollX(), 0, value, 0);
        }
        this.invalidate();
    }

    public void setBounceable(boolean bounceable) {
        this.mBounceable = bounceable;
    }

    public void setEffectMaxHeight(int padding) {
        this.mMaxPadding = padding;
        if (this.mGestureDetector == null) {
            this.mGestureDetector = new GestureDetectorCompat(this.getContext(), (GestureDetector.OnGestureListener)this.mGestureListener);
        }
    }

    private void startPull(float raw) {
        int scrollValue = 0;
        float last = this.isVertical() ? this.mLastMotionY : this.mLastMotionX;
        switch (this.mMode) {
            case PULL_FROM_START: {
                scrollValue = Math.round(Math.min(last - raw, 0.0f) / 2.0f);
                break;
            }
            case PULL_FROM_END: {
                scrollValue = Math.round(Math.max(last - raw, 0.0f) / 2.0f);
            }
        }
        this.pullScrollTo(this.mScrollValue + scrollValue);
    }

    private void pullScrollTo(int scrollValue) {
        int maxScroll = this.getMaximumPullScroll();
        scrollValue = Math.min(maxScroll, Math.max(-maxScroll, scrollValue));
        if (this.mMaxPadding > 0) {
            if (this.isVertical()) {
                this.setPadding(0, -scrollValue <= -this.mMaxPadding ? -this.mMaxPadding : -scrollValue, 0, 0);
            } else {
                this.setPadding(-scrollValue <= -this.mMaxPadding ? -this.mMaxPadding : -scrollValue, 0, 0, 0);
            }
        } else if (this.isVertical()) {
            this.scrollTo(0, scrollValue);
        } else {
            this.scrollTo(scrollValue, 0);
        }
        this.onPull(scrollValue);
    }

    private void onPull(int scrollValue) {
        IRefreshLayout pullLayout = null;
        switch (this.mMode) {
            case PULL_FROM_START: {
                pullLayout = this.mRefreshLayout;
                break;
            }
            case PULL_FROM_END: {
                pullLayout = this.mLoadMoreLayout;
            }
        }
        if ((this.mMode == Mode.PULL_FROM_START || this.mMode == Mode.PULL_FROM_END) && pullLayout != null) {
            int itemDimension = this.isVertical() ? pullLayout.getView().getHeight() : pullLayout.getView().getWidth();
            float scaleOfLayout = (float)Math.abs(scrollValue) / (float)itemDimension;
            float angle = scaleOfLayout * 90.0f;
            pullLayout.onPull(angle);
            this.onPullStateChanged(itemDimension, scrollValue);
        }
    }

    private void backToInitPos(int start, int delta) {
        int duration = 250;
        if (this.mRefreshLayout != null) {
            int scrollLen = Math.abs(this.isVertical() ? this.getScrollY() : this.getScrollX());
            int limit = this.isVertical() ? this.mRefreshLayout.getView().getHeight() : this.mRefreshLayout.getView().getWidth();
            duration = scrollLen < limit ? 250 : (scrollLen - limit) * 250 / (this.getMaximumPullScroll() - limit);
        }
        if (this.isVertical()) {
            this.mScroller.startScroll(0, start, 0, delta, duration);
        } else {
            this.mScroller.startScroll(start, 0, delta, 0, duration);
        }
        this.invalidate();
    }

    private int getMaximumPullScroll() {
        return Math.round(this.isVertical() ? (float)this.getResources().getDisplayMetrics().heightPixels : (float)this.getResources().getDisplayMetrics().widthPixels / 2.0f);
    }

    protected IRefreshLayout getBounceHeaderView() {
        return this.mRefreshLayout;
    }

    protected IRefreshLayout getBounceFooterView() {
        return this.mLoadMoreLayout;
    }

    public void setBounceHeaderView(IRefreshLayout layout) {
        this.mRefreshLayout = layout;
        if (this.mRefreshLayout != null && this.getChildCount() > 1) {
            this.removeViewAt(1);
            this.addView(this.mRefreshLayout.getView(), 1);
        }
    }

    public void setBounceFooterView(IRefreshLayout layout) {
        this.mLoadMoreLayout = layout;
        if (this.mLoadMoreLayout != null && this.getChildCount() > 2) {
            this.removeViewAt(2);
            this.addView(this.mLoadMoreLayout.getView(), 2);
        }
    }

    public abstract boolean isReadyForPullFromStart();

    public abstract boolean isReadyForPullFromEnd();

    public abstract T createBounceView(Context var1);

    public abstract IRefreshLayout createBounceHeaderView(Context var1);

    public IRefreshLayout createBounceFooterView(Context context) {
        return null;
    }

    protected void onPullStateChanged(int itemDimension, int scrollValue) {
    }

    protected void onTouchActionUp() {
    }

    static enum Mode {
        PULL_FROM_START,
        PULL_FROM_END;

    }
}

