/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.adapter.IWXImgLoaderAdapter;
import com.taobao.weex.common.Component;
import com.taobao.weex.common.WXImageSharpen;
import com.taobao.weex.common.WXImageStrategy;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXImageView;
import com.taobao.weex.utils.WXResourceUtils;

@Component(lazyload=false)
public class WXImage
extends WXComponent {
    public WXImage(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) {
        super(instance, node, parent, lazy);
    }

    @Override
    protected void initView() {
        this.mHost = new WXImageView(this.mContext, this.mDomObj);
        ((ImageView)this.getView()).setScaleType(ImageView.ScaleType.FIT_XY);
    }

    @Override
    public View getView() {
        return super.getView();
    }

    @Override
    @WXComponentProp(name="backgroundColor")
    public void setBackgroundColor(String color) {
        int colorInt;
        if (!TextUtils.isEmpty((CharSequence)color) && (colorInt = WXResourceUtils.getColor(color)) != Integer.MIN_VALUE) {
            this.mHost.setBackgroundColor(colorInt);
        }
    }

    @Override
    @WXComponentProp(name="borderRadius")
    public void setBorderRadius(float borderRadius) {
    }

    @Override
    @WXComponentProp(name="borderWidth")
    public void setBorderWidth(float borderWidth) {
    }

    @Override
    @WXComponentProp(name="borderStyle")
    public void setBorderStyle(String borderStyle) {
    }

    @Override
    @WXComponentProp(name="borderColor")
    public void setBorderColor(String borderColor) {
    }

    @WXComponentProp(name="resizeMode")
    public void setResizeMode(String resizeMode) {
        ((ImageView)this.getView()).setScaleType(this.getResizeMode(resizeMode));
    }

    private ImageView.ScaleType getResizeMode(String resizeMode) {
        ImageView.ScaleType scaleType = ImageView.ScaleType.FIT_XY;
        if (TextUtils.isEmpty((CharSequence)resizeMode)) {
            return scaleType;
        }
        if (resizeMode.equals("cover")) {
            scaleType = ImageView.ScaleType.CENTER_CROP;
        } else if (resizeMode.equals("contain")) {
            scaleType = ImageView.ScaleType.FIT_CENTER;
        } else if (resizeMode.equals("stretch")) {
            scaleType = ImageView.ScaleType.FIT_XY;
        } else if (resizeMode.equals("center")) {
            scaleType = ImageView.ScaleType.CENTER;
        } else if (resizeMode.equals("start")) {
            scaleType = ImageView.ScaleType.MATRIX;
        } else if (resizeMode.equals("end")) {
            scaleType = ImageView.ScaleType.FIT_END;
        }
        return scaleType;
    }

    @WXComponentProp(name="resize")
    public void setResize(String resize) {
        ((ImageView)this.getView()).setScaleType(this.getResizeMode(resize));
    }

    @WXComponentProp(name="src")
    public void setSrc(String src) {
        WXImageStrategy imageStrategy = new WXImageStrategy();
        imageStrategy.isClipping = true;
        WXImageSharpen imageSharpen = this.mDomObj.attr.getImageSharpen();
        imageStrategy.isSharpen = imageSharpen == WXImageSharpen.SHARPEN;
        IWXImgLoaderAdapter imgLoaderAdapter = this.mInstance.getImgLoaderAdapter();
        if (imgLoaderAdapter != null) {
            imgLoaderAdapter.setImage(src, (ImageView)this.getView(), this.mDomObj.attr.getImageQuality(), imageStrategy);
        }
    }
}

