/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.animation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TypeEvaluator;
import android.graphics.drawable.ColorDrawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.common.WXModuleAnno;
import com.taobao.weex.ui.animation.WXAnimationBean;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.view.WXBackgroundDrawable;
import com.taobao.weex.utils.FunctionParser;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class WXAnimationModule
extends WXModule {
    public static void applyTransformStyle(@Nullable Map<String, Object> style, WXComponent component) {
        if (component != null) {
            Object transform;
            View target = component.getRealView();
            if (style != null && target != null && (transform = style.get("transform")) instanceof String && !TextUtils.isEmpty((CharSequence)((String)transform)) && target.getLayoutParams() != null) {
                String transformOrigin;
                try {
                    transformOrigin = (String)component.mDomObj.style.get("transformOrigin");
                }
                catch (NullPointerException e) {
                    transformOrigin = null;
                }
                WXAnimationBean animationBean = new WXAnimationBean();
                animationBean.styles = new WXAnimationBean.Style();
                animationBean.styles.setPivot(WXAnimationModule.parsePivot(transformOrigin, target.getLayoutParams()));
                animationBean.styles.setTransformMap(WXAnimationModule.parseTransForm((String)transform, target.getLayoutParams()));
                ObjectAnimator animator = WXAnimationModule.createAnimator(animationBean, target);
                if (animator != null) {
                    animator.setDuration(0L);
                    animator.start();
                }
            }
        }
    }

    @Nullable
    public static WXAnimationBean parseAnimation(@Nullable String animation, ViewGroup.LayoutParams layoutParams) {
        try {
            WXAnimationBean animationBean = (WXAnimationBean)JSONObject.parseObject((String)animation, WXAnimationBean.class);
            if (animationBean != null && animationBean.styles != null) {
                WXAnimationBean.Style style = animationBean.styles;
                style.setTransformMap(WXAnimationModule.parseTransForm(style.transform, layoutParams));
                style.setPivot(WXAnimationModule.parsePivot(style.transformOrigin, layoutParams));
            }
            return animationBean;
        }
        catch (RuntimeException e) {
            WXLogUtils.e(WXLogUtils.getStackTrace(e));
            return null;
        }
    }

    @Nullable
    public static ObjectAnimator createAnimator(@NonNull WXAnimationBean animation, @NonNull View target) {
        WXAnimationBean.Style style = animation.styles;
        if (style != null) {
            LinkedList<PropertyValuesHolder> holders = new LinkedList<PropertyValuesHolder>();
            if (style.getTransformMap() != null) {
                if (style.getTransformMap().isEmpty()) {
                    holders.addAll(WXAnimationModule.moveBackToOrigin());
                } else {
                    for (Map.Entry<String, Float> entry : style.getTransformMap().entrySet()) {
                        holders.add(PropertyValuesHolder.ofFloat((String)entry.getKey(), (float[])new float[]{entry.getValue().floatValue()}));
                    }
                }
            }
            if (!TextUtils.isEmpty((CharSequence)style.opacity)) {
                holders.add(PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{Float.valueOf(style.opacity).floatValue()}));
            }
            if (!TextUtils.isEmpty((CharSequence)style.backgroundColor)) {
                if (target.getBackground() instanceof WXBackgroundDrawable) {
                    holders.add(PropertyValuesHolder.ofObject((String)"backgroundColor", (TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{((WXBackgroundDrawable)target.getBackground()).getColor(), WXResourceUtils.getColor(style.backgroundColor)}));
                } else if (target.getBackground() instanceof ColorDrawable) {
                    holders.add(PropertyValuesHolder.ofObject((String)"backgroundColor", (TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{((ColorDrawable)target.getBackground()).getColor(), WXResourceUtils.getColor(style.backgroundColor)}));
                }
            }
            if (style.getPivot() != null) {
                Pair<Float, Float> pair = style.getPivot();
                target.setPivotX(((Float)pair.first).floatValue());
                target.setPivotY(((Float)pair.second).floatValue());
            }
            ObjectAnimator animator = ObjectAnimator.ofPropertyValuesHolder((Object)target, (PropertyValuesHolder[])holders.toArray(new PropertyValuesHolder[holders.size()]));
            animator.setStartDelay(animation.delay);
            return animator;
        }
        return null;
    }

    @Nullable
    public static Animator.AnimatorListener createAnimatorListener(final WXSDKInstance mWXSDKInstance, final @Nullable String callBack) {
        if (!TextUtils.isEmpty((CharSequence)callBack)) {
            return new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    if (mWXSDKInstance == null) {
                        WXLogUtils.e("WXRenderStatement-onAnimationEnd mWXSDKInstance == null NPE");
                    } else {
                        WXSDKManager.getInstance().callback(mWXSDKInstance.getInstanceId(), callBack, new HashMap<String, Object>());
                    }
                }
            };
        }
        return null;
    }

    @Nullable
    public static Interpolator createTimeInterpolator(@NonNull WXAnimationBean animation) {
        String interpolator = animation.timingFunction;
        if (!TextUtils.isEmpty((CharSequence)interpolator)) {
            switch (interpolator) {
                case "ease-in": {
                    return new AccelerateInterpolator();
                }
                case "ease-out": {
                    return new DecelerateInterpolator();
                }
                case "ease-in-out": {
                    return new AccelerateDecelerateInterpolator();
                }
                case "linear": {
                    return new LinearInterpolator();
                }
            }
        }
        return null;
    }

    private static Map<String, Float> parseTransForm(@Nullable String rawTransform, final ViewGroup.LayoutParams layoutParams) {
        if (!TextUtils.isEmpty((CharSequence)rawTransform)) {
            FunctionParser<Float> parser = new FunctionParser<Float>(rawTransform, new FunctionParser.Mapper<Float>(){

                @Override
                public Map<String, Float> map(String functionName, List<String> raw) {
                    HashMap<String, Float> result = new HashMap<String, Float>();
                    if (raw != null && !raw.isEmpty() && WXAnimationBean.Style.wxToAndroidMap.containsKey(functionName)) {
                        result.putAll(WXAnimationModule.convertParam(layoutParams, WXAnimationBean.Style.wxToAndroidMap.get(functionName), raw));
                    }
                    return result;
                }
            });
            return parser.parse();
        }
        return new LinkedHashMap<String, Float>();
    }

    private static String parsePercentOrPx(String raw, int unit) {
        String lower = raw.toLowerCase();
        if (lower.endsWith("%")) {
            return WXAnimationModule.parsePercent(raw, unit);
        }
        if (lower.endsWith("px")) {
            return Float.toString(WXViewUtils.getRealPxByWidth(Float.parseFloat(raw.replace("px", ""))));
        }
        return Float.toString(WXViewUtils.getRealPxByWidth(Float.parseFloat(raw)));
    }

    private static String parsePercent(String percent, int unit) {
        return Float.toString(Float.parseFloat(percent.replace("%", "")) / 100.0f * (float)unit);
    }

    private static Pair<Float, Float> parsePivot(@Nullable String transformOrigin, ViewGroup.LayoutParams layoutParams) {
        String[] split;
        if (!TextUtils.isEmpty((CharSequence)transformOrigin) && (split = transformOrigin.split("\\s+")).length >= 2) {
            List<String> list = Arrays.asList(split).subList(0, 2);
            return WXAnimationModule.parsePivot(list, layoutParams);
        }
        return WXAnimationModule.parsePivot(Arrays.asList("center", "center"), layoutParams);
    }

    private static Pair<Float, Float> parsePivot(@NonNull List<String> list, ViewGroup.LayoutParams layoutParams) {
        return new Pair((Object)Float.valueOf(WXAnimationModule.parsePivotX(list.get(0), layoutParams)), (Object)Float.valueOf(WXAnimationModule.parsePivotY(list.get(1), layoutParams)));
    }

    private static float parsePivotX(String x, ViewGroup.LayoutParams layoutParams) {
        String value = x;
        if (TextUtils.equals((CharSequence)x, (CharSequence)"left")) {
            value = "0%";
        } else if (TextUtils.equals((CharSequence)x, (CharSequence)"right")) {
            value = "100%";
        } else if (TextUtils.equals((CharSequence)x, (CharSequence)"center")) {
            value = "50%";
        }
        value = WXAnimationModule.parsePercentOrPx(value, layoutParams.width);
        return Float.parseFloat(value);
    }

    private static float parsePivotY(String y, ViewGroup.LayoutParams layoutParams) {
        String value = y;
        if (TextUtils.equals((CharSequence)y, (CharSequence)"top")) {
            value = "0%";
        } else if (TextUtils.equals((CharSequence)y, (CharSequence)"bottom")) {
            value = "100%";
        } else if (TextUtils.equals((CharSequence)y, (CharSequence)"center")) {
            value = "50%";
        }
        value = WXAnimationModule.parsePercentOrPx(value, layoutParams.height);
        return Float.parseFloat(value);
    }

    private static Map<String, Float> convertParam(ViewGroup.LayoutParams layoutParams, @NonNull List<String> nameSet, @NonNull List<String> rawValue) {
        HashMap<String, Float> result = new HashMap<String, Float>();
        ArrayList<String> convertedList = new ArrayList<String>();
        if (nameSet.contains("rotation")) {
            convertedList.addAll(WXAnimationModule.parseRotation(rawValue));
        } else if (nameSet.contains("translationX") || nameSet.contains("translationY")) {
            convertedList.addAll(WXAnimationModule.parseTranslation(nameSet, layoutParams, rawValue));
        } else if (nameSet.contains("scaleX") || nameSet.contains("scaleY")) {
            convertedList.addAll(WXAnimationModule.parseScale(nameSet.size(), rawValue));
        }
        if (nameSet.size() == convertedList.size()) {
            for (int i = 0; i < nameSet.size(); ++i) {
                result.put(nameSet.get(i), Float.valueOf(Float.parseFloat((String)convertedList.get(i))));
            }
        }
        return result;
    }

    private static List<String> parseTranslation(List<String> nameSet, ViewGroup.LayoutParams layoutParams, @NonNull List<String> rawValue) {
        ArrayList<String> convertedList = new ArrayList<String>();
        String first = rawValue.get(0);
        if (nameSet.size() == 1) {
            WXAnimationModule.parseSingleTranslation(nameSet, layoutParams, convertedList, first);
        } else {
            WXAnimationModule.parseDoubleTranslation(layoutParams, rawValue, convertedList, first);
        }
        return convertedList;
    }

    private static void parseSingleTranslation(List<String> nameSet, ViewGroup.LayoutParams layoutParams, List<String> convertedList, String first) {
        if (nameSet.contains("translationX")) {
            convertedList.add(WXAnimationModule.parsePercentOrPx(first, layoutParams.width));
        } else if (nameSet.contains("translationY")) {
            convertedList.add(WXAnimationModule.parsePercentOrPx(first, layoutParams.height));
        }
    }

    private static void parseDoubleTranslation(ViewGroup.LayoutParams layoutParams, @NonNull List<String> rawValue, List<String> convertedList, String first) {
        String second = rawValue.size() == 1 ? first : rawValue.get(1);
        if (layoutParams != null) {
            convertedList.add(WXAnimationModule.parsePercentOrPx(first, layoutParams.width));
            convertedList.add(WXAnimationModule.parsePercentOrPx(second, layoutParams.height));
        }
    }

    private static List<String> parseScale(int size, @NonNull List<String> rawValue) {
        ArrayList<String> convertedList = new ArrayList<String>();
        convertedList.addAll(rawValue);
        if (size != 1 && rawValue.size() == 1) {
            convertedList.addAll(rawValue);
        }
        return convertedList;
    }

    private static List<String> parseRotation(@NonNull List<String> rawValue) {
        ArrayList<String> convertedList = new ArrayList<String>();
        for (String raw : rawValue) {
            String lower = raw.toLowerCase();
            if (lower.endsWith("deg")) {
                convertedList.add(lower.replace("deg", ""));
                continue;
            }
            convertedList.add(Double.valueOf(Math.toDegrees(Double.parseDouble(raw))).toString());
        }
        return convertedList;
    }

    private static List<PropertyValuesHolder> moveBackToOrigin() {
        LinkedList<PropertyValuesHolder> holders = new LinkedList<PropertyValuesHolder>();
        holders.add(PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{0.0f}));
        holders.add(PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{0.0f}));
        holders.add(PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{1.0f}));
        holders.add(PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{1.0f}));
        holders.add(PropertyValuesHolder.ofFloat((String)"rotation", (float[])new float[]{0.0f}));
        return holders;
    }

    @WXModuleAnno
    public void transition(String ref, String animation, String callBack) {
        WXSDKManager.getInstance().getWXRenderManager().startAnimation(this.mWXSDKInstance.getInstanceId(), ref, animation, callBack);
    }
}

