/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui;

import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.bridge.Invoker;
import com.taobao.weex.bridge.MethodInvoker;
import com.taobao.weex.common.Component;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXLogUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ComponentHolder {
    public static final String TAG = "ComponentHolder";
    private final Class<? extends WXComponent> mClz;
    private Map<String, Invoker> mMethods;
    private Constructor<? extends WXComponent> mConstructor;

    public ComponentHolder(Class<? extends WXComponent> clz) {
        Annotation[] annotations;
        this.mClz = clz;
        for (Annotation annotation : annotations = clz.getDeclaredAnnotations()) {
            if (!(annotation instanceof Component)) continue;
            if (!((Component)annotation).lazyload()) {
                this.generate();
            }
            return;
        }
    }

    private synchronized void generate() {
        WXLogUtils.d(TAG, "Generate Component:" + this.mClz.getSimpleName());
        HashMap<String, Invoker> methods = new HashMap<String, Invoker>();
        block4: for (Method method : this.mClz.getMethods()) {
            for (Annotation anno : method.getDeclaredAnnotations()) {
                if (anno == null || !(anno instanceof WXComponentProp)) continue;
                String name = ((WXComponentProp)anno).name();
                methods.put(name, new MethodInvoker(method));
                continue block4;
            }
        }
        this.mMethods = methods;
        try {
            this.mConstructor = this.mClz.getConstructor(WXSDKInstance.class, WXDomObject.class, WXVContainer.class, Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            try {
                this.mConstructor = this.mClz.getConstructor(WXSDKInstance.class, WXDomObject.class, WXVContainer.class, String.class, Boolean.TYPE);
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
                throw new WXRuntimeException("Can't find constructor of component.");
            }
            e.printStackTrace();
        }
    }

    public WXComponent createInstance(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        int parameters;
        if (this.mConstructor == null) {
            this.generate();
        }
        WXComponent component = (parameters = this.mConstructor.getParameterTypes().length) == 4 ? this.mConstructor.newInstance(instance, node, parent, lazy) : this.mConstructor.newInstance(instance, node, parent, instance.getInstanceId(), lazy);
        component.setHolder(this);
        return component;
    }

    public Invoker getMethod(String name) {
        if (this.mMethods == null) {
            this.generate();
        }
        return this.mMethods.get(name);
    }
}

