/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.graphics.Canvas;
import android.os.Build;
import android.text.DynamicLayout;
import android.text.Editable;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.UnderlineSpan;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.dom.WXCustomStyleSpan;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXLineHeightSpan;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.dom.flex.CSSConstants;
import com.taobao.weex.dom.flex.CSSNode;
import com.taobao.weex.dom.flex.FloatUtil;
import com.taobao.weex.dom.flex.MeasureOutput;
import com.taobao.weex.dom.flex.Spacing;
import com.taobao.weex.ui.component.WXTextDecoration;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class WXTextDomObject
extends WXDomObject {
    private static final CSSNode.MeasureFunction TEXT_MEASURE_FUNCTION = new CSSNode.MeasureFunction(){

        @Override
        public void measure(CSSNode node, float width, MeasureOutput measureOutput) {
            WXTextDomObject textDomObject = (WXTextDomObject)node;
            if (CSSConstants.isUndefined(width)) {
                width = node.cssstyle.maxWidth;
            }
            textDomObject.updateLayout(width, false);
            textDomObject.hasBeenMeasured = true;
            textDomObject.previousWidth = textDomObject.layout.getWidth();
            measureOutput.height = textDomObject.layout.getHeight();
            measureOutput.width = textDomObject.previousWidth;
        }
    };
    private static final TextPaint TEXT_PAINT = new TextPaint();
    private static final Canvas DUMMY_CANVAS = new Canvas();
    private static final String ELLIPSIS = "\u2026";
    private boolean mIsColorSet = false;
    private boolean hasBeenMeasured = false;
    private int mColor;
    private int mFontStyle = -1;
    private int mFontWeight = -1;
    private int mNumberOfLines = -1;
    private int mFontSize = -1;
    private int mLineHeight = -1;
    private float previousWidth = Float.NaN;
    private String mFontFamily = null;
    private String mText = null;
    private TextUtils.TruncateAt textOverflow;
    private Layout.Alignment mAlignment;
    private WXTextDecoration mTextDecoration = WXTextDecoration.NONE;
    private SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder();
    private Layout layout;
    private AtomicReference<Layout> atomicReference = new AtomicReference();

    public WXTextDomObject() {
        this.setMeasureFunction(TEXT_MEASURE_FUNCTION);
    }

    @Override
    public void layoutBefore() {
        this.hasBeenMeasured = false;
        this.updateStyleAndText();
        this.updateSpannableStringBuilder(this.mText);
        super.dirty();
        super.layoutBefore();
    }

    @Override
    public void layoutAfter() {
        if (this.hasBeenMeasured) {
            if (this.layout != null && !FloatUtil.floatsEqual(this.getTextContentWidth(), this.previousWidth)) {
                this.recalculateLayout();
            }
        } else {
            this.updateStyleAndText();
            this.recalculateLayout();
        }
        this.hasBeenMeasured = false;
        if (this.layout != null && !this.layout.equals(this.atomicReference.get()) && Build.VERSION.SDK_INT >= 19) {
            this.warmUpTextLayoutCache();
        }
        this.swap();
        super.layoutAfter();
    }

    public Layout getExtra() {
        return this.atomicReference.get();
    }

    @Override
    public void updateAttr(Map<String, Object> attrs) {
        this.swap();
        super.updateAttr(attrs);
        if (attrs.containsKey("value")) {
            this.mText = WXAttr.getValue(attrs);
        }
    }

    @Override
    public void updateStyle(Map<String, Object> styles) {
        this.swap();
        super.updateStyle(styles);
        this.updateStyleImp(styles);
    }

    @Override
    public WXTextDomObject clone() {
        WXTextDomObject dom;
        block5: {
            dom = null;
            try {
                dom = new WXTextDomObject();
                if (this.cssstyle != null) {
                    dom.cssstyle.copy(this.cssstyle);
                }
                dom.ref = this.ref;
                dom.type = this.type;
                dom.style = this.style;
                dom.attr = this.attr;
                dom.event = this.event == null ? null : this.event.clone();
                dom.hasBeenMeasured = this.hasBeenMeasured;
                dom.atomicReference = this.atomicReference;
                if (this.csslayout != null) {
                    dom.csslayout.copy(this.csslayout);
                }
            }
            catch (Exception e) {
                if (!WXEnvironment.isApkDebugable()) break block5;
                WXLogUtils.e("WXTextDomObject clone error: " + WXLogUtils.getStackTrace(e));
            }
        }
        if (dom != null) {
            dom.spannableStringBuilder = this.spannableStringBuilder;
        }
        return dom;
    }

    private float getTextContentWidth() {
        float right;
        float rawWidth = this.getLayoutWidth();
        Spacing padding = this.getPadding();
        float left = padding.get(0);
        if (!CSSConstants.isUndefined(left)) {
            rawWidth -= left;
        }
        if (!CSSConstants.isUndefined(right = padding.get(2))) {
            rawWidth -= right;
        }
        return rawWidth;
    }

    private void recalculateLayout() {
        this.updateSpannableStringBuilder(this.mText);
        this.updateLayout(this.getTextContentWidth(), true);
        this.previousWidth = this.layout.getWidth();
    }

    private void updateStyleAndText() {
        this.updateStyleImp(this.style);
        if (this.attr != null) {
            this.mText = WXAttr.getValue(this.attr);
        }
    }

    private void updateStyleImp(Map<String, Object> style) {
        if (style != null) {
            int lines;
            if (style.containsKey("lines") && (lines = WXStyle.getLines(style)) > 0) {
                this.mNumberOfLines = lines;
            }
            if (style.containsKey("fontSize")) {
                this.mFontSize = WXStyle.getFontSize(style);
            }
            if (style.containsKey("fontWeight")) {
                this.mFontWeight = WXStyle.getFontWeight(style);
            }
            if (style.containsKey("fontStyle")) {
                this.mFontStyle = WXStyle.getFontStyle(style);
            }
            if (style.containsKey("color")) {
                this.mColor = WXResourceUtils.getColor(WXStyle.getTextColor(style));
                boolean bl = this.mIsColorSet = this.mColor != Integer.MIN_VALUE;
            }
            if (style.containsKey("textDecoration")) {
                this.mTextDecoration = WXStyle.getTextDecoration(style);
            }
            if (style.containsKey("fontFamily")) {
                this.mFontFamily = WXStyle.getFontFamily(style);
            }
            this.mAlignment = WXStyle.getTextAlignment(style);
            this.textOverflow = WXStyle.getTextOverflow(style);
            int lineHeight = WXStyle.getLineHeight(style);
            if (lineHeight != -1) {
                this.mLineHeight = lineHeight;
            }
        }
    }

    private void updateLayout(float width, boolean forceWidth) {
        int lastLineEnd;
        int lastLineStart;
        float textWidth;
        if (forceWidth) {
            textWidth = width;
        } else {
            float desiredWidth = Layout.getDesiredWidth((CharSequence)this.spannableStringBuilder, (TextPaint)TEXT_PAINT);
            textWidth = CSSConstants.isUndefined(width) || desiredWidth < width ? desiredWidth : width;
        }
        if (this.layout == null || !FloatUtil.floatsEqual(this.previousWidth, width)) {
            this.layout = new DynamicLayout((CharSequence)this.spannableStringBuilder, TEXT_PAINT, (int)Math.ceil(textWidth), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
        }
        if (this.mNumberOfLines != -1 && this.mNumberOfLines > 0 && this.mNumberOfLines < this.layout.getLineCount() && (lastLineStart = this.layout.getLineStart(this.mNumberOfLines - 1)) < (lastLineEnd = this.layout.getLineEnd(this.mNumberOfLines - 1))) {
            StringBuilder stringBuilder = new StringBuilder();
            CharSequence main = this.mText.subSequence(0, lastLineStart);
            CharSequence reminder = this.mText.subSequence(lastLineStart, this.textOverflow == null ? lastLineEnd : lastLineEnd - 1);
            stringBuilder.setLength(0);
            stringBuilder.append(main);
            stringBuilder.append(reminder);
            if (this.textOverflow != null) {
                stringBuilder.append(ELLIPSIS);
            }
            this.updateSpannableStringBuilder(stringBuilder.toString());
            this.updateLayout(width, forceWidth);
        }
    }

    private Editable updateSpannableStringBuilder(String text) {
        this.spannableStringBuilder.clear();
        if (text != null) {
            this.spannableStringBuilder.append((CharSequence)text);
        }
        List<SetSpanOperation> ops = this.createSetSpanOperation(this.spannableStringBuilder.length());
        if (this.mFontSize == -1) {
            this.spannableStringBuilder.setSpan((Object)new AbsoluteSizeSpan(32), 0, this.spannableStringBuilder.length(), 17);
        }
        Collections.reverse(ops);
        for (SetSpanOperation op : ops) {
            op.execute(this.spannableStringBuilder);
        }
        return this.spannableStringBuilder;
    }

    private List<SetSpanOperation> createSetSpanOperation(int end) {
        LinkedList<SetSpanOperation> ops = new LinkedList<SetSpanOperation>();
        int start = 0;
        if (end >= start) {
            if (this.mTextDecoration == WXTextDecoration.UNDERLINE) {
                ops.add(new SetSpanOperation(start, end, new UnderlineSpan()));
            }
            if (this.mTextDecoration == WXTextDecoration.LINETHROUGH) {
                ops.add(new SetSpanOperation(start, end, new StrikethroughSpan()));
            }
            if (this.mIsColorSet) {
                ops.add(new SetSpanOperation(start, end, new ForegroundColorSpan(this.mColor)));
            }
            if (this.mFontSize != -1) {
                ops.add(new SetSpanOperation(start, end, new AbsoluteSizeSpan(this.mFontSize)));
            }
            if (this.mFontStyle != -1 || this.mFontWeight != -1 || this.mFontFamily != null) {
                ops.add(new SetSpanOperation(start, end, (Object)new WXCustomStyleSpan(this.mFontStyle, this.mFontWeight, this.mFontFamily)));
            }
            ops.add(new SetSpanOperation(start, end, new AlignmentSpan.Standard(this.mAlignment)));
            if (this.mLineHeight != -1) {
                ops.add(new SetSpanOperation(start, end, new WXLineHeightSpan(this.mLineHeight)));
            }
        }
        return ops;
    }

    private void swap() {
        if (this.layout != null) {
            this.spannableStringBuilder = new SpannableStringBuilder((CharSequence)this.spannableStringBuilder);
            this.atomicReference.set(this.layout);
            this.layout = null;
        }
    }

    private boolean warmUpTextLayoutCache() {
        boolean result;
        try {
            this.layout.draw(DUMMY_CANVAS);
            result = true;
        }
        catch (Exception e) {
            WXLogUtils.e(TAG, WXLogUtils.getStackTrace(e));
            result = false;
        }
        return result;
    }

    static {
        TEXT_PAINT.setFlags(1);
    }

    private static class SetSpanOperation {
        protected int start;
        protected int end;
        protected Object what;

        SetSpanOperation(int start, int end, Object what) {
            this.start = start;
            this.end = end;
            this.what = what;
        }

        public void execute(SpannableStringBuilder sb) {
            sb.setSpan(this.what, this.start, this.end, 17);
        }
    }
}

