/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.bridge;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.WXBridge;
import com.taobao.weex.bridge.WXHashMap;
import com.taobao.weex.bridge.WXJSObject;
import com.taobao.weex.bridge.WXModuleManager;
import com.taobao.weex.bridge.WXParams;
import com.taobao.weex.common.IWXBridge;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXRefreshData;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.utils.WXFileUtils;
import com.taobao.weex.utils.WXHack;
import com.taobao.weex.utils.WXJsonUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Stack;
import java.util.concurrent.LinkedBlockingQueue;

public class WXBridgeManager
implements Handler.Callback {
    public static final String METHOD_CREATE_INSTANCE = "createInstance";
    public static final String METHOD_DESTROY_INSTANCE = "destroyInstance";
    public static final String METHOD_CALL_JS = "callJS";
    public static final String METHOD_SET_TIMEOUT = "setTimeoutCallback";
    public static final String METHOD_REGISTER_MODULES = "registerModules";
    public static final String METHOD_REGISTER_COMPONENTS = "registerComponents";
    public static final String METHOD_FIRE_EVENT = "fireEvent";
    public static final String METHOD_CALLBACK = "callback";
    public static final String METHOD_REFRESH_INSTANCE = "refreshInstance";
    private static final String UNDEFINED = "-1";
    private static final int INIT_FRAMEWORK_OK = 1;
    private static WXBridgeManager mBridgeManager;
    private WXHashMap<String, ArrayList<WXHashMap<String, Object>>> mNextTickTasks = new WXHashMap();
    private Queue<WXHashMap<String, Object>> mUITasks = new LinkedBlockingQueue<WXHashMap<String, Object>>();
    private WXThread mJSThread;
    private Handler mJSHandler;
    private IWXBridge mWXBridge;
    private boolean mMock = false;
    private boolean mInit;
    private List<ArrayList<Map<String, String>>> mRegisterComponentFailList = new ArrayList<ArrayList<Map<String, String>>>(8);
    private List<Map<String, Object>> mRegisterModuleFailList = new ArrayList<Map<String, Object>>(8);
    private String mDestroyedInstanceId = "-1";
    private StringBuilder mLodBuilder = new StringBuilder(500);

    private WXBridgeManager() {
        if (WXEnvironment.sDebugMode) {
            try {
                WXHack.HackedClass waBridge = WXHack.into("com.taobao.weex.bridge.WXWebsocketBridge");
                this.mWXBridge = (IWXBridge)waBridge.constructor(WXBridgeManager.class).getInstance(this);
            }
            catch (WXHack.HackDeclaration.HackAssertionException e) {
                e.printStackTrace();
            }
        } else {
            this.mWXBridge = new WXBridge();
        }
        this.mJSThread = new WXThread("WeexJSBridgeThread", this);
        this.mJSHandler = this.mJSThread.getHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WXBridgeManager getInstance() {
        if (mBridgeManager != null) return mBridgeManager;
        Class<WXBridgeManager> clazz = WXBridgeManager.class;
        synchronized (WXBridgeManager.class) {
            if (mBridgeManager != null) return mBridgeManager;
            mBridgeManager = new WXBridgeManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mBridgeManager;
        }
    }

    public boolean callModuleMethod(String instanceId, String moduleStr, String methodStr, JSONArray args) {
        return WXModuleManager.callModuleMethod(instanceId, moduleStr, methodStr, args);
    }

    public Handler getJSHandler() {
        return this.mJSHandler;
    }

    public void restart() {
        this.mInit = false;
        if (WXEnvironment.sDebugMode) {
            try {
                WXHack.HackedClass waBridge = WXHack.into("com.taobao.weex.bridge.WXWebsocketBridge");
                this.mWXBridge = (IWXBridge)waBridge.constructor(WXBridgeManager.class).getInstance(this);
            }
            catch (WXHack.HackDeclaration.HackAssertionException e) {
                e.printStackTrace();
            }
        } else {
            this.mWXBridge = new WXBridge();
        }
    }

    public synchronized void setStackTopInstance(final String instanceId) {
        this.post(new Runnable(){

            @Override
            public void run() {
                WXBridgeManager.this.mNextTickTasks.setStackTopInstance(instanceId);
            }
        }, instanceId);
    }

    private void post(Runnable r, Object token) {
        if (this.mJSHandler == null) {
            return;
        }
        Message m = Message.obtain((Handler)this.mJSHandler, (Runnable)r);
        m.obj = token;
        m.sendToTarget();
    }

    void setTimeout(String callbackId, String time) {
        Message message = Message.obtain();
        message.what = 1;
        TimerInfo timerInfo = new TimerInfo();
        timerInfo.callbackId = callbackId;
        timerInfo.time = (long)Float.parseFloat(time);
        message.obj = timerInfo;
        this.mJSHandler.sendMessageDelayed(message, timerInfo.time);
    }

    void callNative(String instanceId, String tasks, String callback) {
        int size;
        if (TextUtils.isEmpty((CharSequence)tasks)) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.e("[WXBridgeManager] callNative: call Native tasks is null");
            }
            return;
        }
        if (WXEnvironment.isApkDebugable()) {
            this.mLodBuilder.append("[WXBridgeManager] callNative >>>> instanceId:").append(instanceId).append(", tasks:").append(tasks).append(", callback:").append(callback);
            WXLogUtils.d(this.mLodBuilder.substring(0));
            this.mLodBuilder.setLength(0);
        }
        long start = System.currentTimeMillis();
        JSONArray array = JSON.parseArray((String)tasks);
        if (WXSDKManager.getInstance().getSDKInstance(instanceId) != null) {
            WXSDKManager.getInstance().getSDKInstance(instanceId).jsonParseTime(System.currentTimeMillis() - start);
        }
        if ((size = array.size()) > 0) {
            try {
                for (int i = 0; i < size; ++i) {
                    JSONObject task = (JSONObject)array.get(i);
                    if (task == null || WXSDKManager.getInstance().getSDKInstance(instanceId) == null) continue;
                    WXModuleManager.callModuleMethod(instanceId, (String)task.get((Object)"module"), (String)task.get((Object)"method"), (JSONArray)task.get((Object)"args"));
                }
            }
            catch (Exception e) {
                WXLogUtils.e("[WXBridgeManager] callNative exception: " + WXLogUtils.getStackTrace(e));
            }
        }
        if (UNDEFINED.equals(callback) || this.mDestroyedInstanceId.equals(instanceId)) {
            return;
        }
        this.getNextTick(instanceId, callback);
    }

    private void getNextTick(String instanceId, String callback) {
        this.addNextTickTask(instanceId, callback, "{}");
        this.sendMessage(instanceId, 6);
    }

    private void addNextTickTask(String instanceId, Object ... args) {
        if (args == null || args.length == 0) {
            return;
        }
        ArrayList<Object> argsList = new ArrayList<Object>();
        for (Object arg : args) {
            argsList.add(arg);
        }
        WXHashMap<String, Object> task = new WXHashMap<String, Object>();
        task.put("method", METHOD_CALLBACK);
        task.put("args", args);
        if (this.mNextTickTasks.get(instanceId) == null) {
            ArrayList<WXHashMap<String, Object>> list = new ArrayList<WXHashMap<String, Object>>();
            list.add(task);
            this.mNextTickTasks.put(instanceId, list);
        } else {
            ((ArrayList)this.mNextTickTasks.get(instanceId)).add(task);
        }
    }

    private void sendMessage(String instanceId, int what) {
        Message msg = Message.obtain((Handler)this.mJSHandler);
        msg.obj = instanceId;
        msg.what = what;
        msg.sendToTarget();
    }

    public synchronized void initScriptsFramework(String framework) {
        Message msg = this.mJSHandler.obtainMessage();
        msg.obj = framework;
        msg.what = 7;
        msg.setTarget(this.mJSHandler);
        msg.sendToTarget();
    }

    public void fireEvent(String instanceId, String ref, String type, Map<String, Object> data) {
        if (TextUtils.isEmpty((CharSequence)instanceId) || TextUtils.isEmpty((CharSequence)ref) || TextUtils.isEmpty((CharSequence)type) || this.mJSHandler == null) {
            return;
        }
        if (!this.checkMainThread()) {
            throw new WXRuntimeException("fireEvent must be called by main thread");
        }
        this.addUITask(METHOD_FIRE_EVENT, instanceId, ref, type, data);
        this.sendMessage(instanceId, 6);
    }

    private boolean checkMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    private void addUITask(String method, String instanceId, Object ... args) {
        ArrayList<Object> argsList = new ArrayList<Object>();
        for (Object arg : args) {
            argsList.add(arg);
        }
        WXHashMap<String, Object> task = new WXHashMap<String, Object>();
        task.put("method", method);
        task.put("args", argsList);
        task.setTag(instanceId);
        this.mUITasks.offer(task);
    }

    public void callback(String instanceId, String callback, Map<String, Object> data) {
        this.callback(instanceId, callback, data == null ? "{}" : WXJsonUtils.fromObjectToJSONString(data));
    }

    public void callback(String instanceId, String callback, Map<String, Object> data, boolean keepAlive) {
        this.callback(instanceId, callback, data == null ? "{}" : WXJsonUtils.fromObjectToJSONString(data), keepAlive);
    }

    public void callback(String instanceId, String callback, String data) {
        this.callback(instanceId, callback, data, false);
    }

    public void callback(String instanceId, String callback, String data, boolean keepAlive) {
        if (TextUtils.isEmpty((CharSequence)instanceId) || TextUtils.isEmpty((CharSequence)callback) || this.mJSHandler == null) {
            return;
        }
        this.addUITask(METHOD_CALLBACK, instanceId, callback, data, keepAlive);
        this.sendMessage(instanceId, 6);
    }

    public void refreshInstance(final String instanceId, final WXRefreshData jsonData) {
        if (TextUtils.isEmpty((CharSequence)instanceId) || jsonData == null) {
            return;
        }
        this.mJSHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                WXBridgeManager.this.invokeRefreshInstance(instanceId, jsonData);
            }
        }, 0L);
    }

    private void invokeRefreshInstance(String instanceId, WXRefreshData refreshData) {
        try {
            if (!this.mInit) {
                WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
                if (instance != null) {
                    instance.onRenderError("wx_create_instance_error", "createInstance failed!");
                }
                String err = "[WXBridgeManager] invokeRefreshInstance: framework.js uninitialized.";
                WXErrorCode.WX_ERR_INVOKE_NATIVE.appendErrMsg(err);
                this.commitJSBridgeAlarmMonitor(instanceId, WXErrorCode.WX_ERR_INVOKE_NATIVE);
                WXLogUtils.e(err);
                return;
            }
            long start = System.currentTimeMillis();
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("refreshInstance >>>> instanceId:" + instanceId + ", data:" + refreshData.data + ", isDirty:" + refreshData.isDirty);
            }
            if (refreshData.isDirty) {
                return;
            }
            WXJSObject instanceIdObj = new WXJSObject(2, instanceId);
            WXJSObject dataObj = new WXJSObject(3, refreshData.data == null ? "{}" : refreshData.data);
            WXJSObject[] args = new WXJSObject[]{instanceIdObj, dataObj};
            this.mWXBridge.execJS(instanceId, null, METHOD_REFRESH_INSTANCE, args);
            WXLogUtils.renderPerformanceLog("invokeRefreshInstance", System.currentTimeMillis() - start);
            this.commitJSBridgeAlarmMonitor(instanceId, WXErrorCode.WX_SUCCESS);
        }
        catch (Throwable e) {
            String err = "[WXBridgeManager] invokeRefreshInstance " + e.getCause();
            WXErrorCode.WX_ERR_INVOKE_NATIVE.appendErrMsg(err);
            this.commitJSBridgeAlarmMonitor(instanceId, WXErrorCode.WX_ERR_INVOKE_NATIVE);
            WXLogUtils.e(err);
        }
    }

    public void commitJSBridgeAlarmMonitor(String instanceId, WXErrorCode errCode) {
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (instance == null) {
            return;
        }
        instance.commitUTStab("jsBridge", errCode);
    }

    public void createInstance(final String instanceId, final String template, final Map<String, Object> options, final String data) {
        if (TextUtils.isEmpty((CharSequence)instanceId) || TextUtils.isEmpty((CharSequence)template) || this.mJSHandler == null) {
            WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
            if (instance != null) {
                instance.onRenderError("wx_create_instance_error", "createInstance fail!");
            }
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                WXBridgeManager.this.invokeCreateInstance(instanceId, template, options, data);
                final long totalTime = System.currentTimeMillis() - start;
                WXSDKManager.getInstance().postOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
                        if (instance != null) {
                            instance.createInstanceFinished(totalTime);
                        }
                    }
                }, 0L);
            }
        }, instanceId);
    }

    private void invokeCreateInstance(String instanceId, String template, Map<String, Object> options, String data) {
        if (this.mMock) {
            this.mock(instanceId);
        } else {
            if (!this.mInit) {
                WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
                if (instance != null) {
                    instance.onRenderError("wx_create_instance_error", "createInstance fail!");
                }
                String err = "[WXBridgeManager] invokeCreateInstance: framework.js uninitialized.";
                WXErrorCode.WX_ERR_INVOKE_NATIVE.appendErrMsg(err);
                this.commitJSBridgeAlarmMonitor(instanceId, WXErrorCode.WX_ERR_INVOKE_NATIVE);
                WXLogUtils.e(err);
                return;
            }
            try {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("createInstance >>>> instanceId:" + instanceId + ", options:" + WXJsonUtils.fromObjectToJSONString(options) + ", data:" + data);
                }
                WXJSObject instanceIdObj = new WXJSObject(2, instanceId);
                WXJSObject instanceObj = new WXJSObject(2, template);
                WXJSObject optionsObj = new WXJSObject(3, options == null ? "{}" : WXJsonUtils.fromObjectToJSONString(options));
                WXJSObject dataObj = new WXJSObject(3, data == null ? "{}" : data);
                WXJSObject[] args = new WXJSObject[]{instanceIdObj, instanceObj, optionsObj, dataObj};
                this.mWXBridge.execJS(instanceId, null, METHOD_CREATE_INSTANCE, args);
                this.commitJSBridgeAlarmMonitor(instanceId, WXErrorCode.WX_SUCCESS);
            }
            catch (Throwable e) {
                WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
                if (instance != null) {
                    instance.onRenderError("wx_create_instance_error", "createInstance failed!");
                }
                String err = "[WXBridgeManager] invokeCreateInstance " + e.getCause();
                WXErrorCode.WX_ERR_INVOKE_NATIVE.appendErrMsg(err);
                this.commitJSBridgeAlarmMonitor(instanceId, WXErrorCode.WX_ERR_INVOKE_NATIVE);
                WXLogUtils.e(err);
            }
        }
    }

    private void mock(String instanceId) {
    }

    public void destroyInstance(final String instanceId) {
        if (this.mJSHandler == null || TextUtils.isEmpty((CharSequence)instanceId)) {
            return;
        }
        this.mDestroyedInstanceId = instanceId;
        this.mJSHandler.removeCallbacksAndMessages((Object)instanceId);
        this.post(new Runnable(){

            @Override
            public void run() {
                WXBridgeManager.this.mDestroyedInstanceId = WXBridgeManager.UNDEFINED;
                WXBridgeManager.this.removeTaskByInstance(instanceId);
                WXBridgeManager.this.invokeDestroyInstance(instanceId);
            }
        }, instanceId);
    }

    private void removeTaskByInstance(String instanceId) {
        this.mNextTickTasks.removeFromMapAndStack(instanceId);
    }

    private void invokeDestroyInstance(String instanceId) {
        try {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("destroyInstance >>>> instanceId:" + instanceId);
            }
            WXJSObject instanceIdObj = new WXJSObject(2, instanceId);
            WXJSObject[] args = new WXJSObject[]{instanceIdObj};
            this.mWXBridge.execJS(instanceId, null, METHOD_DESTROY_INSTANCE, args);
            this.commitJSBridgeAlarmMonitor(instanceId, WXErrorCode.WX_SUCCESS);
        }
        catch (Throwable e) {
            String err = "[WXBridgeManager] invokeDestroyInstance " + e.getCause();
            WXErrorCode.WX_ERR_INVOKE_NATIVE.appendErrMsg(err);
            this.commitJSBridgeAlarmMonitor(instanceId, WXErrorCode.WX_ERR_INVOKE_NATIVE);
            WXLogUtils.e(err);
        }
    }

    public boolean handleMessage(Message msg) {
        if (msg == null) {
            return false;
        }
        int what = msg.what;
        switch (what) {
            case 7: {
                this.invokeInitFramework(msg);
                break;
            }
            case 6: {
                this.invokeCallJSBatch(msg);
                break;
            }
            case 1: {
                TimerInfo timerInfo = (TimerInfo)msg.obj;
                WXJSObject obj = new WXJSObject(2, timerInfo.callbackId);
                WXJSObject[] args = new WXJSObject[]{obj};
                this.mWXBridge.execJS("", null, METHOD_SET_TIMEOUT, args);
                break;
            }
        }
        return false;
    }

    private void invokeInitFramework(Message msg) {
        String framework = "";
        if (msg.obj != null) {
            framework = (String)msg.obj;
        }
        if (!this.mInit) {
            if (TextUtils.isEmpty((CharSequence)framework)) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("framework from assets");
                }
                framework = WXFileUtils.loadFileContent("main.js", (Context)WXEnvironment.getApplication());
            }
            if (TextUtils.isEmpty((CharSequence)framework)) {
                this.mInit = false;
                return;
            }
            try {
                long start = System.currentTimeMillis();
                if (this.mWXBridge.initFramework(framework, this.assembleDefaultOptions()) == 1) {
                    WXEnvironment.sJSLibInitTime = System.currentTimeMillis() - start;
                    WXLogUtils.renderPerformanceLog("initFramework", WXEnvironment.sJSLibInitTime);
                    this.mInit = true;
                    this.execRegisterFailTask();
                    WXEnvironment.JsFrameworkInit = true;
                } else {
                    WXLogUtils.e("[WXBridgeManager] invokeInitFramework  ExecuteJavaScript fail");
                }
            }
            catch (Throwable e) {
                WXLogUtils.e("[WXBridgeManager] invokeInitFramework " + e.getCause());
            }
        }
    }

    private void invokeCallJSBatch(Message message) {
        if (this.mNextTickTasks.isEmpty() && this.mUITasks.isEmpty() || !this.mInit) {
            if (!this.mInit) {
                WXLogUtils.e("[WXBridgeManager] invokeCallJSBatch: framework.js uninitialized.");
            }
            return;
        }
        try {
            String ins;
            Object task = null;
            Object instanceId = message.obj;
            task = this.mUITasks.poll();
            if (task != null) {
                instanceId = task.getTag();
            }
            Object[] tasks = new Object[]{task};
            if (task == null) {
                Stack<String> instanceStack = this.mNextTickTasks.getInstanceStack();
                int size = instanceStack.size();
                for (int i = size - 1; i >= 0 && ((task = this.mNextTickTasks.remove(instanceId = instanceStack.get(i))) == null || ((ArrayList)task).isEmpty()); --i) {
                }
                tasks = ((ArrayList)task).toArray();
            }
            task = tasks;
            if (WXEnvironment.isApkDebugable()) {
                this.mLodBuilder.append("callJS >>>> instanceId:").append(instanceId).append(" tasks:").append(WXJsonUtils.fromObjectToJSONString(task));
                WXLogUtils.d(this.mLodBuilder.substring(0));
                this.mLodBuilder.setLength(0);
            }
            WXJSObject[] args = new WXJSObject[]{new WXJSObject(2, instanceId), new WXJSObject(3, WXJsonUtils.fromObjectToJSONString(task))};
            if (WXEnvironment.isApkDebugable() && (TextUtils.isEmpty((CharSequence)(ins = String.valueOf(instanceId))) || ins.equals("null") || args == null)) {
                WXLogUtils.e("WXBridgeManager (TextUtils.isEmpty(ins) || ins.equals(\"null\") || args == null)");
            }
            this.mWXBridge.execJS(String.valueOf(instanceId), null, METHOD_CALL_JS, args);
            if (!this.mNextTickTasks.isEmpty() && !this.mUITasks.isEmpty()) {
                this.mJSHandler.sendEmptyMessage(6);
            }
        }
        catch (Throwable e) {
            WXLogUtils.e("WXBridgeManager" + e.getMessage());
        }
    }

    private WXParams assembleDefaultOptions() {
        Map<String, String> config = WXEnvironment.getConfig();
        WXParams wxParams = new WXParams();
        wxParams.setPlatform(config.get("os"));
        wxParams.setOsVersion(config.get("sysVersion"));
        wxParams.setAppVersion(config.get("appVersion"));
        wxParams.setWeexVersion(config.get("weexVersion"));
        wxParams.setDeviceModel(config.get("sysModel"));
        wxParams.setShouldInfoCollect(config.get("infoCollect"));
        wxParams.setLogLevel(config.get("logLevel"));
        String appName = config.get("appName");
        if (!TextUtils.isEmpty((CharSequence)appName)) {
            wxParams.setAppName(appName);
        }
        wxParams.setDeviceWidth(TextUtils.isEmpty((CharSequence)config.get("deviceWidth")) ? String.valueOf(WXViewUtils.getScreenWidth((Context)WXEnvironment.sApplication)) : config.get("deviceWidth"));
        wxParams.setDeviceHeight(TextUtils.isEmpty((CharSequence)config.get("deviceHeight")) ? String.valueOf(WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication)) : config.get("deviceHeight"));
        return wxParams;
    }

    private void execRegisterFailTask() {
        int componentCount;
        int moduleCount = this.mRegisterModuleFailList.size();
        if (moduleCount > 0) {
            for (int i = 0; i < moduleCount; ++i) {
                this.registerModules(this.mRegisterModuleFailList.get(i));
            }
            this.mRegisterModuleFailList.clear();
            WXLogUtils.e("[WXBridgeManager] execRegisterFailTask register module fail");
        }
        if ((componentCount = this.mRegisterComponentFailList.size()) > 0) {
            for (int i = 0; i < componentCount; ++i) {
                this.registerComponents(this.mRegisterComponentFailList.get(i));
            }
            this.mRegisterComponentFailList.clear();
            WXLogUtils.e("[WXBridgeManager] execRegisterFailTask register component fail");
        }
    }

    public void registerModules(final Map<String, Object> modules) {
        if (this.mJSHandler == null || modules == null || modules.size() == 0) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                WXBridgeManager.this.invokeRegisterModules(modules);
            }
        }, null);
    }

    public void registerComponents(final ArrayList<Map<String, String>> components) {
        if (this.mJSHandler == null || components == null || components.size() == 0) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                WXBridgeManager.this.invokeRegisterComponents(components);
            }
        }, null);
    }

    private void invokeRegisterModules(Map<String, Object> modules) {
        if (modules == null || !this.mInit) {
            if (!this.mInit) {
                WXLogUtils.e("[WXBridgeManager] invokeCallJSBatch: framework.js uninitialized.");
            }
            this.mRegisterModuleFailList.add(modules);
            return;
        }
        WXJSObject[] args = new WXJSObject[]{new WXJSObject(3, WXJsonUtils.fromObjectToJSONString(modules))};
        try {
            this.mWXBridge.execJS("", null, METHOD_REGISTER_MODULES, args);
        }
        catch (Throwable e) {
            WXLogUtils.e("[WXBridgeManager] invokeRegisterModules:" + (e == null ? "" : e.getStackTrace()));
        }
    }

    private void invokeRegisterComponents(ArrayList<Map<String, String>> components) {
        if (components == null || !this.mInit) {
            if (!this.mInit) {
                WXLogUtils.e("[WXBridgeManager] invokeCallJSBatch: framework.js uninitialized.");
            }
            this.mRegisterComponentFailList.add(components);
            return;
        }
        WXJSObject[] args = new WXJSObject[]{new WXJSObject(3, WXJsonUtils.fromObjectToJSONString(components))};
        try {
            this.mWXBridge.execJS("", null, METHOD_REGISTER_COMPONENTS, args);
        }
        catch (Throwable e) {
            WXLogUtils.e("[WXBridgeManager] invokeRegisterComponents " + (e == null ? "" : e.getCause()));
        }
    }

    public void destroy() {
        if (this.mJSThread != null) {
            this.mJSThread.quit();
        }
        mBridgeManager = null;
    }

    public void reportJSException(String instanceId, String function, String exception) {
        WXSDKInstance instance;
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.e("reportJSException >>>> instanceId:" + instanceId + ", exception function:" + function + ", exception:" + exception);
        }
        if ((instance = WXSDKManager.getInstance().getSDKInstance(instanceId)) != null) {
            instance.onJSException(null, function, exception);
        }
        WXErrorCode.WX_ERR_JS_EXECUTE.appendErrMsg(exception);
        this.commitJSBridgeAlarmMonitor(instanceId, WXErrorCode.WX_ERR_JS_EXECUTE);
    }

    public static class TimerInfo {
        public String callbackId;
        public long time;
        public String instanceId;
    }
}

