/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex;

import android.app.Application;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import java.util.HashMap;
import java.util.Map;

public class WXEnvironment {
    public static final String OS = "android";
    public static final String SYS_VERSION = Build.VERSION.RELEASE;
    public static final String SYS_MODEL = Build.MODEL;
    public static String JS_LIB_SDK_VERSION = "v0.13.9";
    public static String WXSDK_VERSION = "1.5.0";
    public static Application sApplication;
    public static final String DEV_Id;
    public static int sDeafultWidth;
    public static volatile boolean sSupport;
    public static volatile boolean JsFrameworkInit;
    public static boolean sDebugMode;
    public static String sDebugWsUrl;
    public static long sJSLibInitTime;
    private static boolean isApkDebug;
    private static boolean isPerf;
    private static Map<String, String> options;
    public static boolean sDynamicMode;
    public static String sDynamicUrl;

    public static Map<String, String> getConfig() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("os", OS);
        configs.put("appVersion", WXEnvironment.getAppVersionName());
        configs.put("devId", DEV_Id);
        configs.put("sysVersion", SYS_VERSION);
        configs.put("sysModel", SYS_MODEL);
        configs.put("weexVersion", String.valueOf(WXSDK_VERSION));
        configs.putAll(options);
        if (configs != null && configs.get("appName") == null) {
            configs.put("appName", sApplication.getPackageName());
        }
        return configs;
    }

    private static String getAppVersionName() {
        String versionName = "";
        PackageInfo info = null;
        try {
            PackageManager manager = sApplication.getPackageManager();
            info = manager.getPackageInfo(sApplication.getPackageName(), 0);
            versionName = info.versionName;
        }
        catch (Exception e) {
            WXLogUtils.e("WXEnvironment getAppVersionName Exception: " + WXLogUtils.getStackTrace(e));
        }
        return versionName;
    }

    public static void addCustomOptions(String key, String value) {
        options.put(key, value);
    }

    public static boolean isSupport() {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("WXEnvironment.sSupport:" + sSupport + " WXEnvironment.JsFrameworkInit:" + JsFrameworkInit + " !WXUtils.isTabletDevice():" + !WXUtils.isTabletDevice());
        }
        return sSupport && JsFrameworkInit && !WXUtils.isTabletDevice();
    }

    public static boolean isApkDebugable() {
        if (sApplication == null) {
            return false;
        }
        if (isPerf) {
            return false;
        }
        if (!isApkDebug) {
            return false;
        }
        try {
            ApplicationInfo info = sApplication.getApplicationInfo();
            isApkDebug = (info.flags & 2) != 0;
            return isApkDebug;
        }
        catch (Exception e) {
            WXLogUtils.e("WXEnvironment isApkDebugable Exception: " + WXLogUtils.getStackTrace(e));
            return false;
        }
    }

    public static boolean isPerf() {
        return isPerf;
    }

    private static String getDevId() {
        return sApplication == null ? "" : ((TelephonyManager)sApplication.getSystemService("phone")).getDeviceId();
    }

    public static Application getApplication() {
        return sApplication;
    }

    public void initMetrics() {
        if (sApplication == null) {
            return;
        }
    }

    static {
        DEV_Id = WXEnvironment.getDevId();
        sDeafultWidth = 750;
        sSupport = false;
        JsFrameworkInit = false;
        sDebugMode = false;
        sDebugWsUrl = "";
        sJSLibInitTime = 0L;
        isApkDebug = true;
        isPerf = false;
        options = new HashMap<String, String>();
        sDynamicMode = false;
        sDynamicUrl = "";
    }
}

