/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.listview;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import com.taobao.weex.ui.view.listview.BaseBounceView;
import com.taobao.weex.ui.view.listview.IRefreshLayout;
import com.taobao.weex.ui.view.listview.OnLoadMoreListener;
import com.taobao.weex.ui.view.listview.OnRefreshListener;
import com.taobao.weex.ui.view.listview.RefreshAdapterWrapper;
import com.taobao.weex.ui.view.listview.WXRecyclerView;
import com.taobao.weex.ui.view.listview.adapter.RecyclerViewBaseAdapter;

public class BounceRecyclerView
extends BaseBounceView<RecyclerView> {
    private State mState = State.RESET;
    private OnRefreshListener mOnRefreshListener;
    private OnLoadMoreListener mOnLoadMoreListener;
    private RefreshAdapterWrapper mRefreshAdapter;

    public BounceRecyclerView(Context context) {
        super(context);
    }

    public BounceRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setOnRefreshListener(OnRefreshListener listener) {
        this.mOnRefreshListener = listener;
    }

    public void setOnLoadMoreListener(OnLoadMoreListener listener) {
        this.mOnLoadMoreListener = listener;
    }

    public void setAdapter(RecyclerViewBaseAdapter adapter) {
        this.mRefreshAdapter = new RefreshAdapterWrapper(this.getContext(), adapter);
        ((RecyclerView)this.getBounceView()).setAdapter((RecyclerView.Adapter)this.mRefreshAdapter);
    }

    public RefreshAdapterWrapper getAdapter() {
        return this.mRefreshAdapter;
    }

    public void refreshState() {
        if (this.mOnRefreshListener != null) {
            this.onRefreshComplete();
        }
        if (this.mOnLoadMoreListener != null) {
            this.onLoadMoreComplete();
        }
    }

    @Override
    public boolean isReadyForPullFromTop() {
        View firstVisibleChild;
        LinearLayoutManager lm = (LinearLayoutManager)((RecyclerView)this.getBounceView()).getLayoutManager();
        if (lm.findFirstVisibleItemPosition() == 0 && (firstVisibleChild = ((RecyclerView)this.getBounceView()).getChildAt(0)) != null) {
            return firstVisibleChild.getTop() + this.getPaddingTop() >= ((RecyclerView)this.getBounceView()).getTop();
        }
        return false;
    }

    @Override
    public boolean isReadyForPullFromBottom() {
        int childIndex;
        View lastVisibleChild;
        RecyclerView lv = (RecyclerView)this.getBounceView();
        RecyclerView.Adapter adapter = lv.getAdapter();
        LinearLayoutManager lm = (LinearLayoutManager)((RecyclerView)this.getBounceView()).getLayoutManager();
        int lastItemPosition = adapter.getItemCount() - 1;
        int lastVisiblePosition = lm.findLastVisibleItemPosition();
        if (lastVisiblePosition >= lastItemPosition && (lastVisibleChild = lv.getChildAt(childIndex = lastVisiblePosition - lm.findFirstVisibleItemPosition())) != null) {
            return lastVisibleChild.getBottom() + this.getPaddingTop() <= lv.getBottom();
        }
        return false;
    }

    @Override
    public RecyclerView createBounceView(Context context) {
        WXRecyclerView recyclerView = new WXRecyclerView(context);
        recyclerView.initView(context, 1);
        return recyclerView;
    }

    @Override
    public IRefreshLayout createBounceHeaderView(Context context) {
        return new IRefreshLayout.Adapter(new View(context));
    }

    @Override
    public IRefreshLayout createBounceFooterView(Context context) {
        return new IRefreshLayout.Adapter(new View(context));
    }

    @Override
    protected void onTouchActionUp() {
        super.onTouchActionUp();
        if (!this.isRefreshing() && !this.isLoadingMore()) {
            if (this.getState() == State.RELEASE_TO_REFRESH_TOP && null != this.mOnRefreshListener) {
                this.getBounceHeaderView().setVisibility(4);
                this.setState(State.REFRESHING);
            } else if (this.getState() == State.RELEASE_TO_REFRESH_BOTTOM && null != this.mOnLoadMoreListener) {
                this.getBounceFooterView().setVisibility(4);
                this.setState(State.LOADMORE);
            } else if (this.getState() != State.LOADMORE) {
                this.setState(State.RESET);
            }
        }
    }

    @Override
    protected void onPullStateChanged(int itemDimension, int scrollValue) {
        super.onPullStateChanged(itemDimension, scrollValue);
        if (!this.isRefreshing() && !this.isLoadingMore()) {
            if (scrollValue < 0) {
                if (this.refreshEnabled()) {
                    this.setState(itemDimension >= Math.abs(scrollValue) ? State.PULL_TO_REFRESH_TOP : State.RELEASE_TO_REFRESH_TOP);
                }
                this.getBounceHeaderView().setVisibility(this.refreshEnabled() ? 0 : 4);
            } else {
                if (this.loadMoreEnabled()) {
                    this.setState(itemDimension >= Math.abs(scrollValue) ? State.PULL_TO_REFRESH_BOTTOM : State.RELEASE_TO_REFRESH_BOTTOM);
                }
                this.getBounceFooterView().setVisibility(this.loadMoreEnabled() ? 0 : 4);
            }
        }
    }

    private void setState(State s) {
        this.mState = s;
        switch (s) {
            case PULL_TO_REFRESH_TOP: {
                break;
            }
            case RELEASE_TO_REFRESH_TOP: {
                break;
            }
            case REFRESHING: {
                this.onRefreshing();
                break;
            }
            case RESET: {
                this.onReset();
                break;
            }
            case LOADMORE: {
                this.onLoadingMore();
                break;
            }
        }
    }

    private void onRefreshing() {
        this.mRefreshAdapter.refreshing();
        this.getBounceHeaderView().setVisibility(4);
        if (this.mOnRefreshListener != null) {
            this.mOnRefreshListener.onRefresh();
        }
    }

    private void notifyDataSetChanged(final RecyclerView recyclerView) {
        this.mRefreshAdapter.notifyDataSetChanged();
        recyclerView.post(new Runnable(){

            @Override
            public void run() {
                RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                int lastVisibleItemPosition = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
                recyclerView.setAdapter((RecyclerView.Adapter)BounceRecyclerView.this.mRefreshAdapter);
                layoutManager.scrollToPosition(lastVisibleItemPosition);
            }
        });
    }

    private void onLoadingMore() {
        this.mRefreshAdapter.loadingMore();
        this.getBounceFooterView().setVisibility(4);
        this.notifyDataSetChanged((RecyclerView)this.getBounceView());
        if (this.mOnLoadMoreListener != null) {
            this.mOnLoadMoreListener.onLoadMore();
        }
    }

    private void onRefreshComplete() {
        if (this.isRefreshing()) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    BounceRecyclerView.this.getBounceHeaderView().setVisibility(0);
                    BounceRecyclerView.this.setState(State.RESET);
                }
            }, 500L);
        }
    }

    private void onLoadMoreComplete() {
        if (this.isLoadingMore()) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    BounceRecyclerView.this.getBounceFooterView().setVisibility(0);
                    BounceRecyclerView.this.setState(State.RESET);
                }
            }, 500L);
        }
    }

    private void onReset() {
        this.mRefreshAdapter.resetRefreshing();
    }

    private boolean refreshEnabled() {
        return this.mOnRefreshListener != null;
    }

    private boolean loadMoreEnabled() {
        return this.mOnLoadMoreListener != null;
    }

    private boolean isRefreshing() {
        return this.getState() == State.REFRESHING;
    }

    private boolean isLoadingMore() {
        return this.getState() == State.LOADMORE;
    }

    private State getState() {
        return this.mState;
    }

    private static enum State {
        PULL_TO_REFRESH_TOP,
        RELEASE_TO_REFRESH_TOP,
        PULL_TO_REFRESH_BOTTOM,
        RELEASE_TO_REFRESH_BOTTOM,
        REFRESHING,
        LOADMORE,
        LOADMORE_TOP,
        RESET;

    }
}

