/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;

public class WXLoadingIndicatorView
extends View {
    private int maxProgress = 100;
    private int progress = 0;
    private RectF oval = new RectF();
    private Paint paint = new Paint();

    public WXLoadingIndicatorView(Context context) {
        this(context, null);
    }

    public WXLoadingIndicatorView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WXLoadingIndicatorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int width = this.getWidth();
        int height = this.getHeight();
        if (width != height) {
            int min;
            width = min = Math.min(width, height);
            height = min;
        }
        this.paint.setAntiAlias(true);
        this.paint.setColor(-7829368);
        canvas.drawColor(0);
        int progressStrokeWidth = WXViewUtils.dip2px(4.0f);
        this.paint.setStrokeWidth((float)progressStrokeWidth);
        this.paint.setStyle(Paint.Style.STROKE);
        this.oval.left = progressStrokeWidth / 2;
        this.oval.top = progressStrokeWidth / 2;
        this.oval.right = width - progressStrokeWidth / 2;
        this.oval.bottom = height - progressStrokeWidth / 2;
        canvas.drawArc(this.oval, -90.0f, (float)this.progress / (float)this.maxProgress * 360.0f, false, this.paint);
        WXLogUtils.v("tag", "progress " + this.progress);
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgress = maxProgress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
        this.invalidate();
    }
}

