/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.taobao.weex.IWXRenderListener;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXRenderStrategy;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXDiv;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXLogUtils;

public class WXEmbed
extends WXDiv {
    private String src;
    private WXSDKInstance instance;

    public WXEmbed(WXSDKInstance instance, WXDomObject node, WXVContainer parent, String instanceId, boolean lazy) {
        super(instance, node, parent, instanceId, lazy);
    }

    @WXComponentProp(name="src")
    public void setSrc(String src) {
        this.src = src;
        if (this.instance != null) {
            this.instance.destroy();
            this.instance = null;
        }
        if (TextUtils.equals((CharSequence)this.getVisibility(), (CharSequence)"visible")) {
            this.instance = this.createInstance();
        }
    }

    private WXSDKInstance createInstance() {
        WXSDKInstance sdkInstance = new WXSDKInstance(this.mContext);
        sdkInstance.registerRenderListener(new IWXRenderListener(){

            @Override
            public void onViewCreated(WXSDKInstance instance, View view) {
                WXEmbed.this.getView().removeAllViews();
                WXEmbed.this.getView().addView(view);
            }

            @Override
            public void onRenderSuccess(WXSDKInstance instance, int width, int height) {
            }

            @Override
            public void onRefreshSuccess(WXSDKInstance instance, int width, int height) {
            }

            @Override
            public void onException(WXSDKInstance instance, String errCode, String msg) {
                WXLogUtils.e("WXEmbed", "Error code :" + errCode + ",\n error message :" + msg);
            }
        });
        ViewGroup.LayoutParams layoutParams = this.getView().getLayoutParams();
        sdkInstance.renderByUrl("default", this.src, null, null, layoutParams.width, layoutParams.height, WXRenderStrategy.APPEND_ASYNC);
        return sdkInstance;
    }

    @Override
    @WXComponentProp(name="visibility")
    public void setVisibility(String visibility) {
        super.setVisibility(visibility);
        if (!TextUtils.isEmpty((CharSequence)this.src) && TextUtils.equals((CharSequence)this.getVisibility(), (CharSequence)"visible") && this.instance == null) {
            this.instance = this.createInstance();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.instance != null) {
            this.instance.destroy();
            this.instance = null;
        }
        this.src = null;
    }
}

