/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.content.Context;
import android.graphics.PointF;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.taobao.weex.IWXActivityStateListener;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.IWXObject;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.flex.Spacing;
import com.taobao.weex.ui.component.WXBorder;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXComponentPropCache;
import com.taobao.weex.ui.component.WXScroller;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.list.WXListComponent;
import com.taobao.weex.ui.view.WXCircleIndicator;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.ui.view.gesture.WXGestureType;
import com.taobao.weex.ui.view.listview.BounceRecyclerView;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class WXComponent
implements IWXObject,
IWXActivityStateListener {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static int mComponentNum = 0;
    public View mHost;
    public volatile WXVContainer mParent;
    public volatile WXDomObject mDomObj;
    public String mInstanceId;
    public boolean registerAppearEvent = false;
    public boolean appearState = false;
    protected int mOrientation = 1;
    protected WXSDKInstance mInstance;
    protected Context mContext;
    protected int mAbsoluteY = 0;
    protected int mAbsoluteX = 0;
    protected Set<String> mGestureType;
    private WXBorder mBorder;
    private boolean mLazy;
    private int mPreRealWidth = 0;
    private int mPreRealHeight = 0;
    private int mPreRealLeft = 0;
    private int mPreRealTop = 0;
    private WXGesture wxGesture;

    public WXComponent(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        this.mInstance = instance;
        this.mContext = this.mInstance.getContext();
        this.mParent = parent;
        this.mDomObj = dom.clone();
        this.mInstanceId = instanceId;
        this.mLazy = isLazy;
        this.mGestureType = new HashSet<String>();
        ++mComponentNum;
    }

    public boolean isLazy() {
        return this.mLazy;
    }

    public void lazy(boolean lazy) {
        this.mLazy = lazy;
    }

    public final void bind(View view) {
        if (!this.mLazy) {
            this.bindImpl(view);
        }
    }

    protected void bindImpl(View view) {
        if (view != null) {
            this.mHost = view;
            this.getOrCreateBorder().attachView(view);
        }
        this.setLayout(this.mDomObj);
        this.setPadding(this.mDomObj.getPadding(), this.mDomObj.getBorder());
        this.updateProperties();
        this.addEvents();
        this.updateExtra(this.mDomObj.getExtra());
    }

    protected WXBorder getOrCreateBorder() {
        if (this.mBorder == null) {
            this.mBorder = new WXBorder();
        }
        return this.mBorder;
    }

    public final void setLayout(WXDomObject domObject) {
        if (this.mParent == null || domObject == null || TextUtils.isEmpty((CharSequence)this.mDomObj.ref)) {
            return;
        }
        this.mDomObj = domObject;
        Spacing parentPadding = this.mParent.getDomObject().getPadding();
        Spacing margin = this.mDomObj.getMargin();
        int realWidth = (int)this.mDomObj.getLayoutWidth();
        int realHeight = (int)this.mDomObj.getLayoutHeight();
        int realLeft = (int)(this.mDomObj.getLayoutX() - parentPadding.get(0));
        int realTop = (int)(this.mDomObj.getLayoutY() - parentPadding.get(1));
        int realRight = (int)margin.get(2);
        int realBottom = (int)margin.get(3);
        if (this.mPreRealWidth == realWidth && this.mPreRealHeight == realHeight && this.mPreRealLeft == realLeft && this.mPreRealTop == realTop) {
            return;
        }
        if (this.mParent != null) {
            this.mAbsoluteY = (int)((float)this.mParent.mAbsoluteY + this.mDomObj.getLayoutY());
            this.mAbsoluteX = (int)((float)this.mParent.mAbsoluteX + this.mDomObj.getLayoutX());
        }
        if (!this.mInstance.mEnd && this.mAbsoluteY >= WXViewUtils.getScreenHeight()) {
            this.mInstance.firstScreenRenderFinished(System.currentTimeMillis());
        }
        if (this.mHost == null) {
            return;
        }
        MeasureOutput measureOutput = this.measure(realWidth, realHeight);
        realWidth = measureOutput.width;
        realHeight = measureOutput.height;
        if (this.mHost instanceof WXCircleIndicator) {
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(realWidth, realHeight);
            params.setMargins(realLeft, realTop, realRight, realBottom);
            this.mHost.setLayoutParams((ViewGroup.LayoutParams)params);
            return;
        }
        if (this.mDomObj.isFixed() && this.mInstance.getRootView() != null) {
            if (this.mHost.getParent() instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)this.mHost.getParent();
                viewGroup.removeView(this.mHost);
            }
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
            params.width = realWidth;
            params.height = realHeight;
            params.setMargins(realLeft, realTop, realRight, realBottom);
            this.mHost.setLayoutParams((ViewGroup.LayoutParams)params);
            this.mInstance.getRootView().addView(this.mHost);
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("Weex_Fixed_Style", "WXComponent:setLayout :" + realLeft + " " + realTop + " " + realWidth + " " + realHeight);
                WXLogUtils.d("Weex_Fixed_Style", "WXComponent:setLayout Left:" + this.mDomObj.style.getLeft() + " " + (int)this.mDomObj.style.getTop());
            }
            return;
        }
        if (!(this.mParent.getRealView() instanceof ViewPager)) {
            if (this.mParent.getRealView() instanceof FrameLayout) {
                FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(realWidth, realHeight);
                params.setMargins(realLeft, realTop, realRight, realBottom);
                this.mHost.setLayoutParams((ViewGroup.LayoutParams)params);
            } else if (this.mParent.getRealView() instanceof LinearLayout) {
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(realWidth, realHeight);
                params.setMargins(realLeft, realTop, realRight, realBottom);
                this.mHost.setLayoutParams((ViewGroup.LayoutParams)params);
            } else if (this.mParent.getRealView() instanceof ScrollView) {
                FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(realWidth, realHeight);
                params.setMargins(realLeft, realTop, realRight, realBottom);
                this.mHost.setLayoutParams((ViewGroup.LayoutParams)params);
            } else if (this.mParent.getRealView() instanceof BounceRecyclerView) {
                // empty if block
            }
        }
        this.mPreRealWidth = realWidth;
        this.mPreRealHeight = realHeight;
        this.mPreRealLeft = realLeft;
        this.mPreRealTop = realTop;
    }

    public void setPadding(Spacing padding, Spacing border) {
        int left = (int)(padding.get(0) + border.get(0));
        int top = (int)(padding.get(1) + border.get(1));
        int right = (int)(padding.get(2) + border.get(2));
        int bottom = (int)(padding.get(3) + border.get(3));
        if (this.mHost == null) {
            return;
        }
        this.mHost.setPadding(left, top, right, bottom);
    }

    private void updateProperties() {
        if (this.mDomObj.attr != null && this.mDomObj.attr.size() > 0) {
            this.updateProperties(this.mDomObj.attr);
        }
        if (this.mDomObj.style != null && this.mDomObj.style.size() > 0) {
            this.updateProperties(this.mDomObj.style);
        }
    }

    private void addEvents() {
        int count = this.mDomObj.event == null ? 0 : this.mDomObj.event.size();
        for (int i = 0; i < count; ++i) {
            this.addEvent((String)this.mDomObj.event.get(i));
        }
    }

    public void updateExtra(Object extra) {
    }

    public WXDomObject getDomObject() {
        return this.mDomObj;
    }

    protected MeasureOutput measure(int width, int height) {
        MeasureOutput measureOutput = new MeasureOutput();
        measureOutput.width = width;
        measureOutput.height = height;
        return measureOutput;
    }

    public final void updateProperties(Map<String, Object> props) {
        if (props.isEmpty() || this.mHost == null) {
            return;
        }
        HashMap<String, Method> methodMap = WXComponentPropCache.getMethods(this.getClass());
        Iterator<Map.Entry<String, Object>> iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().getKey();
            Method method = (Method)methodMap.get(key);
            if (method == null) continue;
            try {
                Type[] paramClazzs = WXComponentPropCache.getMethodGenericParameterTypes(method);
                if (paramClazzs.length != 1) {
                    WXLogUtils.e("[WXComponent] setX method only one parameter\uff1a" + method);
                    return;
                }
                Type paramClazz = paramClazzs[0];
                Object value = props.get(key);
                String sValue = value instanceof String ? (String)value : JSON.toJSONString((Object)value);
                Object param = paramClazz == Integer.TYPE ? Integer.valueOf(WXUtils.getInt(sValue)) : (paramClazz == String.class ? sValue : (paramClazz == Long.TYPE ? Long.valueOf(WXUtils.getLong(sValue)) : (paramClazz == Double.TYPE ? Double.valueOf(WXUtils.getDouble(sValue)) : (paramClazz == Float.TYPE ? Float.valueOf(WXUtils.getFloat(sValue)) : (ParameterizedType.class.isAssignableFrom(paramClazz.getClass()) ? JSON.parseObject((String)sValue, (Type)paramClazz, (Feature[])new Feature[0]) : (IWXObject.class.isAssignableFrom(paramClazz.getClass()) ? JSON.parseObject((String)sValue, (Type)paramClazz, (Feature[])new Feature[0]) : JSON.parseObject((String)sValue, (Type)paramClazz, (Feature[])new Feature[0])))))));
                method.invoke((Object)this, param);
            }
            catch (Exception e) {
                WXLogUtils.e("[WXComponent] updateProperties :class:" + this.getClass() + "method:" + method.getName() + " function " + WXLogUtils.getStackTrace(e));
            }
        }
    }

    public void addEvent(String type) {
        if (TextUtils.isEmpty((CharSequence)type)) {
            return;
        }
        this.mDomObj.addEvent(type);
        if (type.equals("click") && this.getRealView() != null) {
            this.mHost.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    WXSDKManager.getInstance().fireEvent(WXComponent.this.mInstanceId, WXComponent.this.mDomObj.ref, "click", params);
                }
            });
        } else if ((type.equals("focus") || type.equals("blur")) && this.getRealView() != null) {
            this.getRealView().setFocusable(true);
            this.getRealView().setOnFocusChangeListener(new View.OnFocusChangeListener(){

                public void onFocusChange(View v, boolean hasFocus) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("timeStamp", System.currentTimeMillis());
                    WXSDKManager.getInstance().fireEvent(WXComponent.this.mInstanceId, WXComponent.this.mDomObj.ref, hasFocus ? "focus" : "blur", params);
                }
            });
        } else if (this.getRealView() != null && this.needGestureDetector(type)) {
            if (this.getRealView() instanceof WXGestureObservable) {
                if (this.wxGesture == null) {
                    this.wxGesture = new WXGesture(this, this.mContext);
                }
                this.mGestureType.add(type);
                ((WXGestureObservable)this.getRealView()).registerGestureListener(this.wxGesture);
            } else {
                WXLogUtils.e(this.getRealView().getClass().getSimpleName() + " don't implement " + "WXGestureObservable, so no gesture is supported.");
            }
        } else {
            WXScroller scroller = this.getParentScroller();
            if (type.equals("appear") && scroller != null) {
                scroller.bindAppearEvent(this);
            }
            if (type.equals("disappear") && scroller != null) {
                scroller.bindDisappearEvent(this);
            }
            if (type.equals("appear") && this.getParent() instanceof WXListComponent) {
                this.registerAppearEvent = true;
            }
            if (type.equals("disappear") && this.getParent() instanceof WXListComponent) {
                this.registerAppearEvent = true;
            }
        }
    }

    public View getRealView() {
        return this.mHost;
    }

    private boolean needGestureDetector(String type) {
        if (this.mHost != null) {
            for (WXGestureType.LowLevelGesture lowLevelGesture : WXGestureType.LowLevelGesture.values()) {
                if (!type.equals(((Object)lowLevelGesture).toString())) continue;
                return true;
            }
            for (Enum enum_ : WXGestureType.HighLevelGesture.values()) {
                if (!type.equals(enum_.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public WXScroller getParentScroller() {
        WXComponent component = this;
        WXVContainer container;
        while ((container = component.getParent()) != null) {
            if (container instanceof WXScroller) {
                WXScroller scroller = (WXScroller)container;
                return scroller;
            }
            if (container.getRef().equals("_root")) {
                return null;
            }
            component = container;
        }
        return null;
    }

    public WXVContainer getParent() {
        return this.mParent;
    }

    public String getRef() {
        if (this.mDomObj == null) {
            return null;
        }
        return this.mDomObj.ref;
    }

    public final void createView(WXVContainer parent, int index) {
        if (!this.mLazy) {
            this.createViewImpl(parent, index);
        }
    }

    protected void createViewImpl(WXVContainer parent, int index) {
        this.initView();
        if (parent != null) {
            parent.addSubView(this.mHost, index);
        }
        this.getOrCreateBorder().attachView(this.mHost);
    }

    protected void initView() {
        this.mHost = new FrameLayout(this.mContext);
    }

    public View getView() {
        return this.mHost;
    }

    public int getAbsoluteY() {
        return this.mAbsoluteY;
    }

    public int getAbsoluteX() {
        return this.mAbsoluteX;
    }

    public void updateDom(WXDomObject dom) {
        if (dom == null) {
            return;
        }
        this.mDomObj = dom;
    }

    public void flushView() {
    }

    public final void removeEvent(String type) {
        if (TextUtils.isEmpty((CharSequence)type)) {
            return;
        }
        this.mDomObj.removeEvent(type);
        this.mGestureType.remove(type);
        this.removeEventFromView(type);
    }

    protected void removeEventFromView(String type) {
        if (type.equals("click") && this.getRealView() != null) {
            this.getRealView().setOnClickListener(null);
        }
        WXScroller scroller = this.getParentScroller();
        if (type.equals("appear") && scroller != null) {
            scroller.unbindAppearEvent(this);
        }
        if (type.equals("disappear") && scroller != null) {
            scroller.unbindDisappearEvent(this);
        }
        if (type.equals("appear") && this.getParent() instanceof WXListComponent) {
            ((WXListComponent)this.getParent()).unbindAppearComponents(this);
            this.registerAppearEvent = false;
        }
        if (type.equals("disappear") && this.getParent() instanceof WXListComponent) {
            ((WXListComponent)this.getParent()).unbindAppearComponents(this);
            this.registerAppearEvent = false;
        }
    }

    public final void removeAllEvent() {
        if (this.mDomObj == null || this.mDomObj.event == null || this.mDomObj.event.size() < 1) {
            return;
        }
        for (String event : this.mDomObj.event) {
            this.removeEventFromView(event);
        }
        this.mDomObj.event.clear();
        this.mGestureType.clear();
        this.wxGesture = null;
        if (this.getRealView() != null && this.getRealView() instanceof WXGestureObservable) {
            ((WXGestureObservable)this.getRealView()).registerGestureListener(null);
        }
    }

    public final void removeStickyStyle() {
        WXScroller scroller;
        if (this.mDomObj == null || this.mDomObj.style == null) {
            return;
        }
        if (this.mDomObj.isSticky() && (scroller = this.getParentScroller()) != null) {
            scroller.unbindStickStyle(this);
        }
    }

    @WXComponentProp(name="disabled")
    public void setDisabled(boolean disabled) {
        if (this.mHost == null) {
            return;
        }
        this.mHost.setEnabled(!disabled);
    }

    @WXComponentProp(name="position")
    public void setSticky(String sticky) {
        WXScroller waScroller;
        if (!TextUtils.isEmpty((CharSequence)sticky) && sticky.equals("sticky") && (waScroller = this.getParentScroller()) != null) {
            waScroller.bindStickStyle(this);
        }
    }

    @WXComponentProp(name="backgroundColor")
    public void setBackgroundColor(String color) {
        int colorInt;
        if (!TextUtils.isEmpty((CharSequence)color) && (colorInt = WXResourceUtils.getColor(color)) != Integer.MIN_VALUE) {
            this.getOrCreateBorder().setBackgroundColor(colorInt);
        }
    }

    @WXComponentProp(name="opacity")
    public void setOpacity(float opacity) {
        if (opacity >= 0.0f && opacity <= 1.0f && this.mHost.getAlpha() != opacity) {
            this.mHost.setAlpha(opacity);
        }
    }

    @WXComponentProp(name="borderRadius")
    public void setBorderRadius(float borderRadius) {
        if (borderRadius >= 0.0f) {
            this.getOrCreateBorder().setBorderRadius(WXViewUtils.getRealPxByWidth(borderRadius));
        }
    }

    @WXComponentProp(name="borderTopLeftRadius")
    public void setBorderTopLeftRadius(float borderRadius) {
        this.setBorderRadius(0, borderRadius);
    }

    private void setBorderRadius(int position, float borderRadius) {
        if (borderRadius >= 0.0f) {
            this.getOrCreateBorder().setBorderRadius(position, WXViewUtils.getRealPxByWidth(borderRadius));
        }
    }

    @WXComponentProp(name="borderTopRightRadius")
    public void setBorderTopRightRadius(float borderRadius) {
        this.setBorderRadius(1, borderRadius);
    }

    @WXComponentProp(name="borderBottomRightRadius")
    public void setBorderBottomRightRadius(float borderRadius) {
        this.setBorderRadius(2, borderRadius);
    }

    @WXComponentProp(name="borderBottomLeftRadius")
    public void setBorderBottoLeftRadius(float borderRadius) {
        this.setBorderRadius(3, borderRadius);
    }

    @WXComponentProp(name="borderWidth")
    public void setBorderWidth(float borderWidth) {
        this.setBorderWidth(8, borderWidth);
    }

    private void setBorderWidth(int position, float borderWidth) {
        if (borderWidth >= 0.0f) {
            this.getOrCreateBorder().setBorderWidth(position, WXViewUtils.getRealPxByWidth(borderWidth));
        }
    }

    @WXComponentProp(name="borderTopWidth")
    public void setBorderTopWidth(float borderWidth) {
        this.setBorderWidth(1, borderWidth);
    }

    @WXComponentProp(name="borderRightWidth")
    public void setBorderRightWidth(float borderWidth) {
        this.setBorderWidth(2, borderWidth);
    }

    @WXComponentProp(name="borderBottomWidth")
    public void setBorderBottomWidth(float borderWidth) {
        this.setBorderWidth(3, borderWidth);
    }

    @WXComponentProp(name="borderLeftWidth")
    public void setBorderLeftWidth(float borderWidth) {
        this.setBorderWidth(0, borderWidth);
    }

    @WXComponentProp(name="borderStyle")
    public void setBorderStyle(String borderStyle) {
        this.getOrCreateBorder().setBorderStyle(borderStyle);
    }

    @WXComponentProp(name="borderColor")
    public void setBorderColor(String borderColor) {
        this.setBorderColor(8, borderColor);
    }

    private void setBorderColor(int position, String borderColor) {
        int colorInt;
        if (!TextUtils.isEmpty((CharSequence)borderColor) && (colorInt = WXResourceUtils.getColor(borderColor)) != Integer.MIN_VALUE) {
            this.getOrCreateBorder().setBorderColor(position, colorInt);
        }
    }

    @WXComponentProp(name="borderTopColor")
    public void setBorderTopColor(String borderColor) {
        this.setBorderColor(1, borderColor);
    }

    @WXComponentProp(name="borderRightColor")
    public void setBorderRightColor(String borderColor) {
        this.setBorderColor(2, borderColor);
    }

    @WXComponentProp(name="borderBottomColor")
    public void setBorderBottomColor(String borderColor) {
        this.setBorderColor(3, borderColor);
    }

    @WXComponentProp(name="borderLeftColor")
    public void setBorderLeftColor(String borderColor) {
        this.setBorderColor(0, borderColor);
    }

    @Nullable
    public String getVisibility() {
        try {
            return (String)this.getDomObject().style.get("visibility");
        }
        catch (Exception e) {
            return "visible";
        }
    }

    @WXComponentProp(name="visibility")
    public void setVisibility(String visibility) {
        View view = this.getRealView();
        if (view != null) {
            if (TextUtils.equals((CharSequence)visibility, (CharSequence)"visible")) {
                view.setVisibility(0);
            } else if (TextUtils.equals((CharSequence)visibility, (CharSequence)"hidden")) {
                view.setVisibility(8);
            }
        }
    }

    public void registerActivityStateListener() {
        if (this.mInstance != null) {
            this.mInstance.registerActivityStateListener(this);
        }
    }

    @Override
    public void onActivityCreate() {
    }

    @Override
    public void onActivityStart() {
    }

    @Override
    public void onActivityPause() {
    }

    @Override
    public void onActivityResume() {
    }

    @Override
    public void onActivityStop() {
    }

    @Override
    public void onActivityDestroy() {
    }

    @Override
    public boolean onActivityBack() {
        return false;
    }

    public void destroy() {
        if (WXEnvironment.isApkDebugable() && !WXUtils.isUiThread()) {
            throw new WXRuntimeException("[WXComponent] destroy can only be called in main thread");
        }
        this.removeAllEvent();
        this.removeStickyStyle();
        if (this.mDomObj != null) {
            this.mDomObj.destroy();
        }
    }

    public View detachViewAndClearPreInfo() {
        View original = this.mHost;
        if (this.mBorder != null) {
            this.mBorder.detachView();
        }
        this.mPreRealLeft = 0;
        this.mPreRealWidth = 0;
        this.mPreRealHeight = 0;
        this.mPreRealTop = 0;
        this.mHost = null;
        return original;
    }

    public void computeVisiblePointInViewCoordinate(PointF pointF) {
        View view = this.getRealView();
        pointF.set((float)view.getScrollX(), (float)view.getScrollY());
    }

    public boolean containsGesture(WXGestureType WXGestureType2) {
        return this.mGestureType != null && this.mGestureType.contains(WXGestureType2.toString());
    }

    public void notifyApppearStateChange(String wxEventType) {
        WXBridgeManager.getInstance().fireEvent(this.mInstanceId, this.getRef(), wxEventType, null);
    }

    public static class MeasureOutput {
        public int width;
        public int height;
    }
}

