/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.common.WXModuleAnno;
import com.taobao.weex.common.WXRequest;
import com.taobao.weex.common.WXResponse;
import com.taobao.weex.utils.WXLogUtils;
import java.util.HashMap;

public class WXStreamModule
extends WXModule {
    @WXModuleAnno
    public void sendHttp(String params, String callback) {
        JSONObject paramsObj = JSON.parseObject((String)params);
        String method = paramsObj.getString("method");
        String url = paramsObj.getString("url");
        JSONObject header = paramsObj.getJSONObject("header");
        String body = paramsObj.getString("body");
        WXRequest wxRequest = new WXRequest();
        wxRequest.method = method;
        wxRequest.url = url;
        wxRequest.body = body;
        if (wxRequest.paramMap == null) {
            wxRequest.paramMap = new HashMap<String, Object>();
        }
        if (header != null) {
            for (String key : header.keySet()) {
                wxRequest.paramMap.put(key, header.get((Object)key));
            }
        }
        if (this.mWXSDKInstance != null && this.mWXSDKInstance.getWXHttpAdapter() != null) {
            this.mWXSDKInstance.getWXHttpAdapter().sendRequest(wxRequest, new StreamHttpListener(this.mWXSDKInstance.getInstanceId(), callback));
        }
    }

    private class StreamHttpListener
    implements IWXHttpAdapter.OnHttpListener {
        private String mInstanceId;
        private String mCallback;

        private StreamHttpListener(String instanceId, String callbak) {
            this.mInstanceId = instanceId;
            this.mCallback = callbak;
        }

        @Override
        public void onHttpStart() {
        }

        @Override
        public void onHttpUploadProgress(int uploadProgress) {
        }

        @Override
        public void onHttpResponseProgress(int responseProgress) {
        }

        @Override
        public void onHttpFinish(final WXResponse response) {
            WXSDKManager.getInstance().postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    WXBridgeManager.getInstance().callback(StreamHttpListener.this.mInstanceId, StreamHttpListener.this.mCallback, response == null || response.originalData == null ? "{}" : new String(response.originalData));
                }
            }, 0L);
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("WXStreamModule", response != null && response.originalData != null ? new String(response.originalData) : "response data is NUll!");
            }
        }
    }
}

