/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.os.Looper;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.utils.WXLogUtils;

public class WXUtils {
    public static boolean isUiThread() {
        return Thread.currentThread().getId() == Looper.getMainLooper().getThread().getId();
    }

    public static boolean isUndefined(float value) {
        return Float.compare(value, Float.NaN) == 0;
    }

    public static float getFloat(Object value) {
        if (value == null) {
            return Float.NaN;
        }
        String temp = value.toString().trim();
        if (temp.endsWith("px")) {
            temp = temp.substring(0, temp.indexOf("px"));
        }
        float result = Float.NaN;
        try {
            result = Float.parseFloat(temp);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    public static int getInt(Object value) {
        if (value == null) {
            return 0;
        }
        String temp = value.toString().trim();
        if (temp.endsWith("px")) {
            temp = temp.substring(0, temp.indexOf("px"));
        }
        int result = 0;
        try {
            result = Integer.parseInt(temp);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    public static long getLong(Object value) {
        if (value == null) {
            return 0L;
        }
        String temp = value.toString().trim();
        if (temp.endsWith("px")) {
            temp = temp.substring(0, temp.indexOf("px"));
        }
        long result = 0L;
        try {
            result = Long.parseLong(temp);
        }
        catch (NumberFormatException e) {
            WXLogUtils.e("[WXUtils] getLong:" + WXLogUtils.getStackTrace(e));
        }
        return result;
    }

    public static double getDouble(Object value) {
        if (value == null) {
            return 0.0;
        }
        String temp = value.toString().trim();
        if (temp.endsWith("px")) {
            temp = temp.substring(0, temp.indexOf("px"));
        }
        double result = 0.0;
        try {
            result = Double.parseDouble(temp);
        }
        catch (NumberFormatException e) {
            WXLogUtils.e("[WXUtils] getDouble:" + WXLogUtils.getStackTrace(e));
        }
        return result;
    }

    public static boolean isTabletDevice() {
        try {
            return (WXEnvironment.getApplication().getResources().getConfiguration().screenLayout & 0xF) >= 3;
        }
        catch (Exception e) {
            WXLogUtils.e("[WXUtils] isTabletDevice:" + WXLogUtils.getStackTrace(e));
            return false;
        }
    }
}

