/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FunctionParser<T> {
    private Mapper<T> mapper;
    private Lexer lexer;

    public FunctionParser(@NonNull String source, @NonNull Mapper<T> mapper) {
        this.lexer = new Lexer(source);
        this.mapper = mapper;
    }

    public LinkedHashMap<String, T> parse() {
        this.lexer.moveOn();
        return this.definition();
    }

    private LinkedHashMap<String, T> definition() {
        LinkedHashMap<String, T> result = new LinkedHashMap<String, T>();
        do {
            result.putAll(this.function());
        } while (this.lexer.getCurrentToken() == Token.FUNC_NAME);
        return result;
    }

    private Map<String, T> function() {
        LinkedList<String> list = new LinkedList<String>();
        String functionName = this.match(Token.FUNC_NAME);
        this.match(Token.LEFT_PARENT);
        list.add(this.match(Token.PARAM_VALUE));
        while (this.lexer.getCurrentToken() == Token.COMMA) {
            this.match(Token.COMMA);
            list.add(this.match(Token.PARAM_VALUE));
        }
        this.match(Token.RIGHT_PARENT);
        return this.mapper.map(functionName, list);
    }

    private String match(Token token) {
        if (token == this.lexer.getCurrentToken()) {
            String value = this.lexer.getCurrentTokenValue();
            this.lexer.moveOn();
            return value;
        }
        throw new WXInterpretationException("Token doesn't match");
    }

    private static class Lexer {
        private String source;
        private Token current;
        private String value;
        private int pointer = 0;

        private Lexer(String source) {
            this.source = source;
        }

        private Token getCurrentToken() {
            return this.current;
        }

        private String getCurrentTokenValue() {
            return this.value;
        }

        private boolean moveOn() {
            String token;
            StringBuilder stringBuilder = new StringBuilder();
            while (this.pointer < this.source.length()) {
                char curChar = this.source.charAt(this.pointer);
                if (Character.isWhitespace(curChar)) {
                    ++this.pointer;
                    if (stringBuilder.length() == 0) continue;
                    break;
                }
                if (Character.isLetterOrDigit(curChar) || curChar == '.' || curChar == '%' || curChar == '-' || curChar == '+') {
                    stringBuilder.append(curChar);
                    ++this.pointer;
                    continue;
                }
                if (stringBuilder.length() != 0) break;
                stringBuilder.append(curChar);
                ++this.pointer;
                break;
            }
            if (!TextUtils.isEmpty((CharSequence)(token = stringBuilder.toString())) || this.pointer < this.source.length()) {
                this.moveOn(token);
                return true;
            }
            this.current = null;
            this.value = null;
            return false;
        }

        private void moveOn(String token) {
            if (TextUtils.equals((CharSequence)token, (CharSequence)"(")) {
                this.current = Token.LEFT_PARENT;
                this.value = "(";
            } else if (TextUtils.equals((CharSequence)token, (CharSequence)")")) {
                this.current = Token.RIGHT_PARENT;
                this.value = ")";
            } else if (TextUtils.equals((CharSequence)token, (CharSequence)",")) {
                this.current = Token.COMMA;
                this.value = ",";
            } else if (token.matches("(?i)[\\+-]?[0-9]+(\\.[0-9]+)?(%||deg||px)?")) {
                this.current = Token.PARAM_VALUE;
                this.value = token;
            } else if (token.matches("[a-zA-Z]+")) {
                this.current = Token.FUNC_NAME;
                this.value = token;
            } else {
                throw new WXInterpretationException("Illegal Token");
            }
        }

        private void reset() {
            this.pointer = 0;
            this.value = null;
            this.current = null;
        }
    }

    private static class WXInterpretationException
    extends RuntimeException {
        private WXInterpretationException(String msg) {
            super(msg);
        }
    }

    public static interface Mapper<T> {
        public Map<String, T> map(String var1, List<String> var2);
    }

    private static enum Token {
        FUNC_NAME,
        PARAM_VALUE,
        LEFT_PARENT,
        RIGHT_PARENT,
        COMMA;

    }
}

