/**
 *
 *                                  Apache License
 *                            Version 2.0, January 2004
 *                         http://www.apache.org/licenses/
 *
 *    TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION
 *
 *    1. Definitions.
 *
 *       "License" shall mean the terms and conditions for use, reproduction,
 *       and distribution as defined by Sections 1 through 9 of this document.
 *
 *       "Licensor" shall mean the copyright owner or entity authorized by
 *       the copyright owner that is granting the License.
 *
 *       "Legal Entity" shall mean the union of the acting entity and all
 *       other entities that control, are controlled by, or are under common
 *       control with that entity. For the purposes of this definition,
 *       "control" means (i) the power, direct or indirect, to cause the
 *       direction or management of such entity, whether by contract or
 *       otherwise, or (ii) ownership of fifty percent (50%) or more of the
 *       outstanding shares, or (iii) beneficial ownership of such entity.
 *
 *       "You" (or "Your") shall mean an individual or Legal Entity
 *       exercising permissions granted by this License.
 *
 *       "Source" form shall mean the preferred form for making modifications,
 *       including but not limited to software source code, documentation
 *       source, and configuration files.
 *
 *       "Object" form shall mean any form resulting from mechanical
 *       transformation or translation of a Source form, including but
 *       not limited to compiled object code, generated documentation,
 *       and conversions to other media types.
 *
 *       "Work" shall mean the work of authorship, whether in Source or
 *       Object form, made available under the License, as indicated by a
 *       copyright notice that is included in or attached to the work
 *       (an example is provided in the Appendix below).
 *
 *       "Derivative Works" shall mean any work, whether in Source or Object
 *       form, that is based on (or derived from) the Work and for which the
 *       editorial revisions, annotations, elaborations, or other modifications
 *       represent, as a whole, an original work of authorship. For the purposes
 *       of this License, Derivative Works shall not include works that remain
 *       separable from, or merely link (or bind by name) to the interfaces of,
 *       the Work and Derivative Works thereof.
 *
 *       "Contribution" shall mean any work of authorship, including
 *       the original version of the Work and any modifications or additions
 *       to that Work or Derivative Works thereof, that is intentionally
 *       submitted to Licensor for inclusion in the Work by the copyright owner
 *       or by an individual or Legal Entity authorized to submit on behalf of
 *       the copyright owner. For the purposes of this definition, "submitted"
 *       means any form of electronic, verbal, or written communication sent
 *       to the Licensor or its representatives, including but not limited to
 *       communication on electronic mailing lists, source code control systems,
 *       and issue tracking systems that are managed by, or on behalf of, the
 *       Licensor for the purpose of discussing and improving the Work, but
 *       excluding communication that is conspicuously marked or otherwise
 *       designated in writing by the copyright owner as "Not a Contribution."
 *
 *       "Contributor" shall mean Licensor and any individual or Legal Entity
 *       on behalf of whom a Contribution has been received by Licensor and
 *       subsequently incorporated within the Work.
 *
 *    2. Grant of Copyright License. Subject to the terms and conditions of
 *       this License, each Contributor hereby grants to You a perpetual,
 *       worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 *       copyright license to reproduce, prepare Derivative Works of,
 *       publicly display, publicly perform, sublicense, and distribute the
 *       Work and such Derivative Works in Source or Object form.
 *
 *    3. Grant of Patent License. Subject to the terms and conditions of
 *       this License, each Contributor hereby grants to You a perpetual,
 *       worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 *       (except as stated in this section) patent license to make, have made,
 *       use, offer to sell, sell, import, and otherwise transfer the Work,
 *       where such license applies only to those patent claims licensable
 *       by such Contributor that are necessarily infringed by their
 *       Contribution(s) alone or by combination of their Contribution(s)
 *       with the Work to which such Contribution(s) was submitted. If You
 *       institute patent litigation against any entity (including a
 *       cross-claim or counterclaim in a lawsuit) alleging that the Work
 *       or a Contribution incorporated within the Work constitutes direct
 *       or contributory patent infringement, then any patent licenses
 *       granted to You under this License for that Work shall terminate
 *       as of the date such litigation is filed.
 *
 *    4. Redistribution. You may reproduce and distribute copies of the
 *       Work or Derivative Works thereof in any medium, with or without
 *       modifications, and in Source or Object form, provided that You
 *       meet the following conditions:
 *
 *       (a) You must give any other recipients of the Work or
 *           Derivative Works a copy of this License; and
 *
 *       (b) You must cause any modified files to carry prominent notices
 *           stating that You changed the files; and
 *
 *       (c) You must retain, in the Source form of any Derivative Works
 *           that You distribute, all copyright, patent, trademark, and
 *           attribution notices from the Source form of the Work,
 *           excluding those notices that do not pertain to any part of
 *           the Derivative Works; and
 *
 *       (d) If the Work includes a "NOTICE" text file as part of its
 *           distribution, then any Derivative Works that You distribute must
 *           include a readable copy of the attribution notices contained
 *           within such NOTICE file, excluding those notices that do not
 *           pertain to any part of the Derivative Works, in at least one
 *           of the following places: within a NOTICE text file distributed
 *           as part of the Derivative Works; within the Source form or
 *           documentation, if provided along with the Derivative Works; or,
 *           within a display generated by the Derivative Works, if and
 *           wherever such third-party notices normally appear. The contents
 *           of the NOTICE file are for informational purposes only and
 *           do not modify the License. You may add Your own attribution
 *           notices within Derivative Works that You distribute, alongside
 *           or as an addendum to the NOTICE text from the Work, provided
 *           that such additional attribution notices cannot be construed
 *           as modifying the License.
 *
 *       You may add Your own copyright statement to Your modifications and
 *       may provide additional or different license terms and conditions
 *       for use, reproduction, or distribution of Your modifications, or
 *       for any such Derivative Works as a whole, provided Your use,
 *       reproduction, and distribution of the Work otherwise complies with
 *       the conditions stated in this License.
 *
 *    5. Submission of Contributions. Unless You explicitly state otherwise,
 *       any Contribution intentionally submitted for inclusion in the Work
 *       by You to the Licensor shall be under the terms and conditions of
 *       this License, without any additional terms or conditions.
 *       Notwithstanding the above, nothing herein shall supersede or modify
 *       the terms of any separate license agreement you may have executed
 *       with Licensor regarding such Contributions.
 *
 *    6. Trademarks. This License does not grant permission to use the trade
 *       names, trademarks, service marks, or product names of the Licensor,
 *       except as required for reasonable and customary use in describing the
 *       origin of the Work and reproducing the content of the NOTICE file.
 *
 *    7. Disclaimer of Warranty. Unless required by applicable law or
 *       agreed to in writing, Licensor provides the Work (and each
 *       Contributor provides its Contributions) on an "AS IS" BASIS,
 *       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *       implied, including, without limitation, any warranties or conditions
 *       of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A
 *       PARTICULAR PURPOSE. You are solely responsible for determining the
 *       appropriateness of using or redistributing the Work and assume any
 *       risks associated with Your exercise of permissions under this License.
 *
 *    8. Limitation of Liability. In no event and under no legal theory,
 *       whether in tort (including negligence), contract, or otherwise,
 *       unless required by applicable law (such as deliberate and grossly
 *       negligent acts) or agreed to in writing, shall any Contributor be
 *       liable to You for damages, including any direct, indirect, special,
 *       incidental, or consequential damages of any character arising as a
 *       result of this License or out of the use or inability to use the
 *       Work (including but not limited to damages for loss of goodwill,
 *       work stoppage, computer failure or malfunction, or any and all
 *       other commercial damages or losses), even if such Contributor
 *       has been advised of the possibility of such damages.
 *
 *    9. Accepting Warranty or Additional Liability. While redistributing
 *       the Work or Derivative Works thereof, You may choose to offer,
 *       and charge a fee for, acceptance of support, warranty, indemnity,
 *       or other liability obligations and/or rights consistent with this
 *       License. However, in accepting such obligations, You may act only
 *       on Your own behalf and on Your sole responsibility, not on behalf
 *       of any other Contributor, and only if You agree to indemnify,
 *       defend, and hold each Contributor harmless for any liability
 *       incurred by, or claims asserted against, such Contributor by reason
 *       of your accepting any such warranty or additional liability.
 *
 *    END OF TERMS AND CONDITIONS
 *
 *    APPENDIX: How to apply the Apache License to your work.
 *
 *       To apply the Apache License to your work, attach the following
 *       boilerplate notice, with the fields enclosed by brackets "[]"
 *       replaced with your own identifying information. (Don't include
 *       the brackets!)  The text should be enclosed in the appropriate
 *       comment syntax for the file format. We also recommend that a
 *       file or class name and description of purpose be included on the
 *       same "printed page" as the copyright notice for easier
 *       identification within third-party archives.
 *
 *    Copyright 2016 Alibaba Group
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package com.taobao.weex.ui.view.listview;

import android.content.Context;
import android.support.v4.view.GestureDetectorCompat;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.Scroller;

public abstract class BaseBounceView<T extends View> extends ViewGroup {

    private static final float FRICTION = 2.0f;
    private static final int DEFAULT_DURATION = 250;

    private int mTouchSlop;
    private boolean mIsBeingDragged;
    private float mLastMotionY;
    private float mLastMotionX;
    private Mode mMode;
    protected Scroller mScroller;
    private T mView;
    private IRefreshLayout mRefreshLayout;
    private IRefreshLayout mLoadMoreLayout;
    //scrollValue, for scroll padding use, 目前设置的值正好和正常的值相反
    private int mScrollValue = 0;
    private int mMaxPadding = 0;
    private GestureDetectorCompat mGestureDetector;
    private boolean mBounceable = true;

    enum Mode {
        PULL_FROM_TOP,
        PULL_FROM_BOTTOM
    }

    public BaseBounceView(Context context) {
        this(context, null);
    }

    public BaseBounceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    private void init(Context context) {
        ViewConfiguration config = ViewConfiguration.get(getContext());
        mTouchSlop = config.getScaledTouchSlop();
        mScroller = new Scroller(context);

        mView = createBounceView(context);
        addView(mView, LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);

        mRefreshLayout = createBounceHeaderView(context);
        if (mRefreshLayout != null) {
            addView(mRefreshLayout.getView(), LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
        }
        mLoadMoreLayout = createBounceFooterView(context);
        if (mLoadMoreLayout != null) {
            addView(mLoadMoreLayout.getView(), LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
        }
    }

    public final T getBounceView() {
        return mView;
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        final int action = ev.getAction();
        if (action != MotionEvent.ACTION_DOWN && mIsBeingDragged) {
            return true;
        }
        switch (action) {
            case MotionEvent.ACTION_DOWN: {
                mLastMotionY = ev.getRawY();
                mLastMotionX = ev.getRawX();
                //两个listview之间切换，其中某个listview.setPadding()时，会使getPaddingTop()和scrollValue的值不统一，需要进行统一
                mScrollValue = -getPaddingTop();
                break;
            }
            case MotionEvent.ACTION_MOVE: {
                float x = ev.getRawX();
                float y = ev.getRawY();
                float deltaX = ev.getRawX() - mLastMotionX;
                float deltaY = ev.getRawY() - mLastMotionY;
                float degree = Math.abs(deltaY) / Math.abs(deltaX);
                //Log.v(getClass().getSimpleName(), "onInterceptTouchEvent move");
                if (Math.abs(deltaY) > mTouchSlop && degree >= 1.7f && mBounceable) {
                    if (deltaY > 0 && isReadyForPullFromTop()) {
                        mLastMotionX = x;
                        mLastMotionY = y;
                        mIsBeingDragged = true;
                        mMode = Mode.PULL_FROM_TOP;
                    } else if (deltaY < 0 && isReadyForPullFromBottom()) {
                        mLastMotionX = x;
                        mLastMotionY = y;
                        mIsBeingDragged = true;
                        mMode = Mode.PULL_FROM_BOTTOM;
                    }

                }
                break;
            }
            case MotionEvent.ACTION_CANCEL:
            case MotionEvent.ACTION_UP: {
                mIsBeingDragged = false;
            }
        }
        return mIsBeingDragged;
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        if (mGestureDetector != null) {
            mGestureDetector.onTouchEvent(ev);
        }
        switch (ev.getAction()) {
            case MotionEvent.ACTION_DOWN: {
                if (ev.getEdgeFlags() != 0) {
                    return false;
                }
                mLastMotionX = ev.getRawX();
                mLastMotionY = ev.getRawY();
                mScrollValue = -getPaddingTop();
                return mIsBeingDragged;
            }
            case MotionEvent.ACTION_MOVE: {
                if (mIsBeingDragged) {
                    float y = ev.getRawY();
                    startPull(y);
                    return true;
                }
                break;
            }
            case MotionEvent.ACTION_CANCEL:
            case MotionEvent.ACTION_UP: {
                if (mIsBeingDragged) {
                    this.mScrollValue = -getPaddingTop();
                    mIsBeingDragged = false;
                    onTouchActionUp();
                    if (mMaxPadding > 0) {
                        /**
                         * 1.当listview当前在paddingTop＝0时，向下拉时，要回到初始位置0，deltaY为－paddingTop < 0
                         * 2.当listview在最小－PADDING时，向上拉时，要回到位置－PADDING，deltaY为(-PADDING - getPaddingTop()) > 0
                         * bug:
                         * listview item超过一屏时，当2的状态时，listview不会向上pull
                         * fix：
                         * listview设置不能向上弹
                         */
                        if (getPaddingTop() > 0/*|| getPaddingTop() < -mMaxPadding*/) {
                            mScrollValue = getPaddingTop() > 0 ? 0 : -mMaxPadding;
                            backToInitPos(getPaddingTop(), getPaddingTop() > 0 ? -getPaddingTop() : (-mMaxPadding - getPaddingTop()));
                        }
                    } else {
                        backToInitPos(getScrollY(), -getScrollY());
                    }
                    mMode = null;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    @Override
    public void computeScroll() {
        super.computeScroll();
        if (mScroller.computeScrollOffset()) {
            int x = mScroller.getCurrX();
            int y = mScroller.getCurrY();
            //Helper.logv("compute scroll y:" + y);
            if (mMaxPadding > 0) {
                this.mScrollValue = -y;//根据scroll.fling() y在－PADDING －0 之间
                setPadding(x, y, 0, 0);
            } else {
                scrollTo(x, y);
            }
            invalidate();
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        //Helper.logv("BaseBounceView onMeasure");
        View child0 = getChildAt(0);
        int w = 0;
        if (child0 != null) {
            child0.measure(widthMeasureSpec, heightMeasureSpec);
            w = child0.getMeasuredWidth();
        }
        View child1 = getChildAt(1);
        if (child1 != null) {
            LayoutParams lp = child1.getLayoutParams();
            child1.measure(
                    MeasureSpec.makeMeasureSpec(w, MeasureSpec.EXACTLY),
                    MeasureSpec.makeMeasureSpec(lp.height, lp.height > 0 ? MeasureSpec.EXACTLY : MeasureSpec.AT_MOST));
        }
        View child2 = getChildAt(2);
        if (child2 != null) {
            LayoutParams lp = child2.getLayoutParams();
            child2.measure(
                    MeasureSpec.makeMeasureSpec(w, MeasureSpec.EXACTLY),
                    MeasureSpec.makeMeasureSpec(lp.height, lp.height > 0 ? MeasureSpec.EXACTLY : MeasureSpec.AT_MOST)
            );
        }
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        View child0 = getChildAt(0);
        int paddingLeft,paddingTop,childRight;
        paddingLeft=getPaddingLeft();
        paddingTop=getPaddingTop();
        childRight=r-l-getPaddingRight();
        if (child0 != null) {
            child0.layout(paddingLeft, paddingTop, childRight, b-t-paddingTop);
        }
        View child1 = getChildAt(1);
        if (child1 != null) {
            int h = child1.getMeasuredHeight();
            child1.layout(paddingLeft, -h, childRight, 0);
        }
        View child2 = getChildAt(2);
        if (child2 != null) {
            int h = child2.getMeasuredHeight();
            child2.layout(paddingLeft, b, childRight, b + h);
        }
    }

    protected void smoothScroll(int value) {
        mScroller.startScroll(0, getScrollY(), 0, value);
        invalidate();
    }

    public void setBounceable(boolean bounceable) {
        mBounceable = bounceable;
    }

    public void setEffectMaxHeight(int padding) {
        this.mMaxPadding = padding;
        if (mGestureDetector == null) {
            mGestureDetector = new GestureDetectorCompat(getContext(), mGestureListener);
        }
    }

    private void startPull(float y) {
        int scrollValue = 0;
        final float lastY;
        lastY = mLastMotionY;
        switch (mMode) {
            case PULL_FROM_TOP: {
                scrollValue = Math.round(Math.min(lastY - y, 0) / FRICTION);
                break;
            }
            case PULL_FROM_BOTTOM: {
                scrollValue = Math.round(Math.max(lastY - y, 0) / FRICTION);
                break;
            }
        }
        //Helper.logv("start pull scrollvalue:" + scrollValue + ", y:" + y + ", allScroll:" + (this.mScrollValue + scrollValue));
        pullScrollTo(this.mScrollValue + scrollValue);
    }

    private void pullScrollTo(int scrollValue) {
        int maxScroll = getMaximumPullScroll();
        scrollValue = Math.min(maxScroll, Math.max(-maxScroll, scrollValue));
        //scrollTo(0, scrollValue);
        if (mMaxPadding > 0) {
            setPadding(0, -scrollValue <= -mMaxPadding ? -mMaxPadding : -scrollValue, 0, 0);
        } else {
            scrollTo(0, scrollValue);
        }

        onPull(scrollValue);
    }

    private void onPull(int scrollValue) {
        IRefreshLayout pullLayout = null;
        switch (mMode) {
            case PULL_FROM_TOP:
                pullLayout = mRefreshLayout;
                break;
            case PULL_FROM_BOTTOM:
                pullLayout = mLoadMoreLayout;
                break;
        }
        if ((mMode == Mode.PULL_FROM_TOP || mMode == Mode.PULL_FROM_BOTTOM) && pullLayout != null) {
            final int itemDimension = pullLayout.getView().getHeight();
            float scaleOfLayout = Math.abs(scrollValue) / (float) itemDimension;
            float angle = scaleOfLayout * 90f;
            pullLayout.onPull(angle);

            onPullStateChanged(itemDimension, scrollValue);
        }
    }

    private void backToInitPos(int startY, int deltaY) {
        int duration = DEFAULT_DURATION;
        if (mRefreshLayout != null) {
            int scrollLen = Math.abs(getScrollY());
            int limit = mRefreshLayout.getView().getHeight();
            if (scrollLen < limit) {
                duration = DEFAULT_DURATION;
            } else {
                duration = (scrollLen - limit)* DEFAULT_DURATION / (getMaximumPullScroll() - limit);
            }
        }
        mScroller.startScroll(0, startY, 0, deltaY/*-getPaddingTop()*/, duration);
        invalidate();
    }

    private int getMaximumPullScroll() {
        return Math.round(getResources().getDisplayMetrics().heightPixels / (FRICTION));
    }

    protected IRefreshLayout getBounceHeaderView() {
        return mRefreshLayout;
    }

    protected IRefreshLayout getBounceFooterView() {
        return mLoadMoreLayout;
    }

    public void setBounceHeaderView(IRefreshLayout layout) {
        mRefreshLayout = layout;
        if (mRefreshLayout != null && getChildCount() > 1) {
            removeViewAt(1);
            addView(mRefreshLayout.getView(), 1);
        }
    }

    public void setBounceFooterView(IRefreshLayout layout) {
        mLoadMoreLayout = layout;
        if (mLoadMoreLayout != null && getChildCount() > 2) {
            removeViewAt(2);
            addView(mLoadMoreLayout.getView(), 2);
        }
    }

    public abstract boolean isReadyForPullFromTop();
    public abstract boolean isReadyForPullFromBottom();
    public abstract T createBounceView(Context context);
    public abstract IRefreshLayout createBounceHeaderView(Context context);

    public IRefreshLayout createBounceFooterView(Context context) {
        return null;
    }

    protected void onPullStateChanged(int itemDimension, int scrollValue) {}

    protected void onTouchActionUp() {}

    private final GestureDetector.SimpleOnGestureListener mGestureListener = new GestureDetector.SimpleOnGestureListener() {
        @Override
        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            mScroller.fling(getPaddingLeft(), getPaddingTop(), 0, (int)velocityY, 0, 0, -mMaxPadding, 0);
            invalidate();
            return true;
        }
    };

}
