/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.dom.CSSTransformFromStyle;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXDomObjectFactory;
import com.taobao.weex.dom.WXEvent;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.dom.flex.CSSLayoutContext;
import com.taobao.weex.dom.flex.Spacing;
import com.taobao.weex.ui.IWXRenderTask;
import com.taobao.weex.ui.WXRenderManager;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class WXDomStatement {
    private final ConcurrentHashMap<String, WXDomObject> mRegistry;
    private String mInstanceId;
    private WXRenderManager mWXRenderManager;
    private ArrayList<IWXRenderTask> mNormalTasks;
    private Set<String> mUpdate;
    private CSSLayoutContext mLayoutContext;
    private volatile boolean mDirty;
    private boolean mDestroy = false;
    private Map<String, AddDomInfo> mAddDom = new HashMap<String, AddDomInfo>();

    public WXDomStatement(String instanceId, WXRenderManager renderManager) {
        this.mInstanceId = instanceId;
        this.mLayoutContext = new CSSLayoutContext();
        this.mRegistry = new ConcurrentHashMap();
        this.mNormalTasks = new ArrayList();
        this.mUpdate = new HashSet<String>();
        this.mWXRenderManager = renderManager;
    }

    private static void putAll(Map<String, Object> container, JSONObject rawValue) {
        for (Map.Entry entry : rawValue.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            container.put(key, value);
        }
    }

    public void destroy() {
        this.mDestroy = true;
        this.mRegistry.clear();
    }

    void rebuildingDomTree(WXDomObject root) {
        if (root != null && root.getFixedStyleRefs() != null) {
            int size = root.getFixedStyleRefs().size();
            for (int i = 0; i < size; ++i) {
                String fixedRef = root.getFixedStyleRefs().get(i);
                WXDomObject wxDomObject = this.mRegistry.get(fixedRef);
                if (wxDomObject == null || wxDomObject.parent == null) continue;
                wxDomObject.parent.remove(wxDomObject);
                root.add(wxDomObject, -1);
            }
        }
    }

    void batch() {
        if (!this.mDirty || this.mDestroy) {
            return;
        }
        WXDomObject rootDom = this.mRegistry.get("_root");
        if (rootDom == null) {
            return;
        }
        this.rebuildingDomTree(rootDom);
        this.layoutBefore(rootDom);
        rootDom.calculateLayout(this.mLayoutContext);
        this.applyUpdate(rootDom);
        this.updateDomObj();
        int count = this.mNormalTasks.size();
        for (int i = 0; i < count && !this.mDestroy; ++i) {
            this.mWXRenderManager.runOnThread(this.mInstanceId, this.mNormalTasks.get(i));
        }
        this.mNormalTasks.clear();
        this.mAddDom.clear();
        this.mUpdate.clear();
        this.mDirty = false;
    }

    private void layoutBefore(WXDomObject dom) {
        if (dom == null || !dom.hasUpdate() || this.mDestroy) {
            return;
        }
        dom.layoutBefore();
        int count = dom.childCount();
        for (int i = 0; i < count; ++i) {
            this.layoutBefore(dom.getChild(i));
        }
    }

    private void applyUpdate(WXDomObject dom) {
        if (dom == null) {
            return;
        }
        if (dom.hasUpdate()) {
            dom.markUpdateSeen();
            this.mUpdate.add(dom.ref);
            if (!dom.isYoung()) {
                final WXDomObject copy = dom.clone();
                if (copy == null) {
                    return;
                }
                this.mNormalTasks.add(new IWXRenderTask(){

                    @Override
                    public void execute() {
                        WXDomStatement.this.mWXRenderManager.setLayout(WXDomStatement.this.mInstanceId, copy.ref, copy);
                    }
                });
                if (dom.getExtra() != null) {
                    this.mNormalTasks.add(new IWXRenderTask(){

                        @Override
                        public void execute() {
                            WXDomStatement.this.mWXRenderManager.setExtra(WXDomStatement.this.mInstanceId, copy.ref, copy.getExtra());
                        }
                    });
                }
            }
        }
        int count = dom.childCount();
        for (int i = 0; i < count; ++i) {
            this.applyUpdate(dom.getChild(i));
        }
    }

    void createBody(JSONObject element) {
        if (this.mDestroy) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        if (element == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_CREATEBODY);
            }
            return;
        }
        WXDomObject domObject = this.parseInner(element);
        HashMap<String, Object> style = new HashMap<String, Object>(5);
        if (domObject.style == null || !domObject.style.containsKey("flexDirection")) {
            style.put("flexDirection", "column");
        }
        if (domObject.style == null || !domObject.style.containsKey("backgroundColor")) {
            style.put("backgroundColor", "#ffffff");
        }
        if (domObject.style == null || !domObject.style.containsKey("width")) {
            style.put("width", Float.valueOf(WXViewUtils.getWebPxByWidth(WXViewUtils.getWeexWidth(this.mInstanceId))));
        }
        if (domObject.style == null || !domObject.style.containsKey("height")) {
            style.put("height", Float.valueOf(WXViewUtils.getWebPxByWidth(WXViewUtils.getWeexHeight(this.mInstanceId))));
        }
        domObject.ref = "_root";
        domObject.updateStyle(style);
        this.transformStyle(domObject, true);
        final WXComponent component = this.mWXRenderManager.createBodyOnDomThread(this.mInstanceId, domObject);
        AddDomInfo addDomInfo = new AddDomInfo();
        addDomInfo.component = component;
        this.mAddDom.put(domObject.ref, addDomInfo);
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.createBody(WXDomStatement.this.mInstanceId, component);
            }
        });
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    private void updateDomObj() {
        long start = System.currentTimeMillis();
        for (Map.Entry<String, AddDomInfo> entry : this.mAddDom.entrySet()) {
            AddDomInfo value = entry.getValue();
            this.updateDomObj(value.component);
        }
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("updateDomObj", "time:" + (System.currentTimeMillis() - start));
        }
    }

    private void updateDomObj(WXComponent component) {
        if (component == null) {
            return;
        }
        WXDomObject domObject = this.mRegistry.get(component.getRef());
        if (domObject == null) {
            return;
        }
        domObject.old();
        component.updateDom(domObject.clone());
        if (component instanceof WXVContainer) {
            WXVContainer container = (WXVContainer)component;
            int count = container.childCount();
            for (int i = 0; i < count; ++i) {
                this.updateDomObj(container.getChild(i));
            }
        }
    }

    void addDom(JSONObject dom, final String parentRef, final int index) {
        if (this.mDestroy) {
            return;
        }
        WXDomObject parent = this.mRegistry.get(parentRef);
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        if (parent == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_ADDELEMENT);
            }
            return;
        }
        WXDomObject domObject = this.parseInner(dom);
        if (domObject == null || this.mRegistry.containsKey(domObject.ref)) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.e("[WXDomStatement] addDom error!!");
            }
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_ADDELEMENT);
            }
            return;
        }
        this.transformStyle(domObject, true);
        if (domObject.isFixed()) {
            WXDomObject rootDom = this.mRegistry.get("_root");
            if (rootDom == null) {
                return;
            }
            rootDom.add2FixedDomList(domObject.ref);
        }
        parent.add(domObject, index);
        final WXComponent component = this.mWXRenderManager.createComponentOnDomThread(this.mInstanceId, domObject, parentRef, index);
        AddDomInfo addDomInfo = new AddDomInfo();
        addDomInfo.component = component;
        this.mAddDom.put(domObject.ref, addDomInfo);
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.addComponent(WXDomStatement.this.mInstanceId, component, parentRef, index);
            }
        });
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void moveDom(final String ref, final String parentRef, final int index) {
        if (this.mDestroy) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        WXDomObject domObject = this.mRegistry.get(ref);
        WXDomObject parentObject = this.mRegistry.get(parentRef);
        if (domObject == null || domObject.parent == null || parentObject == null || parentObject.hasNewLayout()) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_MOVEELEMENT);
            }
            return;
        }
        domObject.parent.remove(domObject);
        parentObject.add(domObject, index);
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.moveComponent(WXDomStatement.this.mInstanceId, ref, parentRef, index);
            }
        });
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void removeDom(final String ref) {
        if (this.mDestroy) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        WXDomObject domObject = this.mRegistry.get(ref);
        if (domObject == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_REMOVEELEMENT);
            }
            return;
        }
        WXDomObject parent = domObject.parent;
        if (parent == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_REMOVEELEMENT);
            }
            return;
        }
        parent.remove(domObject);
        this.clearRegistryForDom(domObject);
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.removeComponent(WXDomStatement.this.mInstanceId, ref);
            }
        });
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    private void clearRegistryForDom(WXDomObject domObject) {
        int count = domObject.childCount();
        this.mRegistry.remove(domObject.ref);
        for (int i = count - 1; i >= 0; --i) {
            this.clearRegistryForDom(domObject.getChild(i));
        }
    }

    void updateAttrs(String ref, final JSONObject attrs) {
        if (this.mDestroy) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        final WXDomObject domObject = this.mRegistry.get(ref);
        if (domObject == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_UPDATEATTRS);
            }
            return;
        }
        domObject.updateAttr((Map<String, Object>)attrs);
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.updateAttrs(WXDomStatement.this.mInstanceId, domObject.ref, (Map<String, Object>)attrs);
            }
        });
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void updateStyle(String ref, JSONObject style) {
        if (this.mDestroy) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        WXDomObject domObject = this.mRegistry.get(ref);
        if (domObject == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_UPDATESTYLE);
            }
            return;
        }
        domObject.updateStyle((Map<String, Object>)style);
        this.transformStyle(domObject, false);
        this.updateStyle(domObject, (Map<String, Object>)style);
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    private void updateStyle(final WXDomObject domObject, final Map<String, Object> update) {
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.updateStyle(WXDomStatement.this.mInstanceId, domObject.ref, update);
            }
        });
        if (update.containsKey("padding") || update.containsKey("paddingTop") || update.containsKey("paddingLeft") || update.containsKey("paddingRight") || update.containsKey("paddingBottom") || update.containsKey("borderWidth")) {
            this.mNormalTasks.add(new IWXRenderTask(){

                @Override
                public void execute() {
                    Spacing padding = domObject.getPadding();
                    Spacing border = domObject.getBorder();
                    WXDomStatement.this.mWXRenderManager.setPadding(WXDomStatement.this.mInstanceId, domObject.ref, padding, border);
                }
            });
        }
    }

    void addEvent(final String ref, final String type) {
        if (this.mDestroy) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        WXDomObject domObject = this.mRegistry.get(ref);
        if (domObject == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_ADDEVENT);
            }
            return;
        }
        domObject.addEvent(type);
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.addEvent(WXDomStatement.this.mInstanceId, ref, type);
            }
        });
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void removeEvent(final String ref, final String type) {
        if (this.mDestroy) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        WXDomObject domObject = this.mRegistry.get(ref);
        if (domObject == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_REMOVEEVENT);
            }
            return;
        }
        domObject.removeEvent(type);
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.removeEvent(WXDomStatement.this.mInstanceId, ref, type);
            }
        });
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void scrollToDom(final String ref, final JSONObject options) {
        if (this.mDestroy) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.scrollToComponent(WXDomStatement.this.mInstanceId, ref, (Map<String, Object>)options);
            }
        });
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void createFinish() {
        if (this.mDestroy) {
            return;
        }
        final WXDomObject root = this.mRegistry.get("_root");
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.createFinish(WXDomStatement.this.mInstanceId, (int)root.getLayoutWidth(), (int)root.getLayoutHeight());
            }
        });
        this.mDirty = true;
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void refreshFinish() {
        if (this.mDestroy) {
            return;
        }
        final WXDomObject root = this.mRegistry.get("_root");
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                int realWidth = (int)root.getLayoutWidth();
                int realHeight = (int)root.getLayoutHeight();
                WXDomStatement.this.mWXRenderManager.refreshFinish(WXDomStatement.this.mInstanceId, realWidth, realHeight);
            }
        });
        this.mDirty = true;
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    private WXDomObject parseInner(JSONObject map) {
        Object children;
        Object event;
        Object attr;
        if (map == null || map.size() <= 0) {
            return null;
        }
        String type = (String)map.get((Object)"type");
        WXDomObject domObject = WXDomObjectFactory.newInstance(type);
        domObject.type = type;
        domObject.ref = (String)map.get((Object)"ref");
        Object style = map.get((Object)"style");
        if (style != null && style instanceof JSONObject) {
            domObject.style = new WXStyle();
            WXDomStatement.putAll(domObject.style, (JSONObject)style);
        }
        if ((attr = map.get((Object)"attr")) != null && attr instanceof JSONObject) {
            domObject.attr = new WXAttr();
            WXDomStatement.putAll(domObject.attr, (JSONObject)attr);
        }
        if ((event = map.get((Object)"event")) != null && event instanceof JSONArray) {
            domObject.event = new WXEvent();
            JSONArray eventArray = (JSONArray)event;
            int count = eventArray.size();
            for (int i = 0; i < count; ++i) {
                domObject.event.add(eventArray.getString(i));
            }
        }
        if ((children = map.get((Object)"children")) != null && children instanceof JSONArray) {
            domObject.children = new ArrayList<WXDomObject>();
            JSONArray childrenArray = (JSONArray)children;
            int count = childrenArray.size();
            for (int i = 0; i < count; ++i) {
                domObject.children.add(this.parseInner(childrenArray.getJSONObject(i)));
            }
        }
        return domObject;
    }

    private void transformStyle(WXDomObject dom, boolean isAdd) {
        if (dom == null) {
            return;
        }
        if (isAdd) {
            dom.young();
            this.mRegistry.put(dom.ref, dom);
        }
        if (dom.style != null && dom.style.size() > 0) {
            CSSTransformFromStyle.transformStyle(dom);
        }
        int count = dom.childCount();
        for (int i = 0; i < count; ++i) {
            WXDomObject child = dom.getChild(i);
            if (isAdd) {
                dom.add2Dom(child, i);
            }
            this.transformStyle(child, isAdd);
        }
    }

    static class AddDomInfo {
        public WXComponent component;

        AddDomInfo() {
        }
    }
}

