/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.text.Spannable;
import android.text.TextUtils;
import android.view.View;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXException;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.ui.component.IWXRecyclerViewChild;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXTextView;

public class WXText
extends WXComponent
implements IWXRecyclerViewChild {
    public static final int sDEFAULT_SIZE = 32;
    private Object mPreExtra;

    public WXText(WXSDKInstance instance, WXDomObject node, WXVContainer parent, String instanceId, boolean lazy) {
        super(instance, node, parent, instanceId, lazy);
    }

    @Override
    protected void initView() {
        this.mHost = new WXTextView(this.mContext);
        this.getView().setEllipsize(TextUtils.TruncateAt.END);
        this.getView().setIncludeFontPadding(false);
    }

    public WXTextView getView() {
        return (WXTextView)super.getView();
    }

    @Override
    public void updateExtra(Object extra) {
        super.updateExtra(extra);
        if (this.mHost == null || extra == this.mPreExtra) {
            return;
        }
        Spannable spannable = (Spannable)extra;
        if (spannable == null) {
            return;
        }
        int fontSize = WXStyle.getFontSize(this.mDomObj.style);
        this.getView().setTextSize(0, fontSize);
        this.mPreExtra = spannable;
        this.getView().setText((CharSequence)spannable);
    }

    @Override
    public View detachViewAndClearPreInfo() throws WXException {
        this.mPreExtra = null;
        return super.detachViewAndClearPreInfo();
    }

    @WXComponentProp(name="textAlign")
    public void setTextAlign(String textAlign) {
        int iTextAlign = this.getTextAlign(textAlign);
        if (iTextAlign > 0) {
            this.getView().setGravity(iTextAlign | 0x10);
        }
    }

    private int getTextAlign(String textAlign) {
        int align = 3;
        if (TextUtils.isEmpty((CharSequence)textAlign)) {
            return align;
        }
        if (textAlign.equals("left")) {
            align = 3;
        } else if (textAlign.equals("center")) {
            align = 17;
        } else if (textAlign.equals("right")) {
            align = 5;
        }
        return align;
    }

    @WXComponentProp(name="lines")
    public void setLines(int lines) {
        WXTextView temp = this.getView();
        if (lines > 1) {
            temp.setSingleLine(false);
            temp.setMaxLines(lines);
        } else if (lines == 1) {
            temp.setSingleLine(true);
        }
    }
}

