/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.adapter.IWXImgLoaderAdapter;
import com.taobao.weex.common.WXImageSharpen;
import com.taobao.weex.common.WXImageStrategy;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.WXRecycleImageManager;
import com.taobao.weex.ui.component.IWXRecyclerViewChild;
import com.taobao.weex.ui.component.IWXUpdateComponent;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXImageView;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXViewUtils;

public class WXImage
extends WXComponent
implements IWXRecyclerViewChild {
    public WXImage(WXSDKInstance instance, WXDomObject node, WXVContainer parent, String instanceId, boolean lazy) {
        super(instance, node, parent, instanceId, lazy);
    }

    @Override
    protected void initView() {
        this.mHost = new WXImageView(this.mContext, this.mDomObj);
        ((ImageView)this.getView()).setScaleType(ImageView.ScaleType.FIT_XY);
    }

    @Override
    public View getView() {
        return super.getView();
    }

    @Override
    public void flushView() {
        super.flushView();
        if (this.getView() != null) {
            if (this.getView() instanceof IWXUpdateComponent) {
                ((IWXUpdateComponent)this.getView()).updateDom(this.mDomObj);
            }
            if (this.mDomObj.attr != null && (this.getAbsoluteY() <= WXViewUtils.getScreenHeight() + WXRecycleImageManager.VISIBLE_BOTTOM_SPACE || WXViewUtils.onScreenArea(this.getView()))) {
                this.setImage(this.mDomObj.attr.getImageSrc(), (ImageView)this.getView());
            }
        }
    }

    @Override
    @WXComponentProp(name="backgroundColor")
    public void setBackgroundColor(String color) {
        int colorInt;
        if (!TextUtils.isEmpty((CharSequence)color) && (colorInt = WXResourceUtils.getColor(color)) != Integer.MIN_VALUE) {
            this.mHost.setBackgroundColor(colorInt);
        }
    }

    @Override
    @WXComponentProp(name="borderRadius")
    public void setBorderRadius(float borderRadius) {
    }

    @Override
    @WXComponentProp(name="borderWidth")
    public void setBorderWidth(float borderWidth) {
    }

    @Override
    @WXComponentProp(name="borderStyle")
    public void setBorderStyle(String borderStyle) {
    }

    @Override
    @WXComponentProp(name="borderColor")
    public void setBorderColor(String borderColor) {
    }

    private void setImage(String src, ImageView imageView) {
        WXImageStrategy imageStrategy = new WXImageStrategy();
        imageStrategy.isClipping = true;
        WXImageSharpen imageSharpen = this.mDomObj.attr.getImageSharpen();
        imageStrategy.isSharpen = imageSharpen == WXImageSharpen.SHARPEN;
        IWXImgLoaderAdapter imgLoaderAdapter = this.mInstance.getImgLoaderAdapter();
        if (imgLoaderAdapter != null) {
            imgLoaderAdapter.setImage(src, imageView, this.mDomObj.attr.getImageQuality(), imageStrategy);
        }
    }

    @WXComponentProp(name="resizeMode")
    public void setResizeMode(String resizeMode) {
        ((ImageView)this.getView()).setScaleType(this.getResizeMode(resizeMode));
    }

    private ImageView.ScaleType getResizeMode(String resizeMode) {
        ImageView.ScaleType scaleType = ImageView.ScaleType.FIT_XY;
        if (TextUtils.isEmpty((CharSequence)resizeMode)) {
            return scaleType;
        }
        if (resizeMode.equals("cover")) {
            scaleType = ImageView.ScaleType.CENTER_CROP;
        } else if (resizeMode.equals("contain")) {
            scaleType = ImageView.ScaleType.CENTER_INSIDE;
        } else if (resizeMode.equals("stretch")) {
            scaleType = ImageView.ScaleType.FIT_XY;
        }
        return scaleType;
    }

    @WXComponentProp(name="resize")
    public void setResize(String resize) {
        ((ImageView)this.getView()).setScaleType(this.getResizeMode(resize));
    }

    @WXComponentProp(name="src")
    public void setSrc(String src) {
        WXRecycleImageManager recycleImageManager;
        if (this.mInstance.getImgLoaderAdapter() == null) {
            return;
        }
        if (this.mDomObj.attr != null) {
            this.mDomObj.attr.put("src", src);
        }
        if ((recycleImageManager = this.mInstance.getRecycleImageManager()) != null && this.mDomObj.style != null && !this.mDomObj.style.isSticky()) {
            recycleImageManager.addImage(this);
        }
    }
}

