/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui;

import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.flex.Spacing;
import com.taobao.weex.ui.IWXRenderTask;
import com.taobao.weex.ui.WXRenderHandler;
import com.taobao.weex.ui.WXRenderStatement;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.utils.WXUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WXRenderManager {
    private ConcurrentHashMap<String, WXRenderStatement> mRegistries = new ConcurrentHashMap();
    private WXRenderHandler mWXRenderHandler = new WXRenderHandler();

    public WXRenderStatement getWXRenderStatement(String instanceId) {
        return this.mRegistries.get(instanceId);
    }

    public WXSDKInstance getWXSDKInstance(String instanceId) {
        WXRenderStatement statement = this.mRegistries.get(instanceId);
        if (statement == null) {
            return null;
        }
        return statement.getWXSDKInstance();
    }

    public void postOnUiThread(Runnable runnable, long delayMillis) {
        this.mWXRenderHandler.postDelayed(runnable, delayMillis);
    }

    public void removeRenderStatement(String instanceId) {
        if (!WXUtils.isUiThread()) {
            throw new WXRuntimeException("[WXRenderManager] removeRenderStatement can only be called in main thread");
        }
        WXRenderStatement statement = this.mRegistries.remove(instanceId);
        if (statement != null) {
            statement.destroy();
        }
    }

    public void runOnThread(final String instanceId, final IWXRenderTask task) {
        this.mWXRenderHandler.post(new Runnable(){

            @Override
            public void run() {
                if (WXRenderManager.this.mRegistries.get(instanceId) == null) {
                    return;
                }
                task.execute();
            }
        });
    }

    public void flushView(final String instanceId, final String ref) {
        this.mWXRenderHandler.post(new Runnable(){

            @Override
            public void run() {
                WXRenderStatement statement = (WXRenderStatement)WXRenderManager.this.mRegistries.get(instanceId);
                if (statement == null) {
                    return;
                }
                statement.flushView(ref);
            }
        });
    }

    public void createInstance(WXSDKInstance instance, String instanceId) {
        this.mRegistries.put(instanceId, new WXRenderStatement(instance, instanceId));
    }

    public void createBody(String instanceId, WXComponent component) {
        WXRenderStatement statement = this.mRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.createBody(component);
    }

    public WXComponent createBodyOnDomThread(String instanceId, WXDomObject domObject) {
        WXRenderStatement statement = this.mRegistries.get(instanceId);
        if (statement == null) {
            return null;
        }
        return statement.createBodyOnDomThread(domObject);
    }

    public void setLayout(String instanceId, String ref, WXDomObject domObject) {
        WXRenderStatement statement = this.mRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.setLayout(ref, domObject);
    }

    public void setExtra(String instanceId, String ref, Object extra) {
        WXRenderStatement statement = this.mRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.setExtra(ref, extra);
    }

    public void setPadding(String instanceId, String ref, Spacing padding, Spacing border) {
        WXRenderStatement statement = this.mRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.setPadding(ref, padding, border);
    }

    public void addComponent(String instanceId, WXDomObject dom, String parentRef, int index) {
        WXRenderStatement statement = this.mRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.addComponent(dom, parentRef, index);
    }

    public WXComponent createComponentOnDomThread(String instanceId, WXDomObject dom, String parentRef, int index) {
        WXRenderStatement statement = this.mRegistries.get(instanceId);
        if (statement == null) {
            return null;
        }
        return statement.createComponentOnDomThread(dom, parentRef, index);
    }

    public void addComponent(String instanceId, WXComponent component, String parentRef, int index) {
        WXRenderStatement statement = this.mRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.addComponent(component, parentRef, index);
    }

    public void removeComponent(String instanceId, String ref) {
        WXRenderStatement statement = this.mRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.removeComponent(ref);
    }

    public void moveComponent(String instanceId, String ref, String parentRef, int index) {
        WXRenderStatement statement = this.mRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.move(ref, parentRef, index);
    }

    public void updateAttrs(String instanceId, String ref, Map<String, Object> attrs) {
        WXRenderStatement statement = this.mRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.updateAttrs(ref, attrs);
    }

    public void updateStyle(String instanceId, String ref, Map<String, Object> style) {
        WXRenderStatement statement = this.mRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.updateStyle(ref, style);
    }

    public void addEvent(String instanceId, String ref, String type) {
        WXRenderStatement statement = this.mRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.addEvent(ref, type);
    }

    public void removeEvent(String instanceId, String ref, String type) {
        WXRenderStatement statement = this.mRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.removeEvent(ref, type);
    }

    public void scrollToComponent(String instanceId, String ref, Map<String, Object> options) {
        WXRenderStatement statement = this.mRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.scrollTo(ref, options);
    }

    public void createFinish(String instanceId, int width, int height) {
        WXRenderStatement statement = this.mRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.createFinish(width, height);
    }

    public void refreshFinish(String instanceId, int width, int height) {
        WXRenderStatement statement = this.mRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.refreshFinish(width, height);
    }

    public void startAnimation(String instanceId, String ref, String animation, String callBack) {
        WXRenderStatement statement = this.mRegistries.get(instanceId);
        if (statement == null) {
            return;
        }
        statement.startAnimation(ref, animation, callBack);
    }
}

