/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.text.TextUtils;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXSlider;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXCircleIndicator;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXViewUtils;

public class WXIndicator
extends WXComponent {
    public WXIndicator(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        super(instance, dom, parent, instanceId, isLazy);
    }

    @Override
    protected void initView() {
        this.mHost = new WXCircleIndicator(this.mContext);
        if (this.mParent instanceof WXSlider) {
            ((WXSlider)this.mParent).addIndicator(this);
        } else if (WXEnvironment.isApkDebugable()) {
            throw new WXRuntimeException("WXIndicator initView error.");
        }
    }

    @Override
    public WXCircleIndicator getView() {
        return (WXCircleIndicator)super.getView();
    }

    @WXComponentProp(name="itemColor")
    public void setItemColor(String itemColor) {
        int colorInt;
        if (!TextUtils.isEmpty((CharSequence)itemColor) && (colorInt = WXResourceUtils.getColor(itemColor)) != Integer.MIN_VALUE) {
            this.getView().setPageColor(colorInt);
            this.getView().forceLayout();
            this.getView().requestLayout();
        }
    }

    @WXComponentProp(name="itemSelectedColor")
    public void setItemSelectedColor(String itemSelectedColor) {
        int colorInt;
        if (!TextUtils.isEmpty((CharSequence)itemSelectedColor) && (colorInt = WXResourceUtils.getColor(itemSelectedColor)) != Integer.MIN_VALUE) {
            this.getView().setFillColor(colorInt);
            this.getView().forceLayout();
            this.getView().requestLayout();
        }
    }

    @WXComponentProp(name="itemSize")
    public void setItemSize(int itemSize) {
        if (itemSize < 0) {
            return;
        }
        this.getView().setRadius(WXViewUtils.getRealPxByWidth(itemSize) / 2.0f);
        this.getView().forceLayout();
        this.getView().requestLayout();
    }

    public void setShowIndicators(boolean show) {
        if (this.mHost == null) {
            return;
        }
        if (show) {
            this.mHost.setVisibility(0);
        } else {
            this.mHost.setVisibility(8);
        }
    }
}

