/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.flat.widget.Widget;
import com.taobao.weex.ui.flat.widget.WidgetGroup;
import com.taobao.weex.ui.view.border.BorderDrawable;
import com.taobao.weex.utils.WXExceptionUtils;
import com.taobao.weex.utils.WXLogUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.atomic.AtomicInteger;

public class WXViewUtils {
    @Deprecated
    public static final int TRANSLUCENT = -3;
    @Deprecated
    public static final int TRANSPARENT = -2;
    @Deprecated
    public static final int OPAQUE = -1;
    public static final int DIMENSION_UNSET = -1;
    private static final boolean mUseWebPx = false;
    private static final AtomicInteger sNextGeneratedId = new AtomicInteger(1);
    private static int mScreenWidth;
    private static int mScreenHeight;

    @SuppressLint(value={"NewApi"})
    public static int generateViewId() {
        if (Build.VERSION.SDK_INT < 17) {
            int newValue;
            int result;
            do {
                if ((newValue = (result = sNextGeneratedId.get()) + 1) <= 0xFFFFFF) continue;
                newValue = 1;
            } while (!sNextGeneratedId.compareAndSet(result, newValue));
            return result;
        }
        return View.generateViewId();
    }

    public static int getWeexHeight(String instanceId) {
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (instance != null) {
            int weexHeight = instance.getWeexHeight();
            if (weexHeight >= 0 || weexHeight == -2) {
                return weexHeight;
            }
            return WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication);
        }
        return -3;
    }

    public static int getWeexWidth(String instanceId) {
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (instance != null) {
            int weexWidth = instance.getWeexWidth();
            if (weexWidth >= 0 || weexWidth == -2) {
                return weexWidth;
            }
            return WXViewUtils.getScreenWidth((Context)WXEnvironment.sApplication);
        }
        return -3;
    }

    @Deprecated
    public static int getScreenWidth() {
        return WXViewUtils.getScreenWidth((Context)WXEnvironment.sApplication);
    }

    @Deprecated
    public static int setScreenWidth(int screenWidth) {
        mScreenWidth = screenWidth;
        return mScreenWidth;
    }

    public static float getScreenDensity(Context ctx) {
        if (ctx != null) {
            try {
                Resources res = ctx.getResources();
                return res.getDisplayMetrics().density;
            }
            catch (Exception e) {
                WXLogUtils.e("getScreenDensityDpi exception:" + e.getMessage());
            }
        }
        return 3.0f;
    }

    public static void updateApplicationScreen(Context context) {
        if (context == null || WXEnvironment.sApplication == null) {
            return;
        }
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        DisplayMetrics displayMetrics = WXEnvironment.sApplication.getResources().getDisplayMetrics();
        displayMetrics.heightPixels = metrics.heightPixels;
        displayMetrics.widthPixels = metrics.widthPixels;
        displayMetrics.density = metrics.density;
        displayMetrics.densityDpi = metrics.densityDpi;
        displayMetrics.scaledDensity = metrics.scaledDensity;
        displayMetrics.xdpi = metrics.xdpi;
    }

    public static int getScreenWidth(Context ctx) {
        if (ctx != null) {
            Resources res = ctx.getResources();
            mScreenWidth = res.getDisplayMetrics().widthPixels;
            if (WXEnvironment.SETTING_FORCE_VERTICAL_SCREEN) {
                mScreenHeight = res.getDisplayMetrics().heightPixels;
                mScreenWidth = mScreenHeight > mScreenWidth ? mScreenWidth : mScreenHeight;
            }
        } else if (WXEnvironment.isApkDebugable()) {
            throw new WXRuntimeException("Error Context is null When getScreenHeight");
        }
        return mScreenWidth;
    }

    public static int getStatusBarHeight(Context context) {
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            int statusBarHeight = resources.getDimensionPixelSize(resourceId);
            return statusBarHeight;
        }
        return -1;
    }

    @Deprecated
    public static int getScreenHeight() {
        return WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication);
    }

    public static int getScreenHeight(String instanceId) {
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        return instance.isFullScreenHeightEnabled() ? WXViewUtils.getFullScreenHeight((Context)WXEnvironment.sApplication) : WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication);
    }

    public static int getFullScreenHeight(Context cxt) {
        if (cxt != null) {
            WindowManager wm;
            Resources res = cxt.getResources();
            if (Build.VERSION.SDK_INT >= 17 && (wm = (WindowManager)cxt.getSystemService("window")) != null && wm.getDefaultDisplay() != null) {
                Point size = new Point();
                wm.getDefaultDisplay().getRealSize(size);
                mScreenHeight = size.y;
            } else {
                mScreenHeight = cxt.getResources().getDisplayMetrics().heightPixels;
            }
            if (WXEnvironment.SETTING_FORCE_VERTICAL_SCREEN) {
                mScreenWidth = res.getDisplayMetrics().widthPixels;
                mScreenHeight = mScreenHeight > mScreenWidth ? mScreenHeight : mScreenWidth;
            }
        } else if (WXEnvironment.isApkDebugable()) {
            throw new WXRuntimeException("Error Context is null When getScreenHeight");
        }
        return mScreenHeight;
    }

    public static int getScreenHeight(Context cxt) {
        if (cxt != null) {
            Resources res = cxt.getResources();
            mScreenHeight = res.getDisplayMetrics().heightPixels;
            if (WXEnvironment.SETTING_FORCE_VERTICAL_SCREEN) {
                mScreenWidth = res.getDisplayMetrics().widthPixels;
                mScreenHeight = mScreenHeight > mScreenWidth ? mScreenHeight : mScreenWidth;
            }
        } else if (WXEnvironment.isApkDebugable()) {
            throw new WXRuntimeException("Error Context is null When getScreenHeight");
        }
        return mScreenHeight;
    }

    @Deprecated
    public static float getRealPxByWidth(float pxValue) {
        return WXViewUtils.getRealPxByWidth(pxValue, 750);
    }

    public static float getRealPxByWidth(float pxValue, int customViewport) {
        if (Float.isNaN(pxValue)) {
            return pxValue;
        }
        float realPx = pxValue * (float)WXViewUtils.getScreenWidth() / (float)customViewport;
        return (double)realPx > 0.005 && realPx < 1.0f ? 1.0f : (float)Math.rint(realPx);
    }

    @Deprecated
    public static float getRealSubPxByWidth(float pxValue) {
        return WXViewUtils.getRealSubPxByWidth(pxValue, 750);
    }

    public static float getRealSubPxByWidth(float pxValue, int customViewport) {
        if (Float.isNaN(pxValue)) {
            return pxValue;
        }
        float realPx = pxValue * (float)WXViewUtils.getScreenWidth() / (float)customViewport;
        return (double)realPx > 0.005 && realPx < 1.0f ? 1.0f : realPx;
    }

    @Deprecated
    public static float getWeexPxByReal(float pxValue) {
        return WXViewUtils.getWeexPxByReal(pxValue, 750);
    }

    public static float getWeexPxByReal(float pxValue, int customViewport) {
        if (Float.isNaN(pxValue)) {
            return pxValue;
        }
        return pxValue * (float)customViewport / (float)WXViewUtils.getScreenWidth();
    }

    @Deprecated
    public static float getRealPxByWidth2(float pxValue) {
        return WXViewUtils.getRealPxByWidth2(pxValue, 750);
    }

    public static int getRealPxByWidth2(float pxValue, int customViewport) {
        float realPx = pxValue * (float)WXViewUtils.getScreenWidth() / (float)customViewport;
        return (double)realPx > 0.005 && realPx < 1.0f ? 1 : (int)realPx - 1;
    }

    @Deprecated
    public static float getWebPxByWidth(float pxValue) {
        return WXViewUtils.getWebPxByWidth(pxValue, 750);
    }

    public static float getWebPxByWidth(float pxValue, int customViewport) {
        if ((double)pxValue < -1.9999 && (double)pxValue > -2.005) {
            return Float.NaN;
        }
        float realPx = pxValue * (float)customViewport / (float)WXViewUtils.getScreenWidth();
        return (double)realPx > 0.005 && realPx < 1.0f ? 1.0f : realPx;
    }

    public static int dip2px(float dpValue) {
        float scale = 2.0f;
        try {
            scale = WXEnvironment.getApplication().getResources().getDisplayMetrics().density;
        }
        catch (Exception e) {
            WXLogUtils.e("[WXViewUtils] dip2px:", e);
        }
        float finalPx = dpValue * scale + 0.5f;
        return finalPx > 0.0f && finalPx < 1.0f ? 1 : (int)finalPx;
    }

    public static boolean onScreenArea(View view) {
        if (view == null || view.getVisibility() != 0) {
            return false;
        }
        int[] p = new int[2];
        view.getLocationOnScreen(p);
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        int viewH = 0;
        viewH = lp != null ? lp.height : view.getHeight();
        return p[1] > 0 && p[1] - WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication) < 0 || viewH + p[1] > 0 && p[1] <= 0;
    }

    public static int multiplyColorAlpha(int color, int alpha) {
        if (alpha == 255) {
            return color;
        }
        if (alpha == 0) {
            return color & 0xFFFFFF;
        }
        alpha += alpha >> 7;
        int colorAlpha = color >>> 24;
        int multipliedAlpha = colorAlpha * alpha >> 8;
        return multipliedAlpha << 24 | color & 0xFFFFFF;
    }

    public static int getOpacityFromColor(int color) {
        int colorAlpha = color >>> 24;
        if (colorAlpha == 255) {
            return -1;
        }
        if (colorAlpha == 0) {
            return -2;
        }
        return -3;
    }

    public static void setBackGround(View view, Drawable drawable2, WXComponent component) {
        if (Build.VERSION.SDK_INT < 16) {
            view.setBackgroundDrawable(drawable2);
        } else {
            try {
                view.setBackground(drawable2);
            }
            catch (Exception e) {
                if (component == null) {
                    return;
                }
                WXExceptionUtils.commitCriticalExceptionRT(component.getInstanceId(), WXErrorCode.WX_RENDER_ERR_TEXTURE_SETBACKGROUND, component.getComponentType() + " setBackGround for android view", WXErrorCode.WX_RENDER_ERR_TEXTURE_SETBACKGROUND.getErrorMsg() + ": TextureView doesn't support displaying a background drawable!", null);
            }
        }
    }

    @Nullable
    public static BorderDrawable getBorderDrawable(@NonNull View view) {
        Drawable innerDrawable;
        Drawable drawable2 = view.getBackground();
        if (drawable2 instanceof BorderDrawable) {
            return (BorderDrawable)drawable2;
        }
        if (drawable2 instanceof LayerDrawable && ((LayerDrawable)drawable2).getNumberOfLayers() > 1 && (innerDrawable = ((LayerDrawable)drawable2).getDrawable(0)) instanceof BorderDrawable) {
            return (BorderDrawable)innerDrawable;
        }
        return null;
    }

    public static void clipCanvasWithinBorderBox(View targetView, Canvas canvas) {
        BorderDrawable borderDrawable;
        Drawable drawable2;
        if (WXViewUtils.clipCanvasDueToAndroidVersion(canvas) && WXViewUtils.clipCanvasIfAnimationExist(targetView) && (drawable2 = targetView.getBackground()) instanceof BorderDrawable && (borderDrawable = (BorderDrawable)drawable2).isRounded() && WXViewUtils.clipCanvasIfBackgroundImageExist(targetView, borderDrawable)) {
            Path path = borderDrawable.getContentPath(new RectF(0.0f, 0.0f, (float)targetView.getWidth(), (float)targetView.getHeight()));
            canvas.clipPath(path);
        }
    }

    public static void clipCanvasWithinBorderBox(Widget widget, Canvas canvas) {
        BorderDrawable borderDrawable;
        if (WXViewUtils.clipCanvasDueToAndroidVersion(canvas) && WXViewUtils.clipCanvasIfAnimationExist(null) && (borderDrawable = widget.getBackgroundAndBorder()) != null) {
            if (borderDrawable.isRounded() && WXViewUtils.clipCanvasIfBackgroundImageExist(widget, borderDrawable)) {
                Path path = borderDrawable.getContentPath(new RectF(0.0f, 0.0f, (float)widget.getBorderBox().width(), (float)widget.getBorderBox().height()));
                canvas.clipPath(path);
            } else {
                canvas.clipRect(widget.getBorderBox());
            }
        }
    }

    private static boolean clipCanvasDueToAndroidVersion(Canvas canvas) {
        return Build.VERSION.SDK_INT >= 18 || !canvas.isHardwareAccelerated();
    }

    private static boolean clipCanvasIfAnimationExist(View targetView) {
        return Build.VERSION.SDK_INT != 24;
    }

    private static boolean clipCanvasIfBackgroundImageExist(@NonNull View targetView, @NonNull BorderDrawable borderDrawable) {
        if (targetView instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)targetView;
            int count = parent.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = parent.getChildAt(i);
                if (!(child.getBackground() instanceof BorderDrawable) || !((BorderDrawable)child.getBackground()).hasImage() || Build.VERSION.SDK_INT >= 21) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean clipCanvasIfBackgroundImageExist(@NonNull Widget widget, @NonNull BorderDrawable borderDrawable) {
        if (widget instanceof WidgetGroup) {
            for (Widget child : ((WidgetGroup)widget).getChildren()) {
                if (!child.getBackgroundAndBorder().hasImage() || Build.VERSION.SDK_INT >= 21) continue;
                return false;
            }
        }
        return true;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Opacity {
    }
}

