/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.content.Context;
import android.os.Build;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.widget.EditText;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;

public class WXEditText
extends EditText
implements WXGestureObservable {
    private WXGesture wxGesture;
    private int mLines = 1;
    private boolean mAllowDisableMovement = true;
    private boolean mAllowCopyPaste = true;

    public WXEditText(Context context) {
        super(context);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(null);
        } else {
            this.setBackgroundDrawable(null);
        }
    }

    @Override
    public void registerGestureListener(WXGesture wxGesture) {
        this.wxGesture = wxGesture;
    }

    @Override
    public WXGesture getGestureListener() {
        return this.wxGesture;
    }

    public void setLines(int lines) {
        super.setLines(lines);
        this.mLines = lines;
    }

    public boolean onTouchEvent(MotionEvent event) {
        ViewParent parent;
        boolean result = super.onTouchEvent(event);
        if (this.wxGesture != null) {
            result |= this.wxGesture.onTouch((View)this, event);
        }
        if ((parent = this.getParent()) != null) {
            switch (event.getAction() & 0xFF) {
                case 0: {
                    if (this.mLines >= this.getLineCount()) break;
                    parent.requestDisallowInterceptTouchEvent(true);
                    break;
                }
                case 1: 
                case 3: {
                    parent.requestDisallowInterceptTouchEvent(false);
                }
            }
        }
        return result;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.getLayout() != null) {
            int contentH = this.getLayout().getHeight();
            if (this.mAllowDisableMovement && h < contentH) {
                this.setMovementMethod(null);
            } else {
                this.setMovementMethod(this.getDefaultMovementMethod());
            }
        }
    }

    public void setAllowDisableMovement(boolean allow) {
        this.mAllowDisableMovement = allow;
    }

    public void setAllowCopyPaste(boolean allow) {
        this.mAllowCopyPaste = allow;
        if (allow) {
            this.setLongClickable(true);
            this.setCustomSelectionActionModeCallback(null);
            if (Build.VERSION.SDK_INT >= 23) {
                this.setCustomInsertionActionModeCallback(null);
            }
        } else {
            this.setLongClickable(false);
            ActionMode.Callback callback = new ActionMode.Callback(){

                public boolean onCreateActionMode(ActionMode mode, Menu menu) {
                    return false;
                }

                public boolean onPrepareActionMode(ActionMode mode, Menu menu) {
                    return false;
                }

                public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
                    return false;
                }

                public void onDestroyActionMode(ActionMode mode) {
                }
            };
            if (Build.VERSION.SDK_INT >= 23) {
                this.setCustomInsertionActionModeCallback(callback);
            }
            this.setCustomSelectionActionModeCallback(callback);
        }
    }

    public boolean onTextContextMenuItem(int id2) {
        return !this.mAllowCopyPaste || super.onTextContextMenuItem(id2);
    }
}

