/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.performance;

import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXConfigAdapter;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXVContainer;
import org.json.JSONObject;

public class WhiteScreenUtils {
    public static boolean doWhiteScreenCheck() {
        IWXConfigAdapter configAdapter = WXSDKManager.getInstance().getWxConfigAdapter();
        if (null == configAdapter) {
            return false;
        }
        double randomValue = Math.random() * 100.0;
        double max = 100.0;
        try {
            String configValue = configAdapter.getConfig("wxapm", "new_ws_sampling", "100");
            max = Double.valueOf(configValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return randomValue < max;
    }

    public static boolean isWhiteScreen(WXSDKInstance instance) {
        if (null == instance) {
            return false;
        }
        View v = instance.getContainerView();
        if (!(v instanceof ViewGroup)) {
            return false;
        }
        if (WhiteScreenUtils.isInWhiteList(instance)) {
            return false;
        }
        return !WhiteScreenUtils.hasLeafViewOrSizeIgnore(v, 3);
    }

    private static boolean isInWhiteList(WXSDKInstance instance) {
        IWXConfigAdapter configAdapter = WXSDKManager.getInstance().getWxConfigAdapter();
        if (null == configAdapter) {
            return false;
        }
        String whiteList = configAdapter.getConfig("wxapm", "ws_white_list", null);
        if (TextUtils.isEmpty((CharSequence)whiteList)) {
            return false;
        }
        try {
            String[] urlList;
            for (String whiteUrl : urlList = whiteList.split(";")) {
                if (instance.getBundleUrl() == null || !instance.getBundleUrl().contains(whiteUrl)) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static boolean hasLeafViewOrSizeIgnore(View v, int checkDeep) {
        if (!(v instanceof ViewGroup)) {
            return true;
        }
        if (checkDeep > 0) {
            if (v.getHeight() < 10 || v.getWidth() < 10) {
                return true;
            }
            --checkDeep;
        }
        ViewGroup group = (ViewGroup)v;
        for (int i = 0; i < group.getChildCount(); ++i) {
            View child = group.getChildAt(i);
            boolean res = WhiteScreenUtils.hasLeafViewOrSizeIgnore(child, checkDeep);
            if (!res) continue;
            return true;
        }
        return false;
    }

    public static String getViewMsg(WXSDKInstance instance) {
        if (null == instance) {
            return "nullInstance";
        }
        View v = instance.getContainerView();
        StringBuilder builder = new StringBuilder();
        WXComponent component = instance.getRootComponent();
        if (null != component) {
            builder.append("componentMsg:").append(WhiteScreenUtils.getComponentTreeMsg(component)).append("-----");
        }
        if (null != v) {
            builder.append("viewTreeMsg:").append(WhiteScreenUtils.geViewDetailTreeMsg(v));
        }
        return builder.toString();
    }

    private static String getComponentTreeMsg(WXComponent component) {
        if (null == component) {
            return "nullComponent";
        }
        if (!(component instanceof WXVContainer)) {
            return component.getRef();
        }
        WXVContainer container = (WXVContainer)component;
        StringBuilder builder = new StringBuilder();
        builder.append(" _start_ ");
        for (int i = 0; i < container.getChildCount(); ++i) {
            builder.append(WhiteScreenUtils.getComponentTreeMsg(container.getChild(i))).append(",");
        }
        builder.append(" _end_ ");
        return builder.toString();
    }

    private static JSONObject geViewDetailTreeMsg(View view) {
        if (null == view) {
            return null;
        }
        JSONObject node = new JSONObject();
        try {
            node.put("width", view.getWidth());
            node.put("height", view.getHeight());
            int[] location = new int[]{-1, -1};
            view.getLocationOnScreen(location);
            node.put("x", location[0]);
            node.put("y", location[1]);
            if (view instanceof ViewGroup) {
                node.put("type", (Object)"ViewGroup");
                ViewGroup group = (ViewGroup)view;
                for (int i = 0; i < group.getChildCount(); ++i) {
                    node.put("child", (Object)WhiteScreenUtils.geViewDetailTreeMsg(group.getChildAt(i)));
                }
            } else {
                node.put("type", (Object)view.getClass().getSimpleName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return node;
    }
}

