/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ScrollView;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.ComponentObserver;
import com.taobao.weex.IWXActivityStateListener;
import com.taobao.weex.IWXRenderListener;
import com.taobao.weex.IWXStatisticsListener;
import com.taobao.weex.RenderContainer;
import com.taobao.weex.Script;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXGlobalEventReceiver;
import com.taobao.weex.WXHttpListener;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IDrawableLoader;
import com.taobao.weex.adapter.IWXConfigAdapter;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.adapter.IWXImgLoaderAdapter;
import com.taobao.weex.adapter.IWXJscProcessManager;
import com.taobao.weex.adapter.IWXUserTrackAdapter;
import com.taobao.weex.adapter.URIAdapter;
import com.taobao.weex.appfram.websocket.IWebSocketAdapter;
import com.taobao.weex.bridge.EventResult;
import com.taobao.weex.bridge.NativeInvokeHelper;
import com.taobao.weex.bridge.SimpleJSCallback;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.bridge.WXModuleManager;
import com.taobao.weex.bridge.WXParams;
import com.taobao.weex.common.Destroyable;
import com.taobao.weex.common.OnWXScrollListener;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.common.WXPerformance;
import com.taobao.weex.common.WXRefreshData;
import com.taobao.weex.common.WXRenderStrategy;
import com.taobao.weex.common.WXRequest;
import com.taobao.weex.dom.WXEvent;
import com.taobao.weex.http.WXHttpUtil;
import com.taobao.weex.instance.InstanceOnFireEventInterceptor;
import com.taobao.weex.layout.ContentBoxMeasurement;
import com.taobao.weex.performance.WXInstanceApm;
import com.taobao.weex.performance.WXStateRecord;
import com.taobao.weex.performance.WhiteScreenUtils;
import com.taobao.weex.tracing.WXTracing;
import com.taobao.weex.ui.action.GraphicActionAddElement;
import com.taobao.weex.ui.component.NestedContainer;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXEmbed;
import com.taobao.weex.ui.flat.FlatGUIContext;
import com.taobao.weex.ui.view.WXScrollView;
import com.taobao.weex.utils.Trace;
import com.taobao.weex.utils.WXDeviceUtils;
import com.taobao.weex.utils.WXExceptionUtils;
import com.taobao.weex.utils.WXFileUtils;
import com.taobao.weex.utils.WXJsonUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXReflectionUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import com.taobao.weex.utils.cache.RegisterCache;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;

public class WXSDKInstance
implements IWXActivityStateListener,
View.OnLayoutChangeListener {
    private static final String SOURCE_TEMPLATE_BASE64_MD5 = "templateSourceBase64MD5";
    public static String ACTION_DEBUG_INSTANCE_REFRESH = "DEBUG_INSTANCE_REFRESH";
    public static String ACTION_INSTANCE_RELOAD = "INSTANCE_RELOAD";
    public boolean mEnd = false;
    public boolean mHasCreateFinish = false;
    public static final String BUNDLE_URL = "bundleUrl";
    private IWXUserTrackAdapter mUserTrackAdapter;
    private IWXRenderListener mRenderListener;
    private IWXStatisticsListener mStatisticsListener;
    Context mContext;
    private final String mInstanceId;
    private RenderContainer mRenderContainer;
    private WXComponent mRootComp;
    private boolean mRendered;
    private WXRefreshData mLastRefreshData;
    private NestedInstanceInterceptor mNestedInstanceInterceptor;
    private String mBundleUrl = "";
    public static String requestUrl = "requestUrl";
    private boolean isDestroy = false;
    private boolean hasException = false;
    private boolean isRenderSuccess = false;
    private Map<String, Serializable> mUserTrackParams;
    private NativeInvokeHelper mNativeInvokeHelper;
    private boolean isCommit = false;
    private WXGlobalEventReceiver mGlobalEventReceiver = null;
    private boolean trackComponent;
    private boolean enableLayerType = true;
    private boolean mNeedValidate = false;
    private boolean mNeedReLoad = false;
    private boolean mUseScroller = false;
    private int mInstanceViewPortWidth = 750;
    private boolean enableFullScreenHeight = false;
    private WXInstanceApm mApmForInstance;
    @NonNull
    private FlatGUIContext mFlatGUIContext = new FlatGUIContext();
    private Map<String, String> mContainerInfo;
    public boolean isNewFsEnd = false;
    public WXBridgeManager.BundType bundleType;
    public long mRenderStartNanos;
    public int mExecJSTraceId = WXTracing.nextId();
    private boolean isViewDisAppear = false;
    public String[] mwxDims = new String[5];
    public long[] measureTimes = new long[5];
    public WeakReference<String> templateRef;
    public Map<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
    private WXRenderStrategy mRenderStrategy = WXRenderStrategy.APPEND_ASYNC;
    private boolean mDisableSkipFrameworkInit = false;
    public long mRenderStartTime;
    private long mRefreshStartTime;
    private WXPerformance mWXPerformance;
    private ScrollView mScrollView;
    private WXScrollView.WXScrollViewListener mWXScrollViewListener;
    private List<OnWXScrollListener> mWXScrollListeners;
    private List<String> mLayerOverFlowListeners;
    private List<ActionBarHandler> mWXActionbarHandlers;
    private List<OnBackPressedHandler> mWXBackPressedHandlers;
    private WXSDKInstance mParentInstance;
    private boolean mAutoAdjustDeviceWidth = WXEnvironment.AUTO_ADJUST_ENV_DEVICE_WIDTH;
    private volatile boolean isPreRenderMode;
    private boolean mCurrentGround = false;
    private ComponentObserver mComponentObserver;
    private Map<String, GraphicActionAddElement> inactiveAddElementAction = new ArrayMap();
    private Map<Long, ContentBoxMeasurement> mContentBoxMeasurements = new ArrayMap();
    private List<InstanceOnFireEventInterceptor> mInstanceOnFireEventInterceptorList;
    private ImageNetworkHandler mImageNetworkHandler;
    private StreamNetworkHandler mStreamNetworkHandler;
    private CustomFontNetworkHandler mCustomFontNetworkHandler;
    public PriorityQueue<WXEmbed> hiddenEmbeds;
    private int maxHiddenEmbedsNum = -1;
    private int mMaxDeepLayer;
    private List<OnInstanceVisibleListener> mVisibleListeners = new ArrayList<OnInstanceVisibleListener>();
    private boolean isPreInit = false;
    private boolean isPreDownLoad = false;
    private WXHttpListener mHttpListener = null;
    private boolean mCreateInstance = true;
    static int sScreenHeight = -1;
    private HashMap<String, List<String>> mGlobalEvents = new HashMap();

    public List<String> getLayerOverFlowListeners() {
        return this.mLayerOverFlowListeners;
    }

    public void addLayerOverFlowListener(String ref) {
        if (this.mLayerOverFlowListeners == null) {
            this.mLayerOverFlowListeners = new ArrayList<String>();
        }
        this.mLayerOverFlowListeners.add(ref);
    }

    public void removeLayerOverFlowListener(String ref) {
        if (this.mLayerOverFlowListeners != null) {
            this.mLayerOverFlowListeners.remove(ref);
        }
    }

    public ImageNetworkHandler getImageNetworkHandler() {
        return this.mImageNetworkHandler;
    }

    public void setImageNetworkHandler(ImageNetworkHandler imageNetworkHandler) {
        this.mImageNetworkHandler = imageNetworkHandler;
    }

    public StreamNetworkHandler getStreamNetworkHandler() {
        return this.mStreamNetworkHandler;
    }

    public void setStreamNetworkHandler(StreamNetworkHandler streamNetworkHandler) {
        this.mStreamNetworkHandler = streamNetworkHandler;
    }

    public CustomFontNetworkHandler getCustomFontNetworkHandler() {
        return this.mCustomFontNetworkHandler;
    }

    public void setCustomFontNetworkHandler(CustomFontNetworkHandler customFontNetworkHandler) {
        this.mCustomFontNetworkHandler = customFontNetworkHandler;
    }

    public void setUseSingleProcess(boolean flag) {
        WXBridgeManager.getInstance().setUseSingleProcess(flag);
    }

    public void setUseSandBox(boolean flag) {
        WXBridgeManager.getInstance().setSandBoxContext(flag);
    }

    public int getMaxHiddenEmbedsNum() {
        return this.maxHiddenEmbedsNum;
    }

    public void setMaxHiddenEmbedsNum(int maxHiddenEmbedsNum) {
        this.maxHiddenEmbedsNum = maxHiddenEmbedsNum;
    }

    @WorkerThread
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void addInActiveAddElementAction(String ref, GraphicActionAddElement action) {
        this.inactiveAddElementAction.put(ref, action);
    }

    @WorkerThread
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void removeInActiveAddElmentAction(String ref) {
        this.inactiveAddElementAction.remove(ref);
    }

    @WorkerThread
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public GraphicActionAddElement getInActiveAddElementAction(String ref) {
        return this.inactiveAddElementAction.get(ref);
    }

    public void setRenderContainer(RenderContainer a) {
        if (a != null) {
            a.setSDKInstance(this);
            a.addOnLayoutChangeListener(this);
        }
        this.mRenderContainer = a;
        if (this.mRenderContainer != null && this.mRenderContainer.getLayoutParams() != null && this.mRenderContainer.getLayoutParams().width == -2) {
            WXBridgeManager.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    WXBridgeManager.getInstance().setRenderContentWrapContentToCore(true, WXSDKInstance.this.getInstanceId());
                }
            });
        } else {
            WXBridgeManager.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    WXBridgeManager.getInstance().setRenderContentWrapContentToCore(false, WXSDKInstance.this.getInstanceId());
                }
            });
        }
    }

    public boolean isTrackComponent() {
        return this.trackComponent;
    }

    public void setTrackComponent(boolean trackComponent) {
        this.trackComponent = trackComponent;
    }

    public boolean isLayerTypeEnabled() {
        return this.enableLayerType;
    }

    public void enableLayerType(boolean enable) {
        this.enableLayerType = enable;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public FlatGUIContext getFlatUIContext() {
        return this.mFlatGUIContext;
    }

    public boolean isNeedValidate() {
        return this.mNeedValidate;
    }

    public boolean isNeedReLoad() {
        return this.mNeedReLoad;
    }

    public void setNeedLoad(boolean load) {
        this.mNeedReLoad = load;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setEnableFullScreenHeight(boolean fullScreenHeight) {
        this.enableFullScreenHeight = fullScreenHeight;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean isFullScreenHeightEnabled() {
        return this.enableFullScreenHeight;
    }

    public boolean isUseScroller() {
        return this.mUseScroller;
    }

    public void setUseScroller(boolean use) {
        this.mUseScroller = use;
    }

    public void setInstanceViewPortWidth(int instanceViewPortWidth) {
        this.mInstanceViewPortWidth = instanceViewPortWidth;
        this.mAutoAdjustDeviceWidth = false;
    }

    public void setAutoAdjustDeviceWidth(boolean autoAdjustViewPort) {
        this.mAutoAdjustDeviceWidth = autoAdjustViewPort;
    }

    public boolean isAutoAdjustDeviceWidth() {
        return this.mAutoAdjustDeviceWidth;
    }

    private void setDeviceDisplay(float deviceWith, float deviceHeight, float scale) {
        WXBridgeManager.getInstance().setDeviceDisplay(this.getInstanceId(), deviceWith, deviceHeight, scale);
    }

    public int getInstanceViewPortWidth() {
        return this.mInstanceViewPortWidth;
    }

    public WXSDKInstance(Context context) {
        this.mInstanceId = WXSDKManager.getInstance().generateInstanceId();
        this.init(context);
    }

    public WXSDKInstance() {
        this.mInstanceId = WXSDKManager.getInstance().generateInstanceId();
        this.mWXPerformance = new WXPerformance(this.mInstanceId);
        this.mApmForInstance = new WXInstanceApm(this.mInstanceId);
        WXSDKManager.getInstance().getAllInstanceMap().put(this.mInstanceId, this);
    }

    @RestrictTo(value={RestrictTo.Scope.TESTS})
    WXSDKInstance(Context context, String id) {
        this.mInstanceId = id;
        this.init(context);
    }

    public WXComponent getRootComponent() {
        return this.mRootComp;
    }

    public void setNestedInstanceInterceptor(NestedInstanceInterceptor interceptor) {
        this.mNestedInstanceInterceptor = interceptor;
    }

    public final WXSDKInstance createNestedInstance(NestedContainer container) {
        WXSDKInstance sdkInstance = this.newNestedInstance();
        if (this.mNestedInstanceInterceptor != null) {
            this.mNestedInstanceInterceptor.onCreateNestInstance(sdkInstance, container);
        }
        if (sdkInstance != null) {
            sdkInstance.setComponentObserver(this.getComponentObserver());
        }
        return sdkInstance;
    }

    protected WXSDKInstance newNestedInstance() {
        return new WXSDKInstance(this.mContext);
    }

    public boolean isHasException() {
        return this.hasException;
    }

    public void setHasException(boolean hasException) {
        this.hasException = hasException;
    }

    public void addOnInstanceVisibleListener(OnInstanceVisibleListener l) {
        this.mVisibleListeners.add(l);
    }

    public void removeOnInstanceVisibleListener(OnInstanceVisibleListener l) {
        this.mVisibleListeners.remove(l);
    }

    public void init(Context context) {
        RegisterCache.getInstance().idle(true);
        this.mContext = context;
        this.mContainerInfo = new HashMap<String, String>(4);
        this.mNativeInvokeHelper = new NativeInvokeHelper(this.mInstanceId);
        if (null == this.mWXPerformance) {
            this.mWXPerformance = new WXPerformance(this.mInstanceId);
        }
        if (null == this.mApmForInstance) {
            this.mApmForInstance = new WXInstanceApm(this.mInstanceId);
        }
        this.mWXPerformance.WXSDKVersion = WXEnvironment.WXSDK_VERSION;
        this.mWXPerformance.JSLibInitTime = WXEnvironment.sJSLibInitTime;
        this.mUserTrackAdapter = WXSDKManager.getInstance().getIWXUserTrackAdapter();
        WXSDKManager.getInstance().getAllInstanceMap().put(this.mInstanceId, this);
        this.mContainerInfo.put("wxContainerName", context instanceof Activity ? context.getClass().getSimpleName() : "unKnowContainer");
        this.mContainerInfo.put("wxInstanceType", "page");
        WXBridgeManager.getInstance().checkJsEngineMultiThread();
        this.mDisableSkipFrameworkInit = WXSDKInstance.isDisableSkipFrameworkInDataRender();
    }

    public void setComponentObserver(ComponentObserver observer) {
        this.mComponentObserver = observer;
    }

    public ComponentObserver getComponentObserver() {
        return this.mComponentObserver;
    }

    public NativeInvokeHelper getNativeInvokeHelper() {
        return this.mNativeInvokeHelper;
    }

    @Deprecated
    public void setBizType(String bizType) {
        if (!TextUtils.isEmpty((CharSequence)bizType)) {
            this.mWXPerformance.bizType = bizType;
        }
    }

    public ScrollView getScrollView() {
        return this.mScrollView;
    }

    public void setRootScrollView(ScrollView scrollView) {
        this.mScrollView = scrollView;
        if (this.mWXScrollViewListener != null && this.mScrollView instanceof WXScrollView) {
            ((WXScrollView)this.mScrollView).addScrollViewListener(this.mWXScrollViewListener);
        }
    }

    @Deprecated
    public void registerScrollViewListener(WXScrollView.WXScrollViewListener scrollViewListener) {
        this.mWXScrollViewListener = scrollViewListener;
    }

    @Deprecated
    public WXScrollView.WXScrollViewListener getScrollViewListener() {
        return this.mWXScrollViewListener;
    }

    @Deprecated
    public void setIWXUserTrackAdapter(IWXUserTrackAdapter adapter) {
    }

    public void setContainerInfo(String key, String val) {
        this.mContainerInfo.put(key, val);
    }

    public Map<String, String> getContainerInfo() {
        return this.mContainerInfo;
    }

    public void render(String template, Map<String, Object> options, String jsonInitData) {
        this.render(template, options, jsonInitData, WXRenderStrategy.APPEND_ASYNC);
    }

    @Deprecated
    public void render(String template, Map<String, Object> options, String jsonInitData, WXRenderStrategy flag) {
        this.render("default", template, options, jsonInitData, flag);
    }

    public void render(String pageName, String template, Map<String, Object> options, String jsonInitData, WXRenderStrategy flag) {
        this.render(pageName, new Script(template), options, jsonInitData, flag);
    }

    public void render(String pageName, Script template, Map<String, Object> options, String jsonInitData, WXRenderStrategy flag) {
        this.mWXPerformance.beforeInstanceRender(this.mInstanceId);
        if (WXEnvironment.isApkDebugable() && "default".equals(pageName)) {
            if (this.getUIContext() != null) {
                new AlertDialog.Builder(this.getUIContext()).setTitle((CharSequence)"Error: Missing pageName").setMessage((CharSequence)"We highly recommend you to set pageName. Call\nWXSDKInstance#render(String pageName, String template, Map<String, Object> options, String jsonInitData, WXRenderStrategy flag)\nto fix it.").show();
            }
            return;
        }
        this.renderInternal(pageName, template, options, jsonInitData, flag);
    }

    public void render(String pageName, byte[] template, Map<String, Object> options, String jsonInitData) {
        this.render(pageName, new Script(template), options, jsonInitData, WXRenderStrategy.DATA_RENDER_BINARY);
    }

    private void ensureRenderArchor() {
        if (this.mRenderContainer == null && this.getContext() != null) {
            this.setRenderContainer(new RenderContainer(this.getContext()));
            this.mRenderContainer.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            this.mRenderContainer.setBackgroundColor(0);
            this.mRenderContainer.setSDKInstance(this);
            this.mRenderContainer.addOnLayoutChangeListener(this);
        }
    }

    private void renderInternal(String pageName, String template, Map<String, Object> options, String jsonInitData, WXRenderStrategy flag) {
        if (this.mRendered || TextUtils.isEmpty((CharSequence)template)) {
            return;
        }
        this.renderInternal(pageName, new Script(template), options, jsonInitData, flag);
    }

    public boolean isPreInitMode() {
        return this.isPreInit;
    }

    public boolean isPreDownLoad() {
        return this.isPreDownLoad;
    }

    public void onInstanceReady() {
        WXLogUtils.e("test->", "onInstanceReady");
        this.mApmForInstance.onStage("wxContainerReady");
        if (!this.isPreInit && !this.isPreDownLoad) {
            return;
        }
        this.mApmForInstance.onInstanceReady(this.isPreDownLoad);
        if (this.isPreDownLoad) {
            this.mHttpListener.onInstanceReady();
        }
    }

    public void preInit(String pageName, String script, Map<String, Object> options, String jsonInitData, WXRenderStrategy flag) {
        this.isPreInit = true;
        this.mRenderStrategy = flag;
        Map<String, Object> renderOptions = options;
        if (renderOptions == null) {
            renderOptions = new HashMap<String, Object>();
        }
        this.mApmForInstance.isReady = false;
        WXSDKManager.getInstance().createInstance(this, new Script(script), renderOptions, jsonInitData);
    }

    public void preDownLoad(String url, Map<String, Object> options, String jsonInitData, WXRenderStrategy flag) {
        this.isPreDownLoad = true;
        this.mRenderStrategy = flag;
        this.mApmForInstance.isReady = false;
        this.renderByUrl(url, url, options, jsonInitData, flag);
    }

    private void renderInternal(String pageName, Script template, Map<String, Object> options, String jsonInitData, WXRenderStrategy flag) {
        if (this.mRendered || template == null || template.isEmpty()) {
            return;
        }
        this.mRenderStrategy = flag;
        if (!this.mApmForInstance.hasInit()) {
            this.mApmForInstance.doInit();
        }
        this.mApmForInstance.setPageName(pageName);
        this.mApmForInstance.onStage("wxRenderTimeOrigin");
        String string = this.mWXPerformance.pageName = TextUtils.isEmpty((CharSequence)pageName) ? "defaultBundleUrl" : pageName;
        if (TextUtils.isEmpty((CharSequence)this.mBundleUrl)) {
            this.mBundleUrl = this.mWXPerformance.pageName;
        }
        if (WXTracing.isAvailable()) {
            WXTracing.TraceEvent traceEvent = WXTracing.newEvent("executeBundleJS", this.mInstanceId, -1);
            traceEvent.traceId = this.mExecJSTraceId;
            traceEvent.iid = this.mInstanceId;
            traceEvent.tname = "JSThread";
            traceEvent.ph = "B";
            traceEvent.submit();
            this.mRenderStartNanos = System.nanoTime();
        }
        this.ensureRenderArchor();
        Map<String, Object> renderOptions = options;
        if (renderOptions == null) {
            renderOptions = new HashMap<String, Object>();
        }
        if (WXEnvironment.sDynamicMode && !TextUtils.isEmpty((CharSequence)WXEnvironment.sDynamicUrl) && renderOptions.get("dynamicMode") == null) {
            renderOptions.put("dynamicMode", "true");
            this.renderByUrl(pageName, WXEnvironment.sDynamicUrl, renderOptions, jsonInitData, flag);
            return;
        }
        this.mWXPerformance.JSTemplateSize = (float)template.length() / 1024.0f;
        this.mApmForInstance.addStats("wxBundleSize", this.mWXPerformance.JSTemplateSize);
        this.mRenderStartTime = System.currentTimeMillis();
        WXSDKManager.getInstance().setCrashInfo("wx_current_url", pageName);
        if (this.mAutoAdjustDeviceWidth && WXDeviceUtils.isAutoResize(this.mContext)) {
            WXParams params;
            if (WXEnvironment.AUTO_UPDATE_APPLICATION_SCREEN_SIZE) {
                WXViewUtils.updateApplicationScreen(this.mContext);
            }
            if ((params = WXBridgeManager.getInstance().getInitParams()) != null && !TextUtils.equals((CharSequence)params.getDeviceWidth(), (CharSequence)String.valueOf(WXViewUtils.getScreenWidth(this.mContext)))) {
                params.setDeviceWidth(String.valueOf(WXViewUtils.getScreenWidth(this.mContext)));
                params.setDeviceHeight(String.valueOf(WXViewUtils.getScreenHeight(this.mContext)));
                float density = WXEnvironment.sApplication.getResources().getDisplayMetrics().density;
                WXEnvironment.addCustomOptions("scale", Float.toString(density));
                String statusBarHeight = null;
                if (WXViewUtils.getStatusBarHeight(this.mContext) > 0) {
                    statusBarHeight = String.valueOf(WXViewUtils.getStatusBarHeight(this.mContext));
                }
                WXBridgeManager.getInstance().updateInitDeviceParams(params.getDeviceWidth(), params.getDeviceHeight(), Float.toString(density), statusBarHeight);
                this.setDeviceDisplay(WXViewUtils.getScreenWidth(this.mContext), WXViewUtils.getScreenHeight(this.mContext), WXViewUtils.getScreenDensity(this.mContext));
            }
        }
        if (this.isPreInitMode()) {
            this.getApmForInstance().onStage("wxStartLoadBundle");
            WXBridgeManager.getInstance().loadJsBundleInPreInitMode(this.getInstanceId(), template.getContent());
        } else {
            WXSDKManager.getInstance().createInstance(this, template, renderOptions, jsonInitData);
        }
        this.mRendered = true;
        final IWXJscProcessManager wxJscProcessManager = WXSDKManager.getInstance().getWXJscProcessManager();
        if (wxJscProcessManager != null && wxJscProcessManager.shouldReboot()) {
            WXSDKManager.getInstance().postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    WXSDKInstance.this.checkWhiteScreen();
                    if (WXSDKInstance.this.isDestroy || WXSDKInstance.this.hasException || WXSDKInstance.this.isRenderSuccess) {
                        return;
                    }
                    View containerView = WXSDKInstance.this.getContainerView();
                    if (containerView instanceof ViewGroup && 0 == ((ViewGroup)containerView).getChildCount()) {
                        if (wxJscProcessManager.withException(WXSDKInstance.this)) {
                            WXSDKInstance.this.onJSException(String.valueOf((Object)WXErrorCode.WX_ERR_RELOAD_PAGE), "jsc reboot", "jsc reboot");
                        }
                        WXBridgeManager.getInstance().callReportCrashReloadPage(WXSDKInstance.this.mInstanceId, null);
                    }
                }
            }, wxJscProcessManager.rebootTimeout());
        }
    }

    private void checkWhiteScreen() {
        if (this.isDestroy || !WhiteScreenUtils.doWhiteScreenCheck()) {
            return;
        }
        boolean isWS = WhiteScreenUtils.isWhiteScreen(this);
        if (!isWS) {
            return;
        }
        WXErrorCode errorCode = WXErrorCode.WX_ERROR_WHITE_SCREEN;
        HashMap<String, String> args = new HashMap<String, String>(1);
        String vieTreeMsg = WhiteScreenUtils.getViewMsg(this);
        args.put("viewTree", null == vieTreeMsg ? "null viewTreeMsg" : vieTreeMsg);
        for (Map.Entry<String, String> entry : WXStateRecord.getInstance().getStateInfo().entrySet()) {
            args.put(entry.getKey(), entry.getValue());
        }
        WXExceptionUtils.commitCriticalExceptionRT(this.getInstanceId(), errorCode, "checkEmptyScreen", errorCode.getErrorMsg(), args);
    }

    public boolean skipFrameworkInit() {
        return this.isDataRender() && !this.mDisableSkipFrameworkInit;
    }

    private boolean isDataRender() {
        return this.getRenderStrategy() == WXRenderStrategy.DATA_RENDER_BINARY || this.getRenderStrategy() == WXRenderStrategy.DATA_RENDER;
    }

    private void renderByUrlInternal(String pageName, String url, Map<String, Object> options, String jsonInitData, WXRenderStrategy flag) {
        Map<String, Object> renderOptions;
        this.ensureRenderArchor();
        pageName = this.wrapPageName(pageName, url);
        this.mBundleUrl = url;
        this.mRenderStrategy = flag;
        if (WXSDKManager.getInstance().getValidateProcessor() != null) {
            this.mNeedValidate = WXSDKManager.getInstance().getValidateProcessor().needValidate(this.mBundleUrl);
        }
        if ((renderOptions = options) == null) {
            renderOptions = new HashMap<String, Object>();
        }
        if (!renderOptions.containsKey(BUNDLE_URL)) {
            renderOptions.put(BUNDLE_URL, url);
        }
        this.getWXPerformance().pageName = pageName;
        this.mApmForInstance.doInit();
        this.mApmForInstance.setPageName(pageName);
        Uri uri = Uri.parse((String)url);
        if (uri != null && TextUtils.equals((CharSequence)uri.getScheme(), (CharSequence)"file")) {
            this.mApmForInstance.onStage("wxStartDownLoadBundle");
            String template = WXFileUtils.loadFileOrAsset(this.assembleFilePath(uri), this.mContext);
            this.mApmForInstance.onStage("wxEndDownLoadBundle");
            this.render(pageName, template, renderOptions, jsonInitData, flag);
            return;
        }
        boolean is_wlasm = false;
        if (uri != null && uri.getPath() != null && uri.getPath().endsWith(".wlasm")) {
            is_wlasm = true;
        }
        if (is_wlasm) {
            flag = WXRenderStrategy.DATA_RENDER_BINARY;
        }
        IWXHttpAdapter adapter = WXSDKManager.getInstance().getIWXHttpAdapter();
        WXRequest wxRequest = new WXRequest();
        wxRequest.url = this.rewriteUri(Uri.parse((String)url), "bundle").toString();
        requestUrl = wxRequest != null && !TextUtils.isEmpty((CharSequence)wxRequest.url) ? wxRequest.url : pageName;
        if (wxRequest.paramMap == null) {
            wxRequest.paramMap = new HashMap<String, String>();
        }
        wxRequest.instanceId = this.getInstanceId();
        wxRequest.paramMap.put("user-agent", WXHttpUtil.assembleUserAgent(this.mContext, WXEnvironment.getConfig()));
        wxRequest.paramMap.put("isBundleRequest", "true");
        this.mHttpListener = new WXHttpListener(this, pageName, renderOptions, jsonInitData, flag, System.currentTimeMillis());
        this.mHttpListener.isPreDownLoadMode = this.isPreDownLoad;
        this.mHttpListener.setSDKInstance(this);
        this.mApmForInstance.onStage("wxStartDownLoadBundle");
        adapter.sendRequest(wxRequest, this.mHttpListener);
    }

    @Deprecated
    public void render(String pageName, String template, Map<String, Object> options, String jsonInitData, int width, int height, WXRenderStrategy flag) {
        this.render(pageName, template, options, jsonInitData, flag);
    }

    public void render(String template) {
        this.render("default", template, null, null, this.mRenderStrategy);
    }

    @Deprecated
    public void render(String template, int width, int height) {
        this.render(template);
    }

    @Deprecated
    public void renderByUrl(String pageName, String url, Map<String, Object> options, String jsonInitData, int width, int height, WXRenderStrategy flag) {
        this.renderByUrl(pageName, url, options, jsonInitData, flag);
    }

    public void renderByUrl(String pageName, String url, Map<String, Object> options, String jsonInitData, WXRenderStrategy flag) {
        this.renderByUrlInternal(pageName, url, options, jsonInitData, flag);
    }

    private String wrapPageName(String pageName, String url) {
        if (TextUtils.equals((CharSequence)pageName, (CharSequence)"default")) {
            WXExceptionUtils.degradeUrl = pageName = url;
            try {
                Uri uri = Uri.parse((String)url);
                if (uri != null) {
                    Uri.Builder builder = new Uri.Builder();
                    builder.scheme(uri.getScheme());
                    builder.authority(uri.getAuthority());
                    builder.path(uri.getPath());
                    pageName = builder.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pageName;
    }

    private String assembleFilePath(Uri uri) {
        if (uri != null && uri.getPath() != null) {
            return uri.getPath().replaceFirst("/", "");
        }
        return "";
    }

    public void reloadPage(boolean reloadThis) {
        WXSDKEngine.reload();
        if (reloadThis) {
            if (this.mContext != null) {
                Intent intent = new Intent();
                intent.setAction(ACTION_INSTANCE_RELOAD);
                intent.putExtra("url", this.mBundleUrl);
                this.mContext.sendBroadcast(intent);
            }
        } else {
            IWXConfigAdapter adapter = WXSDKManager.getInstance().getWxConfigAdapter();
            if (adapter != null) {
                boolean degrade = Boolean.parseBoolean(adapter.getConfig("android_weex_ext_config", "degrade_to_h5_if_not_reload", "true"));
                WXLogUtils.e("degrade : " + degrade);
                if (degrade) {
                    this.onJSException(String.valueOf(WXErrorCode.WX_ERR_JSC_CRASH.getErrorCode()), "jsc Crashed", "jsc Crashed degradeToH5");
                }
            }
        }
    }

    public void refreshInstance(Map<String, Object> data) {
        if (data == null) {
            return;
        }
        this.refreshInstance(WXJsonUtils.fromObjectToJSONString(data));
    }

    public void refreshInstance(String jsonData) {
        if (jsonData == null) {
            return;
        }
        this.mRefreshStartTime = System.currentTimeMillis();
        if (this.mLastRefreshData != null) {
            this.mLastRefreshData.isDirty = true;
        }
        this.mLastRefreshData = new WXRefreshData(jsonData, false);
        WXSDKManager.getInstance().refreshInstance(this.mInstanceId, this.mLastRefreshData);
    }

    public WXRenderStrategy getRenderStrategy() {
        return this.mRenderStrategy;
    }

    public Context getUIContext() {
        return this.mContext;
    }

    public String getInstanceId() {
        return this.mInstanceId;
    }

    public Context getContext() {
        return this.mContext;
    }

    public int getWeexHeight() {
        return this.mRenderContainer == null ? 0 : this.mRenderContainer.getHeight();
    }

    public int getWeexWidth() {
        return this.mRenderContainer == null ? 0 : this.mRenderContainer.getWidth();
    }

    public IWXImgLoaderAdapter getImgLoaderAdapter() {
        return WXSDKManager.getInstance().getIWXImgLoaderAdapter();
    }

    public IDrawableLoader getDrawableLoader() {
        return WXSDKManager.getInstance().getDrawableLoader();
    }

    public URIAdapter getURIAdapter() {
        return WXSDKManager.getInstance().getURIAdapter();
    }

    public Uri rewriteUri(Uri uri, String type) {
        return this.getURIAdapter().rewrite(this, type, uri);
    }

    public IWXHttpAdapter getWXHttpAdapter() {
        return WXSDKManager.getInstance().getIWXHttpAdapter();
    }

    public IWXStatisticsListener getWXStatisticsListener() {
        return this.mStatisticsListener;
    }

    @Nullable
    public IWebSocketAdapter getWXWebSocketAdapter() {
        return WXSDKManager.getInstance().getIWXWebSocketAdapter();
    }

    @Deprecated
    public void reloadImages() {
        if (this.mScrollView == null) {
            return;
        }
    }

    public boolean isPreRenderMode() {
        return this.isPreRenderMode;
    }

    public void setPreRenderMode(final boolean isPreRenderMode) {
        WXSDKManager.getInstance().getWXRenderManager().postOnUiThread(new Runnable(){

            @Override
            public void run() {
                WXSDKInstance.this.isPreRenderMode = isPreRenderMode;
            }
        }, 0L);
    }

    public void setContext(@NonNull Context context) {
        this.mContext = context;
    }

    public void registerRenderListener(IWXRenderListener listener) {
        this.mRenderListener = listener;
    }

    @Deprecated
    public void registerActivityStateListener(IWXActivityStateListener listener) {
    }

    public void registerStatisticsListener(IWXStatisticsListener listener) {
        this.mStatisticsListener = listener;
    }

    public void setRenderStartTime(long renderStartTime) {
        this.mRenderStartTime = renderStartTime;
    }

    @Override
    public void onActivityCreate() {
        WXModuleManager.onActivityCreate(this.getInstanceId());
        if (this.mRootComp != null) {
            this.mRootComp.onActivityCreate();
        } else if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.w("Warning :Component tree has not build completely,onActivityCreate can not be call!");
        }
        this.mGlobalEventReceiver = new WXGlobalEventReceiver(this);
        try {
            this.getContext().registerReceiver((BroadcastReceiver)this.mGlobalEventReceiver, new IntentFilter("wx_global_action"));
        }
        catch (Throwable e) {
            WXLogUtils.e(e.getMessage());
            this.mGlobalEventReceiver = null;
        }
    }

    @Override
    public void onActivityStart() {
        WXModuleManager.onActivityStart(this.getInstanceId());
        if (this.mRootComp != null) {
            this.mRootComp.onActivityStart();
        } else if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.w("Warning :Component tree has not build completely,onActivityStart can not be call!");
        }
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        WXModuleManager.onCreateOptionsMenu(this.getInstanceId(), menu);
        if (this.mRootComp != null) {
            this.mRootComp.onCreateOptionsMenu(menu);
        } else if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.w("Warning :Component tree has not build completely,onActivityStart can not be call!");
        }
        return true;
    }

    @Override
    public void onActivityPause() {
        this.onViewDisappear();
        if (!this.isCommit) {
            if (this.mUseScroller) {
                this.mWXPerformance.useScroller = 1;
            }
            this.mWXPerformance.maxDeepViewLayer = this.getMaxDeepLayer();
            this.mWXPerformance.wxDims = this.mwxDims;
            this.mWXPerformance.measureTimes = this.measureTimes;
            if (this.mUserTrackAdapter != null) {
                this.mUserTrackAdapter.commit(this.mContext, null, "load", this.mWXPerformance, this.getUserTrackParams());
            }
            this.isCommit = true;
        }
        WXModuleManager.onActivityPause(this.getInstanceId());
        if (this.mRootComp != null) {
            this.mRootComp.onActivityPause();
        } else if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.w("Warning :Component tree has not build completely,onActivityPause can not be call!");
        }
        if (!this.mCurrentGround) {
            WXLogUtils.i("Application to be in the backround");
            Intent intent = new Intent("wx_global_action");
            intent.putExtra("eventName", "WXApplicationWillResignActiveEvent");
            intent.putExtra("wx_instanceid", this.getInstanceId());
            if (null != this.mContext) {
                this.mContext.sendBroadcast(intent);
            } else {
                WXEnvironment.getApplication().sendBroadcast(intent);
            }
            this.mCurrentGround = true;
        }
    }

    @Override
    public void onActivityResume() {
        WXModuleManager.onActivityResume(this.getInstanceId());
        if (this.mRootComp != null) {
            this.mRootComp.onActivityResume();
        } else if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.w("Warning :Component tree has not build completely, onActivityResume can not be call!");
        }
        if (this.mCurrentGround) {
            WXLogUtils.i("Application  to be in the foreground");
            Intent intent = new Intent("wx_global_action");
            intent.putExtra("eventName", "WXApplicationDidBecomeActiveEvent");
            intent.putExtra("wx_instanceid", this.getInstanceId());
            if (null != this.mContext) {
                this.mContext.sendBroadcast(intent);
            } else {
                WXEnvironment.getApplication().sendBroadcast(intent);
            }
            this.mCurrentGround = false;
        }
        this.onViewAppear();
    }

    @Override
    public void onActivityStop() {
        WXModuleManager.onActivityStop(this.getInstanceId());
        if (this.mRootComp != null) {
            this.mRootComp.onActivityStop();
        } else if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.w("Warning :Component tree has not build completely, onActivityStop can not be call!");
        }
    }

    @Override
    public void onActivityDestroy() {
        WXModuleManager.onActivityDestroy(this.getInstanceId());
        if (this.mRootComp != null) {
            this.mRootComp.onActivityDestroy();
        } else if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.w("Warning :Component tree has not build completely, onActivityDestroy can not be call!");
        }
        this.destroy();
    }

    @Override
    public boolean onActivityBack() {
        WXModuleManager.onActivityBack(this.getInstanceId());
        if (this.mRootComp != null) {
            return this.mRootComp.onActivityBack();
        }
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.w("Warning :Component tree has not build completely, onActivityBack can not be call!");
        }
        return false;
    }

    public boolean onSupportNavigateUp() {
        if (this.mWXActionbarHandlers != null) {
            for (ActionBarHandler handler : this.mWXActionbarHandlers) {
                if (!handler.onSupportNavigateUp()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean onBackPressed() {
        WXComponent comp;
        if (this.mWXBackPressedHandlers != null) {
            for (OnBackPressedHandler handler : this.mWXBackPressedHandlers) {
                if (!handler.onBackPressed()) continue;
                return true;
            }
        }
        if ((comp = this.getRootComponent()) != null) {
            EventResult result;
            WXEvent events = comp.getEvents();
            boolean hasNativeBackHook = events.contains("nativeback");
            if (hasNativeBackHook && WXUtils.getBoolean((result = comp.fireEventWait("nativeback", null)).getResult(), false).booleanValue()) {
                return true;
            }
            boolean hasBackPressed = events.contains("clickbackitem");
            if (hasBackPressed) {
                this.fireEvent(comp.getRef(), "clickbackitem", null, null);
            }
            return hasBackPressed;
        }
        return false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        WXModuleManager.onActivityResult(this.getInstanceId(), requestCode, resultCode, data);
        if (this.mRootComp != null) {
            this.mRootComp.onActivityResult(requestCode, resultCode, data);
        } else if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.w("Warning :Component tree has not build completely, onActivityResult can not be call!");
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        WXModuleManager.onRequestPermissionsResult(this.getInstanceId(), requestCode, permissions, grantResults);
        if (this.mRootComp != null) {
            this.mRootComp.onRequestPermissionsResult(requestCode, permissions, grantResults);
        } else if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.w("Warning :Component tree has not build completely, onRequestPermissionsResult can not be call!");
        }
    }

    public void onViewDisappear() {
        this.isViewDisAppear = false;
        this.mApmForInstance.onDisAppear();
        WXComponent comp = this.getRootComponent();
        if (comp != null) {
            this.fireEvent(comp.getRef(), "viewdisappear", null, null);
            for (OnInstanceVisibleListener instance : this.mVisibleListeners) {
                instance.onDisappear();
            }
        }
    }

    public boolean isViewDisAppear() {
        return this.isViewDisAppear;
    }

    public void onViewAppear() {
        this.isViewDisAppear = true;
        this.mApmForInstance.onAppear();
        WXComponent comp = this.getRootComponent();
        if (comp != null) {
            this.fireEvent(comp.getRef(), "viewappear", null, null);
            for (OnInstanceVisibleListener instance : this.mVisibleListeners) {
                instance.onAppear();
            }
        }
    }

    public void onCreateFinish() {
        if (this.mContext != null) {
            this.onViewAppear();
            RenderContainer wxView = this.mRenderContainer;
            if (this.mRenderListener != null) {
                this.mRenderListener.onViewCreated(this, (View)wxView);
            }
            if (this.mStatisticsListener != null) {
                this.mStatisticsListener.onFirstView();
            }
        }
    }

    public void onUpdateFinish() {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("Instance onUpdateSuccess");
        }
    }

    public void runOnUiThread(Runnable action) {
        WXSDKManager.getInstance().postOnUiThread(action, 0L);
    }

    public void onRenderSuccess(int width, int height) {
        this.isRenderSuccess = true;
        if (!this.isNewFsEnd) {
            this.getApmForInstance().arriveNewFsRenderTime();
        }
        long time = System.currentTimeMillis() - this.mRenderStartTime;
        long[] renderFinishTime = WXBridgeManager.getInstance().getRenderFinishTime(this.getInstanceId());
        this.mWXPerformance.callBridgeTime = renderFinishTime[0];
        this.mWXPerformance.cssLayoutTime = renderFinishTime[1];
        this.mWXPerformance.parseJsonTime = renderFinishTime[2];
        this.mWXPerformance.totalTime = time;
        if ((double)this.mWXPerformance.screenRenderTime < 0.001) {
            this.mWXPerformance.screenRenderTime = time;
        }
        if (this.mRenderListener != null && this.mContext != null) {
            this.mRenderListener.onRenderSuccess(this, width, height);
            if (this.mUserTrackAdapter != null) {
                WXPerformance performance = new WXPerformance(this.mInstanceId);
                performance.errCode = WXErrorCode.WX_SUCCESS.getErrorCode();
                performance.args = this.getBundleUrl();
                this.mUserTrackAdapter.commit(this.mContext, null, "jsBridge", performance, this.getUserTrackParams());
            }
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.d("weex_perf", this.mWXPerformance.toString());
            }
        }
        if (WXEnvironment.isPerf()) {
            WXLogUtils.e("weex_perf", this.mWXPerformance.getPerfData());
        }
    }

    public void onRefreshSuccess(int width, int height) {
        if (this.mRenderListener != null && this.mContext != null) {
            this.mRenderListener.onRefreshSuccess(this, width, height);
        }
    }

    public void onChangeElement(WXComponent component, boolean isOutOfScreen) {
        long lazyLoadTime;
        if (this.isDestroy() || null == this.mRenderContainer || this.mWXPerformance == null) {
            return;
        }
        if (null == component || component.isIgnoreInteraction) {
            return;
        }
        if (this.mRenderContainer.hasConsumeEvent()) {
            return;
        }
        long lastElementChangeTime = System.currentTimeMillis();
        if (this.mHasCreateFinish && (lazyLoadTime = lastElementChangeTime - this.mWXPerformance.renderTimeOrigin) > 8000L) {
            return;
        }
        if (component.mIsAddElementToTree) {
            ++this.getWXPerformance().localInteractionViewAddCount;
            if (!isOutOfScreen) {
                ++this.getWXPerformance().interactionViewAddLimitCount;
            }
            component.mIsAddElementToTree = false;
        }
        if (!isOutOfScreen) {
            this.mApmForInstance.arriveInteraction(component);
        }
    }

    public void onRenderError(final String errCode, final String msg) {
        if (this.mRenderListener != null && this.mContext != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (WXSDKInstance.this.mRenderListener != null && WXSDKInstance.this.mContext != null) {
                        WXSDKInstance.this.mRenderListener.onException(WXSDKInstance.this, errCode, msg);
                    }
                }
            });
        }
    }

    public void onJSException(final String errCode, final String function, final String exception) {
        this.hasException = true;
        if (this.mRenderListener != null && this.mContext != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (WXSDKInstance.this.mRenderListener != null && WXSDKInstance.this.mContext != null) {
                        StringBuilder builder = new StringBuilder();
                        builder.append(function);
                        builder.append(exception);
                        WXSDKInstance.this.mRenderListener.onException(WXSDKInstance.this, errCode, builder.toString());
                    }
                }
            });
        }
    }

    public final void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        if (left != oldLeft || top != oldTop || right != oldRight || bottom != oldBottom) {
            this.onLayoutChange(v);
        }
    }

    public void onLayoutChange(View godView) {
    }

    public void firstScreenCreateInstanceTime(long time) {
        if (this.mCreateInstance) {
            this.mWXPerformance.firstScreenJSFExecuteTime = time - this.mRenderStartTime;
            this.mCreateInstance = false;
        }
    }

    public void callJsTime(long time) {
        if (!this.mEnd) {
            this.mWXPerformance.fsCallJsTotalTime += time;
            ++this.mWXPerformance.fsCallJsTotalNum;
        }
    }

    public void onComponentCreate(WXComponent component, long createTime) {
        ++this.mWXPerformance.mActionAddElementCount;
        this.mWXPerformance.mActionAddElementSumTime = (int)((long)this.mWXPerformance.mActionAddElementSumTime + createTime);
        if (!this.mEnd) {
            this.mWXPerformance.fsComponentCreateTime = (int)((long)this.mWXPerformance.fsComponentCreateTime + createTime);
            ++this.mWXPerformance.fsComponentCount;
        }
        ++this.mWXPerformance.componentCount;
        this.mWXPerformance.componentCreateTime += createTime;
    }

    public void callActionAddElementTime(long time) {
        this.mWXPerformance.mActionAddElementSumTime = (int)((long)this.mWXPerformance.mActionAddElementSumTime + time);
    }

    public void onOldFsRenderTimeLogic() {
        if (this.mEnd) {
            return;
        }
        this.mEnd = true;
        if (this.mStatisticsListener != null && this.mContext != null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (WXSDKInstance.this.mStatisticsListener != null && WXSDKInstance.this.mContext != null) {
                        Trace.beginSection("onFirstScreen");
                        WXSDKInstance.this.mStatisticsListener.onFirstScreen();
                        Trace.endSection();
                    }
                }
            });
        }
        this.mApmForInstance.arriveFSRenderTime();
        this.mWXPerformance.fsRenderTime = System.currentTimeMillis();
        this.mWXPerformance.screenRenderTime = System.currentTimeMillis() - this.mRenderStartTime;
    }

    public WXSDKInstance getParentInstance() {
        return this.mParentInstance;
    }

    public void setParentInstance(WXSDKInstance mParentInstance) {
        this.mParentInstance = mParentInstance;
    }

    private void destroyView(View rootView) {
        try {
            if (rootView instanceof ViewGroup) {
                ViewGroup cViewGroup = (ViewGroup)rootView;
                for (int index = 0; index < cViewGroup.getChildCount(); ++index) {
                    this.destroyView(cViewGroup.getChildAt(index));
                }
                cViewGroup.removeViews(0, ((ViewGroup)rootView).getChildCount());
                WXReflectionUtils.setValue(rootView, "mChildrenCount", 0);
            }
            if (rootView instanceof Destroyable) {
                ((Destroyable)rootView).destroy();
            }
        }
        catch (Exception e) {
            WXLogUtils.e("WXSDKInstance destroyView Exception: ", e);
        }
    }

    public synchronized void destroy() {
        if (!this.isDestroy()) {
            if (this.mParentInstance != null) {
                this.mParentInstance = null;
            }
            this.mApmForInstance.onEnd();
            if (this.mRendered) {
                WXSDKManager.getInstance().destroyInstance(this.mInstanceId);
            }
            if (this.mGlobalEventReceiver != null) {
                this.getContext().unregisterReceiver((BroadcastReceiver)this.mGlobalEventReceiver);
                this.mGlobalEventReceiver = null;
            }
            if (this.mRootComp != null) {
                this.mRootComp.destroy();
                this.destroyView((View)this.mRenderContainer);
                this.mRootComp = null;
            }
            if (this.mGlobalEvents != null) {
                this.mGlobalEvents.clear();
            }
            if (this.mComponentObserver != null) {
                this.mComponentObserver = null;
            }
            if (this.mLayerOverFlowListeners != null) {
                this.mLayerOverFlowListeners.clear();
            }
            this.getFlatUIContext().destroy();
            this.mFlatGUIContext = null;
            this.mInstanceOnFireEventInterceptorList = null;
            this.mWXScrollListeners = null;
            this.mWXActionbarHandlers = null;
            this.mWXBackPressedHandlers = null;
            this.mRenderContainer = null;
            this.mNestedInstanceInterceptor = null;
            this.mUserTrackAdapter = null;
            this.mScrollView = null;
            this.mContext = null;
            this.mRenderListener = null;
            this.isDestroy = true;
            this.mStatisticsListener = null;
            if (this.responseHeaders != null) {
                this.responseHeaders.clear();
            }
            if (this.templateRef != null) {
                this.templateRef = null;
            }
            if (null != this.mContentBoxMeasurements) {
                this.mContentBoxMeasurements.clear();
            }
            this.mWXPerformance.afterInstanceDestroy(this.mInstanceId);
            WXBridgeManager.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    WXBridgeManager.getInstance().onInstanceClose(WXSDKInstance.this.getInstanceId());
                    WXSDKInstance.this.inactiveAddElementAction.clear();
                }
            });
            WXBridgeManager.getInstance().postDelay(new Runnable(){

                @Override
                public void run() {
                    WXSDKManager.getInstance().getAllInstanceMap().remove(WXSDKInstance.this.mInstanceId);
                }
            }, 1000L);
        }
    }

    public boolean isDestroy() {
        return this.isDestroy;
    }

    @Nullable
    public String getBundleUrl() {
        return this.mBundleUrl;
    }

    public View getRootView() {
        if (this.mRootComp == null) {
            return null;
        }
        return this.mRootComp.getRealView();
    }

    public View getContainerView() {
        return this.mRenderContainer;
    }

    @Deprecated
    public void setBundleUrl(String url) {
        this.mBundleUrl = url;
        if (WXSDKManager.getInstance().getValidateProcessor() != null) {
            this.mNeedValidate = WXSDKManager.getInstance().getValidateProcessor().needValidate(this.mBundleUrl);
        }
    }

    public void onRootCreated(WXComponent root) {
        this.mRootComp = root;
        this.mRootComp.mDeepInComponentTree = 1;
        this.mRenderContainer.addView((View)root.getHostView());
        this.setSize(this.mRenderContainer.getWidth(), this.mRenderContainer.getHeight());
    }

    public void moveFixedView(View fixedChild) {
        if (this.mRenderContainer != null) {
            ViewGroup parent = (ViewGroup)fixedChild.getParent();
            if (parent != null) {
                if (parent != this.mRenderContainer) {
                    parent.removeView(fixedChild);
                    this.mRenderContainer.addView(fixedChild);
                }
            } else {
                this.mRenderContainer.addView(fixedChild);
            }
        }
    }

    public void removeFixedView(View fixedChild) {
        if (this.mRenderContainer != null) {
            this.mRenderContainer.removeView(fixedChild);
        }
    }

    public int getRenderContainerPaddingLeft() {
        if (this.mRenderContainer != null) {
            return this.mRenderContainer.getPaddingLeft();
        }
        return 0;
    }

    public int getRenderContainerPaddingRight() {
        if (this.mRenderContainer != null) {
            return this.mRenderContainer.getPaddingRight();
        }
        return 0;
    }

    public int getRenderContainerPaddingTop() {
        if (this.mRenderContainer != null) {
            return this.mRenderContainer.getPaddingTop();
        }
        return 0;
    }

    public synchronized List<OnWXScrollListener> getWXScrollListeners() {
        return this.mWXScrollListeners;
    }

    public synchronized void registerOnWXScrollListener(OnWXScrollListener wxScrollListener) {
        if (this.mWXScrollListeners == null) {
            this.mWXScrollListeners = new ArrayList<OnWXScrollListener>();
        }
        this.mWXScrollListeners.add(wxScrollListener);
    }

    public synchronized void registerActionbarHandler(ActionBarHandler actionBarHandler) {
        if (actionBarHandler == null) {
            return;
        }
        if (this.mWXActionbarHandlers == null) {
            this.mWXActionbarHandlers = new ArrayList<ActionBarHandler>();
        }
        this.mWXActionbarHandlers.add(actionBarHandler);
    }

    public synchronized void unRegisterActionbarHandler(ActionBarHandler actionBarHandler) {
        if (this.mWXActionbarHandlers != null && actionBarHandler != null) {
            this.mWXActionbarHandlers.remove(actionBarHandler);
        }
    }

    public synchronized void registerBackPressedHandler(OnBackPressedHandler backPressedHandler) {
        if (backPressedHandler == null) {
            return;
        }
        if (this.mWXBackPressedHandlers == null) {
            this.mWXBackPressedHandlers = new ArrayList<OnBackPressedHandler>();
        }
        this.mWXBackPressedHandlers.add(backPressedHandler);
    }

    public synchronized void unRegisterBackPressedHandler(OnBackPressedHandler backPressedHandler) {
        if (this.mWXBackPressedHandlers != null && backPressedHandler != null) {
            this.mWXBackPressedHandlers.remove(backPressedHandler);
        }
    }

    public void setSize(int width, int height) {
        if (width > 0 && height > 0 & !this.isDestroy && this.mRendered && this.mRenderContainer != null) {
            ViewGroup.LayoutParams layoutParams;
            if (sScreenHeight < 0) {
                sScreenHeight = WXViewUtils.getScreenHeight(this.getContext());
            }
            if (sScreenHeight > 0) {
                double screenRatio = (double)height / (double)sScreenHeight * 100.0;
                if (screenRatio > 100.0) {
                    screenRatio = 100.0;
                }
                this.getApmForInstance().addStats("wxBodyRatio", screenRatio);
            }
            if ((layoutParams = this.mRenderContainer.getLayoutParams()) != null) {
                final float realWidth = width;
                final float realHeight = height;
                if (this.mRenderContainer.getWidth() != width || this.mRenderContainer.getHeight() != height) {
                    layoutParams.width = width;
                    layoutParams.height = height;
                    this.mRenderContainer.setLayoutParams(layoutParams);
                }
                if (this.mRootComp != null && layoutParams != null) {
                    final boolean isWidthWrapContent = layoutParams.width == -2;
                    final boolean isHeightWrapContent = layoutParams.height == -2;
                    WXBridgeManager.getInstance().post(new Runnable(){

                        @Override
                        public void run() {
                            WXBridgeManager.getInstance().setDefaultRootSize(WXSDKInstance.this.getInstanceId(), realWidth, realHeight, isWidthWrapContent, isHeightWrapContent);
                        }
                    });
                }
            }
        }
    }

    public void fireGlobalEventCallback(String eventName, Map<String, Object> params) {
        List<String> callbacks = this.mGlobalEvents.get(eventName);
        if (callbacks != null) {
            for (String callback : callbacks) {
                WXSDKManager.getInstance().callback(this.mInstanceId, callback, params, true);
            }
        }
    }

    public void fireEvent(String elementRef, String type, Map<String, Object> data, Map<String, Object> domChanges, List<Object> eventArgs) {
        this.fireEvent(elementRef, type, data, domChanges, eventArgs, null);
    }

    public void fireEvent(String elementRef, String type, Map<String, Object> data, Map<String, Object> domChanges, List<Object> eventArgs, EventResult callback) {
        this.onInterceptInstanceEvent(this.getInstanceId(), elementRef, type, data, domChanges);
        if (null != this.mWXPerformance && this.mWXPerformance.fsCallEventTotalNum < Integer.MAX_VALUE) {
            ++this.mWXPerformance.fsCallEventTotalNum;
        }
        this.mApmForInstance.updateFSDiffStats("wxFSCallEventTotalNum", 1.0);
        WXBridgeManager.getInstance().fireEventOnNode(this.getInstanceId(), elementRef, type, data, domChanges, eventArgs, callback);
    }

    public void fireEvent(String elementRef, String type, Map<String, Object> data, Map<String, Object> domChanges) {
        this.fireEvent(elementRef, type, data, domChanges, null);
    }

    public void fireEvent(String elementRef, String type, Map<String, Object> data) {
        this.fireEvent(elementRef, type, data, null);
    }

    public void fireEvent(String ref, String type) {
        this.fireEvent(ref, type, new HashMap<String, Object>());
    }

    protected void addEventListener(String eventName, String callback) {
        if (TextUtils.isEmpty((CharSequence)eventName) || TextUtils.isEmpty((CharSequence)callback)) {
            return;
        }
        List<String> callbacks = this.mGlobalEvents.get(eventName);
        if (callbacks == null) {
            callbacks = new ArrayList<String>();
            this.mGlobalEvents.put(eventName, callbacks);
        }
        callbacks.add(callback);
    }

    protected void removeEventListener(String eventName, String callback) {
        if (TextUtils.isEmpty((CharSequence)eventName) || TextUtils.isEmpty((CharSequence)callback)) {
            return;
        }
        List<String> callbacks = this.mGlobalEvents.get(eventName);
        if (callbacks != null) {
            callbacks.remove(callback);
        }
    }

    protected void removeEventListener(String eventName) {
        if (TextUtils.isEmpty((CharSequence)eventName)) {
            return;
        }
        this.mGlobalEvents.remove(eventName);
    }

    public void fireModuleEvent(String eventName, WXModule module, Map<String, Object> params) {
        if (TextUtils.isEmpty((CharSequence)eventName) || module == null) {
            return;
        }
        HashMap<String, Object> event = new HashMap<String, Object>();
        event.put("type", eventName);
        event.put("module", module.getModuleName());
        event.put("data", params);
        List<String> callbacks = module.getEventCallbacks(eventName);
        if (callbacks != null) {
            for (String callback : callbacks) {
                SimpleJSCallback jsCallback = new SimpleJSCallback(this.mInstanceId, callback);
                if (module.isOnce(callback)) {
                    jsCallback.invoke(event);
                    continue;
                }
                jsCallback.invokeAndKeepAlive(event);
            }
        }
    }

    public boolean checkModuleEventRegistered(String eventName, WXModule module) {
        List<String> events;
        return module != null && (events = module.getEventCallbacks(eventName)) != null && events.size() > 0;
    }

    public WXPerformance getWXPerformance() {
        return this.mWXPerformance;
    }

    public WXInstanceApm getApmForInstance() {
        return this.mApmForInstance;
    }

    public Map<String, Serializable> getUserTrackParams() {
        return this.mUserTrackParams;
    }

    public void addUserTrackParameter(String key, Serializable value) {
        if (this.mUserTrackParams == null) {
            this.mUserTrackParams = new ConcurrentHashMap<String, Serializable>();
        }
        this.mUserTrackParams.put(key, value);
    }

    public void clearUserTrackParameters() {
        if (this.mUserTrackParams != null) {
            this.mUserTrackParams.clear();
        }
    }

    public void removeUserTrackParameter(String key) {
        if (this.mUserTrackParams != null) {
            this.mUserTrackParams.remove(key);
        }
    }

    public int getMaxDeepLayer() {
        return this.mMaxDeepLayer;
    }

    public void setMaxDeepLayer(int maxDeepLayer) {
        this.mMaxDeepLayer = maxDeepLayer;
        this.mApmForInstance.updateMaxStats("wxMaxDeepViewLayer", maxDeepLayer);
    }

    public void setMaxDomDeep(int maxDomDeep) {
        this.mApmForInstance.updateMaxStats("wxMaxDeepVDomLayer", maxDomDeep);
        if (null == this.mWXPerformance) {
            return;
        }
        if (this.mWXPerformance.maxDeepVDomLayer <= maxDomDeep) {
            this.mWXPerformance.maxDeepVDomLayer = maxDomDeep;
        }
    }

    public void onHttpStart() {
        if (!this.mEnd) {
            ++this.mWXPerformance.fsRequestNum;
        }
    }

    public String getTemplateInfo() {
        String template = this.getTemplate();
        if (template == null) {
            return " template md5 null ,httpHeader:" + JSONObject.toJSONString(this.responseHeaders);
        }
        if (TextUtils.isEmpty((CharSequence)template)) {
            return " template md5  length 0 ,httpHeader" + JSONObject.toJSONString(this.responseHeaders);
        }
        try {
            byte[] bts = template.getBytes("UTF-8");
            String sourceMD5 = WXFileUtils.md5(bts);
            String sourceBase64MD5 = WXFileUtils.base64Md5(bts);
            ArrayList<String> sourceMD5List = new ArrayList<String>();
            ArrayList<String> sourceBase64MD5List = new ArrayList<String>();
            sourceMD5List.add(sourceMD5);
            sourceBase64MD5List.add(sourceBase64MD5);
            this.responseHeaders.put("templateSourceMD5", sourceMD5List);
            this.responseHeaders.put(SOURCE_TEMPLATE_BASE64_MD5, sourceBase64MD5List);
            return " template md5 " + sourceMD5 + " length " + bts.length + " base64 md5 " + sourceBase64MD5 + " response header " + JSONObject.toJSONString(this.responseHeaders);
        }
        catch (Exception e) {
            return "template md5 getBytes error";
        }
    }

    public boolean isContentMd5Match() {
        if (this.responseHeaders == null) {
            return true;
        }
        List<String> contentMD5s = this.responseHeaders.get("Content-Md5");
        if (contentMD5s == null) {
            contentMD5s = this.responseHeaders.get("content-md5");
        }
        if (contentMD5s == null || contentMD5s.size() <= 0) {
            return true;
        }
        String md5 = contentMD5s.get(0);
        List<String> sourceBase64Md5 = this.responseHeaders.get(SOURCE_TEMPLATE_BASE64_MD5);
        if (sourceBase64Md5 == null) {
            this.getTemplateInfo();
            sourceBase64Md5 = this.responseHeaders.get(SOURCE_TEMPLATE_BASE64_MD5);
        }
        if (sourceBase64Md5 == null || sourceBase64Md5.size() == 0) {
            return true;
        }
        return md5.equals(sourceBase64Md5.get(0));
    }

    public String getTemplate() {
        if (this.templateRef == null) {
            return null;
        }
        return (String)this.templateRef.get();
    }

    public void setTemplate(String template) {
        this.templateRef = new WeakReference<String>(template);
    }

    public void OnVSync() {
        boolean forceLayout = WXBridgeManager.getInstance().notifyLayout(this.getInstanceId());
        if (forceLayout) {
            WXBridgeManager.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    WXBridgeManager.getInstance().forceLayout(WXSDKInstance.this.getInstanceId());
                }
            });
        }
    }

    public void addContentBoxMeasurement(long renderObjectPtr, ContentBoxMeasurement contentBoxMeasurement) {
        this.mContentBoxMeasurements.put(renderObjectPtr, contentBoxMeasurement);
    }

    public ContentBoxMeasurement getContentBoxMeasurement(long renderObjectPtr) {
        return this.mContentBoxMeasurements.get(renderObjectPtr);
    }

    private void onInterceptInstanceEvent(String instanceId, String elementRef, String type, Map<String, Object> data, Map<String, Object> domChanges) {
        if (this.mInstanceOnFireEventInterceptorList == null) {
            return;
        }
        for (InstanceOnFireEventInterceptor instanceOnFireEventInterceptor : this.mInstanceOnFireEventInterceptorList) {
            instanceOnFireEventInterceptor.onInterceptFireEvent(instanceId, elementRef, type, data, domChanges);
        }
    }

    public List<InstanceOnFireEventInterceptor> getInstanceOnFireEventInterceptorList() {
        if (this.mInstanceOnFireEventInterceptorList == null) {
            this.mInstanceOnFireEventInterceptorList = new ArrayList<InstanceOnFireEventInterceptor>();
        }
        return this.mInstanceOnFireEventInterceptorList;
    }

    public void addInstanceOnFireEventInterceptor(InstanceOnFireEventInterceptor instanceOnFireEventInterceptor) {
        if (instanceOnFireEventInterceptor == null) {
            return;
        }
        if (!this.getInstanceOnFireEventInterceptorList().contains(instanceOnFireEventInterceptor)) {
            this.getInstanceOnFireEventInterceptorList().add(instanceOnFireEventInterceptor);
        }
    }

    private static boolean isDisableSkipFrameworkInDataRender() {
        IWXConfigAdapter adapter = WXSDKManager.getInstance().getWxConfigAdapter();
        if (adapter == null) {
            return false;
        }
        String result = adapter.getConfig("wxeagle", "disable_skip_framework_init", "false");
        return "true".equals(result);
    }

    public static interface NestedInstanceInterceptor {
        public void onCreateNestInstance(WXSDKInstance var1, NestedContainer var2);
    }

    public static interface OnInstanceVisibleListener {
        public void onAppear();

        public void onDisappear();
    }

    public static interface OnBackPressedHandler {
        public boolean onBackPressed();
    }

    public static interface ActionBarHandler {
        public boolean onSupportNavigateUp();
    }

    public static interface CustomFontNetworkHandler {
        public String fetchLocal(String var1);
    }

    public static interface StreamNetworkHandler {
        public String fetchLocal(String var1);
    }

    public static interface ImageNetworkHandler {
        public String fetchLocal(String var1);
    }
}

