/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Looper;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.support.v4.util.LruCache;
import android.text.TextUtils;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;

public class WXUtils {
    static final LruCache<String, Integer> sCache = new LruCache(64);
    public static final char PERCENT = '%';
    private static final int HUNDRED = 100;
    private static final long sInterval = System.currentTimeMillis() - SystemClock.uptimeMillis();

    public static boolean isUiThread() {
        return Thread.currentThread().getId() == Looper.getMainLooper().getThread().getId();
    }

    public static boolean isUndefined(float value) {
        return Float.isNaN(value);
    }

    public static float getFloatByViewport(Object value, int viewport) {
        block14: {
            if (value == null) {
                return Float.NaN;
            }
            String temp = value.toString().trim();
            if ("auto".equals(temp) || "undefined".equals(temp) || TextUtils.isEmpty((CharSequence)temp)) {
                WXLogUtils.e("Argument Warning ! value is " + temp + "And default Value:" + Float.NaN);
                return Float.NaN;
            }
            if (temp.endsWith("wx")) {
                try {
                    return WXUtils.transferWx(temp, viewport);
                }
                catch (NumberFormatException e) {
                    WXLogUtils.e("Argument format error! value is " + value, e);
                    break block14;
                }
                catch (Exception e) {
                    WXLogUtils.e("Argument error! value is " + value, e);
                    break block14;
                }
            }
            if (temp.endsWith("px")) {
                try {
                    temp = temp.substring(0, temp.indexOf("px"));
                    return Float.parseFloat(temp);
                }
                catch (NumberFormatException nfe) {
                    WXLogUtils.e("Argument format error! value is " + value, nfe);
                }
                catch (Exception e) {
                    WXLogUtils.e("Argument error! value is " + value, e);
                }
            } else {
                try {
                    return Float.parseFloat(temp);
                }
                catch (NumberFormatException nfe) {
                    WXLogUtils.e("Argument format error! value is " + value, nfe);
                }
                catch (Exception e) {
                    WXLogUtils.e("Argument error! value is " + value, e);
                }
            }
        }
        return Float.NaN;
    }

    public static float getFloat(Object value) {
        return WXUtils.getFloat(value, Float.valueOf(Float.NaN)).floatValue();
    }

    public static Float getFloat(Object value, @Nullable Float df) {
        block14: {
            if (value == null) {
                return df;
            }
            String temp = value.toString().trim();
            if ("auto".equals(temp) || "undefined".equals(temp) || TextUtils.isEmpty((CharSequence)temp)) {
                WXLogUtils.e("Argument Warning ! value is " + temp + "And default Value:" + Float.NaN);
                return df;
            }
            if (temp.endsWith("wx")) {
                try {
                    return Float.valueOf(WXUtils.transferWx(temp, 750));
                }
                catch (NumberFormatException e) {
                    WXLogUtils.e("Argument format error! value is " + value, e);
                    break block14;
                }
                catch (Exception e) {
                    WXLogUtils.e("Argument error! value is " + value, e);
                    break block14;
                }
            }
            if (temp.endsWith("px")) {
                try {
                    temp = temp.substring(0, temp.indexOf("px"));
                    return Float.valueOf(Float.parseFloat(temp));
                }
                catch (NumberFormatException nfe) {
                    WXLogUtils.e("Argument format error! value is " + value, nfe);
                }
                catch (Exception e) {
                    WXLogUtils.e("Argument error! value is " + value, e);
                }
            } else {
                try {
                    return Float.valueOf(Float.parseFloat(temp));
                }
                catch (NumberFormatException nfe) {
                    WXLogUtils.e("Argument format error! value is " + value, nfe);
                }
                catch (Exception e) {
                    WXLogUtils.e("Argument error! value is " + value, e);
                }
            }
        }
        return df;
    }

    private static float transferWx(String stringWithWXPostfix, int viewport) {
        if (null == stringWithWXPostfix) {
            return 0.0f;
        }
        String temp = stringWithWXPostfix;
        if (stringWithWXPostfix.endsWith("wx")) {
            temp = stringWithWXPostfix.substring(0, stringWithWXPostfix.indexOf("wx"));
        }
        Float f = Float.valueOf(Float.parseFloat(temp));
        float density = Float.parseFloat(WXEnvironment.getConfig().get("scale"));
        return density * f.floatValue() * (float)viewport / (float)WXViewUtils.getScreenWidth();
    }

    public static float fastGetFloat(String raw, int precision) {
        if (!TextUtils.isEmpty((CharSequence)raw)) {
            char digit;
            boolean positive = true;
            int loc = 0;
            if (raw.charAt(0) == '-') {
                positive = false;
                ++loc;
            } else if (raw.charAt(0) == '+') {
                ++loc;
            }
            float result = 0.0f;
            while (loc < raw.length() && (digit = raw.charAt(loc)) >= '0' && digit <= '9') {
                result = result * 10.0f + (float)digit - 48.0f;
                ++loc;
            }
            if (loc < raw.length() && raw.charAt(loc) == '.') {
                ++loc;
                int remainderLength = 10;
                for (int counter = 0; loc < raw.length() && counter < precision && (digit = raw.charAt(loc)) >= '0' && digit <= '9'; ++loc, ++counter) {
                    result += (float)(digit - 48) / (float)remainderLength;
                    remainderLength *= 10;
                }
            }
            if (!positive) {
                result *= -1.0f;
            }
            return result;
        }
        return 0.0f;
    }

    public static float fastGetFloat(String raw) {
        return WXUtils.fastGetFloat(raw, Integer.MAX_VALUE);
    }

    public static int parseInt(String value) {
        block3: {
            try {
                if (!TextUtils.isEmpty((CharSequence)value) && !value.contains(".")) {
                    return Integer.parseInt(value);
                }
            }
            catch (NumberFormatException e) {
                if (!WXEnvironment.isApkDebugable()) break block3;
                WXLogUtils.e(WXLogUtils.getStackTrace(e));
            }
        }
        return 0;
    }

    public static int parseInt(Object value) {
        return WXUtils.parseInt(String.valueOf(value));
    }

    public static float parseFloat(Object value) {
        return WXUtils.parseFloat(String.valueOf(value));
    }

    public static float parseFloat(String value) {
        block4: {
            try {
                if (!TextUtils.isEmpty((CharSequence)value) && !TextUtils.equals((CharSequence)value, (CharSequence)"null")) {
                    return Float.parseFloat(value);
                }
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.e("WXUtils parseFloat illegal value is " + value);
                }
            }
            catch (NumberFormatException e) {
                if (!WXEnvironment.isApkDebugable()) break block4;
                WXLogUtils.e(WXLogUtils.getStackTrace(e));
            }
        }
        return 0.0f;
    }

    public static int getInt(Object value) {
        return WXUtils.getInteger(value, 0);
    }

    public static Integer getInteger(@Nullable Object value, @Nullable Integer df) {
        Integer ret;
        String key;
        block22: {
            if (value == null) {
                return df;
            }
            String temp = value.toString().trim();
            key = temp;
            Integer cache = (Integer)sCache.get((Object)key);
            if (cache != null) {
                return cache;
            }
            ret = df;
            String suffix = "";
            if (temp.length() >= 2) {
                suffix = temp.substring(temp.length() - 2, temp.length());
            }
            if (TextUtils.equals((CharSequence)"wx", (CharSequence)suffix)) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.w("the value of " + value + " use wx unit, which will be not supported soon after.");
                }
                try {
                    ret = (int)WXUtils.transferWx(temp, 750);
                }
                catch (NumberFormatException e) {
                    WXLogUtils.e("Argument format error! value is " + value, e);
                }
                catch (Exception e) {
                    WXLogUtils.e("Argument error! value is " + value, e);
                }
            } else if (TextUtils.equals((CharSequence)"px", (CharSequence)suffix)) {
                try {
                    temp = temp.substring(0, temp.length() - 2);
                    if (!TextUtils.isEmpty((CharSequence)temp) && temp.contains(".")) {
                        ret = (int)WXUtils.parseFloat(temp);
                        break block22;
                    }
                    ret = Integer.parseInt(temp);
                }
                catch (NumberFormatException nfe) {
                    WXLogUtils.e("Argument format error! value is " + value, nfe);
                }
                catch (Exception e) {
                    WXLogUtils.e("Argument error! value is " + value, e);
                }
            } else {
                try {
                    if (!TextUtils.isEmpty((CharSequence)temp)) {
                        ret = temp.contains(".") ? Integer.valueOf((int)WXUtils.parseFloat(temp)) : Integer.valueOf(Integer.parseInt(temp));
                    } else if (WXEnvironment.isApkDebugable()) {
                        WXLogUtils.e("Argument value is null, df is" + df);
                    }
                }
                catch (NumberFormatException nfe) {
                    WXLogUtils.e("Argument format error! value is " + value, nfe);
                }
                catch (Exception e) {
                    WXLogUtils.e("Argument error! value is " + value, e);
                }
            }
        }
        if (!ret.equals(df)) {
            sCache.put((Object)key, (Object)ret);
        }
        return ret;
    }

    @Deprecated
    public static long getLong(Object value) {
        long result;
        block14: {
            if (value == null) {
                return 0L;
            }
            result = 0L;
            String temp = value.toString().trim();
            if (temp.endsWith("wx")) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.w("the value of " + value + " use wx unit, which will be not supported soon after.");
                }
                try {
                    return (long)WXUtils.transferWx(temp, 750);
                }
                catch (NumberFormatException e) {
                    WXLogUtils.e("Argument format error! value is " + value, e);
                    break block14;
                }
                catch (Exception e) {
                    WXLogUtils.e("Argument error! value is " + value, e);
                    break block14;
                }
            }
            if (temp.endsWith("px")) {
                try {
                    temp = temp.substring(0, temp.indexOf("px"));
                    return Long.parseLong(temp);
                }
                catch (NumberFormatException nfe) {
                    WXLogUtils.e("Argument format error! value is " + value, nfe);
                }
                catch (Exception e) {
                    WXLogUtils.e("Argument error! value is " + value, e);
                }
            } else {
                try {
                    return Long.parseLong(temp);
                }
                catch (NumberFormatException nfe) {
                    WXLogUtils.e("Argument format error! value is " + value, nfe);
                }
                catch (Exception e) {
                    WXLogUtils.e("Argument error! value is " + value, e);
                }
            }
        }
        return result;
    }

    @Deprecated
    public static double getDouble(Object value) {
        double result;
        block14: {
            if (value == null) {
                return 0.0;
            }
            result = 0.0;
            String temp = value.toString().trim();
            if (temp.endsWith("wx")) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.w("the value of " + value + " use wx unit, which will be not supported soon after.");
                }
                try {
                    return WXUtils.transferWx(temp, 750);
                }
                catch (NumberFormatException e) {
                    WXLogUtils.e("Argument format error! value is " + value, e);
                    break block14;
                }
                catch (Exception e) {
                    WXLogUtils.e("Argument error! value is " + value, e);
                    break block14;
                }
            }
            if (temp.endsWith("px")) {
                try {
                    temp = temp.substring(0, temp.indexOf("px"));
                    return Double.parseDouble(temp);
                }
                catch (NumberFormatException nfe) {
                    WXLogUtils.e("Argument format error! value is " + value, nfe);
                }
                catch (Exception e) {
                    WXLogUtils.e("Argument error! value is " + value, e);
                }
            } else {
                try {
                    return Double.parseDouble(temp);
                }
                catch (NumberFormatException nfe) {
                    WXLogUtils.e("Argument format error! value is " + value, nfe);
                }
                catch (Exception e) {
                    WXLogUtils.e("Argument error! value is " + value, e);
                }
            }
        }
        return result;
    }

    @Deprecated
    public static boolean isTabletDevice() {
        try {
            return (WXEnvironment.getApplication().getResources().getConfiguration().screenLayout & 0xF) >= 3;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Boolean getBoolean(@Nullable Object value, @Nullable Boolean df) {
        if (value == null) {
            return df;
        }
        if (TextUtils.equals((CharSequence)"false", (CharSequence)value.toString())) {
            return false;
        }
        if (TextUtils.equals((CharSequence)"true", (CharSequence)value.toString())) {
            return true;
        }
        return df;
    }

    public static long getAvailMemory(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        am.getMemoryInfo(mi);
        WXLogUtils.w("app AvailMemory ---->>>" + mi.availMem / 0x100000L);
        return mi.availMem / 0x100000L;
    }

    public static String getString(@Nullable Object value, @Nullable String df) {
        if (value == null) {
            return df;
        }
        String originValue = value instanceof String ? (String)value : value.toString();
        return originValue;
    }

    public static int parseUnitOrPercent(String raw, int unit) {
        int suffix = raw.lastIndexOf(37);
        if (suffix != -1) {
            return WXUtils.parsePercent(raw.substring(0, suffix), unit);
        }
        return WXUtils.parseInt(raw);
    }

    private static int parsePercent(String raw, int unit) {
        return (int)(Float.parseFloat(raw) / 100.0f * (float)unit);
    }

    public static String getBundleBanner(String content) {
        String[] items;
        String commentBegin = "/*!";
        String commentEnd = "!*/";
        String asteriskRegex = "\\*";
        String replacement = "";
        int offsetCountBegin = content.indexOf("/*!");
        if (offsetCountBegin == -1) {
            return null;
        }
        int offsetCountEnd = WXUtils.indexLineBreak(content, offsetCountBegin += "/*!".length());
        if (offsetCountEnd == -1) {
            return null;
        }
        String countStr = content.substring(offsetCountBegin, offsetCountEnd);
        int count = Integer.parseInt(countStr);
        String commentBody = content.substring(offsetCountEnd + 1, offsetCountEnd + 1 + count);
        int offsetBodyEnd = commentBody.lastIndexOf("!*/");
        if (offsetBodyEnd == -1) {
            return null;
        }
        commentBody = commentBody.substring(0, offsetBodyEnd);
        StringBuilder commentBodyBuilder = new StringBuilder();
        for (String item : items = WXUtils.splitLineBreak(commentBody)) {
            commentBodyBuilder.append(item.replaceFirst("\\*", ""));
        }
        return commentBodyBuilder.toString();
    }

    private static int indexLineBreak(String str, int fromIndex) {
        String lineBreakIos = "\r";
        String lineBreakUnix = "\n";
        String linebreakWin = "\r\n";
        int index = str.indexOf("\r", fromIndex);
        if (index == -1) {
            index = str.indexOf("\n", fromIndex);
        }
        if (index == -1) {
            index = str.indexOf("\r\n", fromIndex);
        }
        return index;
    }

    private static String[] splitLineBreak(String str) {
        String lineBreakIos = "\r";
        String lineBreakUnix = "\n";
        String linebreakWin = "\r\n";
        String[] items = str.split("\r");
        if (items.length == 1) {
            items = str.split("\n");
        }
        if (items.length == 1) {
            items = str.split("\r\n");
        }
        return items;
    }

    public static int getNumberInt(Object value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            String number = value.toString();
            if (number.indexOf(46) >= 0) {
                return (int)Float.parseFloat(value.toString());
            }
            return Integer.parseInt(number);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static long getFixUnixTime() {
        return sInterval + SystemClock.uptimeMillis();
    }
}

