/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.utils.LogLevel;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class WXLogUtils {
    public static final String WEEX_TAG = "weex";
    public static final String WEEX_PERF_TAG = "weex_perf";
    private static final String CLAZZ_NAME_LOG_UTIL = "com.taobao.weex.devtools.common.LogUtil";
    private static StringBuilder builder = new StringBuilder(50);
    private static HashMap<String, Class> clazzMaps = new HashMap(2);
    private static List<JsLogWatcher> jsLogWatcherList;
    private static LogWatcher sLogWatcher;

    private static Class loadClass(String clazzName) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(clazzName);
            if (clazz != null) {
                clazzMaps.put(clazzName, clazz);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    public static void renderPerformanceLog(String type, long time) {
        if (WXEnvironment.isApkDebugable() || WXEnvironment.isPerf()) {
            // empty if block
        }
    }

    private static void log(String tag, String msg, LogLevel level) {
        if (TextUtils.isEmpty((CharSequence)msg) || TextUtils.isEmpty((CharSequence)tag) || level == null || TextUtils.isEmpty((CharSequence)level.getName())) {
            return;
        }
        if (sLogWatcher != null) {
            sLogWatcher.onLog(level.getName(), tag, msg);
        }
        if (WXEnvironment.isApkDebugable()) {
            Log.println((int)level.getPriority(), (String)tag, (String)msg);
            if (!level.getName().equals("debug")) {
                WXLogUtils.writeConsoleLog(level.getName(), msg);
            }
        } else if (level.getPriority() - LogLevel.WARN.getPriority() >= 0) {
            Log.println((int)level.getPriority(), (String)tag, (String)msg);
        }
    }

    public static void d(String msg) {
        WXLogUtils.d(WEEX_TAG, msg);
    }

    public static void i(String msg) {
        WXLogUtils.i(WEEX_TAG, msg);
    }

    public static void info(String msg) {
        WXLogUtils.i(WEEX_TAG, msg);
    }

    public static void v(String msg) {
        WXLogUtils.v(WEEX_TAG, msg);
    }

    public static void w(String msg) {
        WXLogUtils.w(WEEX_TAG, msg);
    }

    public static void e(String msg) {
        WXLogUtils.e(WEEX_TAG, msg);
    }

    public static void d(String tag, byte[] msg) {
        WXLogUtils.d(tag, new String(msg));
    }

    public static void wtf(String msg) {
        WXLogUtils.wtf(WEEX_TAG, msg);
    }

    public static void d(String tag, String msg) {
        if (!TextUtils.isEmpty((CharSequence)tag) && !TextUtils.isEmpty((CharSequence)msg)) {
            WXLogUtils.log(tag, msg, LogLevel.DEBUG);
            if (WXEnvironment.isApkDebugable()) {
                String[] msgs;
                if ("jsLog".equals(tag) && jsLogWatcherList != null && jsLogWatcherList.size() > 0) {
                    for (JsLogWatcher jsLogWatcher : jsLogWatcherList) {
                        if (msg.endsWith("__DEBUG")) {
                            jsLogWatcher.onJsLog(3, msg.replace("__DEBUG", ""));
                            continue;
                        }
                        if (msg.endsWith("__INFO")) {
                            jsLogWatcher.onJsLog(3, msg.replace("__INFO", ""));
                            continue;
                        }
                        if (msg.endsWith("__WARN")) {
                            jsLogWatcher.onJsLog(3, msg.replace("__WARN", ""));
                            continue;
                        }
                        if (msg.endsWith("__ERROR")) {
                            jsLogWatcher.onJsLog(3, msg.replace("__ERROR", ""));
                            continue;
                        }
                        jsLogWatcher.onJsLog(3, msg);
                    }
                }
                WXLogUtils.writeConsoleLog("debug", tag + ":" + msg);
                if (msg.contains(" | __") && (msgs = msg.split(" | __")) != null && msgs.length == 4 && !TextUtils.isEmpty((CharSequence)msgs[0]) && !TextUtils.isEmpty((CharSequence)msgs[2])) {
                    LogLevel level = WXLogUtils.getLogLevel(msgs[2]);
                    return;
                }
            }
        }
    }

    private static LogLevel getLogLevel(String level) {
        switch (level.trim()) {
            case "__ERROR": {
                return LogLevel.ERROR;
            }
            case "__WARN": {
                return LogLevel.WARN;
            }
            case "__INFO": {
                return LogLevel.INFO;
            }
            case "__LOG": {
                return LogLevel.INFO;
            }
            case "__DEBUG": {
                return LogLevel.DEBUG;
            }
        }
        return LogLevel.DEBUG;
    }

    public static void i(String tag, String msg) {
        WXLogUtils.log(tag, msg, LogLevel.INFO);
    }

    public static void v(String tag, String msg) {
        WXLogUtils.log(tag, msg, LogLevel.VERBOSE);
    }

    public static void w(String tag, String msg) {
        WXLogUtils.log(tag, msg, LogLevel.WARN);
    }

    public static void e(String tag, String msg) {
        WXLogUtils.log(tag, msg, LogLevel.ERROR);
    }

    public static void wtf(String tag, String msg) {
        WXLogUtils.log(tag, msg, LogLevel.WTF);
    }

    public static void p(String msg) {
        WXLogUtils.d(WEEX_PERF_TAG, msg);
    }

    public static void d(String prefix, Throwable e) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(prefix + WXLogUtils.getStackTrace(e));
        }
    }

    public static void i(String prefix, Throwable e) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.info(prefix + WXLogUtils.getStackTrace(e));
        }
    }

    public static void v(String prefix, Throwable e) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.v(prefix + WXLogUtils.getStackTrace(e));
        }
    }

    public static void w(String prefix, Throwable e) {
        WXLogUtils.w(prefix + WXLogUtils.getStackTrace(e));
    }

    public static void e(String prefix, Throwable e) {
        WXLogUtils.e(prefix + WXLogUtils.getStackTrace(e));
    }

    public static void wtf(String prefix, Throwable e) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.wtf(prefix + WXLogUtils.getStackTrace(e));
        }
    }

    public static void p(String prefix, Throwable e) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.p(prefix + WXLogUtils.getStackTrace(e));
        }
    }

    public static void eTag(String tag, Throwable e) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.e(tag, WXLogUtils.getStackTrace(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTrace(@Nullable Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            sw.flush();
        }
        finally {
            if (sw != null) {
                try {
                    sw.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (pw != null) {
                pw.close();
            }
        }
        return sw.toString();
    }

    private static void writeConsoleLog(String level, String message) {
        if (WXEnvironment.isApkDebugable()) {
            try {
                Class clazz = clazzMaps.get(CLAZZ_NAME_LOG_UTIL);
                if (clazz != null) {
                    Method m = clazz.getMethod("log", String.class, String.class);
                    m.invoke((Object)clazz, level, message);
                }
            }
            catch (Exception e) {
                Log.d((String)WEEX_TAG, (String)"LogUtil not found!");
            }
        }
    }

    public static void setJsLogWatcher(JsLogWatcher watcher) {
        if (!jsLogWatcherList.contains(watcher)) {
            jsLogWatcherList.add(watcher);
        }
    }

    public static void setLogWatcher(LogWatcher watcher) {
        sLogWatcher = watcher;
    }

    static {
        clazzMaps.put(CLAZZ_NAME_LOG_UTIL, WXLogUtils.loadClass(CLAZZ_NAME_LOG_UTIL));
        jsLogWatcherList = new ArrayList<JsLogWatcher>();
    }

    public static interface LogWatcher {
        public void onLog(String var1, String var2, String var3);
    }

    public static interface JsLogWatcher {
        public void onJsLog(int var1, String var2);
    }
}

