/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.bridge;

import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.Invoker;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.bridge.MethodInvoker;
import com.taobao.weex.bridge.SimpleJSCallback;
import com.taobao.weex.performance.WXAnalyzerDataTransfer;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXReflectionUtils;
import java.lang.reflect.Type;

public class NativeInvokeHelper {
    private String mInstanceId;

    public NativeInvokeHelper(String instanceId) {
        this.mInstanceId = instanceId;
    }

    public Object invoke(final Object target, final Invoker invoker, JSONArray args) throws Exception {
        final Object[] params = this.prepareArguments(invoker.getParameterTypes(), args);
        if (WXAnalyzerDataTransfer.isInteractionLogOpen() && invoker instanceof MethodInvoker) {
            for (int i = 0; i < params.length; ++i) {
                if (!(params[i] instanceof SimpleJSCallback)) continue;
                final String callBackId = ((SimpleJSCallback)params[i]).getCallbackId();
                Log.d((String)"wxInteractionAnalyzer", (String)("[client][callNativeModuleStart]," + this.mInstanceId + "," + ((MethodInvoker)invoker).mMethod.getDeclaringClass() + "," + ((MethodInvoker)invoker).mMethod.getName() + "," + callBackId));
                ((SimpleJSCallback)params[i]).setInvokerCallback(new SimpleJSCallback.InvokerCallback(){

                    @Override
                    public void onInvokeSuccess() {
                        Log.d((String)"wxInteractionAnalyzer", (String)("[client][callNativeModuleEnd]," + NativeInvokeHelper.this.mInstanceId + "," + ((MethodInvoker)invoker).mMethod.getDeclaringClass() + "," + ((MethodInvoker)invoker).mMethod.getName() + "," + callBackId));
                    }
                });
                break;
            }
        }
        if (!invoker.isRunOnUIThread()) {
            return invoker.invoke(target, params);
        }
        WXSDKManager.getInstance().postOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (invoker != null) {
                    try {
                        WXSDKInstance targetInstance = WXSDKManager.getInstance().getSDKInstance(NativeInvokeHelper.this.mInstanceId);
                        if (null == targetInstance || targetInstance.isDestroy()) {
                            return;
                        }
                        invoker.invoke(target, params);
                    }
                    catch (Exception e) {
                        WXLogUtils.e("NativeInvokeHelper", target + " Invoker " + invoker.toString() + " exception:" + e);
                    }
                }
            }
        }, 0L);
        return null;
    }

    protected Object[] prepareArguments(Type[] paramClazzs, JSONArray args) throws Exception {
        Object[] params = new Object[paramClazzs.length];
        for (int i = 0; i < paramClazzs.length; ++i) {
            Type paramClazz = paramClazzs[i];
            if (i >= args.size()) {
                if (!paramClazz.getClass().isPrimitive()) {
                    params[i] = null;
                    continue;
                }
                throw new Exception("[prepareArguments] method argument list not match.");
            }
            Object value = args.get(i);
            if (paramClazz == JSONObject.class) {
                if (value instanceof JSONObject || value == null) {
                    params[i] = value;
                    continue;
                }
                if (!(value instanceof String)) continue;
                params[i] = JSON.parseObject((String)value.toString());
                continue;
            }
            if (JSCallback.class == paramClazz) {
                if (value instanceof String) {
                    params[i] = new SimpleJSCallback(this.mInstanceId, (String)value);
                    continue;
                }
                throw new Exception("Parameter type not match.");
            }
            params[i] = WXReflectionUtils.parseArgument(paramClazz, value);
        }
        return params;
    }
}

