/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.appfram.storage;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import android.support.annotation.Nullable;
import com.taobao.weex.appfram.storage.IWXStorageAdapter;
import com.taobao.weex.appfram.storage.StorageResultHandler;
import com.taobao.weex.appfram.storage.WXSQLiteOpenHelper;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.utils.WXLogUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DefaultWXStorage
implements IWXStorageAdapter {
    private WXSQLiteOpenHelper mDatabaseSupplier;
    private ExecutorService mExecutorService;

    private void execute(@Nullable Runnable runnable) {
        if (this.mExecutorService == null) {
            this.mExecutorService = Executors.newSingleThreadExecutor();
        }
        if (runnable != null && !this.mExecutorService.isShutdown() && !this.mExecutorService.isTerminated()) {
            this.mExecutorService.execute(WXThread.secure(runnable));
        }
    }

    public DefaultWXStorage(Context context) {
        this.mDatabaseSupplier = new WXSQLiteOpenHelper(context);
    }

    @Override
    public void setItem(final String key, final String value, final IWXStorageAdapter.OnResultReceivedListener listener) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                Map<String, Object> data = StorageResultHandler.setItemResult(DefaultWXStorage.this.performSetItem(key, value, false, true));
                if (listener == null) {
                    return;
                }
                listener.onReceived(data);
            }
        });
    }

    @Override
    public void getItem(final String key, final IWXStorageAdapter.OnResultReceivedListener listener) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                Map<String, Object> data = StorageResultHandler.getItemResult(DefaultWXStorage.this.performGetItem(key));
                if (listener == null) {
                    return;
                }
                listener.onReceived(data);
            }
        });
    }

    @Override
    public void removeItem(final String key, final IWXStorageAdapter.OnResultReceivedListener listener) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                Map<String, Object> data = StorageResultHandler.removeItemResult(DefaultWXStorage.this.performRemoveItem(key));
                if (listener == null) {
                    return;
                }
                listener.onReceived(data);
            }
        });
    }

    @Override
    public void length(final IWXStorageAdapter.OnResultReceivedListener listener) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                Map<String, Object> data = StorageResultHandler.getLengthResult(DefaultWXStorage.this.performGetLength());
                if (listener == null) {
                    return;
                }
                listener.onReceived(data);
            }
        });
    }

    @Override
    public void getAllKeys(final IWXStorageAdapter.OnResultReceivedListener listener) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                Map<String, Object> data = StorageResultHandler.getAllkeysResult(DefaultWXStorage.this.performGetAllKeys());
                if (listener == null) {
                    return;
                }
                listener.onReceived(data);
            }
        });
    }

    @Override
    public void setItemPersistent(final String key, final String value, final IWXStorageAdapter.OnResultReceivedListener listener) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                Map<String, Object> data = StorageResultHandler.setItemResult(DefaultWXStorage.this.performSetItem(key, value, true, true));
                if (listener == null) {
                    return;
                }
                listener.onReceived(data);
            }
        });
    }

    @Override
    public void close() {
        final ExecutorService needCloseService = this.mExecutorService;
        this.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultWXStorage.this.mDatabaseSupplier.closeDatabase();
                    if (needCloseService != null) {
                        needCloseService.shutdown();
                    }
                }
                catch (Exception e) {
                    WXLogUtils.e("weex_storage", e.getMessage());
                }
            }
        });
        this.mExecutorService = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performSetItem(String key, String value, boolean isPersistent, boolean allowRetryWhenFull) {
        SQLiteDatabase database = this.mDatabaseSupplier.getDatabase();
        if (database == null) {
            return false;
        }
        WXLogUtils.d("weex_storage", "set k-v to storage(key:" + key + ",value:" + value + ",isPersistent:" + isPersistent + ",allowRetry:" + allowRetryWhenFull + ")");
        String sql = "INSERT OR REPLACE INTO default_wx_storage VALUES (?,?,?,?);";
        String timeStamp = WXSQLiteOpenHelper.sDateFormatter.format(new Date());
        try (SQLiteStatement statement = null;){
            statement = database.compileStatement(sql);
            statement.clearBindings();
            statement.bindString(1, key);
            statement.bindString(2, value);
            statement.bindString(3, timeStamp);
            statement.bindLong(4, isPersistent ? 1L : 0L);
            statement.execute();
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean trimToSize() {
        SQLiteDatabase database = this.mDatabaseSupplier.getDatabase();
        if (database == null) {
            return false;
        }
        ArrayList<String> toEvict = new ArrayList<String>();
        int num = 0;
        try (Cursor c = database.query("default_wx_storage", new String[]{"key", "persistent"}, null, null, null, null, "timestamp ASC");){
            int evictSize = c.getCount() / 10;
            while (c.moveToNext()) {
                String key = c.getString(c.getColumnIndex("key"));
                boolean persistent = c.getInt(c.getColumnIndex("persistent")) == 1;
                if (persistent || key == null) continue;
                toEvict.add(key);
                if (++num != evictSize) continue;
                break;
            }
        }
        if (num <= 0) {
            return false;
        }
        for (String key : toEvict) {
            this.performRemoveItem(key);
        }
        WXLogUtils.e("weex_storage", "remove " + num + " items by lru");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String performGetItem(String key) {
        SQLiteDatabase database = this.mDatabaseSupplier.getDatabase();
        if (database == null) {
            return null;
        }
        try (Cursor c = database.query("default_wx_storage", new String[]{"value"}, "key=?", new String[]{key}, null, null, null);){
            if (c.moveToNext()) {
                ContentValues values = new ContentValues();
                values.put("timestamp", WXSQLiteOpenHelper.sDateFormatter.format(new Date()));
                int updateResult = this.mDatabaseSupplier.getDatabase().update("default_wx_storage", values, "key= ?", new String[]{key});
                WXLogUtils.d("weex_storage", "update timestamp " + (updateResult == 1 ? "success" : "failed") + " for operation [getItem(key = " + key + ")]");
                String string2 = c.getString(c.getColumnIndex("value"));
                return string2;
            }
            String values = null;
            return values;
        }
    }

    private boolean performRemoveItem(String key) {
        SQLiteDatabase database = this.mDatabaseSupplier.getDatabase();
        if (database == null) {
            return false;
        }
        int count = 0;
        try {
            count = database.delete("default_wx_storage", "key=?", new String[]{key});
        }
        catch (Exception e) {
            WXLogUtils.e("weex_storage", "DefaultWXStorage occurred an exception when execute removeItem:" + e.getMessage());
            return false;
        }
        return count == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long performGetLength() {
        SQLiteDatabase database = this.mDatabaseSupplier.getDatabase();
        if (database == null) {
            return 0L;
        }
        String sql = "SELECT count(key) FROM default_wx_storage";
        try (SQLiteStatement statement = null;){
            statement = database.compileStatement(sql);
            long l = statement.simpleQueryForLong();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> performGetAllKeys() {
        SQLiteDatabase database = this.mDatabaseSupplier.getDatabase();
        if (database == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        try (Cursor c = database.query("default_wx_storage", new String[]{"key"}, null, null, null, null, null);){
            while (c.moveToNext()) {
                result.add(c.getString(c.getColumnIndex("key")));
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }
}

