/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.taobao.weex.ui.component.WXImage;
import com.taobao.weex.ui.view.IRenderResult;
import com.taobao.weex.ui.view.IRenderStatus;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.utils.ImageDrawable;
import com.taobao.weex.utils.WXLogUtils;
import java.lang.ref.WeakReference;
import java.util.Arrays;

public class WXImageView
extends ImageView
implements WXGestureObservable,
IRenderStatus<WXImage>,
IRenderResult<WXImage>,
WXImage.Measurable {
    private WeakReference<WXImage> mWeakReference;
    private WXGesture wxGesture;
    private float[] borderRadius;
    private boolean gif;
    private boolean isBitmapReleased = false;
    private boolean enableBitmapAutoManage = true;
    private boolean mOutWindowVisibilityChangedReally;

    public WXImageView(Context context) {
        super(context);
    }

    public void setImageResource(int resId) {
        Drawable drawable2 = this.getResources().getDrawable(resId);
        this.setImageDrawable(drawable2);
    }

    public void setImageDrawable(@Nullable Drawable drawable2, boolean isGif) {
        this.gif = isGif;
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams != null) {
            WXImage component;
            ImageDrawable imageDrawable;
            Drawable wrapDrawable = ImageDrawable.createImageDrawable(drawable2, this.getScaleType(), this.borderRadius, layoutParams.width - this.getPaddingLeft() - this.getPaddingRight(), layoutParams.height - this.getPaddingTop() - this.getPaddingBottom(), isGif);
            if (wrapDrawable instanceof ImageDrawable && !Arrays.equals((imageDrawable = (ImageDrawable)wrapDrawable).getCornerRadii(), this.borderRadius)) {
                imageDrawable.setCornerRadii(this.borderRadius);
            }
            super.setImageDrawable(wrapDrawable);
            if (this.mWeakReference != null && (component = (WXImage)this.mWeakReference.get()) != null) {
                component.readyToRender();
            }
        }
    }

    public void setImageDrawable(@Nullable Drawable drawable2) {
        this.setImageDrawable(drawable2, this.gif);
    }

    public void setImageBitmap(@Nullable Bitmap bm) {
        this.setImageDrawable((Drawable)(bm == null ? null : new BitmapDrawable(this.getResources(), bm)));
    }

    @Override
    public void registerGestureListener(WXGesture wxGesture) {
        this.wxGesture = wxGesture;
    }

    @Override
    public WXGesture getGestureListener() {
        return this.wxGesture;
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean result = super.onTouchEvent(event);
        if (this.wxGesture != null) {
            result |= this.wxGesture.onTouch((View)this, event);
        }
        return result;
    }

    public void setBorderRadius(@NonNull float[] borderRadius) {
        this.borderRadius = borderRadius;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            this.setImageDrawable(this.getDrawable(), this.gif);
        }
    }

    @Override
    public void holdComponent(WXImage component) {
        this.mWeakReference = new WeakReference<WXImage>(component);
    }

    @Override
    @Nullable
    public WXImage getComponent() {
        return null != this.mWeakReference ? (WXImage)this.mWeakReference.get() : null;
    }

    @Override
    public int getNaturalWidth() {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 != null) {
            if (drawable2 instanceof ImageDrawable) {
                return ((ImageDrawable)drawable2).getBitmapWidth();
            }
            if (drawable2 instanceof BitmapDrawable) {
                Bitmap bitmap = ((BitmapDrawable)drawable2).getBitmap();
                if (bitmap != null) {
                    return bitmap.getWidth();
                }
                WXLogUtils.w("WXImageView", "Bitmap on " + drawable2.toString() + " is null");
            } else {
                WXLogUtils.w("WXImageView", "Not supported drawable type: " + drawable2.getClass().getSimpleName());
            }
        }
        return -1;
    }

    @Override
    public int getNaturalHeight() {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 != null) {
            if (drawable2 instanceof ImageDrawable) {
                return ((ImageDrawable)drawable2).getBitmapHeight();
            }
            if (drawable2 instanceof BitmapDrawable) {
                Bitmap bitmap = ((BitmapDrawable)drawable2).getBitmap();
                if (bitmap != null) {
                    return bitmap.getHeight();
                }
                WXLogUtils.w("WXImageView", "Bitmap on " + drawable2.toString() + " is null");
            } else {
                WXLogUtils.w("WXImageView", "Not supported drawable type: " + drawable2.getClass().getSimpleName());
            }
        }
        return -1;
    }

    public void dispatchWindowVisibilityChanged(int visibility) {
        this.mOutWindowVisibilityChangedReally = true;
        super.dispatchWindowVisibilityChanged(visibility);
        this.mOutWindowVisibilityChangedReally = false;
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (this.mOutWindowVisibilityChangedReally) {
            if (visibility == 0) {
                this.autoRecoverImage();
            } else {
                this.autoReleaseImage();
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.autoRecoverImage();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.autoReleaseImage();
    }

    public void onStartTemporaryDetach() {
        super.onStartTemporaryDetach();
        this.autoReleaseImage();
    }

    public void onFinishTemporaryDetach() {
        super.onFinishTemporaryDetach();
        this.autoRecoverImage();
    }

    public void setEnableBitmapAutoManage(boolean enableBitmapAutoManage) {
        this.enableBitmapAutoManage = enableBitmapAutoManage;
    }

    public void autoReleaseImage() {
        if (this.enableBitmapAutoManage && !this.isBitmapReleased) {
            this.isBitmapReleased = true;
            WXImage image = this.getComponent();
            if (image != null) {
                image.autoReleaseImage();
            }
        }
    }

    public void autoRecoverImage() {
        if (this.enableBitmapAutoManage && this.isBitmapReleased) {
            WXImage image = this.getComponent();
            if (image != null) {
                image.autoRecoverImage();
            }
            this.isBitmapReleased = false;
        }
    }
}

