/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.richtext.span;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.style.ReplacementSpan;
import android.view.View;
import com.taobao.weex.adapter.IDrawableLoader;

public class ImgSpan
extends ReplacementSpan
implements IDrawableLoader.StaticTarget {
    private int width;
    private int height;
    private Drawable mDrawable;
    private View mView;

    public ImgSpan(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        if (fm != null) {
            fm.ascent = -this.height;
            fm.descent = 0;
            fm.top = fm.ascent;
            fm.bottom = 0;
        }
        return this.width;
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        if (this.mDrawable != null) {
            canvas.save();
            int transY = bottom - this.mDrawable.getBounds().bottom;
            canvas.translate(x, (float)(transY -= paint.getFontMetricsInt().descent));
            this.mDrawable.draw(canvas);
            canvas.restore();
        }
    }

    @Override
    public void setDrawable(Drawable drawable2, boolean resetBounds) {
        this.mDrawable = drawable2;
        if (resetBounds) {
            this.mDrawable.setBounds(0, 0, this.width, this.height);
        }
        this.setCallback();
        this.mDrawable.invalidateSelf();
    }

    public void setView(View view) {
        this.mView = view;
        this.setCallback();
    }

    private void setCallback() {
        if (this.mDrawable != null && this.mView != null) {
            this.mDrawable.setCallback((Drawable.Callback)this.mView);
        }
    }
}

