/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.richtext.node;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.dom.WXCustomStyleSpan;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.ui.component.richtext.node.RichTextNodeManager;
import com.taobao.weex.utils.WXResourceUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class RichTextNode {
    public static final String TYPE = "type";
    public static final String STYLE = "style";
    public static final String ATTR = "attr";
    public static final String CHILDREN = "children";
    public static final String VALUE = "value";
    public static final String ITEM_CLICK = "itemclick";
    public static final String PSEUDO_REF = "pseudoRef";
    private static final int MAX_LEVEL = 255;
    protected final Context mContext;
    protected final String mInstanceId;
    protected final String mComponentRef;
    protected Map<String, Object> style;
    protected Map<String, Object> attr;
    protected List<RichTextNode> children;

    protected RichTextNode(Context context, String instanceId, String componentRef) {
        this.mContext = context;
        this.mInstanceId = instanceId;
        this.mComponentRef = componentRef;
    }

    @NonNull
    public static Spannable parse(@NonNull Context context, @NonNull String instanceId, @NonNull String componentRef, String json) {
        JSONArray jsonArray = JSON.parseArray((String)json);
        if (jsonArray != null && !jsonArray.isEmpty()) {
            ArrayList<RichTextNode> nodes = new ArrayList<RichTextNode>(jsonArray.size());
            for (int i = 0; i < jsonArray.size(); ++i) {
                RichTextNode node;
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                if (jsonObject == null || (node = RichTextNodeManager.createRichTextNode(context, instanceId, componentRef, jsonObject)) == null) continue;
                nodes.add(node);
            }
            return RichTextNode.parse(nodes);
        }
        return new SpannableString((CharSequence)"");
    }

    public static int createSpanFlag(int level) {
        return RichTextNode.createPriorityFlag(level) | 0x11;
    }

    public abstract String toString();

    protected abstract boolean isInternalNode();

    final void parse(@NonNull Context context, @NonNull String instanceId, @NonNull String componentRef, JSONObject jsonObject) {
        JSONObject jsonStyle = jsonObject.getJSONObject(STYLE);
        if (jsonStyle != null) {
            this.style = new ArrayMap();
            this.style.putAll((Map<String, Object>)jsonStyle);
        } else {
            this.style = new ArrayMap(0);
        }
        JSONObject jsonAttr = jsonObject.getJSONObject(ATTR);
        if (jsonAttr != null) {
            this.attr = new ArrayMap(jsonAttr.size());
            this.attr.putAll((Map<String, Object>)jsonAttr);
        } else {
            this.attr = new ArrayMap(0);
        }
        JSONArray jsonChildren = jsonObject.getJSONArray(CHILDREN);
        if (jsonChildren != null) {
            this.children = new ArrayList<RichTextNode>(jsonChildren.size());
            for (int i = 0; i < jsonChildren.size(); ++i) {
                JSONObject child = jsonChildren.getJSONObject(i);
                RichTextNode node = RichTextNodeManager.createRichTextNode(context, instanceId, componentRef, child);
                if (node == null) continue;
                this.children.add(node);
            }
        } else {
            this.children = new ArrayList<RichTextNode>(0);
        }
    }

    protected void updateSpans(SpannableStringBuilder spannableStringBuilder, int level) {
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        if (this.style != null && instance != null) {
            int color;
            LinkedList<WXCustomStyleSpan> spans = new LinkedList<WXCustomStyleSpan>();
            WXCustomStyleSpan customStyleSpan = this.createCustomStyleSpan();
            if (customStyleSpan != null) {
                spans.add(customStyleSpan);
            }
            if (this.style.containsKey("fontSize")) {
                spans.add((WXCustomStyleSpan)new AbsoluteSizeSpan(WXStyle.getFontSize(this.style, instance.getInstanceViewPortWidth())));
            }
            if (this.style.containsKey("backgroundColor") && (color = WXResourceUtils.getColor(this.style.get("backgroundColor").toString(), 0)) != 0) {
                spans.add((WXCustomStyleSpan)new BackgroundColorSpan(color));
            }
            if (this.style.containsKey("color")) {
                spans.add((WXCustomStyleSpan)new ForegroundColorSpan(WXResourceUtils.getColor(WXStyle.getTextColor(this.style))));
            }
            int spanFlag = RichTextNode.createSpanFlag(level);
            for (Object e : spans) {
                spannableStringBuilder.setSpan(e, 0, spannableStringBuilder.length(), spanFlag);
            }
        }
    }

    private static int createPriorityFlag(int level) {
        return level <= 255 ? 255 - level << 16 : 0xFF0000;
    }

    @NonNull
    private static Spannable parse(@NonNull List<RichTextNode> list) {
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder();
        for (RichTextNode richTextNode : list) {
            spannableStringBuilder.append((CharSequence)richTextNode.toSpan(1));
        }
        return spannableStringBuilder;
    }

    private Spannable toSpan(int level) {
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder();
        spannableStringBuilder.append((CharSequence)this.toString());
        if (this.isInternalNode() && this.children != null) {
            for (RichTextNode child : this.children) {
                spannableStringBuilder.append((CharSequence)child.toSpan(level + 1));
            }
        }
        this.updateSpans(spannableStringBuilder, level);
        return spannableStringBuilder;
    }

    @Nullable
    private WXCustomStyleSpan createCustomStyleSpan() {
        int fontWeight = -1;
        int fontStyle = -1;
        String fontFamily = null;
        if (this.style.containsKey("fontWeight")) {
            fontWeight = WXStyle.getFontWeight(this.style);
        }
        if (this.style.containsKey("fontStyle")) {
            fontStyle = WXStyle.getFontStyle(this.style);
        }
        if (this.style.containsKey("fontFamily")) {
            fontFamily = WXStyle.getFontFamily(this.style);
        }
        if (fontWeight != -1 || fontStyle != -1 || fontFamily != null) {
            return new WXCustomStyleSpan(fontStyle, fontWeight, fontFamily);
        }
        return null;
    }
}

