/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.richtext.node;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.SpannableStringBuilder;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.DrawableStrategy;
import com.taobao.weex.ui.component.richtext.node.RichTextNode;
import com.taobao.weex.ui.component.richtext.node.RichTextNodeCreator;
import com.taobao.weex.ui.component.richtext.span.ImgSpan;
import com.taobao.weex.ui.component.richtext.span.ItemClickSpan;
import com.taobao.weex.utils.ImgURIUtil;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.LinkedList;

class ImgNode
extends RichTextNode {
    public static final String NODE_TYPE = "image";

    private ImgNode(Context context, String instanceId, String componentRef) {
        super(context, instanceId, componentRef);
    }

    @Override
    public String toString() {
        return " ";
    }

    @Override
    protected boolean isInternalNode() {
        return false;
    }

    @Override
    protected void updateSpans(SpannableStringBuilder spannableStringBuilder, int level) {
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        if (WXSDKEngine.getDrawableLoader() != null && this.style.containsKey("width") && this.style.containsKey("height") && this.attr.containsKey("src") && instance != null) {
            LinkedList<Object> spans = new LinkedList<Object>();
            spans.add(this.createImgSpan(instance));
            if (this.attr.containsKey("pseudoRef")) {
                spans.add((Object)new ItemClickSpan(this.mInstanceId, this.mComponentRef, this.attr.get("pseudoRef").toString()));
            }
            for (Object e : spans) {
                spannableStringBuilder.setSpan(e, 0, spannableStringBuilder.length(), ImgNode.createSpanFlag(level));
            }
        }
    }

    @NonNull
    private ImgSpan createImgSpan(WXSDKInstance instance) {
        int width = (int)WXViewUtils.getRealPxByWidth(WXUtils.getFloat(this.style.get("width")), instance.getInstanceViewPortWidth());
        int height = (int)WXViewUtils.getRealPxByWidth(WXUtils.getFloat(this.style.get("height")), instance.getInstanceViewPortWidth());
        ImgSpan imageSpan = new ImgSpan(width, height);
        String url = this.attr.get("src").toString();
        Uri rewrited = instance.rewriteUri(Uri.parse((String)url), NODE_TYPE);
        if ("local".equals(rewrited.getScheme())) {
            Drawable localDrawable = ImgURIUtil.getDrawableFromLoaclSrc(this.mContext, rewrited);
            imageSpan.setDrawable(localDrawable, false);
        } else {
            DrawableStrategy drawableStrategy = new DrawableStrategy();
            drawableStrategy.width = width;
            drawableStrategy.height = height;
            WXSDKEngine.getDrawableLoader().setDrawable(rewrited.toString(), imageSpan, drawableStrategy);
        }
        return imageSpan;
    }

    static class ImgNodeCreator
    implements RichTextNodeCreator<ImgNode> {
        ImgNodeCreator() {
        }

        @Override
        public ImgNode createRichTextNode(Context context, String instanceId, String componentRef) {
            return new ImgNode(context, instanceId, componentRef);
        }
    }
}

