/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list.template;

import android.support.v4.util.ArrayMap;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.taobao.weex.ui.component.list.template.TemplateViewHolder;
import com.taobao.weex.ui.component.list.template.WXRecyclerTemplateList;
import com.taobao.weex.ui.view.refresh.wrapper.BounceRecyclerView;
import java.util.ArrayList;
import java.util.List;

public class TemplateStickyHelper {
    private WXRecyclerTemplateList recyclerTemplateList;
    private List<Integer> stickyPositions;
    private ArrayMap<Integer, TemplateViewHolder> stickyHolderCache;
    private List<String> mStickyTypes;

    public TemplateStickyHelper(WXRecyclerTemplateList recyclerTemplateList) {
        this.recyclerTemplateList = recyclerTemplateList;
        this.stickyPositions = new ArrayList<Integer>();
        this.stickyHolderCache = new ArrayMap();
        this.mStickyTypes = new ArrayList<String>(8);
    }

    public void onBeforeScroll(int dx, int dy) {
        TemplateViewHolder stickyFakeViewHolder;
        View stickyFakeView;
        if (this.stickyPositions == null || this.stickyPositions.size() == 0) {
            return;
        }
        BounceRecyclerView bounceRecyclerView = (BounceRecyclerView)this.recyclerTemplateList.getHostView();
        RecyclerView recyclerView = (RecyclerView)((BounceRecyclerView)this.recyclerTemplateList.getHostView()).getInnerView();
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        int firstVisiblePosition = -1;
        int lastVisiblePosition = -1;
        if (layoutManager instanceof LinearLayoutManager) {
            firstVisiblePosition = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
            lastVisiblePosition = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
        } else if (layoutManager instanceof StaggeredGridLayoutManager) {
            int[] firstVisibleItemPositions = new int[3];
            firstVisiblePosition = ((StaggeredGridLayoutManager)layoutManager).findFirstVisibleItemPositions(firstVisibleItemPositions)[0];
            lastVisiblePosition = ((StaggeredGridLayoutManager)layoutManager).findLastVisibleItemPositions(firstVisibleItemPositions)[0];
        }
        if (firstVisiblePosition < 0) {
            return;
        }
        TemplateViewHolder firstVisibleItemHolder = (TemplateViewHolder)recyclerView.findViewHolderForAdapterPosition(firstVisiblePosition);
        if (firstVisibleItemHolder == null) {
            return;
        }
        int matchStickyPosition = -1;
        for (Integer headerPosition : this.stickyPositions) {
            if (headerPosition == null) continue;
            if (headerPosition > firstVisiblePosition) break;
            matchStickyPosition = Math.max(matchStickyPosition, headerPosition);
        }
        if (matchStickyPosition < 0) {
            stickyFakeView = bounceRecyclerView.getChildAt(bounceRecyclerView.getChildCount() - 1);
            if (stickyFakeView.getTag() instanceof TemplateViewHolder) {
                stickyFakeViewHolder = (TemplateViewHolder)((Object)stickyFakeView.getTag());
                bounceRecyclerView.removeView(stickyFakeViewHolder.itemView);
                stickyFakeViewHolder.itemView.setTranslationY(0.0f);
                if (stickyFakeViewHolder.getComponent() != null && stickyFakeViewHolder.getComponent().getEvents().contains("unsticky")) {
                    stickyFakeViewHolder.getComponent().fireEvent("unsticky");
                }
            }
            for (int i = 0; i < recyclerView.getChildCount(); ++i) {
                int adapterPosition;
                View itemView = recyclerView.getChildAt(i);
                TemplateViewHolder itemHolder = (TemplateViewHolder)recyclerView.getChildViewHolder(itemView);
                if (itemHolder == null || !this.stickyPositions.contains(adapterPosition = itemHolder.getAdapterPosition()) || itemView.getVisibility() == 0) continue;
                itemView.setVisibility(0);
            }
            return;
        }
        stickyFakeView = bounceRecyclerView.getChildAt(bounceRecyclerView.getChildCount() - 1);
        if (!(stickyFakeView.getTag() instanceof TemplateViewHolder) || ((TemplateViewHolder)((Object)stickyFakeView.getTag())).getHolderPosition() != matchStickyPosition) {
            int stickyHolderType;
            TemplateViewHolder fakeStickyHolder;
            if (stickyFakeView.getTag() instanceof TemplateViewHolder && ((TemplateViewHolder)((Object)stickyFakeView.getTag())).getHolderPosition() != matchStickyPosition) {
                stickyFakeViewHolder = (TemplateViewHolder)((Object)stickyFakeView.getTag());
                bounceRecyclerView.removeView(stickyFakeViewHolder.itemView);
                stickyFakeViewHolder.itemView.setTranslationY(0.0f);
                if (stickyFakeViewHolder.getComponent() != null && stickyFakeViewHolder.getComponent().getEvents().contains("unsticky")) {
                    stickyFakeViewHolder.getComponent().fireEvent("unsticky");
                }
            }
            if ((fakeStickyHolder = (TemplateViewHolder)((Object)this.stickyHolderCache.get((Object)(stickyHolderType = this.recyclerTemplateList.getItemViewType(matchStickyPosition))))) == null) {
                fakeStickyHolder = this.recyclerTemplateList.onCreateViewHolder((ViewGroup)recyclerView, stickyHolderType);
                this.stickyHolderCache.put((Object)stickyHolderType, (Object)fakeStickyHolder);
            }
            this.recyclerTemplateList.onBindViewHolder(fakeStickyHolder, matchStickyPosition);
            fakeStickyHolder.itemView.setTranslationY(0.0f);
            fakeStickyHolder.itemView.setTag((Object)fakeStickyHolder);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2);
            fakeStickyHolder.getComponent().clearPreLayout();
            if (fakeStickyHolder.itemView.getParent() != null) {
                ViewGroup parent = (ViewGroup)fakeStickyHolder.itemView.getParent();
                parent.removeView(fakeStickyHolder.itemView);
            }
            bounceRecyclerView.addView(fakeStickyHolder.itemView, (ViewGroup.LayoutParams)params);
            fakeStickyHolder.getComponent().setLayout(fakeStickyHolder.getComponent());
            stickyFakeView = fakeStickyHolder.itemView;
            if (fakeStickyHolder.getComponent() != null && fakeStickyHolder.getComponent().getEvents().contains("sticky")) {
                fakeStickyHolder.getComponent().fireEvent("sticky");
            }
        }
        stickyFakeViewHolder = (TemplateViewHolder)((Object)stickyFakeView.getTag());
        for (int i = 0; i < recyclerView.getChildCount(); ++i) {
            int adapterPosition;
            View itemView = recyclerView.getChildAt(i);
            TemplateViewHolder itemHolder = (TemplateViewHolder)recyclerView.getChildViewHolder(itemView);
            if (itemHolder == null || !this.stickyPositions.contains(adapterPosition = itemHolder.getAdapterPosition())) continue;
            if (adapterPosition == stickyFakeViewHolder.getHolderPosition()) {
                if (itemView.getVisibility() == 4) continue;
                itemView.setVisibility(4);
                continue;
            }
            if (itemView.getVisibility() == 0) continue;
            itemView.setVisibility(0);
        }
        if (firstVisibleItemHolder.getComponent().isSticky()) {
            if (firstVisibleItemHolder.itemView.getY() < 0.0f) {
                if (firstVisibleItemHolder.itemView.getVisibility() != 4) {
                    firstVisibleItemHolder.itemView.setVisibility(4);
                }
                if (stickyFakeView.getVisibility() != 0) {
                    stickyFakeView.setVisibility(0);
                }
                stickyFakeView.bringToFront();
            } else {
                if (firstVisibleItemHolder.itemView.getVisibility() != 0) {
                    firstVisibleItemHolder.itemView.setVisibility(0);
                }
                if (stickyFakeView.getVisibility() != 8) {
                    stickyFakeView.setVisibility(8);
                }
            }
        } else if (stickyFakeView.getVisibility() != 0) {
            stickyFakeView.setVisibility(0);
        }
        int nextVisiblePostion = firstVisiblePosition + 1;
        if (lastVisiblePosition > 0) {
            for (int i = nextVisiblePostion; i <= lastVisiblePosition; ++i) {
                if (!this.stickyPositions.contains(i)) continue;
                nextVisiblePostion = i;
                break;
            }
        }
        if (!this.stickyPositions.contains(nextVisiblePostion)) {
            if (stickyFakeViewHolder.itemView.getTranslationY() < 0.0f) {
                stickyFakeViewHolder.itemView.setTranslationY(0.0f);
            }
            return;
        }
        TemplateViewHolder nextStickyHolder = (TemplateViewHolder)recyclerView.findViewHolderForAdapterPosition(nextVisiblePostion);
        if (nextStickyHolder == null || nextStickyHolder.getComponent() == null) {
            return;
        }
        int translationY = (int)(nextStickyHolder.itemView.getY() - (float)stickyFakeViewHolder.itemView.getMeasuredHeight());
        if (translationY <= 0) {
            stickyFakeViewHolder.itemView.setTranslationY((float)translationY);
        } else {
            stickyFakeViewHolder.itemView.setTranslationY(0.0f);
        }
    }

    public List<Integer> getStickyPositions() {
        if (this.stickyPositions == null) {
            this.stickyPositions = new ArrayList<Integer>();
        }
        return this.stickyPositions;
    }

    public List<String> getStickyTypes() {
        return this.mStickyTypes;
    }
}

