/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.action;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.graphics.drawable.ColorDrawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.animation.PathInterpolatorCompat;
import android.text.TextUtils;
import android.util.Pair;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.ui.action.BasicGraphicAction;
import com.taobao.weex.ui.animation.BackgroundColorProperty;
import com.taobao.weex.ui.animation.HeightProperty;
import com.taobao.weex.ui.animation.WXAnimationBean;
import com.taobao.weex.ui.animation.WXAnimationModule;
import com.taobao.weex.ui.animation.WidthProperty;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.list.template.TemplateDom;
import com.taobao.weex.ui.view.border.BorderDrawable;
import com.taobao.weex.utils.SingleFunctionParser;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.HashMap;
import java.util.List;

public class GraphicActionAnimation
extends BasicGraphicAction {
    private static final String TAG = "GraphicActionAnimation";
    private final boolean styleNeedInit;
    @Nullable
    private final String callback;
    @Nullable
    private WXAnimationBean mAnimationBean;

    public GraphicActionAnimation(@NonNull WXSDKInstance instance, @NonNull String ref, @NonNull WXAnimationBean animationBean) {
        super(instance, ref);
        this.styleNeedInit = false;
        this.callback = null;
        this.mAnimationBean = animationBean;
    }

    public GraphicActionAnimation(@NonNull WXSDKInstance instance, @NonNull String ref, @Nullable String animation, @Nullable String callBack) {
        super(instance, ref);
        this.styleNeedInit = true;
        this.callback = callBack;
        if (!TextUtils.isEmpty((CharSequence)animation)) {
            this.mAnimationBean = (WXAnimationBean)JSONObject.parseObject((String)animation, WXAnimationBean.class);
        }
    }

    public GraphicActionAnimation(@NonNull WXSDKInstance instance, @NonNull String ref, @NonNull WXAnimationBean animationBean, @Nullable String callBack) {
        super(instance, ref);
        this.styleNeedInit = false;
        this.mAnimationBean = animationBean;
        this.callback = callBack;
    }

    @Override
    public void executeAction() {
        WXSDKInstance instance;
        if (null == this.mAnimationBean) {
            return;
        }
        WXComponent component = WXSDKManager.getInstance().getWXRenderManager().getWXComponent(this.getPageId(), this.getRef());
        if (component == null) {
            if (!TemplateDom.isVirtualDomRef(this.getRef())) {
                return;
            }
            component = TemplateDom.findVirtualComponentByVRef(this.getPageId(), this.getRef());
            if (component == null) {
                return;
            }
        }
        if ((instance = WXSDKManager.getInstance().getWXRenderManager().getWXSDKInstance(this.getPageId())) == null) {
            return;
        }
        if (null != this.mAnimationBean.styles) {
            if (this.styleNeedInit) {
                String transformOrigin = (String)component.getStyles().get("transformOrigin");
                if (TextUtils.isEmpty((CharSequence)this.mAnimationBean.styles.transformOrigin)) {
                    this.mAnimationBean.styles.transformOrigin = transformOrigin;
                }
                this.mAnimationBean.styles.init(this.mAnimationBean.styles.transformOrigin, this.mAnimationBean.styles.transform, (int)component.getLayoutWidth(), (int)component.getLayoutHeight(), instance.getInstanceViewPortWidth(), instance);
            }
            this.startAnimation(instance, component);
        }
    }

    private void startAnimation(@NonNull WXSDKInstance instance, @Nullable WXComponent component) {
        if (component != null) {
            if (this.mAnimationBean != null) {
                component.setNeedLayoutOnAnimation(this.mAnimationBean.needLayout);
            }
            if (component.getHostView() == null) {
                WXAnimationModule.AnimationHolder holder = new WXAnimationModule.AnimationHolder(this.mAnimationBean, this.callback);
                component.postAnimation(holder);
            } else {
                try {
                    ObjectAnimator animator = this.createAnimator((View)component.getHostView(), instance.getInstanceViewPortWidth());
                    if (animator != null) {
                        Animator.AnimatorListener animatorCallback = this.createAnimatorListener(instance, this.callback);
                        if (Build.VERSION.SDK_INT < 18 && component.isLayerTypeEnabled()) {
                            component.getHostView().setLayerType(2, null);
                        }
                        Interpolator interpolator = this.createTimeInterpolator();
                        if (animatorCallback != null) {
                            animator.addListener(animatorCallback);
                        }
                        if (interpolator != null) {
                            animator.setInterpolator((TimeInterpolator)interpolator);
                        }
                        component.getHostView().setCameraDistance(this.mAnimationBean.styles.getCameraDistance());
                        animator.setDuration(this.mAnimationBean.duration);
                        animator.start();
                    }
                }
                catch (RuntimeException e) {
                    WXLogUtils.e(TAG, WXLogUtils.getStackTrace(e));
                }
            }
        }
    }

    @Nullable
    private ObjectAnimator createAnimator(View target, int viewPortWidth) {
        if (target == null) {
            return null;
        }
        WXAnimationBean.Style style = this.mAnimationBean.styles;
        if (style != null) {
            List<PropertyValuesHolder> holders = style.getHolders();
            if (!TextUtils.isEmpty((CharSequence)style.backgroundColor)) {
                BorderDrawable borderDrawable = WXViewUtils.getBorderDrawable(target);
                if (borderDrawable != null) {
                    holders.add(PropertyValuesHolder.ofObject((Property)new BackgroundColorProperty(), (TypeEvaluator)new ArgbEvaluator(), (Object[])new Integer[]{borderDrawable.getColor(), WXResourceUtils.getColor(style.backgroundColor)}));
                } else if (target.getBackground() instanceof ColorDrawable) {
                    holders.add(PropertyValuesHolder.ofObject((Property)new BackgroundColorProperty(), (TypeEvaluator)new ArgbEvaluator(), (Object[])new Integer[]{((ColorDrawable)target.getBackground()).getColor(), WXResourceUtils.getColor(style.backgroundColor)}));
                }
            }
            if (!(target.getLayoutParams() == null || TextUtils.isEmpty((CharSequence)style.width) && TextUtils.isEmpty((CharSequence)style.height))) {
                ViewGroup.LayoutParams layoutParams = target.getLayoutParams();
                if (!TextUtils.isEmpty((CharSequence)style.width)) {
                    holders.add(PropertyValuesHolder.ofInt((Property)new WidthProperty(), (int[])new int[]{layoutParams.width, (int)WXViewUtils.getRealPxByWidth(WXUtils.getFloat(style.width), viewPortWidth)}));
                }
                if (!TextUtils.isEmpty((CharSequence)style.height)) {
                    holders.add(PropertyValuesHolder.ofInt((Property)new HeightProperty(), (int[])new int[]{layoutParams.height, (int)WXViewUtils.getRealPxByWidth(WXUtils.getFloat(style.height), viewPortWidth)}));
                }
            }
            if (style.getPivot() != null) {
                Pair<Float, Float> pair = style.getPivot();
                target.setPivotX(((Float)pair.first).floatValue());
                target.setPivotY(((Float)pair.second).floatValue());
            }
            ObjectAnimator animator = ObjectAnimator.ofPropertyValuesHolder((Object)target, (PropertyValuesHolder[])holders.toArray(new PropertyValuesHolder[holders.size()]));
            animator.setStartDelay(this.mAnimationBean.delay);
            return animator;
        }
        return null;
    }

    @Nullable
    private Animator.AnimatorListener createAnimatorListener(final WXSDKInstance instance, final @Nullable String callBack) {
        if (!TextUtils.isEmpty((CharSequence)callBack)) {
            return new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    if (instance == null || instance.isDestroy()) {
                        WXLogUtils.e("RenderContextImpl-onAnimationEnd WXSDKInstance == null NPE or instance is destroyed");
                    } else {
                        WXSDKManager.getInstance().callback(instance.getInstanceId(), callBack, new HashMap<String, Object>());
                    }
                }
            };
        }
        return null;
    }

    @Nullable
    private Interpolator createTimeInterpolator() {
        String interpolator = this.mAnimationBean.timingFunction;
        if (!TextUtils.isEmpty((CharSequence)interpolator)) {
            switch (interpolator) {
                case "ease-in": {
                    return new AccelerateInterpolator();
                }
                case "ease-out": {
                    return new DecelerateInterpolator();
                }
                case "ease-in-out": {
                    return new AccelerateDecelerateInterpolator();
                }
                case "linear": {
                    return new LinearInterpolator();
                }
            }
            try {
                SingleFunctionParser<Float> parser = new SingleFunctionParser<Float>(this.mAnimationBean.timingFunction, new SingleFunctionParser.FlatMapper<Float>(){

                    @Override
                    public Float map(String raw) {
                        return Float.valueOf(Float.parseFloat(raw));
                    }
                });
                List<Float> params = parser.parse("cubic-bezier");
                if (params != null && params.size() == 4) {
                    return PathInterpolatorCompat.create((float)params.get(0).floatValue(), (float)params.get(1).floatValue(), (float)params.get(2).floatValue(), (float)params.get(3).floatValue());
                }
                return null;
            }
            catch (RuntimeException e) {
                return null;
            }
        }
        return null;
    }
}

